/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawEngineDocView;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.LockView;

public class BaseTextUI
extends BasicTextUI
implements PropertyChangeListener,
DocumentListener,
SettingsChangeListener {
    private EditorUI editorUI;
    private boolean foldingEnabled;
    private boolean needsRefresh = false;
    int componentID = -1;
    private AbstractDocument lastDocument;
    private static final GetFocusedComponentAction gfcAction = new GetFocusedComponentAction();

    @Override
    protected String getPropertyPrefix() {
        return "EditorPane";
    }

    public static JTextComponent getFocusedComponent() {
        return gfcAction.getFocusedComponent2();
    }

    protected boolean isRootViewReplaceNecessary() {
        boolean bl = false;
        Document document = this.getComponent().getDocument();
        if (document != this.lastDocument) {
            bl = true;
        }
        return bl;
    }

    protected void rootViewReplaceNotify() {
        this.lastDocument = (AbstractDocument)this.getComponent().getDocument();
    }

    @Override
    protected void modelChanged() {
        JTextComponent jTextComponent = this.getComponent();
        Document document = jTextComponent.getDocument();
        if (document != null && !(document instanceof AbstractDocument)) {
            return;
        }
        AbstractDocument abstractDocument = (AbstractDocument)document;
        if (document != null) {
            Settings.KitAndValue[] kitAndValueArray;
            ViewFactory viewFactory = this.getRootView(jTextComponent).getViewFactory();
            BaseKit baseKit = (BaseKit)this.getEditorKit(jTextComponent);
            jTextComponent.removeAll();
            if (this.isRootViewReplaceNecessary()) {
                this.rootViewReplaceNotify();
                kitAndValueArray = document.getDefaultRootElement();
                View view = viewFactory.create((Element)kitAndValueArray);
                this.setView(view);
            }
            jTextComponent.revalidate();
            kitAndValueArray = Settings.getValueHierarchy(baseKit.getClass(), "doc-install-action-name-list");
            for (int i = kitAndValueArray.length - 1; i >= 0; --i) {
                List list = (List)kitAndValueArray[i].value;
                if ((list = baseKit.translateActionNameList(list)) == null) continue;
                for (Action action : list) {
                    action.actionPerformed(new ActionEvent(jTextComponent, 1001, ""));
                }
            }
        }
    }

    @Override
    protected void installKeyboardActions() {
        String string = this.getPropertyPrefix() + ".actionMap";
        UIManager.getLookAndFeelDefaults().put(string, (Object)null);
        UIManager.getDefaults().put(string, (Object)null);
        super.installKeyboardActions();
    }

    @Override
    public void installUI(JComponent jComponent) {
        Object object;
        super.installUI(jComponent);
        if (!(jComponent instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = this.getComponent();
        Object object2 = Settings.getValue(Utilities.getKitClass(jTextComponent), "margin");
        Insets insets = object2 instanceof Insets ? (Insets)object2 : null;
        jTextComponent.setMargin(insets);
        this.getEditorUI().installUI(jTextComponent);
        Boolean bl = (Boolean)Settings.getValue(Utilities.getKitClass(jTextComponent), "code-folding-enable");
        this.foldingEnabled = bl;
        jTextComponent.putClientProperty("code-folding-enable", bl);
        Settings.addSettingsChangeListener(this);
        if (jTextComponent.getClientProperty(UIWatcher.class) == null) {
            object = new UIWatcher(this.getClass());
            jTextComponent.addPropertyChangeListener((PropertyChangeListener)object);
            jTextComponent.putClientProperty(UIWatcher.class, object);
        }
        object = (BaseKit)this.getEditorKit(jTextComponent);
        ViewFactory viewFactory = ((BaseKit)object).getViewFactory();
        Caret caret = ((BaseKit)object).createCaret();
        jTextComponent.setCaretColor(Color.black);
        jTextComponent.setCaret(caret);
        int n = SettingsUtil.getInteger(Utilities.getKitClass(jTextComponent), "caret-blink-rate", (int)SettingsDefaults.defaultCaretBlinkRate);
        caret.setBlinkRate(n);
        SwingUtilities.replaceUIInputMap(jComponent, 0, null);
        Registry.addComponent(jTextComponent);
        Registry.activate(jTextComponent);
        jTextComponent.setCursor(Cursor.getPredefinedCursor(2));
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        Settings.removeSettingsChangeListener(this);
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                baseDocument.removeDocumentListener(this);
            }
            jTextComponent.setKeymap(null);
            jTextComponent.setCaret(null);
            this.getEditorUI().uninstallUI(jTextComponent);
            Registry.removeComponent(jTextComponent);
        }
        this.editorUI = null;
    }

    public int getYFromPos(int n) throws BadLocationException {
        Rectangle rectangle = this.modelToView(this.getComponent(), n);
        return rectangle == null ? 0 : rectangle.y;
    }

    public int getPosFromY(int n) throws BadLocationException {
        return this.viewToModel(this.getComponent(), 0, n);
    }

    public int getBaseX(int n) {
        return this.getEditorUI().getTextMargin().left;
    }

    public int viewToModel(JTextComponent jTextComponent, int n, int n2) {
        return this.viewToModel(jTextComponent, new Point(n, n2));
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        if (biasArray == null) {
            biasArray = new Position.Bias[]{Position.Bias.Forward};
        }
        return super.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)this.getComponent();
        return jEditorPane == null ? null : jEditorPane.getEditorKit();
    }

    public EditorUI getEditorUI() {
        if (this.editorUI == null) {
            JTextComponent jTextComponent = this.getComponent();
            BaseKit baseKit = (BaseKit)this.getEditorKit(jTextComponent);
            this.editorUI = baseKit.createEditorUI();
            this.editorUI.initLineHeight(jTextComponent);
        }
        return this.editorUI;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument;
            BaseDocument baseDocument2;
            BaseDocument baseDocument3 = baseDocument2 = propertyChangeEvent.getOldValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getOldValue() : null;
            if (baseDocument2 != null) {
                baseDocument2.removeDocumentListener(this);
            }
            BaseDocument baseDocument4 = baseDocument = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            if (baseDocument != null) {
                baseDocument.addDocumentListener(this);
                Registry.activate(baseDocument);
            }
        } else if ("ancestor".equals(string) && (jTextComponent = (JTextComponent)propertyChangeEvent.getSource()).isDisplayable() && this.editorUI != null && this.editorUI.hasExtComponent() && !Boolean.TRUE.equals(jTextComponent.getClientProperty("ancestorOverride"))) {
            jTextComponent.putClientProperty("ancestorOverride", Boolean.TRUE);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            EditorUI editorUI = this.getEditorUI();
            int n = this.getYFromPos(documentEvent.getOffset());
            int n2 = editorUI.getLineHeight();
            int n3 = this.getYFromPos(baseDocumentEvent.getSyntaxUpdateOffset());
            if (baseDocumentEvent.getSyntaxUpdateOffset() == documentEvent.getDocument().getLength()) {
                n3 += n2;
            }
            if (this.getComponent().isShowing()) {
                editorUI.repaint(n, Math.max(n2, n3 - n));
            }
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            EditorUI editorUI = this.getEditorUI();
            int n = this.getYFromPos(documentEvent.getOffset());
            int n2 = editorUI.getLineHeight();
            int n3 = this.getYFromPos(baseDocumentEvent.getSyntaxUpdateOffset());
            if (baseDocumentEvent.getSyntaxUpdateOffset() == documentEvent.getDocument().getLength()) {
                n3 += n2;
            }
            if (this.getComponent().isShowing()) {
                editorUI.repaint(n, Math.max(n2, n3 - n));
            }
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent instanceof BaseDocumentEvent) {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            BaseDocument baseDocument = (BaseDocument)baseDocumentEvent.getDocument();
            String string = baseDocumentEvent.getDrawLayerName();
            if (string != null) {
                this.getEditorUI().addLayer(baseDocument.findLayer(string), baseDocumentEvent.getDrawLayerVisibility());
            } else {
                try {
                    JTextComponent jTextComponent = this.getComponent();
                    if (jTextComponent != null && jTextComponent.isShowing()) {
                        this.getEditorUI().repaintBlock(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength());
                    }
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            }
        }
    }

    @Override
    public View create(Element element) {
        String string = element.getName();
        if (string != null) {
            if (string.equals("content")) {
                return new LabelView(element);
            }
            if (string.equals("paragraph")) {
                return new DrawEngineLineView(element);
            }
            if (string.equals("section")) {
                return new LockView(new DrawEngineDocView(element));
            }
            if (string.equals("component")) {
                return new ComponentView(element);
            }
            if (string.equals("icon")) {
                return new IconView(element);
            }
        }
        return new DrawEngineLineView(element);
    }

    @Override
    public View create(Element element, int n, int n2) {
        return null;
    }

    public void preferenceChanged(boolean bl, boolean bl2) {
        this.modelChanged();
    }

    public void invalidateStartY() {
    }

    @Override
    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (settingsChangeEvent == null || Utilities.getKitClass(jTextComponent) != settingsChangeEvent.getKitClass()) {
            return;
        }
        if ("code-folding-enable".equals(settingsChangeEvent.getSettingName())) {
            Boolean bl = (Boolean)Settings.getValue(settingsChangeEvent.getKitClass(), "code-folding-enable");
            this.foldingEnabled = bl;
            jTextComponent.putClientProperty("code-folding-enable", bl);
            this.needsRefresh = true;
            Utilities.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    BaseTextUI.this.refresh();
                }
            });
        }
    }

    boolean isFoldingEnabled() {
        return this.foldingEnabled;
    }

    protected void refresh() {
        if (this.getComponent().isShowing() && this.needsRefresh) {
            this.modelChanged();
            this.needsRefresh = false;
        }
    }

    static void uninstallUIWatcher(JTextComponent jTextComponent) {
        UIWatcher uIWatcher = (UIWatcher)jTextComponent.getClientProperty(UIWatcher.class);
        if (uIWatcher != null) {
            jTextComponent.removePropertyChangeListener(uIWatcher);
            jTextComponent.putClientProperty(UIWatcher.class, null);
        }
    }

    static class UIWatcher
    implements PropertyChangeListener {
        private Class uiClass;

        UIWatcher(Class clazz) {
            this.uiClass = clazz;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTextComponent jTextComponent;
            EditorKit editorKit;
            Object object = propertyChangeEvent.getNewValue();
            if ("UI".equals(propertyChangeEvent.getPropertyName()) && object != null && !(object instanceof BaseTextUI) && (editorKit = ((TextUI)object).getEditorKit(jTextComponent = (JTextComponent)propertyChangeEvent.getSource())) instanceof BaseKit) {
                try {
                    jTextComponent.setUI((BaseTextUI)this.uiClass.newInstance());
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    class EditorUIBoxView
    extends BoxView {
        public EditorUIBoxView(Element element, int n) {
            super(element, n);
        }

        private DrawEngine.PreinitializedDrawEngine getPreinitializedDrawEngine(Graphics graphics) {
            DrawEngine.PreinitializedDrawEngine preinitializedDrawEngine = null;
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.height <= 0 || rectangle.width < 0) {
                return null;
            }
            int n = rectangle.y;
            int n2 = rectangle.height;
            int n3 = Math.max(n, 0);
            BaseDocument baseDocument = BaseTextUI.this.getEditorUI().getDocument();
            try {
                int n4 = BaseTextUI.this.getPosFromY(n3);
                int n5 = BaseTextUI.this.getPosFromY(n + n2 - 1);
                int n6 = Utilities.getRowEnd(baseDocument, n5);
                int n7 = n4;
                int n8 = n6;
                int n9 = BaseTextUI.this.getYFromPos(n7);
                if (n8 > n7) {
                    preinitializedDrawEngine = DrawEngine.getDrawEngine().getDrawEngine(this, new DrawGraphics.GraphicsDG(graphics), BaseTextUI.this.getEditorUI(), n7, n8, BaseTextUI.this.getBaseX(n9), n9, Integer.MAX_VALUE);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return preinitializedDrawEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
            DrawEngine.PreinitializedDrawEngine preinitializedDrawEngine = null;
            JTextComponent jTextComponent = BaseTextUI.this.getComponent();
            try {
                preinitializedDrawEngine = this.getPreinitializedDrawEngine(graphics);
                if (jTextComponent != null) {
                    jTextComponent.putClientProperty(DrawEngine.PreinitializedDrawEngine.class, preinitializedDrawEngine);
                }
                BaseTextUI.this.getEditorUI().paint(graphics);
            }
            finally {
                if (preinitializedDrawEngine != null) {
                    preinitializedDrawEngine.release();
                }
                if (jTextComponent != null) {
                    jTextComponent.putClientProperty(DrawEngine.PreinitializedDrawEngine.class, null);
                }
            }
        }
    }

    private static class GetFocusedComponentAction
    extends TextAction {
        private GetFocusedComponentAction() {
            super("get-focused-component");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        JTextComponent getFocusedComponent2() {
            return super.getFocusedComponent();
        }
    }
}

