/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

class DrawEngine {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.draw");
    private static final boolean debugFragment = Boolean.getBoolean("netbeans.debug.editor.draw.fragment");
    private static DrawEngine drawEngine;
    private static final char[] SPACE;

    private DrawEngine() {
    }

    public static DrawEngine getDrawEngine() {
        if (drawEngine == null) {
            drawEngine = new DrawEngine();
        }
        return drawEngine;
    }

    public PreinitializedDrawEngine getDrawEngine(View view, DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        if (n < 0 || n2 < 0 || n > n2 || n3 < 0 || n4 < 0) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)(view != null ? view.getDocument() : editorUI.getDocument());
        PreinitializedDrawEngine preinitializedDrawEngine = new PreinitializedDrawEngine(drawGraphics);
        preinitializedDrawEngine.preinitialize(baseDocument, editorUI, n, n2, n3, n4, n5);
        return preinitializedDrawEngine;
    }

    private void initLineNumbering(DrawInfo drawInfo) {
        boolean bl = drawInfo.lineNumbering = drawInfo.editorUI.lineNumberVisible && drawInfo.drawGraphics.supportsLineNumbers();
        if (drawInfo.lineNumbering) {
            Color color;
            Color color2;
            try {
                drawInfo.startLineNumber = Utilities.getLineOffset(drawInfo.doc, drawInfo.startOffset) + 1;
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            drawInfo.lineNumberColoring = drawInfo.editorUI.getColoring("line-number");
            drawInfo.lineNumberColoring = drawInfo.lineNumberColoring == null ? drawInfo.defaultColoring : drawInfo.lineNumberColoring.apply(drawInfo.defaultColoring);
            Font font = drawInfo.lineNumberColoring.getFont();
            if (font == null) {
                font = drawInfo.defaultColoring.getFont();
            }
            if ((color2 = drawInfo.lineNumberColoring.getBackColor()) == null) {
                color2 = drawInfo.defaultColoring.getBackColor();
            }
            if ((color = drawInfo.lineNumberColoring.getForeColor()) == null) {
                color = drawInfo.defaultColoring.getForeColor();
            }
            drawInfo.lineNumberChars = new char[Math.max(drawInfo.editorUI.lineNumberMaxDigitCount, 1)];
            if (drawInfo.graphics == null) {
                drawInfo.syncedLineNumbering = true;
            } else {
                try {
                    int n = Utilities.getLineOffset(drawInfo.doc, drawInfo.endOffset) + 1;
                    drawInfo.lineStartOffsets = new int[n - drawInfo.startLineNumber + 2];
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInfo(DrawInfo drawInfo) throws BadLocationException {
        drawInfo.x = drawInfo.startX;
        drawInfo.y = drawInfo.startY;
        drawInfo.lineHeight = drawInfo.editorUI.getLineHeight();
        drawInfo.defaultColoring = drawInfo.editorUI.getDefaultColoring();
        drawInfo.tabSize = drawInfo.doc.getTabSize();
        drawInfo.fragmentOffset = drawInfo.startOffset;
        drawInfo.graphics = drawInfo.drawGraphics.getGraphics();
        if (drawInfo.graphics != null && drawInfo.editorUI.renderingHints != null) {
            ((Graphics2D)drawInfo.graphics).setRenderingHints(drawInfo.editorUI.renderingHints);
        }
        this.initLineNumbering(drawInfo);
        drawInfo.foreColor = drawInfo.defaultColoring.getForeColor();
        drawInfo.backColor = drawInfo.defaultColoring.getBackColor();
        drawInfo.font = drawInfo.defaultColoring.getFont();
        drawInfo.bol = true;
        drawInfo.drawGraphics.init(drawInfo);
        drawInfo.drawGraphics.setDefaultBackColor(drawInfo.defaultColoring.getBackColor());
        drawInfo.drawGraphics.setLineHeight(drawInfo.lineHeight);
        drawInfo.drawGraphics.setLineAscent(drawInfo.editorUI.getLineAscent());
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
        drawInfo.layers = drawInfo.editorUI.getDrawLayerList().currentLayers();
        int n = drawInfo.layers.length;
        drawInfo.layerActives = new boolean[n];
        drawInfo.layerActivityChangeOffsets = new int[n];
        for (int i = 0; i < n; ++i) {
            drawInfo.layers[i].init(drawInfo);
        }
        drawInfo.drawMarkList = new ArrayList();
        Map map = drawInfo.doc.marks;
        MarkVector markVector = drawInfo.doc.marksStorage;
        Map map2 = map;
        synchronized (map2) {
            int n2 = drawInfo.startOffset;
            int n3 = 0;
            int n4 = markVector.getMarkCount();
            int n5 = n4 - 1;
            while (n3 <= n5) {
                int n6 = n3 + n5 >> 1;
                int n7 = markVector.getMarkOffsetInternal(n6) - n2;
                if (n7 < 0) {
                    n3 = n6 + 1;
                    continue;
                }
                if (n7 > 0) {
                    n5 = n6 - 1;
                    continue;
                }
                while (--n6 >= 0 && markVector.getMarkOffsetInternal(n6) == n2) {
                }
                n3 = n6 + 1;
                break;
            }
            n2 = drawInfo.endOffset;
            while (n3 < n4) {
                MultiMark multiMark = markVector.getMark(n3);
                if (multiMark.isValid()) {
                    if (multiMark.getOffset() > n2) break;
                    Mark mark = (Mark)map.get(multiMark);
                    if (mark == null) {
                        throw new IllegalStateException("No mark for m=" + multiMark);
                    }
                    if (mark instanceof MarkFactory.DrawMark) {
                        drawInfo.drawMarkList.add(mark);
                    }
                }
                ++n3;
            }
        }
        drawInfo.drawMarkIndex = 0;
        drawInfo.drawMarkOffset = Integer.MAX_VALUE;
        if (drawInfo.drawMarkList.size() > 0) {
            drawInfo.drawMark = (MarkFactory.DrawMark)drawInfo.drawMarkList.get(drawInfo.drawMarkIndex++);
            try {
                drawInfo.drawMarkOffset = drawInfo.drawMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                throw new IllegalStateException(invalidMarkException.toString());
            }
            if (drawInfo.drawMarkOffset < drawInfo.updateOffset) {
                drawInfo.updateOffset = drawInfo.drawMarkOffset;
                drawInfo.drawMarkUpdate = true;
            }
        }
        int n8 = drawInfo.doc.getTokenSafeOffset(drawInfo.endOffset);
        drawInfo.doc.prepareSyntax(drawInfo.text, drawInfo.syntax, drawInfo.startOffset, n8 - drawInfo.startOffset, false, false);
        drawInfo.textArray = drawInfo.text.array;
        drawInfo.buffer = drawInfo.textArray;
        drawInfo.bufferStartOffset = drawInfo.startOffset - drawInfo.syntax.getOffset();
        drawInfo.drawGraphics.setBuffer(drawInfo.textArray);
        if (drawInfo.drawGraphics instanceof DrawGraphics.GraphicsDG) {
            ((DrawGraphics.GraphicsDG)drawInfo.drawGraphics).setBufferStartOffset(drawInfo.bufferStartOffset);
        }
        drawInfo.continueDraw = true;
    }

    private void handleBOL(DrawInfo drawInfo) {
        if (drawInfo.lineNumbering) {
            if (drawInfo.syncedLineNumbering) {
                int n;
                drawInfo.foreColor = drawInfo.lineNumberColoring.getForeColor();
                drawInfo.backColor = drawInfo.lineNumberColoring.getBackColor();
                drawInfo.font = drawInfo.lineNumberColoring.getFont();
                drawInfo.strikeThroughColor = null;
                drawInfo.underlineColor = null;
                drawInfo.waveUnderlineColor = null;
                drawInfo.aboveLineColor = null;
                int n2 = drawInfo.startLineNumber + drawInfo.lineIndex;
                int n3 = drawInfo.layers.length;
                for (n = 0; n < n3; ++n) {
                    n2 = drawInfo.layers[n].updateLineNumberContext(n2, drawInfo);
                }
                n = Math.max(drawInfo.lineNumberChars.length - 1, 0);
                do {
                    drawInfo.lineNumberChars[n--] = (char)(48 + n2 % 10);
                } while ((n2 /= 10) != 0 && n >= 0);
                while (n >= 0) {
                    drawInfo.lineNumberChars[n--] = 32;
                }
                int n4 = drawInfo.x - drawInfo.editorUI.lineNumberWidth;
                if (drawInfo.editorUI.getLineNumberMargin() != null) {
                    n4 += drawInfo.editorUI.getLineNumberMargin().left;
                }
                drawInfo.drawGraphics.setX(n4);
                drawInfo.drawGraphics.setBuffer(drawInfo.lineNumberChars);
                drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.setStrikeThroughColor(drawInfo.strikeThroughColor);
                drawInfo.drawGraphics.setUnderlineColor(drawInfo.underlineColor);
                drawInfo.drawGraphics.setWaveUnderlineColor(drawInfo.waveUnderlineColor);
                drawInfo.drawGraphics.setAboveLineColor(drawInfo.aboveLineColor);
                drawInfo.drawGraphics.setFont(drawInfo.font);
                drawInfo.drawGraphics.drawChars(0, drawInfo.lineNumberChars.length, drawInfo.editorUI.lineNumberWidth);
                if (drawInfo.drawGraphics.getGraphics() == null) {
                    drawInfo.drawGraphics.setBuffer(SPACE);
                    drawInfo.drawGraphics.drawChars(0, 1, drawInfo.editorUI.lineNumberDigitWidth);
                }
                drawInfo.drawGraphics.setX(drawInfo.x);
                drawInfo.drawGraphics.setBuffer(drawInfo.textArray);
            } else {
                drawInfo.lineStartOffsets[drawInfo.lineIndex] = drawInfo.fragmentOffset;
            }
        }
        ++drawInfo.lineIndex;
    }

    private void handleEOL(DrawInfo drawInfo) {
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
        drawInfo.drawGraphics.eol();
        drawInfo.widestWidth = Math.max(drawInfo.widestWidth, drawInfo.x);
        drawInfo.visualColumn = 0;
        drawInfo.x = drawInfo.startX;
        drawInfo.y += drawInfo.lineHeight;
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
    }

    private void updateOffsetReached(DrawInfo drawInfo) {
        if (drawInfo.drawMarkUpdate) {
            for (DrawLayer drawLayer : drawInfo.layers) {
                int n;
                if (!drawLayer.getName().equals(drawInfo.drawMark.layerName) || !drawInfo.drawMark.isDocumentMark() && drawInfo.editorUI != drawInfo.drawMark.getEditorUI()) continue;
                drawInfo.layerActives[var3_4] = drawLayer.isActive(drawInfo, drawInfo.drawMark);
                drawInfo.layerActivityChangeOffsets[var3_4] = n = drawLayer.getNextActivityChangeOffset(drawInfo);
                if (n <= drawInfo.fragmentOffset || n >= drawInfo.layerUpdateOffset) continue;
                drawInfo.layerUpdateOffset = n;
            }
            if (drawInfo.drawMarkIndex < drawInfo.drawMarkList.size()) {
                drawInfo.drawMark = (MarkFactory.DrawMark)drawInfo.drawMarkList.get(drawInfo.drawMarkIndex++);
                try {
                    drawInfo.drawMarkOffset = drawInfo.drawMark.getOffset();
                }
                catch (InvalidMarkException invalidMarkException) {
                    throw new IllegalStateException(invalidMarkException.toString());
                }
            } else {
                drawInfo.drawMark = null;
                drawInfo.drawMarkOffset = Integer.MAX_VALUE;
            }
        } else {
            drawInfo.layerUpdateOffset = Integer.MAX_VALUE;
            int n = drawInfo.layers.length;
            for (int i = 0; i < n; ++i) {
                int n2 = drawInfo.layerActivityChangeOffsets[i];
                if (n2 == drawInfo.fragmentOffset) {
                    DrawLayer drawLayer = drawInfo.layers[i];
                    drawInfo.layerActives[i] = drawLayer.isActive(drawInfo, null);
                    drawInfo.layerActivityChangeOffsets[i] = n2 = drawLayer.getNextActivityChangeOffset(drawInfo);
                }
                if (n2 <= drawInfo.fragmentOffset || n2 >= drawInfo.layerUpdateOffset) continue;
                drawInfo.layerUpdateOffset = n2;
            }
        }
        if (drawInfo.drawMarkOffset < drawInfo.layerUpdateOffset) {
            drawInfo.drawMarkUpdate = true;
            drawInfo.updateOffset = drawInfo.drawMarkOffset;
        } else {
            drawInfo.drawMarkUpdate = false;
            drawInfo.updateOffset = drawInfo.layerUpdateOffset;
        }
    }

    private void computeFragmentLength(DrawInfo drawInfo) {
        drawInfo.fragmentStartIndex = drawInfo.fragmentOffset - drawInfo.bufferStartOffset;
        drawInfo.fragmentLength = Math.min(drawInfo.updateOffset - drawInfo.fragmentOffset, drawInfo.tokenLength - drawInfo.drawnLength);
        int n = Analyzer.findFirstTabOrLF(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
        drawInfo.eol = drawInfo.fragmentOffset == drawInfo.docLen;
        drawInfo.tabsFragment = false;
        if (n >= 0) {
            if (n == drawInfo.fragmentStartIndex) {
                if (drawInfo.textArray[n] == '\t') {
                    drawInfo.tabsFragment = true;
                    int n2 = Analyzer.findFirstNonTab(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
                    if (n2 != -1) {
                        drawInfo.fragmentLength = n2 - drawInfo.fragmentStartIndex;
                    }
                } else {
                    drawInfo.eol = true;
                    drawInfo.fragmentLength = 1;
                }
            } else {
                drawInfo.fragmentLength = n - drawInfo.fragmentStartIndex;
            }
        }
    }

    private void computeFragmentDisplayWidth(DrawInfo drawInfo) {
        if (!drawInfo.eol) {
            int n = drawInfo.layers.length;
            for (int i = 0; i < n; ++i) {
                if (!drawInfo.layerActives[i]) continue;
                drawInfo.layers[i].updateContext(drawInfo);
            }
        }
        FontMetricsCache.Info info = FontMetricsCache.getInfo(drawInfo.font);
        drawInfo.spaceWidth = drawInfo.component != null ? info.getSpaceWidth(drawInfo.component) : drawInfo.editorUI.defaultSpaceWidth;
        drawInfo.fragmentCharCount = drawInfo.fragmentLength;
        if (drawInfo.tabsFragment) {
            drawInfo.fragmentCharCount = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
            drawInfo.fragmentWidth = drawInfo.fragmentCharCount * drawInfo.spaceWidth;
        } else {
            drawInfo.fragmentWidth = drawInfo.eol ? drawInfo.spaceWidth : (drawInfo.fragmentLength > 0 ? (drawInfo.component != null ? FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength) : drawInfo.fragmentLength * drawInfo.spaceWidth) : 0);
        }
    }

    private void drawFragment(DrawInfo drawInfo) {
        if (drawInfo.eol) {
            if (drawInfo.drawGraphics instanceof DrawGraphics.PrintDG) {
                DrawGraphics.PrintDG printDG = (DrawGraphics.PrintDG)drawInfo.drawGraphics;
                if (printDG.getFont() == null) {
                    printDG.setFont(drawInfo.font);
                }
                if (printDG.getForeColor() == null) {
                    printDG.setForeColor(drawInfo.foreColor);
                }
            }
            int n = drawInfo.layers.length;
            boolean bl = false;
            int n2 = drawInfo.fragmentWidth;
            do {
                int n3;
                n2 = 0;
                if (drawInfo.bol) {
                    if (!bl) {
                        for (n3 = 0; n3 < n; ++n3) {
                            DrawLayer drawLayer;
                            if (!drawInfo.layerActives[n3] || !(drawLayer = drawInfo.layers[n3]).extendsEmptyLine()) continue;
                            bl = true;
                            drawLayer.updateContext(drawInfo);
                        }
                        if (bl) {
                            n2 = drawInfo.spaceWidth / 2;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        DrawLayer drawLayer;
                        if (!drawInfo.layerActives[i] || !(drawLayer = drawInfo.layers[i]).extendsEOL()) continue;
                        n3 = 1;
                        drawLayer.updateContext(drawInfo);
                    }
                    if (n3 != 0 && drawInfo.component != null) {
                        drawInfo.drawGraphics.setStrikeThroughColor(null);
                        drawInfo.drawGraphics.setUnderlineColor(null);
                        drawInfo.drawGraphics.setWaveUnderlineColor(null);
                        n2 = drawInfo.component.getWidth();
                    }
                }
                if (n2 <= 0) continue;
                n3 = drawInfo.drawGraphics.getX();
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.fillRect(n2);
                if (drawInfo.aboveLineColor != null) {
                    drawInfo.drawGraphics.setAboveLineColor(drawInfo.aboveLineColor);
                    drawInfo.drawGraphics.drawAboveLine(n3, n2);
                }
                if (!bl) continue;
                drawInfo.x += n2;
            } while (bl);
        } else {
            drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
            drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
            drawInfo.drawGraphics.setStrikeThroughColor(drawInfo.strikeThroughColor);
            drawInfo.drawGraphics.setUnderlineColor(drawInfo.underlineColor);
            drawInfo.drawGraphics.setWaveUnderlineColor(drawInfo.waveUnderlineColor);
            drawInfo.drawGraphics.setAboveLineColor(drawInfo.aboveLineColor);
            drawInfo.drawGraphics.setFont(drawInfo.font);
            if (drawInfo.tabsFragment) {
                drawInfo.drawGraphics.drawTabs(drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.fragmentCharCount, drawInfo.fragmentWidth);
            } else {
                drawInfo.drawGraphics.drawChars(drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.fragmentWidth);
            }
        }
    }

    private void checkTargetOffsetReached(DrawInfo drawInfo) {
        drawInfo.continueDraw = true;
        if (drawInfo.eol && (drawInfo.targetOffset == drawInfo.fragmentOffset || drawInfo.targetOffset == -1)) {
            char c = '\n';
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset, c, drawInfo.x, drawInfo.spaceWidth, drawInfo);
        } else if (drawInfo.targetOffset == -1 && drawInfo.fragmentLength > 0) {
            int n;
            int n2;
            int n3;
            int n4;
            FontMetrics fontMetrics = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component);
            int n5 = -1;
            int n6 = n4 = drawInfo.fragmentLength - 1;
            if (drawInfo.tabsFragment) {
                n3 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n4, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n2 = n3 * drawInfo.spaceWidth;
            } else {
                n2 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n4);
            }
            if (drawInfo.tabsFragment) {
                n = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n3 = n * drawInfo.spaceWidth;
            } else {
                n3 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
            }
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n4, drawInfo.textArray[drawInfo.fragmentStartIndex + n4], drawInfo.x + n2, n3 - n2, drawInfo);
            if (!drawInfo.continueDraw) {
                while (n5 <= n4) {
                    int n7;
                    n = (n5 + n4) / 2;
                    int n8 = 0;
                    if (n == n6 + 1) {
                        n8 = n3;
                    } else if (drawInfo.tabsFragment) {
                        n7 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                        n8 = n7 * drawInfo.spaceWidth;
                    } else {
                        n8 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n);
                    }
                    n7 = 0;
                    if (n == n6 - 1) {
                        n7 = n2;
                    } else if (drawInfo.tabsFragment) {
                        int n9 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n + 1, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                        n7 = n9 * drawInfo.spaceWidth;
                    } else {
                        n7 = fontMetrics.charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n + 1);
                    }
                    n2 = n8;
                    n3 = n7;
                    n6 = n;
                    drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n, drawInfo.textArray[drawInfo.fragmentStartIndex + n], drawInfo.x + n8, n7 - n8, drawInfo);
                    if (drawInfo.continueDraw) {
                        n5 = n + 1;
                        continue;
                    }
                    if (n > n5 && n != n4) {
                        n4 = n;
                        continue;
                    }
                    break;
                }
            }
        } else if (drawInfo.targetOffset < drawInfo.fragmentOffset + drawInfo.fragmentLength && drawInfo.fragmentOffset <= drawInfo.targetOffset) {
            int n;
            int n10;
            int n11 = 0;
            int n12 = drawInfo.targetOffset - drawInfo.fragmentOffset;
            if (n12 > 0) {
                if (drawInfo.tabsFragment) {
                    n10 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n12, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                    n11 = n10 * drawInfo.spaceWidth;
                } else {
                    n11 = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n12);
                }
            }
            if (drawInfo.tabsFragment) {
                n10 = Analyzer.getColumn(drawInfo.textArray, drawInfo.fragmentStartIndex, n12 + 1, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n = n10 * drawInfo.spaceWidth;
            } else {
                n = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.textArray, drawInfo.fragmentStartIndex, n12 + 1);
            }
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n12, drawInfo.textArray[drawInfo.fragmentStartIndex + n12], drawInfo.x + n11, n - n11, drawInfo);
        }
    }

    private void drawCurrentTokenFragment(DrawInfo drawInfo) {
        drawInfo.foreColor = drawInfo.defaultColoring.getForeColor();
        drawInfo.backColor = drawInfo.defaultColoring.getBackColor();
        drawInfo.font = drawInfo.defaultColoring.getFont();
        drawInfo.strikeThroughColor = null;
        drawInfo.underlineColor = null;
        drawInfo.waveUnderlineColor = null;
        drawInfo.aboveLineColor = null;
        if (drawInfo.bol) {
            Color color = drawInfo.foreColor;
            Color color2 = drawInfo.backColor;
            this.handleBOL(drawInfo);
            drawInfo.foreColor = color;
            drawInfo.backColor = color2;
        }
        while (drawInfo.fragmentOffset == drawInfo.updateOffset) {
            this.updateOffsetReached(drawInfo);
        }
        this.computeFragmentLength(drawInfo);
        this.computeFragmentDisplayWidth(drawInfo);
        this.drawFragment(drawInfo);
        if (debugFragment) {
            System.err.println("DrawEngine:   FRAGMENT='" + EditorDebug.debugChars(drawInfo.buffer, drawInfo.fragmentStartIndex, drawInfo.fragmentLength) + "', at pos=" + drawInfo.fragmentOffset + ", bol=" + drawInfo.bol + ", eol=" + drawInfo.eol);
        }
        if (drawInfo.component != null) {
            this.checkTargetOffsetReached(drawInfo);
        }
        drawInfo.fragmentOffset += drawInfo.fragmentLength;
        drawInfo.drawnLength += drawInfo.fragmentLength;
        drawInfo.visualColumn += drawInfo.fragmentCharCount;
        drawInfo.x += drawInfo.fragmentWidth;
        drawInfo.bol = false;
        if (drawInfo.eol) {
            this.handleEOL(drawInfo);
            drawInfo.bol = true;
        }
        if (drawInfo.fragmentOffset >= drawInfo.endOffset && drawInfo.endOffset < drawInfo.docLen) {
            drawInfo.continueDraw = false;
        }
    }

    private void drawCurrentToken(DrawInfo drawInfo) {
        if (drawInfo.tokenID != null) {
            drawInfo.tokenContextPath = drawInfo.syntax.getTokenContextPath();
            drawInfo.tokenOffset = drawInfo.syntax.getTokenOffset() + drawInfo.bufferStartOffset;
            drawInfo.tokenLength = drawInfo.syntax.getTokenLength();
            if (drawInfo.tokenOffset + drawInfo.tokenLength <= drawInfo.startOffset) {
                return;
            }
        } else {
            drawInfo.tokenContextPath = null;
            drawInfo.tokenOffset = drawInfo.fragmentOffset;
            drawInfo.tokenLength = 0;
        }
        if (drawInfo.tokenOffset <= drawInfo.startOffset) {
            drawInfo.layerUpdateOffset = Integer.MAX_VALUE;
            for (DrawLayer drawLayer : drawInfo.layers) {
                int n;
                drawInfo.layerActives[var3_3] = drawLayer.isActive(drawInfo, null);
                drawInfo.layerActivityChangeOffsets[var3_3] = n = drawLayer.getNextActivityChangeOffset(drawInfo);
                if (n <= drawInfo.fragmentOffset || n >= drawInfo.layerUpdateOffset) continue;
                drawInfo.layerUpdateOffset = n;
            }
            drawInfo.updateOffset = Math.min(drawInfo.layerUpdateOffset, drawInfo.drawMarkOffset);
        }
        drawInfo.drawnLength = drawInfo.fragmentOffset - drawInfo.tokenOffset;
        drawInfo.fragmentLength = 0;
        if (debug) {
            System.err.println("DrawEngine: TOKEN='" + EditorDebug.debugChars(drawInfo.getBuffer(), drawInfo.getTokenOffset() - drawInfo.getBufferStartOffset(), drawInfo.getTokenLength()) + "', tokenID=<" + (drawInfo.getTokenID() == null ? "null" : drawInfo.tokenID.getName()) + ">, tcp=" + drawInfo.getTokenContextPath() + ", pos=" + drawInfo.getTokenOffset());
        }
        do {
            this.drawCurrentTokenFragment(drawInfo);
        } while (drawInfo.continueDraw && drawInfo.drawnLength < drawInfo.tokenLength);
    }

    private void graphicsSpecificUpdates(DrawInfo drawInfo) {
        Rectangle rectangle = drawInfo.editorUI.getExtentBounds();
        Rectangle rectangle2 = drawInfo.graphics.getClipBounds();
        Insets insets = drawInfo.editorUI.getTextMargin();
        int n = insets.left - drawInfo.editorUI.lineNumberWidth - drawInfo.editorUI.textLeftMarginWidth;
        if (drawInfo.lineNumbering && !drawInfo.syncedLineNumbering) {
            Color color = drawInfo.lineNumberColoring.getBackColor();
            int n2 = drawInfo.startY;
            int n3 = rectangle.x + n;
            if (!color.equals(drawInfo.defaultColoring.getBackColor()) || rectangle.x > 0) {
                drawInfo.graphics.setColor(color);
                drawInfo.graphics.fillRect(n3, n2, drawInfo.editorUI.lineNumberWidth, drawInfo.lineIndex * drawInfo.lineHeight);
            }
            drawInfo.drawGraphics.setDefaultBackColor(color);
            int n4 = Math.max(drawInfo.lineNumberChars.length - 1, 0);
            int n5 = n3;
            if (drawInfo.editorUI.getLineNumberMargin() != null) {
                n5 += drawInfo.editorUI.getLineNumberMargin().left;
            }
            drawInfo.bol = true;
            for (int i = 0; i < drawInfo.lineIndex; ++i) {
                int n6;
                drawInfo.fragmentOffset = drawInfo.lineStartOffsets[i];
                drawInfo.foreColor = drawInfo.lineNumberColoring.getForeColor();
                drawInfo.backColor = color;
                drawInfo.font = drawInfo.lineNumberColoring.getFont();
                drawInfo.strikeThroughColor = null;
                drawInfo.underlineColor = null;
                drawInfo.waveUnderlineColor = null;
                drawInfo.aboveLineColor = null;
                int n7 = drawInfo.startLineNumber + i;
                int n8 = drawInfo.layers.length;
                for (n6 = 0; n6 < n8; ++n6) {
                    n7 = drawInfo.layers[n6].updateLineNumberContext(n7, drawInfo);
                }
                n6 = n4;
                do {
                    drawInfo.lineNumberChars[n6--] = (char)(48 + n7 % 10);
                } while ((n7 /= 10) != 0 && n6 >= 0);
                while (n6 >= 0) {
                    drawInfo.lineNumberChars[n6--] = 32;
                }
                drawInfo.drawGraphics.setY(n2);
                drawInfo.drawGraphics.setBuffer(drawInfo.lineNumberChars);
                drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.setStrikeThroughColor(drawInfo.strikeThroughColor);
                drawInfo.drawGraphics.setUnderlineColor(drawInfo.underlineColor);
                drawInfo.drawGraphics.setWaveUnderlineColor(drawInfo.waveUnderlineColor);
                drawInfo.drawGraphics.setAboveLineColor(drawInfo.aboveLineColor);
                drawInfo.drawGraphics.setFont(drawInfo.font);
                drawInfo.drawGraphics.setX(n3);
                drawInfo.drawGraphics.fillRect(drawInfo.editorUI.lineNumberWidth);
                drawInfo.drawGraphics.setX(n5);
                drawInfo.drawGraphics.drawChars(0, drawInfo.lineNumberChars.length, drawInfo.lineNumberChars.length * drawInfo.editorUI.lineNumberDigitWidth);
                drawInfo.drawGraphics.setBuffer(null);
                n2 += drawInfo.lineHeight;
            }
        }
        drawInfo.graphics.setColor(drawInfo.defaultColoring.getBackColor());
    }

    void draw(DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        this.draw(null, drawGraphics, editorUI, n, n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw(View view, DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        int n6;
        Object object;
        if (n < 0 || n2 < 0 || n > n2 || n3 < 0 || n4 < 0) {
            return;
        }
        BaseDocument baseDocument = (BaseDocument)(view != null ? view.getDocument() : editorUI.getDocument());
        if (debug) {
            object = baseDocument.getParagraphElement(0).getParentElement();
            int n7 = object.getElementIndex(n);
            n6 = object.getElement(n7).getStartOffset();
            int n8 = object.getElementIndex(n2);
            int n9 = object.getElement(n8).getStartOffset();
            Graphics graphics = drawGraphics.getGraphics();
            System.err.println("DrawEngine:---------- DRAWING startOffset=" + n + ", startLine=" + n7 + "(o=" + n6 + "), endOffset=" + n2 + ", endLine=" + n8 + "(o=" + n9 + "), clip=" + (graphics != null ? graphics.getClipBounds().toString() : "null") + "  ------------------");
        }
        object = new DrawInfo();
        ((DrawInfo)object).drawGraphics = drawGraphics;
        ((DrawInfo)object).drawGraphics.setView(view);
        ((DrawInfo)object).view = view;
        ((DrawInfo)object).editorUI = editorUI;
        ((DrawInfo)object).startOffset = n;
        ((DrawInfo)object).endOffset = n2;
        ((DrawInfo)object).startX = n3;
        ((DrawInfo)object).startY = n4;
        ((DrawInfo)object).targetOffset = n5;
        EditorUI editorUI2 = editorUI;
        synchronized (editorUI2) {
            ((DrawInfo)object).doc = baseDocument;
            if (((DrawInfo)object).doc == null) {
                return;
            }
            ((DrawInfo)object).text = DocumentUtilities.SEGMENT_CACHE.getSegment();
            ((DrawInfo)object).syntax = ((DrawInfo)object).doc.getFreeSyntax();
            ((DrawInfo)object).doc.readLock();
            try {
                ((DrawInfo)object).component = editorUI.getComponent();
                ((DrawInfo)object).docLen = ((DrawInfo)object).doc.getLength();
                if (((DrawInfo)object).startOffset > ((DrawInfo)object).docLen || ((DrawInfo)object).endOffset > ((DrawInfo)object).docLen) {
                    return;
                }
                if (((DrawInfo)object).endOffset < ((DrawInfo)object).docLen) {
                    ++((DrawInfo)object).endOffset;
                }
                this.initInfo((DrawInfo)object);
                do {
                    ((DrawInfo)object).tokenID = ((DrawInfo)object).syntax.nextToken();
                    this.drawCurrentToken((DrawInfo)object);
                } while (((DrawInfo)object).continueDraw && ((DrawInfo)object).tokenID != null);
                if (((DrawInfo)object).endOffset == ((DrawInfo)object).docLen) {
                    this.handleEOL((DrawInfo)object);
                    if (((DrawInfo)object).editorUI.textLimitLineVisible) {
                        n6 = ((DrawInfo)object).startX + ((DrawInfo)object).editorUI.textLimitWidth * ((DrawInfo)object).editorUI.defaultSpaceWidth;
                        if (((DrawInfo)object).graphics != null) {
                            ((DrawInfo)object).graphics.setColor(((DrawInfo)object).editorUI.textLimitLineColor);
                            Rectangle rectangle = ((DrawInfo)object).graphics.getClipBounds();
                            if (rectangle.height > ((DrawInfo)object).editorUI.getLineHeight()) {
                                ((DrawInfo)object).graphics.fillRect(n6, ((DrawInfo)object).y, ((DrawInfo)object).editorUI.textLimitLineWidth, rectangle.height);
                            }
                        }
                    }
                }
                if (((DrawInfo)object).graphics != null) {
                    this.graphicsSpecificUpdates((DrawInfo)object);
                }
            }
            finally {
                ((DrawInfo)object).drawGraphics.setBuffer(null);
                ((DrawInfo)object).drawGraphics.finish();
                if (((DrawInfo)object).syntax != null) {
                    ((DrawInfo)object).doc.releaseSyntax(((DrawInfo)object).syntax);
                }
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(((DrawInfo)object).text);
                ((DrawInfo)object).doc.readUnlock();
            }
        }
    }

    static {
        SPACE = new char[]{' '};
    }

    class PreinitializedDrawEngine
    extends DrawEngine {
        DrawGraphics drawGraphics;
        DrawInfo drawInfo;

        public PreinitializedDrawEngine(DrawGraphics drawGraphics) {
            this.drawGraphics = drawGraphics;
        }

        public void release() {
            this.drawInfo.drawGraphics.setBuffer(null);
            this.drawInfo.drawGraphics.finish();
            if (this.drawInfo.syntax != null) {
                this.drawInfo.doc.releaseSyntax(this.drawInfo.syntax);
            }
            DocumentUtilities.SEGMENT_CACHE.releaseSegment(this.drawInfo.text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preinitialize(BaseDocument baseDocument, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
            this.drawInfo = new DrawInfo();
            this.drawInfo.drawGraphics = this.drawGraphics;
            this.drawInfo.editorUI = editorUI;
            this.drawInfo.startOffset = n;
            this.drawInfo.endOffset = n2;
            this.drawInfo.startX = n3;
            this.drawInfo.startY = n4;
            this.drawInfo.targetOffset = n5;
            EditorUI editorUI2 = editorUI;
            synchronized (editorUI2) {
                this.drawInfo.doc = baseDocument;
                if (this.drawInfo.doc == null) {
                    return;
                }
                try {
                    this.drawInfo.text = DocumentUtilities.SEGMENT_CACHE.getSegment();
                    this.drawInfo.syntax = this.drawInfo.doc.getFreeSyntax();
                    this.drawInfo.doc.readLock();
                    this.drawInfo.component = editorUI.getComponent();
                    this.drawInfo.docLen = this.drawInfo.doc.getLength();
                    if (this.drawInfo.startOffset > this.drawInfo.docLen || this.drawInfo.endOffset > this.drawInfo.docLen) {
                        return;
                    }
                    if (this.drawInfo.endOffset < this.drawInfo.docLen) {
                        ++this.drawInfo.endOffset;
                    }
                    DrawEngine.this.initInfo(this.drawInfo);
                }
                finally {
                    this.drawInfo.doc.readUnlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void draw(DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
            if (n < 0 || n2 < 0 || n > n2 || n3 < 0 || n4 < 0) {
                return;
            }
            if (drawGraphics != null) {
                super.draw(drawGraphics, editorUI, n, n2, n3, n4, n5);
                return;
            }
            drawGraphics = this.drawGraphics;
            EditorUI editorUI2 = editorUI;
            synchronized (editorUI2) {
                DrawInfo drawInfo = this.drawInfo;
                drawInfo.doc.readLock();
                try {
                    do {
                        drawInfo.tokenID = drawInfo.syntax.nextToken();
                        DrawEngine.this.drawCurrentToken(drawInfo);
                    } while (drawInfo.continueDraw && drawInfo.tokenID != null);
                    if (drawInfo.endOffset == drawInfo.docLen) {
                        DrawEngine.this.handleEOL(drawInfo);
                    }
                    drawInfo.editorUI.updateVirtualWidth(drawInfo.widestWidth + drawInfo.editorUI.lineNumberWidth + 2 * drawInfo.editorUI.defaultSpaceWidth);
                    if (drawInfo.graphics != null) {
                        DrawEngine.this.graphicsSpecificUpdates(drawInfo);
                    }
                }
                finally {
                    drawInfo.doc.readUnlock();
                }
            }
        }
    }

    static class DrawInfo
    implements DrawContext {
        Color foreColor;
        Color backColor;
        Color underlineColor;
        Color waveUnderlineColor;
        Color strikeThroughColor;
        Color aboveLineColor;
        Font font;
        int startOffset;
        int endOffset;
        boolean bol;
        boolean eol;
        EditorUI editorUI;
        char[] buffer;
        int bufferStartOffset;
        TokenID tokenID;
        TokenContextPath tokenContextPath;
        int tokenOffset;
        int tokenLength;
        int fragmentOffset;
        int fragmentLength;
        DrawGraphics drawGraphics;
        int targetOffset;
        Segment text;
        char[] textArray;
        Syntax syntax;
        View view;
        JTextComponent component;
        BaseDocument doc;
        int docLen;
        int visualColumn;
        int x;
        int y;
        int startX;
        int startY;
        int lineHeight;
        Coloring defaultColoring;
        int tabSize;
        int widestWidth;
        boolean continueDraw;
        int startLineNumber;
        int lineIndex;
        int[] lineStartOffsets;
        char[] lineNumberChars;
        Coloring lineNumberColoring;
        Graphics graphics;
        boolean lineNumbering;
        boolean syncedLineNumbering;
        DrawLayer[] layers;
        boolean[] layerActives;
        int[] layerActivityChangeOffsets;
        int updateOffset;
        int layerUpdateOffset;
        boolean drawMarkUpdate;
        List drawMarkList;
        int drawMarkIndex;
        MarkFactory.DrawMark drawMark;
        int drawMarkOffset;
        int drawnLength;
        int fragmentStartIndex;
        boolean tabsFragment;
        int spaceWidth;
        int fragmentWidth;
        int fragmentCharCount;

        DrawInfo() {
        }

        @Override
        public Color getForeColor() {
            return this.foreColor;
        }

        @Override
        public void setForeColor(Color color) {
            this.foreColor = color;
        }

        @Override
        public Color getBackColor() {
            return this.backColor;
        }

        @Override
        public void setBackColor(Color color) {
            this.backColor = color;
        }

        @Override
        public Color getUnderlineColor() {
            return this.underlineColor;
        }

        @Override
        public void setUnderlineColor(Color color) {
            this.underlineColor = color;
        }

        @Override
        public Color getWaveUnderlineColor() {
            return this.waveUnderlineColor;
        }

        @Override
        public void setWaveUnderlineColor(Color color) {
            this.waveUnderlineColor = color;
        }

        @Override
        public Color getStrikeThroughColor() {
            return this.strikeThroughColor;
        }

        @Override
        public void setStrikeThroughColor(Color color) {
            this.strikeThroughColor = color;
        }

        @Override
        public void setAboveLineColor(Color color) {
            this.aboveLineColor = color;
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        @Override
        public void setFont(Font font) {
            this.font = font;
        }

        @Override
        public int getStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public boolean isBOL() {
            return this.bol;
        }

        @Override
        public boolean isEOL() {
            return this.eol;
        }

        @Override
        public EditorUI getEditorUI() {
            return this.editorUI;
        }

        @Override
        public char[] getBuffer() {
            return this.buffer;
        }

        @Override
        public int getBufferStartOffset() {
            return this.bufferStartOffset;
        }

        @Override
        public TokenID getTokenID() {
            return this.tokenID;
        }

        @Override
        public TokenContextPath getTokenContextPath() {
            return this.tokenContextPath;
        }

        @Override
        public int getTokenOffset() {
            return this.tokenOffset;
        }

        @Override
        public int getTokenLength() {
            return this.tokenLength;
        }

        @Override
        public int getFragmentOffset() {
            return this.fragmentOffset;
        }

        @Override
        public int getFragmentLength() {
            return this.fragmentLength;
        }
    }
}

