/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.java.JavaFormatSupport;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaFormatter
extends ExtFormatter {
    public JavaFormatter(Class clazz) {
        super(clazz);
    }

    @Override
    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JavaSyntax;
    }

    @Override
    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null) {
            if ("e".equals(string)) {
                try {
                    int n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
                    if (n2 >= 0 && n2 + 4 == n && "else".equals(baseDocument.getText(n2, 4))) {
                        nArray = new int[]{n2, n2 + 4};
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else if (":".equals(string)) {
                try {
                    int n3 = Utilities.getRowFirstNonWhite(baseDocument, n);
                    if (n3 >= 0 && n3 + 4 <= baseDocument.getLength() && "case".equals(baseDocument.getText(n3, 4))) {
                        nArray = new int[]{n3, n3 + 4};
                    } else if (n3 >= 0 & n3 + 7 <= baseDocument.getLength() && "default".equals(baseDocument.getText(n3, 7))) {
                        nArray = new int[]{n3, n3 + 7};
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                nArray = super.getReformatBlock(jTextComponent, string);
            }
        }
        return nArray;
    }

    @Override
    protected void initFormatLayers() {
        this.addFormatLayer(new StripEndWhitespaceLayer());
        this.addFormatLayer(new JavaLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new JavaFormatSupport(formatWriter);
    }

    public class JavaLayer
    extends AbstractFormatLayer {
        public JavaLayer() {
            super("java-layer");
        }

        @Override
        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new JavaFormatSupport(formatWriter);
        }

        @Override
        public void format(FormatWriter formatWriter) {
            block6: {
                try {
                    JavaFormatSupport javaFormatSupport = (JavaFormatSupport)this.createFormatSupport(formatWriter);
                    FormatTokenPosition formatTokenPosition = javaFormatSupport.getFormatStartPosition();
                    if (javaFormatSupport.isIndentOnly()) {
                        javaFormatSupport.indentLine(formatTokenPosition);
                        break block6;
                    }
                    while (formatTokenPosition != null) {
                        javaFormatSupport.indentLine(formatTokenPosition);
                        this.formatLine(javaFormatSupport, formatTokenPosition);
                        FormatTokenPosition formatTokenPosition2 = javaFormatSupport.findLineEnd(formatTokenPosition);
                        if (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && (formatTokenPosition = javaFormatSupport.getNextPosition(formatTokenPosition2, Position.Bias.Forward)) != formatTokenPosition2 && formatTokenPosition != null && formatTokenPosition.getToken() != null) {
                            FormatTokenPosition formatTokenPosition3 = javaFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                            if (formatTokenPosition3 != null) {
                                formatTokenPosition = formatTokenPosition3;
                                continue;
                            }
                            formatTokenPosition = javaFormatSupport.findLineStart(formatTokenPosition);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        private void removeLineBeforeToken(TokenItem tokenItem, JavaFormatSupport javaFormatSupport, boolean bl) {
            FormatTokenPosition formatTokenPosition;
            FormatTokenPosition formatTokenPosition2;
            FormatTokenPosition formatTokenPosition3 = javaFormatSupport.getPosition(tokenItem, 0);
            if (javaFormatSupport.findNonWhitespace(formatTokenPosition3, null, true, true) != null) {
                return;
            }
            if (bl && ((formatTokenPosition2 = javaFormatSupport.findNonWhitespace(formatTokenPosition3, null, false, true)) == null || formatTokenPosition2.getToken().getTokenID().getNumericID() != 58)) {
                return;
            }
            if (javaFormatSupport.getNextPosition(formatTokenPosition3) != null && (formatTokenPosition2 = javaFormatSupport.findImportant(javaFormatSupport.getNextPosition(formatTokenPosition3), null, true, false)) != null) {
                this.insertNewLineBeforeToken(formatTokenPosition2.getToken(), javaFormatSupport);
            }
            if ((formatTokenPosition = javaFormatSupport.getPreviousPosition(formatTokenPosition2 = javaFormatSupport.findLineStart(formatTokenPosition3))) == null || formatTokenPosition.getToken().getTokenID() != JavaTokenContext.WHITESPACE) {
                return;
            }
            formatTokenPosition2 = javaFormatSupport.findLineStart(formatTokenPosition);
            if ((formatTokenPosition2 = javaFormatSupport.findImportant(formatTokenPosition3, formatTokenPosition2, false, true)) == null) {
                return;
            }
            formatTokenPosition2 = javaFormatSupport.findNonWhitespace(formatTokenPosition, null, true, true);
            if (formatTokenPosition2.getToken().getTokenID() == JavaTokenContext.LINE_COMMENT || formatTokenPosition2.getToken().getTokenID() == JavaTokenContext.LBRACE) {
                return;
            }
            boolean bl2 = true;
            while (bl2) {
                if (tokenItem.getPrevious() == formatTokenPosition.getToken()) {
                    bl2 = false;
                }
                if (javaFormatSupport.canRemoveToken(tokenItem.getPrevious())) {
                    javaFormatSupport.removeToken(tokenItem.getPrevious());
                    continue;
                }
                return;
            }
            if (javaFormatSupport.canInsertToken(tokenItem)) {
                javaFormatSupport.insertSpaces(tokenItem, 1);
            }
        }

        private void insertNewLineBeforeToken(TokenItem tokenItem, JavaFormatSupport javaFormatSupport) {
            FormatTokenPosition formatTokenPosition = javaFormatSupport.getPosition(tokenItem, 0);
            FormatTokenPosition formatTokenPosition2 = javaFormatSupport.findImportant(formatTokenPosition, null, true, true);
            if (formatTokenPosition2 != null && formatTokenPosition2.getToken().getTokenContextPath() == javaFormatSupport.getTokenContextPath() && javaFormatSupport.canInsertToken(tokenItem)) {
                javaFormatSupport.insertToken(tokenItem, javaFormatSupport.getValidWhitespaceTokenID(), javaFormatSupport.getValidWhitespaceTokenContextPath(), "\n");
                javaFormatSupport.removeLineEndWhitespace(formatTokenPosition2);
                javaFormatSupport.indentLine(formatTokenPosition);
            }
        }

        protected void formatLine(JavaFormatSupport javaFormatSupport, FormatTokenPosition formatTokenPosition) {
            block15: for (TokenItem tokenItem = javaFormatSupport.findLineStart(formatTokenPosition).getToken(); tokenItem != null; tokenItem = tokenItem.getNext()) {
                if (tokenItem.getTokenContextPath() != javaFormatSupport.getTokenContextPath()) continue;
                switch (tokenItem.getTokenID().getNumericID()) {
                    case 82: {
                        if (javaFormatSupport.getFormatNewlineBeforeBrace()) {
                            this.insertNewLineBeforeToken(tokenItem, javaFormatSupport);
                            continue block15;
                        }
                        this.removeLineBeforeToken(tokenItem, javaFormatSupport, true);
                        continue block15;
                    }
                    case 76: {
                        if (javaFormatSupport.getFormatNewlineBeforeBrace()) {
                            this.insertNewLineBeforeToken(tokenItem, javaFormatSupport);
                            continue block15;
                        }
                        this.removeLineBeforeToken(tokenItem, javaFormatSupport, true);
                        continue block15;
                    }
                    case 87: {
                        if (javaFormatSupport.getFormatNewlineBeforeBrace()) {
                            this.insertNewLineBeforeToken(tokenItem, javaFormatSupport);
                            continue block15;
                        }
                        this.removeLineBeforeToken(tokenItem, javaFormatSupport, true);
                        continue block15;
                    }
                    case 57: {
                        Object object;
                        Object object2;
                        if (javaFormatSupport.isIndentOnly()) continue block15;
                        if (javaFormatSupport.getFormatNewlineBeforeBrace()) {
                            object2 = javaFormatSupport.getPosition(tokenItem, 0);
                            object = javaFormatSupport.findImportant((FormatTokenPosition)object2, null, true, true);
                            if (object == null || object.getToken().getTokenContextPath() != javaFormatSupport.getTokenContextPath()) continue block15;
                            switch (object.getToken().getTokenID().getNumericID()) {
                                case 7: 
                                case 8: {
                                    continue block15;
                                }
                                case 56: {
                                    continue block15;
                                }
                                case 17: 
                                case 49: 
                                case 57: {
                                    continue block15;
                                }
                            }
                            FormatTokenPosition formatTokenPosition2 = javaFormatSupport.findImportant((FormatTokenPosition)object2, null, true, false);
                            if (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && formatTokenPosition2.getToken().getTokenID() == JavaTokenContext.RBRACE || !javaFormatSupport.canInsertToken(tokenItem)) continue block15;
                            javaFormatSupport.insertToken(tokenItem, javaFormatSupport.getValidWhitespaceTokenID(), javaFormatSupport.getValidWhitespaceTokenContextPath(), "\n");
                            javaFormatSupport.removeLineEndWhitespace((FormatTokenPosition)object);
                            javaFormatSupport.indentLine((FormatTokenPosition)object2);
                            continue block15;
                        }
                        object2 = javaFormatSupport.getPosition(tokenItem, 0);
                        object = javaFormatSupport.findNonWhitespace((FormatTokenPosition)object2, null, false, true);
                        if (object == null) continue block15;
                        switch (object.getToken().getTokenID().getNumericID()) {
                            case 6: 
                            case 54: 
                            case 82: 
                            case 87: 
                            case 113: {
                                this.removeLineBeforeToken(tokenItem, javaFormatSupport, false);
                            }
                        }
                        continue block15;
                    }
                    case 53: {
                        Object object;
                        Object object2;
                        if (javaFormatSupport.getFormatSpaceBeforeParenthesis()) {
                            object2 = tokenItem.getPrevious();
                            if (object2 == null || object2.getTokenID() != JavaTokenContext.IDENTIFIER && object2.getTokenID() != JavaTokenContext.THIS && object2.getTokenID() != JavaTokenContext.SUPER || !javaFormatSupport.canInsertToken(tokenItem)) continue block15;
                            javaFormatSupport.insertToken(tokenItem, javaFormatSupport.getWhitespaceTokenID(), javaFormatSupport.getWhitespaceTokenContextPath(), " ");
                            continue block15;
                        }
                        object2 = tokenItem.getPrevious();
                        if (object2 == null || object2.getTokenID() != JavaTokenContext.WHITESPACE || object2.getImage().length() != 1 || (object = object2.getPrevious()) == null || object.getTokenID() != JavaTokenContext.IDENTIFIER && object.getTokenID() != JavaTokenContext.THIS && object.getTokenID() != JavaTokenContext.SUPER || !javaFormatSupport.canRemoveToken((TokenItem)object2)) continue block15;
                        javaFormatSupport.removeToken((TokenItem)object2);
                    }
                }
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("java-strip-whitespace-at-line-end");
        }

        @Override
        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new JavaFormatSupport(formatWriter);
        }

        @Override
        public void format(FormatWriter formatWriter) {
            JavaFormatSupport javaFormatSupport = (JavaFormatSupport)this.createFormatSupport(formatWriter);
            FormatTokenPosition formatTokenPosition = javaFormatSupport.getFormatStartPosition();
            if (!javaFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    FormatTokenPosition formatTokenPosition2 = formatTokenPosition;
                    if ((formatTokenPosition = javaFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() != null) {
                        formatTokenPosition = javaFormatSupport.getNextPosition(formatTokenPosition);
                    }
                    if (!formatTokenPosition2.equals(formatTokenPosition)) continue;
                    break;
                }
            }
        }
    }
}

