/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.collection.impl;

import com.mathworks.comparisons.collection.impl.ComparisonCollectionFileImpl;
import com.mathworks.comparisons.collection.impl.NameAsFileComparator;
import com.mathworks.comparisons.source.impl.ZipEntrySource;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileCollection
extends ComparisonCollectionFileImpl {
    public ZipFileCollection(String string, File file, CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) throws IOException {
        super(string, ResourceManager.getString(cSPInfoIncludeRelativeFrom.getValue().length() == 0 ? "collectiontype.zipfile" : "collectiontype.zipfolder"), file, new NameAsFileComparator());
        this.checkArgument(file);
        boolean bl = cSPInfoIncludeSubFolders.getValue();
        String string2 = cSPInfoIncludeRelativeFrom.getValue();
        this.doLoad(bl, string2);
    }

    private synchronized void doLoad(boolean bl, String string) throws IOException {
        ZipFile zipFile = new ZipFile(this.getFile(), 1);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            int n = string.length();
            if (!string2.startsWith(string)) continue;
            if (bl) {
                if (zipEntry.isDirectory()) continue;
                this.addSource(new ZipEntrySource(this.getFile(), this.getName(), zipEntry, string2.substring(n)));
                continue;
            }
            int n2 = string2.indexOf(47, n);
            if (n2 == -1 && string2.length() > n) {
                this.addSource(new ZipEntrySource(this.getFile(), this.getName(), zipEntry, string2.substring(n)));
                continue;
            }
            int n3 = string2.lastIndexOf(47);
            if (n2 == n3 && string2.endsWith("/")) {
                assert (zipEntry.isDirectory());
                this.addSource(new ZipEntrySource(this.getFile(), this.getName(), zipEntry, string2.substring(n)));
                hashSet2.add(string2.substring(n));
                continue;
            }
            if (string2.length() <= n) continue;
            String string3 = string2.substring(n, n2 + 1);
            hashSet.add(string3);
        }
        for (String string2 : hashSet) {
            if (hashSet2.contains(string2)) continue;
            this.addSource(ZipEntrySource.createFolderPlaceholder(this.getFile(), string + string2, string2));
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkArgument(File file) throws FileNotFoundException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(ResourceManager.format("exception.filenotfound", file.getPath()));
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(ResourceManager.format("exception.absolutefilename", file.getPath()));
        }
    }
}

