/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.impl.CompareInMatlabGenerateHTML;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.data.CEventDataRefresh;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.CParameterDetailedBinaryComparison;
import com.mathworks.comparisons.result.impl.ComparisonResultBoolean;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyInputStream;
import com.mathworks.comparisons.source.property.CSPropertySize;
import com.mathworks.comparisons.util.LocalIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public class BinaryComparison
extends CompareInMatlabGenerateHTML {
    private static final String COMPARE_FUNCTION = "comparisons_private";
    private static final int NUM_OUT_ARGS = 1;
    private ComparisonParameterSet mParameterSet;
    private static Hashtable<String, BinaryComparison> sComparisons = null;

    @Override
    protected void setInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        this.mInputArgs = BinaryComparison.createInputArgs(comparisonSource, comparisonSource2, comparisonParameterSet, this.getReportID());
        this.mParameterSet = comparisonParameterSet;
    }

    public static Object[] createInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet, String string) {
        Object[] objectArray = new Object[5];
        objectArray[0] = "bindiff";
        objectArray[1] = comparisonSource;
        objectArray[2] = comparisonSource2;
        objectArray[3] = string;
        assert (comparisonParameterSet.hasParameter(CParameterDetailedBinaryComparison.getInstance()));
        Boolean bl = (Boolean)comparisonParameterSet.getValue(CParameterDetailedBinaryComparison.getInstance());
        objectArray[4] = bl;
        return objectArray;
    }

    @Override
    protected HTMLReportDecorator createDefaultDecorator() {
        return new HTMLReportDecorator(this.getMainEventListener());
    }

    @Override
    public void dispose() {
        super.dispose();
        BinaryComparison.removeComparison(this);
    }

    public BinaryComparison() {
        super(COMPARE_FUNCTION, 1);
        BinaryComparison.addComparison(this);
    }

    private ComparisonResultBoolean convertToComparisonResult(boolean bl) {
        ComparisonResultBoolean comparisonResultBoolean = new ComparisonResultBoolean();
        comparisonResultBoolean.addResultData(bl);
        return comparisonResultBoolean;
    }

    public static boolean compare(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) throws IOException {
        long l;
        long l2;
        CSPropertySize cSPropertySize = CSPropertySize.getInstance();
        assert (cSPropertySize.isValueType(Long.class));
        if (comparisonSource.hasProperty(cSPropertySize) && comparisonSource2.hasProperty(cSPropertySize) && (l2 = ((Long)comparisonSource.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0])).longValue()) != (l = ((Long)comparisonSource2.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0])).longValue()) && l2 != 0L && l != 0L) {
            return false;
        }
        return BinaryComparison.compareContents(comparisonSource, comparisonSource2);
    }

    public boolean compare(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = BinaryComparison.compare(comparisonSource, comparisonSource2);
        }
        catch (IOException iOException) {
            this.handle(iOException, bl);
        }
        return bl2;
    }

    public static boolean compareSize(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        CSPropertySize cSPropertySize = CSPropertySize.getInstance();
        assert (cSPropertySize.isValueType(Long.class));
        assert (comparisonSource.hasProperty(cSPropertySize) && comparisonSource2.hasProperty(cSPropertySize));
        return comparisonSource.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0]).equals(comparisonSource2.getPropertyValue(CSPropertySize.getInstance(), new ComparisonSourcePropertyInfo[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareContents(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) throws IOException {
        CSPropertyInputStream cSPropertyInputStream = CSPropertyInputStream.getInstance();
        assert (cSPropertyInputStream.isAssignableFromValueType(InputStream.class));
        assert (comparisonSource.hasProperty(cSPropertyInputStream) && comparisonSource2.hasProperty(cSPropertyInputStream));
        InputStream inputStream = (InputStream)comparisonSource.getPropertyValue(CSPropertyInputStream.getInstance(), new ComparisonSourcePropertyInfo[0]);
        try {
            InputStream inputStream2 = (InputStream)comparisonSource2.getPropertyValue(CSPropertyInputStream.getInstance(), new ComparisonSourcePropertyInfo[0]);
            try {
                boolean bl = LocalIOUtils.contentEquals(inputStream, inputStream2);
                comparisonSource2.refresh();
                return bl;
            }
            catch (Throwable throwable) {
                comparisonSource2.refresh();
                throw throwable;
            }
        }
        finally {
            comparisonSource.refresh();
        }
    }

    public void doRefresh(boolean bl) {
        this.mParameterSet.setValue(CParameterDetailedBinaryComparison.getInstance(), bl);
        this.getMainEventListener().processEvent(new ComparisonEvent(this, CEventDataRefresh.getInstance()));
    }

    public String getReportID() {
        return Integer.toString(this.hashCode());
    }

    private static void addComparison(BinaryComparison binaryComparison) {
        if (sComparisons == null) {
            sComparisons = new Hashtable();
        }
        sComparisons.put(binaryComparison.getReportID(), binaryComparison);
    }

    private static void removeComparison(BinaryComparison binaryComparison) {
        sComparisons.remove(binaryComparison.getReportID());
    }

    public static BinaryComparison getComparison(String string) {
        if (sComparisons == null) {
            return null;
        }
        return sComparisons.get(string);
    }

    public static Collection<String> getComparisonCodes() {
        if (sComparisons != null) {
            return sComparisons.keySet();
        }
        return new ArrayList<String>();
    }
}

