/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionUtilities;
import com.mathworks.comparisons.compare.concr.ListComparisonGenerator;
import com.mathworks.comparisons.main.ComparisonUtilities;
import com.mathworks.comparisons.main.NoSuitableComparisonTypeException;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.LocalConstants;
import com.mathworks.comparisons.util.MatlabRoot;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlwidgets.html.HTMLCallbackProvider;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.xml.XMLUtils;
import com.mathworks.xml.XMLValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class ListComparisonUtilities {
    private static Hashtable<String, ListComparisonGenerator> sComparisons = null;
    private static ThreadGroup fThreadGroup;
    private static String sStyleSheet;
    private static HTMLCallbackProvider sTestRenderer;
    private static File sDebugDirectory;

    static void addComparison(ListComparisonGenerator listComparisonGenerator) {
        if (sComparisons == null) {
            sComparisons = new Hashtable();
        }
        sComparisons.put(listComparisonGenerator.getReportID(), listComparisonGenerator);
    }

    static void removeComparison(ListComparisonGenerator listComparisonGenerator) {
        sComparisons.remove(listComparisonGenerator.getReportID());
    }

    static ListComparisonGenerator getComparison(String string) {
        if (sComparisons == null) {
            return null;
        }
        return sComparisons.get(string);
    }

    public static Collection<String> getComparisonCodes() {
        if (sComparisons != null) {
            return sComparisons.keySet();
        }
        return new ArrayList<String>();
    }

    public static ThreadGroup getThreadGroup() {
        if (fThreadGroup == null) {
            fThreadGroup = new ThreadGroup("ListComparisons");
        }
        return fThreadGroup;
    }

    public static synchronized String getStyleSheet() {
        if (sStyleSheet == null) {
            sStyleSheet = LocalConstants.COMPARISONS_TOOLBOX_FOLDER + File.separator + "private" + File.separator + "listcomparison.xsl";
        }
        return sStyleSheet;
    }

    public static synchronized void setStyleSheet(String string) {
        sStyleSheet = string;
    }

    public static HTMLCallbackProvider getTestRenderer() {
        return sTestRenderer;
    }

    public static void setTestRenderer(HTMLCallbackProvider hTMLCallbackProvider) {
        sTestRenderer = hTMLCallbackProvider;
    }

    public static void setDebugDirectory(String string) {
        sDebugDirectory = string != null ? new File(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void debugSaveHTML(String string) {
        if (sDebugDirectory == null) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = File.createTempFile("diffreport_", ".html", sDebugDirectory);
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write(string);
            System.out.println("HTML output saved in " + file.getAbsolutePath());
            file.deleteOnExit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void debugSaveXML(Document document) {
        ListComparisonUtilities.debugSaveXML(document, ListComparisonUtilities.getStyleSheet().replaceAll("l$", "d"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugSaveXML(Document document, String string) {
        if (sDebugDirectory == null) {
            return;
        }
        String string2 = "javax.xml.transform.TransformerFactory";
        String string3 = System.getProperty(string2);
        System.setProperty(string2, "net.sf.saxon.TransformerFactoryImpl");
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            File file = File.createTempFile("editscript_", ".xml", sDebugDirectory);
            XMLUtils.serializeXML((Object)document, (Object)new StreamResult(file));
            file.deleteOnExit();
            System.out.println("Edit script saved in " + file.getAbsolutePath());
            inputStream2 = new FileInputStream(file);
            inputStream = new FileInputStream(string);
            XMLValidator.ValidationResults validationResults = XMLValidator.validate((InputStream)inputStream2, (InputStream)inputStream);
            if (validationResults.hasErrors()) {
                System.out.println(validationResults.getErrorMessage());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (string3 == null) {
                System.clearProperty(string2);
            } else {
                System.setProperty(string2, string3);
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static String doTransform(Source source) throws Exception {
        return ListComparisonUtilities.doTransform(source, ListComparisonUtilities.getStyleSheet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doTransform(Source source, String string) throws Exception {
        String string2 = "javax.xml.transform.TransformerFactory";
        String string3 = System.getProperty(string2);
        System.setProperty(string2, "net.sf.saxon.TransformerFactoryImpl");
        try {
            Source source2 = XMLUtils.transformSourceFactory((Object)string);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(source2);
            Transformer transformer = templates.newTransformer();
            transformer.setParameter("matlabroot", HTMLUtils.getURLStringFromFile((File)new File(MatlabRoot.get())));
            transformer.transform(source, streamResult);
            String string4 = stringWriter.toString();
            ListComparisonUtilities.debugSaveHTML(string4);
            String string5 = string4;
            return string5;
        }
        catch (Throwable throwable) {
            ExceptionHandler.rethrow(throwable);
            String string6 = null;
            return string6;
        }
        finally {
            if (string3 == null) {
                System.clearProperty(string2);
            } else {
                System.setProperty(string2, string3);
            }
        }
    }

    public static void viewFile(String string, String string2, String string3) {
        String string4;
        ComparisonCollection comparisonCollection;
        ListComparisonGenerator listComparisonGenerator = ListComparisonUtilities.getComparison(string);
        if (listComparisonGenerator == null) {
            throw new IllegalArgumentException("Report " + string + " has been closed");
        }
        if (string2.equals("left")) {
            comparisonCollection = listComparisonGenerator.getLeftCollection();
        } else if (string2.equals("right")) {
            comparisonCollection = listComparisonGenerator.getRightCollection();
        } else {
            throw new IllegalArgumentException("Side must be \"left\" or \"right\"");
        }
        ComparisonSource comparisonSource = ComparisonCollectionUtilities.getSourceByName(comparisonCollection, string3);
        if (comparisonSource == null) {
            listComparisonGenerator.reportError(ResourceManager.format("listcomparison.fileNotFound", string3));
        }
        try {
            File file = (File)comparisonSource.getPropertyValue(CSPropertyReadableLocation.getInstance(), new ComparisonSourcePropertyInfo[0]);
            if (file == null) {
                return;
            }
            string4 = file.getAbsolutePath();
        }
        catch (RuntimeException runtimeException) {
            listComparisonGenerator.reportError(runtimeException.getMessage());
            return;
        }
        new Matlab().feval("uiopen", new Object[]{string4, 1}, 0, new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
            }
        });
    }

    public static void compareFiles(String string, final String string2) {
        final ListComparisonGenerator listComparisonGenerator = ListComparisonUtilities.getComparison(string);
        if (listComparisonGenerator == null) {
            throw new IllegalArgumentException("Report " + string + " has been closed");
        }
        final ComparisonSource comparisonSource = ComparisonCollectionUtilities.getSourceByName(listComparisonGenerator.getLeftCollection(), string2);
        final ComparisonSource comparisonSource2 = ComparisonCollectionUtilities.getSourceByName(listComparisonGenerator.getRightCollection(), string2);
        Thread thread = new Thread(ListComparisonUtilities.getThreadGroup(), new Runnable(){

            @Override
            public void run() {
                if (comparisonSource == null) {
                    listComparisonGenerator.reportError(ResourceManager.format("listcomparison.fileNotFound", string2));
                } else if (comparisonSource2 == null) {
                    listComparisonGenerator.reportError(ResourceManager.format("listcomparison.fileNotFound", string2));
                } else {
                    try {
                        ComparisonUtilities.startComparison(comparisonSource, comparisonSource2, true);
                    }
                    catch (NoSuitableComparisonTypeException noSuitableComparisonTypeException) {
                        ListComparisonUtilities.reportError(listComparisonGenerator, comparisonSource, comparisonSource2, noSuitableComparisonTypeException);
                    }
                }
            }
        });
        thread.start();
    }

    private static void reportError(ListComparisonGenerator listComparisonGenerator, ComparisonSource comparisonSource, ComparisonSource comparisonSource2, NoSuitableComparisonTypeException noSuitableComparisonTypeException) {
        File file;
        CSPropertyReadableLocation cSPropertyReadableLocation = CSPropertyReadableLocation.getInstance();
        try {
            if (comparisonSource2.hasProperty(cSPropertyReadableLocation) && !(file = (File)comparisonSource2.getPropertyValue(cSPropertyReadableLocation, new ComparisonSourcePropertyInfo[0])).exists()) {
                listComparisonGenerator.reportError(ResourceManager.format("listcomparison.fileNotFound", file.getAbsolutePath()));
                return;
            }
        }
        catch (Exception exception) {
            listComparisonGenerator.reportError(exception.getMessage());
            return;
        }
        try {
            if (comparisonSource.hasProperty(cSPropertyReadableLocation) && !(file = (File)comparisonSource.getPropertyValue(cSPropertyReadableLocation, new ComparisonSourcePropertyInfo[0])).exists()) {
                listComparisonGenerator.reportError(ResourceManager.format("listcomparison.fileNotFound", file.getAbsolutePath()));
                return;
            }
        }
        catch (Exception exception) {
            listComparisonGenerator.reportError(exception.getMessage());
            return;
        }
        listComparisonGenerator.reportError(noSuitableComparisonTypeException.getMessage());
    }

    public static ComparisonCollection getLeftCollectionForReport(String string) {
        ListComparisonGenerator listComparisonGenerator = ListComparisonUtilities.getComparison(string);
        if (listComparisonGenerator == null) {
            throw new IllegalArgumentException("Report " + string + " has been closed");
        }
        return listComparisonGenerator.getLeftCollection();
    }

    public static ComparisonCollection getRightCollectionForReport(String string) {
        ListComparisonGenerator listComparisonGenerator = ListComparisonUtilities.getComparison(string);
        if (listComparisonGenerator == null) {
            throw new IllegalArgumentException("Report " + string + " has been closed");
        }
        return listComparisonGenerator.getRightCollection();
    }

    public static void skipAsync(String string) {
        ListComparisonGenerator listComparisonGenerator = ListComparisonUtilities.getComparison(string);
        if (listComparisonGenerator == null) {
            throw new IllegalArgumentException("Report " + string + " has been closed");
        }
        listComparisonGenerator.getQueue().cancelCurrent();
    }

    public static void cancelAsync(String string) {
        ListComparisonGenerator listComparisonGenerator = ListComparisonUtilities.getComparison(string);
        if (listComparisonGenerator == null) {
            throw new IllegalArgumentException("Report " + string + " has been closed");
        }
        listComparisonGenerator.getQueue().cancelAll();
    }

    public static String fileNameToId(String string) {
        return Integer.toString(string.hashCode());
    }

    static {
        sStyleSheet = null;
        sDebugDirectory = null;
    }
}

