/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.main;

import com.mathworks.comparisons.compare.CannotRunWithoutDisplayException;
import com.mathworks.comparisons.compare.Comparison;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventData;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.main.ComparisonTool;
import com.mathworks.comparisons.main.ComparisonUtilities;
import com.mathworks.comparisons.main.SelectionIncompleteException;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.report.ComparisonReport;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.dialog.SourceSelectionDialog;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.ComparisonSourceUtilities;
import com.mathworks.comparisons.source.impl.LocalFileSource;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.Desktop;
import java.io.File;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;

public class ComparisonDriver
implements ComparisonEventListener {
    private static Map<String, Method> sKnownEventMethods = new HashMap<String, Method>();
    private static Set<String> sUnknownEventNames = new HashSet<String>();
    private final ComparisonSelection mCurrentSelection;
    private final Set<ComparisonStatus> mComparisonStatus = EnumSet.noneOf(ComparisonStatus.class);
    private Comparison<?> mComparison = null;
    private Desktop mParentDesktop = null;
    private DTGroupPropertyProvider mParentGroup = null;
    private ComparisonReport mReport = null;

    public ComparisonDriver(ComparisonSelection comparisonSelection) {
        this.mCurrentSelection = comparisonSelection;
        if (this.mCurrentSelection.isSelectionReady()) {
            this.mComparisonStatus.add(ComparisonStatus.SELECTION_READY);
        }
    }

    public void compareAndDisplay(Desktop desktop, DTGroupPropertyProvider dTGroupPropertyProvider) {
        this.mParentDesktop = desktop;
        this.mParentGroup = dTGroupPropertyProvider;
        SourceSelectionDialog sourceSelectionDialog = null;
        if (!this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY)) {
            sourceSelectionDialog = ComparisonUtilities.createSelectionDialog(this, this.mCurrentSelection);
        }
        ComparisonReport.createComparisonReport(desktop, dTGroupPropertyProvider, this, sourceSelectionDialog);
    }

    public ComparisonResult<?> compareAndReturn() throws CannotRunWithoutDisplayException, SelectionIncompleteException {
        if (this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY)) {
            ComparisonType comparisonType = this.mCurrentSelection.getComparisonType();
            if (comparisonType.hasFeature(ComparisonTypeFeature.CANRUNWITHOUTDISPLAY)) {
                this.mCurrentSelection.prepareForComparison();
                this.updatePreviouslyComparedList();
                this.mComparison = comparisonType.createComparison();
                return this.mComparison.compareAndReturn(this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST), this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND), this.mCurrentSelection);
            }
            throw new CannotRunWithoutDisplayException(comparisonType.getDescription());
        }
        throw new SelectionIncompleteException();
    }

    public void dispose() {
        if (this.mComparison != null) {
            this.mComparison.dispose();
            this.mComparison = null;
        }
        if (this.mCurrentSelection != null) {
            this.mCurrentSelection.dispose();
        }
        ComparisonTool.getInstance().removeDriver(this);
        this.mReport = null;
    }

    @Override
    public void processEvent(ComparisonEvent comparisonEvent) {
        assert (comparisonEvent != null && comparisonEvent.getEventData() != null);
        ComparisonEventData comparisonEventData = comparisonEvent.getEventData();
        String string = comparisonEventData.getName();
        Method method = this.getEventHandlerFor(string);
        if (method != null) {
            try {
                method.invoke((Object)this, comparisonEvent);
            }
            catch (Throwable throwable) {
                ExceptionHandler.rethrow(throwable);
            }
        }
    }

    private void handleReportCreated(ComparisonEvent comparisonEvent) {
        assert (comparisonEvent.getSource() instanceof ComparisonReport);
        this.mComparisonStatus.add(ComparisonStatus.REPORT_CREATED);
        this.mReport = (ComparisonReport)((Object)comparisonEvent.getSource());
    }

    private void handleReportOpened(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_OPENED);
        if (this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY)) {
            this.whenSelectionReady();
        }
    }

    private void handleReportClosed(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_CLOSED);
        this.dispose();
    }

    private void handleReportClosing(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_CLOSING);
        if (this.mComparison != null) {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    ComparisonDriver.this.mComparison.close();
                    return null;
                }

                @Override
                protected void done() {
                    if (ComparisonDriver.this.mReport != null) {
                        ComparisonDriver.this.mReport.approveClose();
                    }
                }
            }.execute();
        } else if (this.mReport != null) {
            this.mReport.approveClose();
        }
    }

    private void handleSelectionDialogCreated(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.SELECTION_DIALOG_CREATED);
        if (this.mReport != null) {
            this.mReport.showDialog();
        }
    }

    private void handleSelectionDialogDisposed(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.SELECTION_DIALOG_DISPOSED);
    }

    private void handleSelectionReady(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.SELECTION_READY);
        this.mReport.disposeDialog();
        this.whenSelectionReady();
    }

    private void handleComparisonStarted(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.COMPARISON_STARTED);
    }

    private void handleComparisonFinished(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.COMPARISON_FINISHED);
    }

    private void handleComparisonCancelled(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.COMPARISON_CANCELLED);
    }

    private void handleErrorOccurred(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.ERROR_OCCURRED);
    }

    private synchronized void handleNewComparison(ComparisonEvent comparisonEvent) {
        if (this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY) || this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_DIALOG_DISPOSED)) {
            ComparisonUtilities.startEmptyComparison(this.mParentDesktop, this.mParentGroup);
        } else {
            this.mReport.showDialog();
        }
    }

    private void handleSwapSides(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_STARTED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_FINISHED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_CANCELLED);
        this.mCurrentSelection.swap();
        this.whenDecorationReady();
    }

    private void handleRefresh(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_STARTED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_FINISHED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_CANCELLED);
        this.mCurrentSelection.refresh();
        this.whenDecorationReady();
    }

    private void whenSelectionReady() {
        if (this.mReport == null) {
            return;
        }
        assert (this.mCurrentSelection.isSelectionReady());
        ComparisonType comparisonType = this.mCurrentSelection.getComparisonType();
        this.mComparison = comparisonType.createComparison();
        this.mComparison.setMainComparisonEventListener(this);
        this.performDecoration();
    }

    private void performDecoration() {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_DECORATION_STARTED);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComparisonReportDecorator comparisonReportDecorator = ComparisonDriver.this.mComparison.getDecorator();
                assert (comparisonReportDecorator != null) : "Comparison should specify a decorator";
                ComparisonDriver.this.mReport.setCentralComponent(comparisonReportDecorator.createCentralComponent());
                ComparisonDriver.this.mReport.setToolBar(comparisonReportDecorator.decorate(ComparisonDriver.this.mReport.getToolBar()));
                ComparisonDriver.this.mReport.setMenuBar(comparisonReportDecorator.decorate(ComparisonDriver.this.mReport.getMenuBar()));
                ComparisonDriver.this.mComparisonStatus.add(ComparisonStatus.REPORT_DECORATION_FINISHED);
                ComparisonDriver.this.whenDecorationReady();
            }
        });
    }

    private void whenDecorationReady() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComparisonDriver.this.mComparison.getDecorator().disableControls();
            }
        });
        this.mCurrentSelection.prepareForComparison();
        ComparisonSource comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
        ComparisonSource comparisonSource2 = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
        this.setReportTitleFor(comparisonSource, comparisonSource2);
        this.mComparison.compareAndDisplay(comparisonSource, comparisonSource2, this.mCurrentSelection);
        this.updatePreviouslyComparedList();
    }

    private void updatePreviouslyComparedList() {
        String string;
        ComparisonSource comparisonSource;
        SourceSelectionListModel sourceSelectionListModel = ComparisonTool.getInstance().getPreviouslyComparedList();
        Object object = this.mCurrentSelection.getSelection(ComparisonSelection.Index.FIRST);
        Object object2 = this.mCurrentSelection.getSelection(ComparisonSelection.Index.SECOND);
        if (object2 == null) {
            comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
            if (comparisonSource instanceof LocalFileSource) {
                string = (String)comparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
                sourceSelectionListModel.add(new File(string));
            }
        } else {
            sourceSelectionListModel.add(object2);
        }
        if (object == null) {
            comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
            if (comparisonSource instanceof LocalFileSource) {
                string = (String)comparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
                sourceSelectionListModel.add(new File(string));
            }
        } else {
            sourceSelectionListModel.add(object);
        }
    }

    private void setReportTitleFor(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        String string = ComparisonSourceUtilities.getSuitableTitle(comparisonSource);
        String string2 = ComparisonSourceUtilities.getSuitableShortTitle(comparisonSource);
        String string3 = ComparisonSourceUtilities.getSuitableTitle(comparisonSource2);
        String string4 = ComparisonSourceUtilities.getSuitableShortTitle(comparisonSource2);
        if (string == null) {
            string = string3;
        }
        if (string2 == null) {
            string2 = string4;
        }
        if (string != null && string.equals(string3)) {
            string3 = null;
        }
        if (string2 != null && string2.equals(string4)) {
            string4 = null;
        }
        if (string != null && string3 != null) {
            this.mReport.setTitle(ResourceManager.format("comparisonreport.title.two", string, string3));
        } else if (string != null) {
            this.mReport.setTitle(ResourceManager.format("comparisonreport.title.one", string));
        } else {
            this.mReport.setTitle(this.mCurrentSelection.getComparisonType().getDescription());
        }
        if (string2 != null && string4 != null) {
            this.mReport.setShortTitle(ResourceManager.format("comparisonreport.title.two", string2, string4));
        } else if (string2 != null) {
            this.mReport.setShortTitle(ResourceManager.format("comparisonreport.title.one", string2));
        } else {
            String string5 = this.mCurrentSelection.getComparisonType().getDescription();
            if (string5.length() > 31) {
                string5 = string5.substring(0, 31);
            }
            this.mReport.setShortTitle(string5);
        }
    }

    private synchronized Method getEventHandlerFor(String string) {
        Method method = null;
        if (!sUnknownEventNames.contains(string)) {
            if (sKnownEventMethods.containsKey(string)) {
                method = sKnownEventMethods.get(string);
            } else {
                method = this.resolveMethod(string);
                if (method == null) {
                    sUnknownEventNames.add(string);
                } else {
                    sKnownEventMethods.put(string, method);
                }
            }
        }
        return method;
    }

    private Method resolveMethod(String string) {
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("handle" + string, ComparisonEvent.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static enum ComparisonStatus {
        REPORT_CREATED,
        REPORT_OPENED,
        REPORT_CLOSED,
        REPORT_CLOSING,
        SELECTION_DIALOG_CREATED,
        SELECTION_DIALOG_DISPOSED,
        SELECTION_READY,
        REPORT_DECORATION_STARTED,
        REPORT_DECORATION_FINISHED,
        COMPARISON_STARTED,
        COMPARISON_FINISHED,
        COMPARISON_CANCELLED,
        ERROR_OCCURRED,
        DRIVER_DISPOSED;

    }
}

