/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report;

import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.event.ComparisonEventSupport;
import com.mathworks.comparisons.event.data.CEventDataNewComparison;
import com.mathworks.comparisons.event.data.CEventDataReportClosed;
import com.mathworks.comparisons.event.data.CEventDataReportClosing;
import com.mathworks.comparisons.event.data.CEventDataReportCreated;
import com.mathworks.comparisons.event.data.CEventDataReportOpened;
import com.mathworks.comparisons.report.ComparisonReportGroup;
import com.mathworks.comparisons.selection.dialog.SourceSelectionDialog;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ComparisonReport
extends DTClientBase {
    public static final String COMPONENT_CLIENT_NAME = "Comparison Report";
    public static final String COMPONENT_NEW_COMPARISON = "New";
    private final Desktop mDesktop;
    private final ComparisonEventSupport mEventSupport = new ComparisonEventSupport();
    private final Action mNewAction = new NewComparisonFromClient();
    private final ComparisonReportListener mReportListener = new ComparisonReportListener();
    private SourceSelectionDialog mSelectionDialog = null;
    private String mTitle = ResourceManager.getString("comparisonreport.initialtitle");
    private String mShortTitle = null;
    private MJToolBar mClientToolBar = null;
    private MJMenuBar mClientMenuBar = null;
    private Component mCentralComponent = null;
    private Object fClientClosingEventData = null;

    public static void createComparisonReport(final Desktop desktop, final DTGroupPropertyProvider dTGroupPropertyProvider, final ComparisonEventListener comparisonEventListener, final SourceSelectionDialog sourceSelectionDialog) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComparisonReport comparisonReport = new ComparisonReport(desktop, dTGroupPropertyProvider, comparisonEventListener, sourceSelectionDialog);
                desktop.addClient((Component)((Object)comparisonReport), comparisonReport.getTitle());
            }
        });
    }

    private ComparisonReport(Desktop desktop, DTGroupPropertyProvider dTGroupPropertyProvider, ComparisonEventListener comparisonEventListener, SourceSelectionDialog sourceSelectionDialog) {
        CheckNullArgument.check(desktop, "aDesktop");
        CheckNullArgument.check(comparisonEventListener, "aMainEventListener");
        this.mDesktop = desktop;
        this.mSelectionDialog = sourceSelectionDialog;
        this.setName(COMPONENT_CLIENT_NAME);
        this.setMultipleInstances(true);
        if (dTGroupPropertyProvider != null) {
            this.setGroup(dTGroupPropertyProvider);
        }
        this.putClientProperty(DTClientProperty.DONT_REOPEN, Boolean.TRUE);
        this.mEventSupport.addComparisonEventListener(comparisonEventListener);
        desktop.addClientListener((Component)((Object)this), (DTClientListener)this.mReportListener);
        this.initLayout();
        this.mEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportCreated.getInstance()));
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String string) {
        super.setTitle(string);
        assert (string != null);
        this.mTitle = string;
    }

    public String getShortTitle() {
        return this.mShortTitle;
    }

    public void setShortTitle(String string) {
        super.setShortTitle(string);
        assert (string != null);
        this.mShortTitle = string;
    }

    public MJToolBar getToolBar() {
        return this.mClientToolBar;
    }

    public void setToolBar(MJToolBar mJToolBar) {
        super.setToolBar((JToolBar)this.mClientToolBar);
        assert (mJToolBar != null);
        this.mClientToolBar = mJToolBar;
    }

    public MJMenuBar getMenuBar() {
        return this.mClientMenuBar;
    }

    public void setMenuBar(MJMenuBar mJMenuBar) {
        super.setMenuBar((JMenuBar)mJMenuBar);
        assert (mJMenuBar != null);
        this.mClientMenuBar = mJMenuBar;
    }

    public Component getCentralComponent() {
        return this.mCentralComponent;
    }

    public void setCentralComponent(Component component) {
        assert (component != null);
        this.mCentralComponent = component;
        this.add(this.mCentralComponent, "Center");
    }

    public void showDialog() {
        if (this.mSelectionDialog != null) {
            this.mSelectionDialog.showDialog();
        }
    }

    public void disposeDialog() {
        if (this.mSelectionDialog != null) {
            this.mSelectionDialog.dispose();
            this.mSelectionDialog = null;
        }
    }

    public void approveClose() {
        this.approveClose(this.fClientClosingEventData);
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlLtHighlight")));
        this.setBackground(ColorPrefs.getBackgroundColor());
        if (this.mClientToolBar == null) {
            this.mClientToolBar = this.createToolBar();
        }
        if (this.mClientMenuBar == null) {
            this.mClientMenuBar = this.createMenuBar();
        }
        this.setToolBar(this.mClientToolBar);
        this.setMenuBar(this.mClientMenuBar);
    }

    private MJToolBar createToolBar() {
        MJToolBar mJToolBar = ComparisonReportGroup.createEmptyToolBar();
        mJToolBar.add(this.mNewAction);
        return mJToolBar;
    }

    private MJMenuBar createMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        MJMenu mJMenu = new MJMenu();
        DTMenuMergeTag.FILE.setTag((JMenuItem)mJMenu);
        DTMenuMergeTag.NEW.setTag(this.mNewAction);
        mJMenu.add(this.mNewAction);
        mJMenu.add((JMenuItem)new DTMenuOmission(DTMenuMergeTag.OPEN));
        mJMenuBar.add((JMenu)mJMenu);
        return mJMenuBar;
    }

    private void handleReportOpened() {
        if (this.mSelectionDialog != null) {
            this.mSelectionDialog.attach(this.getCurrentFrame());
        }
        this.mEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportOpened.getInstance()));
    }

    private void handleReportDockingChanged() {
        if (this.mSelectionDialog != null) {
            this.mSelectionDialog.attach(this.getCurrentFrame());
        }
    }

    private void handleReportClosed() {
        this.mEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportClosed.getInstance()));
        this.dispose();
    }

    private void handleReportClosing() {
        this.mEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataReportClosing.getInstance()));
    }

    private synchronized void dispose() {
        this.disposeDialog();
        this.mEventSupport.removeAllComparisonEventListeners();
        if (this.mReportListener != null) {
            this.mDesktop.removeClientListener((Component)((Object)this), (DTClientListener)this.mReportListener);
        }
        this.mDesktop.removeClient((Component)((Object)this));
        if (this.mClientToolBar != null) {
            this.mClientToolBar.dispose();
        }
        if (this.mClientMenuBar != null) {
            this.mClientMenuBar.dispose();
        }
    }

    private synchronized Frame getCurrentFrame() {
        return (Frame)SwingUtilities.windowForComponent((Component)((Object)this));
    }

    private class ComparisonReportListener
    extends DTClientAdapter {
        private boolean mFirstTimeActivated = false;

        public void clientOpened(DTClientEvent dTClientEvent) {
            this.mFirstTimeActivated = true;
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            if (this.mFirstTimeActivated) {
                this.mFirstTimeActivated = false;
                ComparisonReport.this.handleReportOpened();
            }
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            ComparisonReport.this.handleReportDockingChanged();
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            ComparisonReport.this.handleReportDockingChanged();
        }

        public void clientRelocated(DTClientEvent dTClientEvent) {
            ComparisonReport.this.handleReportDockingChanged();
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            ComparisonReport.this.handleReportClosed();
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            ComparisonReport.this.fClientClosingEventData = dTClientEvent.getData();
            ComparisonReport.this.deferClose();
            ComparisonReport.this.handleReportClosing();
        }
    }

    private class NewComparisonFromClient
    extends MJAbstractAction {
        public NewComparisonFromClient() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("comparisons", "comparisons-new", (ExtendedAction)this);
            this.setComponentName(ComparisonReport.COMPONENT_NEW_COMPARISON);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ComparisonReport.this.mEventSupport.fireComparisonEvent(new ComparisonEvent((Object)this, CEventDataNewComparison.getInstance()));
        }
    }
}

