/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.selection.DropPolicy;
import com.mathworks.comparisons.selection.dialog.SourceSelectionComboBoxModel;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.util.Log;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public final class SourceSelectionComboBox
extends MJComboBox {
    public static final String ACTION_COMMAND = "SelectionChanged";
    private final Map<DataFlavor, DropPolicy> mDropPolicyRegister = new HashMap<DataFlavor, DropPolicy>();
    private final SourceSelectionDropTargetListener mDropTargetListener;
    private final DropTarget mDropTarget;

    public SourceSelectionComboBox(SourceSelectionComboBoxModel sourceSelectionComboBoxModel) {
        super((ComboBoxModel)sourceSelectionComboBoxModel);
        this.setActionCommand(ACTION_COMMAND);
        JComponent jComponent = (JComponent)this.getEditor().getEditorComponent();
        this.mDropTargetListener = new SourceSelectionDropTargetListener();
        this.mDropTarget = new DropTarget(jComponent, 1, this.mDropTargetListener);
        this.removeContextMemu(jComponent);
        this.setupCutCopyPaste(jComponent);
    }

    public void register(DropPolicy dropPolicy) {
        if (dropPolicy != null) {
            DataFlavor dataFlavor = dropPolicy.getDataFlavor();
            if (!this.mDropPolicyRegister.containsKey(dataFlavor)) {
                this.mDropPolicyRegister.put(dataFlavor, dropPolicy);
            } else {
                throw new UnsupportedOperationException(ResourceManager.format("exception.toomanypolicies", "DropPolicy", dataFlavor.toString()));
            }
        }
    }

    public void setCurrentStringConversionPolicyClass(Class<?> clazz) {
        SourceSelectionComboBoxModel sourceSelectionComboBoxModel = (SourceSelectionComboBoxModel)this.getModel();
        sourceSelectionComboBoxModel.setCurrentStringConversionPolicyClass(clazz);
        if (sourceSelectionComboBoxModel.getSelectedItem() != null) {
            this.setSelectedItem(sourceSelectionComboBoxModel.getSelectedItem().toString());
        }
    }

    public Class<?> getCurrentStringConversionPolicyClass() {
        return ((SourceSelectionComboBoxModel)this.getModel()).getCurrentStringConversionPolicyClass();
    }

    public void dispose() {
        this.setModel(new DefaultComboBoxModel());
    }

    private void removeContextMemu(JComponent jComponent) {
        for (MouseListener mouseListener : jComponent.getMouseListeners()) {
            if (!(mouseListener instanceof PopupListener) || !mouseListener.getClass().getSimpleName().equals("ContextMenuListener")) continue;
            jComponent.removeMouseListener(mouseListener);
        }
    }

    private void setupCutCopyPaste(JComponent jComponent) {
        SourceSelectionTransferHandler sourceSelectionTransferHandler = new SourceSelectionTransferHandler(jComponent.getTransferHandler());
        jComponent.setTransferHandler(sourceSelectionTransferHandler);
    }

    private class SourceSelectionDropTargetListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.dragMethodCalled(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.dragMethodCalled(dropTargetDragEvent);
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            for (DataFlavor dataFlavor : SourceSelectionComboBox.this.mDropPolicyRegister.keySet()) {
                if (!dropTargetDropEvent.isDataFlavorSupported(dataFlavor)) continue;
                try {
                    dropTargetDropEvent.acceptDrop(1);
                    Object t = ((DropPolicy)SourceSelectionComboBox.this.mDropPolicyRegister.get(dataFlavor)).decode(dropTargetDropEvent.getTransferable());
                    SourceSelectionComboBox.this.setSelectedItem(t);
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    dropTargetDropEvent.rejectDrop();
                    Log.logException((Exception)unsupportedFlavorException);
                }
            }
            dropTargetDropEvent.rejectDrop();
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        private void dragMethodCalled(DropTargetDragEvent dropTargetDragEvent) {
            for (DataFlavor dataFlavor : SourceSelectionComboBox.this.mDropPolicyRegister.keySet()) {
                if (!dropTargetDragEvent.isDataFlavorSupported(dataFlavor)) continue;
                dropTargetDragEvent.acceptDrag(1);
                return;
            }
            dropTargetDragEvent.rejectDrag();
        }
    }

    private class SourceSelectionTransferHandler
    extends TransferHandler {
        private final TransferHandler mOriginalEditorTransferHandler;

        public SourceSelectionTransferHandler(TransferHandler transferHandler) {
            this.mOriginalEditorTransferHandler = transferHandler;
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            boolean bl = false;
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!SourceSelectionComboBox.this.mDropPolicyRegister.containsKey(dataFlavor) && !dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            for (DataFlavor dataFlavor : SourceSelectionComboBox.this.mDropPolicyRegister.keySet()) {
                if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                try {
                    Object t = ((DropPolicy)SourceSelectionComboBox.this.mDropPolicyRegister.get(dataFlavor)).decode(transferable);
                    SourceSelectionComboBox.this.setSelectedItem(t);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Log.logException((Exception)unsupportedFlavorException);
                }
            }
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    return this.mOriginalEditorTransferHandler.importData(jComponent, transferable);
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return this.mOriginalEditorTransferHandler.getSourceActions(jComponent);
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            this.mOriginalEditorTransferHandler.exportToClipboard(jComponent, clipboard, n);
        }
    }
}

