/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import ice.cert.CertificateParsingException;
import ice.cert.DERValue;
import ice.cert.OID;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class DERUtil {
    public static final byte INDIFFERENT = 0;
    public static final byte NO_REMAIN = 1;
    public static final byte REMAIN = 2;
    private static final SimpleDateFormat OEAB = new SimpleDateFormat("yyyyMMddHHmmssz");

    private DERUtil() {
    }

    public static byte[] decode(byte[] byArray, DERValue dERValue) throws CertificateParsingException {
        return DERUtil.decode(byArray, dERValue, -1, (byte)0);
    }

    public static byte[] decode(byte[] byArray, DERValue dERValue, byte by) throws CertificateParsingException {
        return DERUtil.decode(byArray, dERValue, -1, by);
    }

    public static byte[] decode(byte[] byArray, DERValue dERValue, int n) throws CertificateParsingException {
        return DERUtil.decode(byArray, dERValue, n, (byte)0);
    }

    public static byte[] decode(byte[] byArray, DERValue dERValue, int n, byte by) throws CertificateParsingException {
        int n2;
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        n5 = byArray[n4++] & 0xFF;
        n6 = n5 >> 6;
        bl = (n5 & 0x20) != 0;
        if ((n5 & 0x1F) == 31) {
            do {
                n5 = byArray[n4++] & 0x7F;
                n7 = n7 << 7 | n5;
            } while ((n5 & 0x80) == 128);
        } else {
            n7 = n5 & 0x1F;
        }
        n5 = byArray[n4++] & 0xFF;
        if ((n5 & 0x80) == 128) {
            n2 = n5 & 0x7F;
            while (n2 > 0) {
                n5 = byArray[n4++] & 0xFF;
                n8 = (n8 << 8) + n5;
                --n2;
            }
        } else {
            n8 = n5;
        }
        n2 = n4;
        if (n4 + n8 > n3) {
            throw new CertificateParsingException("entity length (" + (n4 + n8) + ") bigger than number of actual bytes (" + n3 + ").");
        }
        if (n4 + n8 == n3 && by == 2) {
            throw new CertificateParsingException("missing bytes in certificate");
        }
        if (n4 + n8 < n3 && by == 1) {
            throw new CertificateParsingException("unexpected bytes in the certificate");
        }
        byte[] byArray2 = new byte[n3 - n4 - n8];
        System.arraycopy(byArray, n4 + n8, byArray2, 0, byArray2.length);
        dERValue.setDerClass(n6);
        dERValue.setTagNumber(n7);
        dERValue.setLength(n8);
        if (n6 != 0) {
            if (n != -1 && n != 0) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(0) + ") in certificate.");
            }
            byte[] byArray3 = new byte[n8];
            System.arraycopy(byArray, n4, byArray3, 0, n8);
            dERValue.setData(byArray3);
            dERValue.setTag(0);
            return byArray2;
        }
        if (n7 == 16 || n7 == 17) {
            byte[] byArray4 = new byte[n8];
            System.arraycopy(byArray, n4, byArray4, 0, n8);
            if (n7 == 16) {
                if (n != -1 && n != 1) {
                    throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(1) + ") in certificate.");
                }
                dERValue.setTag(1);
            } else {
                if (n != -1 && n != 2) {
                    throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(2) + ") in certificate.");
                }
                dERValue.setTag(2);
            }
            dERValue.setData(byArray4);
            return byArray2;
        }
        if (n7 == 6) {
            if (n != -1 && n != 3) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(3) + ") in certificate.");
            }
            n5 = byArray[n4++] & 0xFF;
            int[] nArray = new int[64];
            nArray[0] = n5 / 40;
            nArray[1] = n5 % 40;
            int n9 = 0;
            int n10 = 2;
            while (n4 - n2 < n8) {
                if (((n5 = byArray[n4++] & 0xFF) & 0x80) == 128) {
                    n9 = (n9 << 7) + (n5 & 0x7F);
                    continue;
                }
                n9 = (n9 << 7) + (n5 & 0x7F);
                nArray[n10++] = n9;
                n9 = 0;
            }
            int[] nArray2 = new int[n10];
            System.arraycopy(nArray, 0, nArray2, 0, n10);
            dERValue.setData(OID.parse(nArray2));
            dERValue.setTag(3);
            return byArray2;
        }
        if (n7 == 3) {
            if (n != -1 && n != 4) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(4) + ") in certificate.");
            }
            int n11 = n5 = byArray[n4++] & 0xFF;
            byte[] byArray5 = new byte[n8 - 1];
            System.arraycopy(byArray, n4, byArray5, 0, n8 - 1);
            BigInteger bigInteger = new BigInteger(byArray5);
            bigInteger.shiftRight(n11);
            dERValue.setData(bigInteger);
            dERValue.setTag(4);
            return byArray2;
        }
        if (n7 == 4) {
            if (n != -1 && n != 5) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(5) + ") in certificate.");
            }
            byte[] byArray6 = new byte[n8];
            System.arraycopy(byArray, n4, byArray6, 0, n8);
            dERValue.setData(byArray6);
            dERValue.setTag(5);
            return byArray2;
        }
        if (n7 == 19 || n7 == 22 || n7 == 12 || n7 == 20 || n7 == 28 || n7 == 30) {
            if (n != -1 && n != 6) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(6) + ") in certificate.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (n4 - n2 < n8) {
                stringBuffer.append((char)byArray[n4++]);
            }
            dERValue.setData(stringBuffer.toString());
            dERValue.setTag(6);
            return byArray2;
        }
        if (n7 == 2) {
            if (n != -1 && n != 7) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(7) + ") in certificate.");
            }
            byte[] byArray7 = new byte[n8];
            System.arraycopy(byArray, n4, byArray7, 0, n8);
            BigInteger bigInteger = new BigInteger(byArray7);
            dERValue.setData(bigInteger);
            dERValue.setTag(7);
            return byArray2;
        }
        if (n7 == 23 || n7 == 24) {
            if (n != -1 && n != 8) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(8) + ") in certificate.");
            }
            int n12 = Integer.parseInt(new String(byArray, n4, 2));
            String string = n7 == 24 ? new String(byArray, n4, 14) + "GMT+00:00" : (n12 < 50 ? "20" + new String(byArray, n4, 12) + "GMT+00:00" : "19" + new String(byArray, n4, 12) + "GMT+00:00");
            dERValue.setData(OEAB.parse(string, new ParsePosition(0)));
            dERValue.setTag(8);
            return byArray2;
        }
        if (n7 == 5) {
            if (n != -1 && n != 9) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(9) + ") in certificate.");
            }
            dERValue.setTag(9);
            return byArray2;
        }
        if (n7 == 1) {
            if (n != -1 && n != 10) {
                throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(10) + ") in certificate.");
            }
            dERValue.setTag(10);
            boolean bl2 = false;
            bl2 = byArray[n4] != -1;
            dERValue.setData(bl2);
            return byArray2;
        }
        if (n != -1 && n != -1) {
            throw new CertificateParsingException("unexpected data type (" + DERValue.getTagName(-1) + ") in certificate.");
        }
        byte[] byArray8 = new byte[n8];
        System.arraycopy(byArray, n4, byArray8, 0, n8);
        dERValue.setData(byArray8);
        dERValue.setTag(-1);
        return byArray2;
    }

    public static byte[] getFirst(byte[] byArray) throws CertificateParsingException {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n4 = byArray[n3++] & 0xFF;
        n5 = n4 >> 6;
        bl = (n4 & 0x20) != 0;
        if ((n4 & 0x1F) == 31) {
            do {
                n4 = byArray[n3++] & 0xFF;
                n6 = (n6 << 7) + (n4 & 0x7F);
            } while ((n4 & 0x80) == 128);
        } else {
            n6 = n4 & 0x1F;
        }
        n4 = byArray[n3++] & 0xFF;
        if ((n4 & 0x80) == 128) {
            n = n4 & 0x7F;
            while (n > 0) {
                n4 = byArray[n3++] & 0xFF;
                n7 = (n7 << 8) + n4;
                --n;
            }
        } else {
            n7 = n4;
        }
        n = n3;
        if (n3 + n7 > n2) {
            throw new CertificateParsingException("entity length (" + (n3 + n7) + ") bigger than number of actual bytes (" + n2 + ").");
        }
        if (n3 + n7 == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3 + n7];
        System.arraycopy(byArray, 0, byArray2, 0, n3 + n7);
        return byArray2;
    }

    public static byte[] encodeX509Date(Date date) {
        if (date.getTime() < 2524607999999L && date.getTime() > -631152000000L) {
            return DERUtil.encodeUTCTime(date);
        }
        return DERUtil.encodeGeneralizedTime(date);
    }

    public static byte[] encodeGeneralizedTime(Date date) {
        String string = OEAB.format(date).substring(0, 14) + "Z";
        return DERUtil.encode(0, 24, false, string.getBytes());
    }

    public static byte[] encodeUTCTime(Date date) {
        String string = OEAB.format(date).substring(2, 14) + "Z";
        return DERUtil.encode(0, 23, false, string.getBytes());
    }

    public static byte[] encodeSequence(byte[][] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2].length;
            ++n2;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            System.arraycopy(byArray[n4], 0, byArray2, n3, byArray[n4].length);
            n3 += byArray[n4].length;
            ++n4;
        }
        return DERUtil.encode(0, 16, true, byArray2);
    }

    public static byte[] encodeSet(byte[][] byArray) {
        int n;
        int n2;
        int n3 = 0;
        int[] nArray = new int[byArray.length];
        int n4 = 0;
        while (n4 < byArray.length) {
            n3 += byArray[n4].length;
            n2 = 0;
            int n5 = 0;
            if (((n = byArray[n4][n2++]) & 0x1F) == 31) {
                do {
                    n = byArray[n4][n2++];
                    n5 = (n5 << 7) + (n & 0x7F);
                } while ((n & 0x80) == 128);
            } else {
                n5 = n & 0x1F;
            }
            nArray[n4] = n5;
            ++n4;
        }
        byte[] byArray2 = new byte[n3];
        n2 = 0;
        n = 0;
        while (n < byArray.length) {
            System.arraycopy(byArray[n], 0, byArray2, n2, byArray[n].length);
            n2 += byArray[n].length;
            ++n;
        }
        return DERUtil.encode(0, 17, true, byArray2);
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.valueOf(0L))) {
            byte[] byArray = new byte[1];
            return DERUtil.encode(0, 2, false, byArray);
        }
        return DERUtil.encode(0, 2, false, bigInteger.toByteArray());
    }

    public static byte[] encodeInteger(int n) {
        if (n == 0) {
            byte[] byArray = new byte[1];
            return DERUtil.encode(0, 2, false, byArray);
        }
        return DERUtil.encode(0, 2, false, BigInteger.valueOf(n).toByteArray());
    }

    public static byte[] encodeBitString(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)n;
        int n2 = 0;
        while (n2 < byArray.length - 1) {
            byArray2[n2 + 1] = (byte)(byArray[n2] << n | (byArray[n2 + 1] & 0xFF) >> 8 - n);
            ++n2;
        }
        byArray2[byArray.length] = (byte)(byArray[byArray.length - 1] << n);
        return DERUtil.encode(0, 3, false, byArray2);
    }

    public static byte[] encodeOctetString(byte[] byArray) {
        return DERUtil.encode(0, 4, false, byArray);
    }

    public static byte[] encodeOID(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if ('.' == string.charAt(n2)) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[n + 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = string.indexOf(".", n3);
            nArray[n4] = Integer.parseInt(string.substring(n3, n5));
            n3 = n5 + 1;
            ++n4;
        }
        nArray[n] = Integer.parseInt(string.substring(n3, string.length()));
        byte[] byArray = new byte[nArray.length * 6];
        byArray[0] = (byte)(40 * nArray[0] + nArray[1]);
        int n6 = 1;
        int n7 = 2;
        while (n7 < nArray.length) {
            int n8 = nArray[n7];
            byte[] byArray2 = new byte[6];
            int n9 = 5;
            while (n8 > 0) {
                int n10 = n8 % 128;
                n8 /= 128;
                byArray2[n9] = (byte)n10;
                if (n9 != 5) {
                    int n11 = n9;
                    byArray2[n11] = (byte)(byArray2[n11] | 0x80);
                }
                --n9;
            }
            System.arraycopy(byArray2, n9 + 1, byArray, n6, 5 - n9);
            n6 += 5 - n9;
            ++n7;
        }
        byte[] byArray3 = new byte[n6];
        System.arraycopy(byArray, 0, byArray3, 0, n6);
        return DERUtil.encode(0, 6, false, byArray3);
    }

    public static byte[] encodeASCIIString(String string) {
        return DERUtil.encode(0, 22, false, string.getBytes());
    }

    public static byte[] encodeNull() {
        byte[] byArray = new byte[]{5, 0};
        return byArray;
    }

    public static byte[] encodeExplicit(int n, byte[] byArray) {
        return DERUtil.encode(2, n, true, byArray);
    }

    public static byte[] encodeImplicit(int n, byte[] byArray) {
        byte[] byArray2 = new byte[5];
        int n2 = 0;
        int n3 = 0;
        byArray2[0] = -128;
        if (n <= 30) {
            byArray2[0] = (byte)(byArray2[0] | (byte)n);
            ++n3;
        } else {
            byArray2[0] = (byte)(byArray2[0] | 0x1F);
            ++n3;
            if (n > 0xFFFFFF) {
                byArray2[n3++] = (byte)(n >> 24);
            }
            if (n > 65535) {
                byArray2[n3++] = (byte)(n >> 16);
            }
            if (n > 255) {
                byArray2[n3++] = (byte)(n >> 8);
            }
            byArray2[n3++] = (byte)n;
        }
        byte by = byArray[n2++];
        byte by2 = (byte)(byArray2[0] | by & 0x20);
        if ((by & 0x1F) == 31) {
            by = byArray[n2++];
            while ((by & 0x80) == 128) {
            }
            by = byArray[n2++];
        }
        byte[] byArray3 = new byte[byArray.length - n2 + n3];
        byArray3[0] = by2;
        System.arraycopy(byArray2, 0, byArray3, 1, n3);
        System.arraycopy(byArray, n2, byArray3, n3, byArray.length - n2);
        return byArray3;
    }

    public static byte[] encode(int n, int n2, boolean bl, byte[] byArray) {
        int n3 = 0;
        byte[] byArray2 = new byte[byArray.length + 5 + 5];
        byArray2[n3] = (byte)(n << 6 & 0xC0);
        int n4 = n3;
        byArray2[n4] = (byte)(byArray2[n4] | (bl ? 32 : 0));
        if (n2 <= 30) {
            int n5 = n3++;
            byArray2[n5] = (byte)(byArray2[n5] | (byte)n2);
        } else {
            int n6 = n3++;
            byArray2[n6] = (byte)(byArray2[n6] | 0x1F);
            if (n2 > 0xFFFFFF) {
                byArray2[n3++] = (byte)(n2 >> 24);
            }
            if (n2 > 65535) {
                byArray2[n3++] = (byte)(n2 >> 16);
            }
            if (n2 > 255) {
                byArray2[n3++] = (byte)(n2 >> 8);
            }
            byArray2[n3++] = (byte)n2;
        }
        if (byArray.length <= 127) {
            byArray2[n3++] = (byte)byArray.length;
        } else {
            byArray2[n3] = -128;
            if (byArray.length > 0xFFFFFF) {
                int n7 = n3++;
                byArray2[n7] = (byte)(byArray2[n7] | 4);
            } else if (byArray.length > 65535) {
                int n8 = n3++;
                byArray2[n8] = (byte)(byArray2[n8] | 3);
            } else if (byArray.length > 255) {
                int n9 = n3++;
                byArray2[n9] = (byte)(byArray2[n9] | 2);
            } else {
                int n10 = n3++;
                byArray2[n10] = (byte)(byArray2[n10] | 1);
            }
            if (byArray.length > 0xFFFFFF) {
                byArray2[n3++] = (byte)(byArray.length >> 24);
            }
            if (byArray.length > 65535) {
                byArray2[n3++] = (byte)(byArray.length >> 16);
            }
            if (byArray.length > 255) {
                byArray2[n3++] = (byte)(byArray.length >> 8);
            }
            byArray2[n3++] = (byte)byArray.length;
        }
        byte[] byArray3 = new byte[n3 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        System.arraycopy(byArray, 0, byArray3, n3, byArray.length);
        return byArray3;
    }

    static {
        OEAB.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

