/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import ice.cert.CertificateEncodingException;
import ice.cert.CertificateException;
import ice.cert.CertificateExpiredException;
import ice.cert.CertificateNotYetValidException;
import ice.cert.DERUtil;
import ice.cert.OID;
import ice.cert.X500Name;
import ice.cryptix.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;

public class X509Certificate
implements Serializable {
    static final long serialVersionUID = 4460491224171687916L;
    X500Name issuerDN;
    boolean[] issuerUniqueID;
    Date notAfter;
    Date notBefore;
    BigInteger serialNumber;
    OID sigOID;
    byte[] sigAlgParams;
    byte[] signature;
    X500Name subjectDN;
    boolean[] subjectUniqueID;
    byte[] tbsCertificate;
    int version;
    byte[] encoded;
    PublicKey publicKey;
    int basicConstraints = -1;
    boolean[] keyUsage = null;

    X509Certificate() {
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        if (date.before(this.notBefore)) {
            throw new CertificateNotYetValidException("Certificate not valid before " + this.notBefore);
        }
        if (date.after(this.notAfter)) {
            throw new CertificateExpiredException("Certificate not valid after " + this.notAfter);
        }
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.notBefore)) {
            throw new CertificateNotYetValidException("Certificate not valid before " + this.notBefore);
        }
        if (date.after(this.notAfter)) {
            throw new CertificateExpiredException("Certificate not valid after " + this.notAfter);
        }
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public Principal getIssuerDN() {
        return this.issuerDN;
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getSigAlgName() {
        return this.sigOID.oidName;
    }

    public String getSigAlgOID() {
        return this.sigOID.oidString;
    }

    public byte[] getSigAlgParams() {
        return this.sigAlgParams;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public Principal getSubjectDN() {
        return this.subjectDN;
    }

    public boolean[] getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.tbsCertificate;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encoded;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X500Name getSubject() {
        return this.subjectDN;
    }

    public X500Name getIssuer() {
        return this.issuerDN;
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, null);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.sigOID.oidName, string) : Signature.getInstance(this.sigOID.oidName);
        signature.initVerify(publicKey);
        signature.update(this.tbsCertificate);
        boolean bl = signature.verify(this.signature);
        if (!bl) {
            throw new SignatureException("the signature is not valid");
        }
    }

    void setBasicConstraints(int n) {
        this.basicConstraints = n;
    }

    void setKeyUsage(boolean[] blArray) {
        this.keyUsage = blArray;
    }

    public void save(OutputStream outputStream) throws IOException {
        outputStream.write(this.encoded);
    }

    public void saveAsText(OutputStream outputStream) throws IOException {
        outputStream.write(Base64.isoLatin1ToByteArray("-----BEGIN CERTIFICATE-----\n"));
        outputStream.write(Base64.encodeAsByteArray(this.encoded));
        outputStream.write(Base64.isoLatin1ToByteArray("-----END CERTIFICATE-----\n"));
    }

    public static void saveChain(X509Certificate[] x509CertificateArray, OutputStream outputStream) throws IOException {
        byte[] byArray;
        byte[][] byArrayArray;
        byte[][] byArrayArray2;
        if (x509CertificateArray.length == 0) {
            byArrayArray2 = new byte[4][];
            byArrayArray2[3] = DERUtil.encodeSet(new byte[0][]);
        } else {
            byArrayArray2 = new byte[5][];
            byArrayArray2[4] = DERUtil.encodeSet(new byte[0][]);
            byArrayArray = new byte[x509CertificateArray.length][];
            int n = 0;
            while (n < x509CertificateArray.length) {
                byArrayArray[n] = x509CertificateArray[n].encoded;
                ++n;
            }
            byArray = DERUtil.encodeSequence(byArrayArray);
            byArrayArray2[3] = DERUtil.encodeImplicit(0, byArray);
        }
        byArrayArray = new byte[][]{DERUtil.encodeOID("1.2.840.113549.1.7.1")};
        byArrayArray2[2] = DERUtil.encodeSequence(byArrayArray);
        byArrayArray2[1] = DERUtil.encodeSet(new byte[0][]);
        byArrayArray2[0] = DERUtil.encodeInteger(1);
        byte[][] byArrayArray3 = new byte[2][];
        byArray = DERUtil.encodeSequence(byArrayArray2);
        byArrayArray3[1] = DERUtil.encodeExplicit(0, byArray);
        byArrayArray3[0] = DERUtil.encodeOID("1.2.840.113549.1.7.2");
        byte[] byArray2 = DERUtil.encodeSequence(byArrayArray3);
        outputStream.write(byArray2);
    }

    public static void saveChainAsText(X509Certificate[] x509CertificateArray, OutputStream outputStream) throws IOException {
        outputStream.write("-----BEGIN PKCS #7 SIGNED DATA-----\r\n".getBytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        X509Certificate.saveChain(x509CertificateArray, byteArrayOutputStream);
        outputStream.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        outputStream.write("-----END PKCS #7 SIGNED DATA-----\r\n".getBytes());
    }

    public String getType() {
        return "X.509";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509Certificate)) {
            return false;
        }
        byte[] byArray = ((X509Certificate)object).encoded;
        if (this.encoded.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.encoded.length) {
            if (this.encoded[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
            return n;
        }
        catch (CertificateException certificateException) {
            return n;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + "\n\tissuerDN " + this.issuerDN + "\n\tissuerUniqueID " + this.issuerUniqueID + "\n\tnotAfter " + this.notAfter + "\n\tnotBefore " + this.notBefore + "\n\tserialNumber " + this.serialNumber + "\n\tsigOID " + this.sigOID + "\n\tsigAlgParams " + this.sigAlgParams + "\n\tsignature " + this.signature + "\n\tsubjectDN " + this.subjectDN + "\n\tsubjectUniqueID " + this.subjectUniqueID + "\n\ttbsCertificate " + this.tbsCertificate + "\n\tversion " + this.version + "\n\tencoded " + this.encoded + "\n\tpublicKey " + this.publicKey + "\n]";
    }
}

