/*
 * Decompiled with CFR 0.152.
 */
package ice.demo;

import ice.cert.X500Name;
import ice.cert.X509Certificate;
import ice.debug.Debug;
import ice.demo.ViewCertificateDialog;
import ice.ssl.CertificateErrorInfo;
import ice.ssl.CertificateEvent;
import ice.ssl.CertificateListener;
import ice.ssl.SSLSocket;
import ice.ssl.ServerCertificateList;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class CertificateWizard
extends Dialog
implements CertificateListener,
ActionListener {
    public static final int POP_ALL_EVENTS = 1;
    public static final int POP_ERROR_EVENTS = 2;
    public static final int POP_NO_EVENTS = 3;
    private static final String TRUSTED_SITE_FILE = "ssl/trustedSite.lst";
    private static Object trustedSites_Lock;
    private CertificateEvent lastEvent;
    private boolean userAccept;
    private static final Font font;
    private Frame parentFrame;
    private Button acceptNowButton;
    private Button acceptAlwaysButton;
    private Button rejectButton;
    private Button seeCertButton;
    private Button saveCertButton;
    private Panel generalPanel;
    private ViewCertificateDialog certInfoDialog;
    private static String host;

    public CertificateWizard(Frame parent) {
        super(parent, "Certificate Received", true);
        this.parentFrame = parent;
        SSLSocket.removeBlockingCertificateListener(SSLSocket.getBlockingCertificateListener());
        SSLSocket.setBlockingCertificateListener(this);
        ServerCertificateList list = this.readCertList();
        if (list == null) {
            if (Debug.trace) {
                Debug.trace((String)"Using the default list of trusted sites");
            }
        } else {
            SSLSocket.setTrustedSiteCertList(list);
            if (Debug.trace) {
                StringBuffer sb = new StringBuffer();
                sb.append("Default list of trusted sites:");
                Enumeration enumeration = list.getList();
                while (enumeration.hasMoreElements()) {
                    X509Certificate cert = (X509Certificate)enumeration.nextElement();
                    sb.append("\n\n");
                    sb.append(cert);
                }
                Debug.trace((String)sb.toString());
            }
        }
        this.setFont(font);
        this.generalPanel = new Panel();
        this.generalPanel.setLayout(new BorderLayout());
        this.add((Component)this.generalPanel, "Center");
        Panel buttonPanel = new Panel();
        this.seeCertButton = new Button("See Certificate");
        this.seeCertButton.addActionListener(this);
        buttonPanel.add(this.seeCertButton);
        this.acceptAlwaysButton = new Button("Accept forever");
        this.acceptAlwaysButton.addActionListener(this);
        buttonPanel.add(this.acceptAlwaysButton);
        this.acceptNowButton = new Button("Accept now only");
        this.acceptNowButton.addActionListener(this);
        buttonPanel.add(this.acceptNowButton);
        this.rejectButton = new Button("Reject");
        this.rejectButton.addActionListener(this);
        buttonPanel.add(this.rejectButton);
        buttonPanel.setLayout(new FlowLayout());
        this.add((Component)buttonPanel, "South");
    }

    private ServerCertificateList readCertList() {
        ServerCertificateList list;
        block9: {
            list = null;
            try {
                Object object = trustedSites_Lock;
                synchronized (object) {
                    FileInputStream in = new FileInputStream(TRUSTED_SITE_FILE);
                    if (in != null) {
                        try {
                            list = ServerCertificateList.restoreList(in);
                            Object var5_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            ((InputStream)in).close();
                            throw throwable;
                        }
                        ((InputStream)in).close();
                        {
                        }
                    }
                }
            }
            catch (IOException ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) break block9;
                Debug.trace((String)"Warning: failed to load the list of trusted sites");
            }
        }
        return list;
    }

    private void writeCertList(ServerCertificateList list) {
        block9: {
            try {
                Object object = trustedSites_Lock;
                synchronized (object) {
                    FileOutputStream os = new FileOutputStream(TRUSTED_SITE_FILE);
                    try {
                        list.save(os);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        ((OutputStream)os).close();
                        throw throwable;
                    }
                    ((OutputStream)os).close();
                }
                if (Debug.trace) {
                    Debug.trace((String)"Saved trusted site certifcate list");
                }
            }
            catch (IOException ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) break block9;
                Debug.trace((String)"Cannot save trusted site list");
            }
        }
    }

    public CertificateEvent getLastEvent() {
        return this.lastEvent;
    }

    public boolean certificateReceived(CertificateEvent ev) {
        this.lastEvent = ev;
        this.userAccept = true;
        this.construct();
        this.pack();
        ((Component)this).setVisible(true);
        return this.userAccept;
    }

    public void setPopEvents(int popEvents) {
        SSLSocket.setCertEvents(popEvents);
    }

    public int getPopEvents() {
        return SSLSocket.getCertEvents();
    }

    private void construct() {
        X509Certificate cert = this.lastEvent.getCertificate();
        CertificateErrorInfo[] errorInfos = this.lastEvent.getErrors();
        String site = ((SSLSocket)this.lastEvent.getSource()).getInetAddress().getHostName();
        this.generalPanel.removeAll();
        this.generalPanel.add((Component)new Label("A certificate has been received from: " + site), "North");
        if (cert != null) {
            this.seeCertButton.setVisible(true);
            this.certInfoDialog = new ViewCertificateDialog(cert, this.parentFrame);
            this.certInfoDialog.pack();
        } else {
            this.seeCertButton.setVisible(false);
        }
        this.acceptAlwaysButton.setVisible(false);
        if (errorInfos.length > 0) {
            Panel errorPanel = new Panel();
            errorPanel.add(new Label("With the following security errors:"));
            int i = 0;
            while (i < errorInfos.length) {
                if (errorInfos[i].getId() == 1) {
                    errorPanel.add(new Label("" + (i + 1) + ". The certificate's signer is not trusted."));
                    errorPanel.add(new Label("   The signer is distinguished name is:"));
                    X500Name untrustedCA = (X500Name)errorInfos[i].getFaulty();
                    Enumeration enumeration = untrustedCA.getAllElements();
                    while (enumeration.hasMoreElements()) {
                        String attribute = (String)enumeration.nextElement();
                        String[] values = untrustedCA.getElementArray(attribute);
                        int j = 0;
                        while (j < values.length) {
                            errorPanel.add(new Label("      " + values[j]));
                            ++j;
                        }
                    }
                    errorPanel.add(new Label("   Be very careful when accepting certificates signed by untrusted certificate authorities."));
                    this.acceptAlwaysButton.setVisible(true);
                } else {
                    errorPanel.add(new Label("" + (i + 1) + ". " + errorInfos[i].getMessage()));
                }
                ++i;
            }
            errorPanel.setLayout(new GridLayout(errorPanel.getComponentCount(), 1));
            this.generalPanel.add((Component)errorPanel, "Center");
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.acceptAlwaysButton) {
            ServerCertificateList list = SSLSocket.getTrustedSiteCertList();
            list.addCertificate(this.lastEvent.getCertificate());
            SSLSocket.setTrustedSiteCertList(list);
            this.writeCertList(list);
            this.userAccept = true;
            this.certInfoDialog.dispose();
            ((Component)this).setVisible(false);
        } else if (ev.getSource() == this.acceptNowButton) {
            this.userAccept = true;
            this.certInfoDialog.dispose();
            ((Component)this).setVisible(false);
        } else if (ev.getSource() == this.rejectButton) {
            this.userAccept = false;
            this.certInfoDialog.dispose();
            ((Component)this).setVisible(false);
        } else if (ev.getSource() == this.seeCertButton) {
            ((Component)this.certInfoDialog).setVisible(true);
        }
    }

    static {
        font = new Font("SansSerif", 0, 10);
        trustedSites_Lock = new Object();
        host = "www.belsign.be";
    }
}

