/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.ClientHandshake;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class ClientFinished
extends ClientHandshake {
    private static final byte[] I = new byte[]{67, 76, 78, 84};
    private HandshakeState OEAB;

    ClientFinished(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        super(20, sessionState, connectionState);
        this.OEAB = handshakeState;
        this.length = 36;
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(super.toByteArray());
        MessageDigest messageDigest = null;
        MessageDigest messageDigest2 = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest2 = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("Algorithm not found : " + (messageDigest == null ? "MD5" : "SHA") + " digest");
        }
        if (this.sesState.nowProto == 2) {
            MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest, messageDigest2};
            int n = 0;
            while (n < 2) {
                messageDigestArray[n].reset();
                messageDigestArray[n].update(this.OEAB.messages.toByteArray());
                messageDigestArray[n].update(I);
                messageDigestArray[n].update(this.sesState.masterSecret);
                messageDigestArray[n].update(Util.pad1, 0, n == 0 ? 48 : 40);
                byte[] byArray2 = messageDigestArray[n].digest();
                messageDigestArray[n].reset();
                messageDigestArray[n].update(this.sesState.masterSecret);
                messageDigestArray[n].update(Util.pad2, 0, n == 0 ? 48 : 40);
                messageDigestArray[n].update(byArray2);
                byteArrayOutputStream.write(messageDigestArray[n].digest());
                ++n;
            }
        } else {
            messageDigest.reset();
            messageDigest.update(this.OEAB.messages.toByteArray());
            messageDigest2.reset();
            messageDigest2.update(this.OEAB.messages.toByteArray());
            byteArrayOutputStream.write(Util.prf(12, this.sesState.masterSecret, "client finished", Util.concat(messageDigest.digest(), messageDigest2.digest())));
        }
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }
}

