/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.debug.Debug;
import ice.ssl.Alert;
import ice.ssl.CertificateCallback;
import ice.ssl.CertificateEvent;
import ice.ssl.CertificateListener;
import ice.ssl.CertificateManager;
import ice.ssl.CertificateVerify;
import ice.ssl.ClientCertificate;
import ice.ssl.ClientFinished;
import ice.ssl.ClientHandshake;
import ice.ssl.ClientHello;
import ice.ssl.ClientKeyExchange;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.ReadRecord;
import ice.ssl.SSLPlaintext;
import ice.ssl.ServerCertificateList;
import ice.ssl.ServerFinished;
import ice.ssl.ServerHandshake;
import ice.ssl.SessionState;
import ice.ssl.Util;
import ice.ssl.V2ClientFinished;
import ice.ssl.V2ClientHello;
import ice.ssl.V2ClientMasterKey;
import ice.ssl.V2ServerHello;
import ice.ssl.WriteRecord;
import ice.util.Defs;
import ice.util.io.DataStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;

public final class SSLSocket
extends Socket {
    public static final String VERSION = "v3_0_4";
    static boolean useSecureRandom;
    private static Hashtable IVSize;
    private HandshakeState J;
    private SessionState OEAB;
    private ConnectionState acceptCertificate;
    private Socket append = null;
    private boolean arraycopy = false;
    private String askedCert = null;
    public static final int SSL_2_0 = 1;
    public static final int SSL_3_0 = 2;
    static final int TLS_1_0 = 4;
    private static int bulkCipherAlgorithm;
    static int highestProto;
    public static final int ALL_CERTIFICATES = 1;
    public static final int ERROR_CERTIFICATES = 2;
    public static final int NO_CERTIFICATES = 3;
    private static int certEvent;
    public static final int SSL3_NULL_WITH_NULL_NULL = 0;
    public static final int SSL3_RSA_WITH_NULL_MD5 = 1;
    public static final int SSL3_RSA_WITH_NULL_SHA = 2;
    public static final int SSL3_RSA_EXPORT_WITH_IC4_40_MD5 = 3;
    public static final int SSL3_RSA_WITH_IC4_128_MD5 = 4;
    public static final int SSL3_RSA_WITH_IC4_128_SHA = 5;
    public static final int SSL3_RSA_EXPORT_WITH_IC2_CBC_40_MD5 = 6;
    public static final int SSL3_RSA_EXPORT_WITH_DES40_CBC_SHA = 8;
    public static final int SSL3_RSA_WITH_DES_CBC_SHA = 9;
    public static final int SSL3_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    static final int SSL3_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11;
    static final int SSL3_DH_DSS_WITH_DES_CBC_SHA = 12;
    static final int SSL3_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13;
    static final int SSL3_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14;
    static final int SSL3_DH_RSA_WITH_DES_CBC_SHA = 15;
    static final int SSL3_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16;
    static final int SSL3_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    static final int SSL3_DHE_DSS_WITH_DES_CBC_SHA = 18;
    static final int SSL3_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 20;
    static final int SSL3_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 21;
    static final int SSL3_DHE_RSA_WITH_DES_CBC_SHA = 22;
    static final int SSL3_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 23;
    private static final int[] certificateReceived;
    public static final int SSL2_IC4_128_WITH_MD5 = 65664;
    public static final int SSL2_IC4_128_EXPORT40_WITH_MD5 = 131200;
    public static final int SSL2_IC2_128_CBC_WITH_MD5 = 196736;
    public static final int SSL2_IC2_128_CBC_EXPORT40_WITH_MD5 = 262272;
    public static final int SSL2_DES_64_CBC_WITH_MD5 = 393280;
    public static final int SSL2_DES_192_EDE3_CBC_WITH_MD5 = 458944;
    private static final int[] cipherSuite;
    private static int[] class$;
    private static int[] clientCertificate;
    private static int[] clientCertificateChain;
    private InputStream clientRandom;
    private OutputStream clientSeqNum;
    private WriteRecord clientWriteIV;
    private ReadRecord clientWriteKey;
    public static DataStorage storage;
    static ServerCertificateList trustedCA;
    static ServerCertificateList trustedSites;
    private static final String clientWriteMACSecret;
    static CertificateCallback certCallback;
    private CertificateManager clone = null;
    private static CertificateListener close;
    static Class class$ice$ssl$ServerCertificateList;

    public SSLSocket(String string, int n) throws UnknownHostException, IOException {
        super(string, n);
        SSLSocket.init();
    }

    public SSLSocket(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        SSLSocket.init();
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        super(string, n, inetAddress, n2);
        SSLSocket.init();
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        SSLSocket.init();
    }

    public SSLSocket(Socket socket, String string) throws IOException {
        this.append = socket;
        this.arraycopy = true;
        this.askedCert = string;
        SSLSocket.init();
    }

    public static void init() {
        Util.init();
    }

    private void IVSize() throws IOException {
        if (this.arraycopy) {
            this.clientRandom = this.append.getInputStream();
            this.clientSeqNum = this.append.getOutputStream();
        } else {
            this.clientRandom = super.getInputStream();
            this.clientSeqNum = super.getOutputStream();
        }
        this.clientWriteIV = new WriteRecord(this.clientSeqNum, new SessionState(), new ConnectionState());
        this.clientWriteKey = new ReadRecord(this.clientRandom, new SessionState(), new ConnectionState(), this);
        this.startHandshake();
    }

    void startHandshake() throws IOException {
        int n;
        this.OEAB = (SessionState)IVSize.get(this.getInetAddress());
        if (this.OEAB != null) {
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < class$.length) {
                if (this.OEAB.cipherSuite == class$[n2]) {
                    bl = true;
                }
                ++n2;
            }
            n = 0;
            while (!bl && n < clientCertificateChain.length) {
                if (this.OEAB.cipherSuite == clientCertificateChain[n]) {
                    bl = true;
                }
                ++n;
            }
            if ((this.OEAB.nowProto & bulkCipherAlgorithm) == 0) {
                bl = false;
            }
            if (!bl) {
                this.OEAB = null;
            }
        }
        this.OEAB = this.OEAB == null ? new SessionState() : new SessionState(this.OEAB);
        this.J = new HandshakeState();
        this.acceptCertificate = new ConnectionState();
        this.clientWriteIV.setHandshake(true);
        this.clientWriteKey.setHandshake(true);
        if (this.OEAB.sessionID.length > 0) {
            this.clientWriteIV.getSessionState().nowProto = this.OEAB.nowProto;
            this.clientWriteKey.getSessionState().nowProto = this.OEAB.nowProto;
            if (this.OEAB.nowProto == 1) {
                this.acceptCertificate();
            } else {
                this.OEAB();
            }
        } else if ((bulkCipherAlgorithm & 1) != 0) {
            this.OEAB.nowProto = 1;
            this.clientWriteIV.getSessionState().nowProto = 1;
            this.clientWriteKey.getSessionState().nowProto = 1;
            this.acceptCertificate();
        } else if ((bulkCipherAlgorithm & 2) != 0) {
            this.OEAB.nowProto = 2;
            this.clientWriteIV.getSessionState().nowProto = 2;
            this.clientWriteKey.getSessionState().nowProto = 2;
            this.OEAB();
        } else {
            this.OEAB.nowProto = 4;
            this.clientWriteIV.getSessionState().nowProto = 4;
            this.clientWriteKey.getSessionState().nowProto = 4;
            this.OEAB();
        }
        SSLPlaintext sSLPlaintext = this.clientWriteKey.readNext();
        if (sSLPlaintext == null) {
            this.close();
            throw new IOException("Server is not responding, it might not support the current protocol. Missing ServerHello.");
        }
        this.J.data = sSLPlaintext.data;
        this.J(sSLPlaintext);
        if (sSLPlaintext.major < Util.majorVersion(1)) {
            this.close();
            throw new IOException("Server implements a too old SSL version: " + sSLPlaintext.major + "." + sSLPlaintext.minor);
        }
        if (sSLPlaintext.major == Util.majorVersion(1) && (bulkCipherAlgorithm & 1) == 0) {
            this.close(40);
            throw new IOException("Server uses a disabled SSL version: " + sSLPlaintext.major + "." + sSLPlaintext.minor);
        }
        if (highestProto == 1 || sSLPlaintext.major == Util.majorVersion(1)) {
            this.OEAB.nowProto = 1;
            this.clientWriteIV.getSessionState().nowProto = 1;
            this.clientWriteKey.getSessionState().nowProto = 1;
            this.askedCert();
            return;
        }
        if (sSLPlaintext.major == Util.majorVersion(2) && sSLPlaintext.minor == Util.minorVersion(2) && (bulkCipherAlgorithm & 2) == 0) {
            this.close(40);
            throw new IOException("Server uses a disabled SSL version: " + sSLPlaintext.major + "." + sSLPlaintext.minor);
        }
        if (this.acceptCertificate.clientRandom.length < 32) {
            byte[] byArray = new byte[32];
            n = 0;
            while (n < this.acceptCertificate.clientRandom.length) {
                byArray[n + (32 - this.acceptCertificate.clientRandom.length)] = this.acceptCertificate.clientRandom[n];
                ++n;
            }
            this.acceptCertificate.clientRandom = byArray;
        }
        if (highestProto == 2 || sSLPlaintext.major == Util.majorVersion(2) && sSLPlaintext.minor == Util.minorVersion(2)) {
            this.OEAB.nowProto = 2;
            this.clientWriteIV.getSessionState().nowProto = 2;
            this.clientWriteKey.getSessionState().nowProto = 2;
            this.append();
            return;
        }
        if (highestProto == 4 && sSLPlaintext.major >= Util.majorVersion(4) && sSLPlaintext.minor >= Util.minorVersion(4)) {
            this.OEAB.nowProto = 4;
            this.clientWriteIV.getSessionState().nowProto = 4;
            this.clientWriteKey.getSessionState().nowProto = 4;
            this.append();
            return;
        }
        this.close(40);
        throw new InternalError("Cannot match server version(" + sSLPlaintext.major + "." + sSLPlaintext.minor + ") with client version (" + bulkCipherAlgorithm + ")\n" + "Please send a bug report to support@icesoft.no");
    }

    private void J(SSLPlaintext sSLPlaintext) throws IOException {
        if (sSLPlaintext.contentType == 21) {
            Alert alert = new Alert(sSLPlaintext);
            this.close();
            throw new IOException("Fatal alert received from the server: " + alert.getDescriptionString());
        }
        if (sSLPlaintext.contentType != 22) {
            this.close(10);
            throw new IOException("Unexpected message received from the server: Expecting handshake message - received " + sSLPlaintext.contentType);
        }
    }

    private void OEAB() throws IOException {
        ClientHello clientHello = new ClientHello(this.OEAB, this.acceptCertificate, class$, clientCertificate);
        byte[] byArray = clientHello.toByteArray();
        this.clientWriteIV.write(22, byArray);
        this.J.messages.write(byArray);
    }

    private void acceptCertificate() throws IOException {
        int[] nArray = null;
        nArray = bulkCipherAlgorithm == 1 ? clientCertificateChain : Util.concat(clientCertificateChain, class$);
        V2ClientHello v2ClientHello = new V2ClientHello(this.OEAB, this.acceptCertificate, nArray);
        byte[] byArray = v2ClientHello.toByteArray();
        this.clientWriteIV.write(22, byArray);
        this.J.messages.write(byArray);
    }

    private void append() throws IOException {
        Object object;
        Object object2;
        byte[] byArray;
        SSLPlaintext sSLPlaintext = null;
        boolean bl = false;
        boolean bl2 = false;
        this.J.next = new int[1];
        this.J.next[0] = 2;
        ServerHandshake serverHandshake = null;
        while (this.J.next.length > 0 && this.J.next[0] != -1) {
            int n = 4;
            if (this.J.offset + n <= this.J.data.length) {
                n = Math.max(n, ServerHandshake.getNextLength(this.J));
            }
            if (this.J.offset + n > this.J.data.length) {
                sSLPlaintext = this.clientWriteKey.readNext();
                if (sSLPlaintext == null) {
                    this.close(40);
                    throw new IOException("Server is not responding (protocol error ?). Missing ServerHandshake.");
                }
                this.J(sSLPlaintext);
                byArray = new byte[this.J.data.length + sSLPlaintext.data.length];
                System.arraycopy(this.J.data, 0, byArray, 0, this.J.data.length);
                System.arraycopy(sSLPlaintext.data, 0, byArray, this.J.data.length, sSLPlaintext.data.length);
                this.J.data = byArray;
            }
            try {
                serverHandshake = ServerHandshake.makeChild(this, this.OEAB, this.acceptCertificate, this.J);
            }
            catch (IOException iOException) {
                this.close(10);
                throw iOException;
            }
        }
        if (this.J.next.length == 0) {
            if (this.J.askedCert) {
                if (this.OEAB.nowProto == 2 && certCallback != null && this.J.clientCertificateChain != null) {
                    ClientCertificate clientCertificate = new ClientCertificate(this.OEAB, this.acceptCertificate, this.J);
                    byArray = clientCertificate.toByteArray();
                    this.clientWriteIV.write(22, byArray);
                    this.J.messages.write(byArray);
                } else {
                    Alert alert = new Alert(1, 41);
                    this.clientWriteIV.write(21, alert.toByteArray());
                }
            }
            ClientKeyExchange clientKeyExchange = new ClientKeyExchange(this.OEAB, this.acceptCertificate, this.J);
            byArray = clientKeyExchange.toByteArray();
            this.clientWriteIV.write(22, byArray);
            this.J.messages.write(byArray);
            this.arraycopy(this.OEAB, this.acceptCertificate, this.J);
            if (this.J.askedCert && this.J.clientCertificate != null) {
                object2 = new CertificateVerify(this.OEAB, this.acceptCertificate, this.J);
                object = object2.toByteArray();
                this.clientWriteIV.write(22, (byte[])object);
                this.J.messages.write((byte[])object);
            }
            object2 = new byte[]{1};
            this.clientWriteIV.write(20, (byte[])object2);
            this.clientWriteIV.setStates(this.acceptCertificate, this.OEAB);
            this.acceptCertificate.clientSeqNum = 0L;
            bl2 = true;
            object = new ClientFinished(this.OEAB, this.acceptCertificate, this.J);
            byte[] byArray2 = object.toByteArray();
            this.clientWriteIV.write(22, byArray2);
            this.J.messages.write(byArray2);
            this.clientWriteIV.setHandshake(false);
        }
        if ((sSLPlaintext = this.clientWriteKey.readNext()) == null) {
            this.close();
            throw new IOException("Server is not responding (protocol error ?). Missing ChangeCipherSpec.");
        }
        if (sSLPlaintext.contentType == 21) {
            Alert alert = new Alert(sSLPlaintext);
            this.close();
            throw new IOException("Fatal alert received from the server: " + alert.getDescriptionString());
        }
        if (sSLPlaintext.contentType != 20) {
            this.close(10);
            throw new IOException("Unexpected message received from the server: Expecting Change Cipher Spec - received " + sSLPlaintext.contentType);
        }
        if (sSLPlaintext.data.length != 1 && sSLPlaintext.data[0] != 1) {
            this.close(47);
            throw new IOException("error in change_cipher_spec message body");
        }
        if (!bl2) {
            this.arraycopy(this.OEAB, this.acceptCertificate, this.J);
        }
        this.clientWriteKey.setStates(this.acceptCertificate, this.OEAB);
        this.acceptCertificate.serverSeqNum = 0L;
        bl = true;
        this.J.next = new int[1];
        this.J.next[0] = 20;
        int n = 4;
        if (this.J.offset + n <= this.J.data.length) {
            n = Math.max(n, ServerHandshake.getNextLength(this.J));
        }
        if (this.J.offset + n > this.J.data.length) {
            sSLPlaintext = this.clientWriteKey.readNext();
            if (sSLPlaintext == null) {
                this.close(40);
                throw new IOException("Server is not responding (protocol error ?). Missing Server Finished.");
            }
            this.J(sSLPlaintext);
            byArray = new byte[this.J.data.length + sSLPlaintext.data.length];
            System.arraycopy(this.J.data, 0, byArray, 0, this.J.data.length);
            System.arraycopy(sSLPlaintext.data, 0, byArray, this.J.data.length, sSLPlaintext.data.length);
            this.J.data = byArray;
        }
        try {
            serverHandshake = ServerHandshake.makeChild(this, this.OEAB, this.acceptCertificate, this.J);
        }
        catch (IOException iOException) {
            this.close(10);
            throw iOException;
        }
        if (!((ServerFinished)serverHandshake).verified()) {
            this.close(40);
            throw new IOException("Server failed to send valid verification data.");
        }
        this.clientWriteKey.setHandshake(false);
        if (!bl2) {
            byArray = new byte[]{1};
            this.clientWriteIV.write(20, byArray);
            this.clientWriteIV.setStates(this.acceptCertificate, this.OEAB);
            this.acceptCertificate.clientSeqNum = 0L;
            object2 = new ClientFinished(this.OEAB, this.acceptCertificate, this.J);
            object = object2.toByteArray();
            this.clientWriteIV.write(22, (byte[])object);
            this.clientWriteIV.setHandshake(false);
        }
        this.OEAB.isResumable = this.OEAB.sessionID.length != 0;
        this.certCallback(this.OEAB, this.acceptCertificate, this.J);
    }

    private void arraycopy(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        int n;
        int n2 = 2 * sessionState.hashSize + 2 * sessionState.keyMaterial + 2 * sessionState.IVSize;
        byte[] byArray = null;
        MessageDigest messageDigest = null;
        MessageDigest messageDigest2 = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest2 = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("Algorithm not found : " + (messageDigest == null ? "MD5" : "SHA") + " digest");
        }
        if (sessionState.nowProto == 2) {
            n = (n2 - 1) / 16 + 1;
            byArray = new byte[n * 16];
            int n3 = 0;
            while (n3 < n) {
                byte[] byArray2 = new byte[n3 + 1];
                int n4 = 0;
                while (n4 < n3 + 1) {
                    byArray2[n4] = (byte)(65 + n3);
                    ++n4;
                }
                messageDigest2.reset();
                messageDigest2.update(byArray2);
                messageDigest2.update(sessionState.masterSecret);
                messageDigest2.update(connectionState.serverRandom);
                messageDigest2.update(connectionState.clientRandom);
                byte[] byArray3 = messageDigest2.digest();
                messageDigest.reset();
                messageDigest.update(sessionState.masterSecret);
                messageDigest.update(byArray3);
                byte[] byArray4 = messageDigest.digest();
                System.arraycopy(byArray4, 0, byArray, n3 * 16, 16);
                ++n3;
            }
        } else {
            byArray = Util.prf(n2, sessionState.masterSecret, "key expansion", Util.concat(connectionState.serverRandom, connectionState.clientRandom));
        }
        connectionState.clientWriteMACSecret = new byte[sessionState.hashSize];
        connectionState.serverWriteMACSecret = new byte[sessionState.hashSize];
        connectionState.clientWriteKey = new byte[sessionState.keyMaterial];
        connectionState.serverWriteKey = new byte[sessionState.keyMaterial];
        sessionState.clientWriteIV = new byte[sessionState.IVSize];
        sessionState.serverWriteIV = new byte[sessionState.IVSize];
        n = 0;
        System.arraycopy(byArray, n, connectionState.clientWriteMACSecret, 0, sessionState.hashSize);
        System.arraycopy(byArray, n += sessionState.hashSize, connectionState.serverWriteMACSecret, 0, sessionState.hashSize);
        System.arraycopy(byArray, n += sessionState.hashSize, connectionState.clientWriteKey, 0, sessionState.keyMaterial);
        System.arraycopy(byArray, n += sessionState.keyMaterial, connectionState.serverWriteKey, 0, sessionState.keyMaterial);
        System.arraycopy(byArray, n += sessionState.keyMaterial, sessionState.clientWriteIV, 0, sessionState.IVSize);
        System.arraycopy(byArray, n += sessionState.IVSize, sessionState.serverWriteIV, 0, sessionState.IVSize);
        if (sessionState.isExportable && sessionState.nowProto == 2) {
            messageDigest.reset();
            messageDigest.update(connectionState.clientWriteKey);
            messageDigest.update(connectionState.clientRandom);
            messageDigest.update(connectionState.serverRandom);
            byte[] byArray5 = messageDigest.digest();
            connectionState.clientWriteKey = new byte[sessionState.keySize];
            System.arraycopy(byArray5, 0, connectionState.clientWriteKey, 0, sessionState.keySize);
            messageDigest.reset();
            messageDigest.update(connectionState.serverWriteKey);
            messageDigest.update(connectionState.serverRandom);
            messageDigest.update(connectionState.clientRandom);
            byArray5 = messageDigest.digest();
            connectionState.serverWriteKey = new byte[sessionState.keySize];
            System.arraycopy(byArray5, 0, connectionState.serverWriteKey, 0, sessionState.keySize);
            messageDigest.reset();
            messageDigest.update(connectionState.clientRandom);
            messageDigest.update(connectionState.serverRandom);
            byArray5 = messageDigest.digest();
            System.arraycopy(byArray5, 0, sessionState.clientWriteIV, 0, sessionState.IVSize);
            messageDigest.reset();
            messageDigest.update(connectionState.serverRandom);
            messageDigest.update(connectionState.clientRandom);
            byArray5 = messageDigest.digest();
            System.arraycopy(byArray5, 0, sessionState.serverWriteIV, 0, sessionState.IVSize);
        } else if (sessionState.isExportable) {
            connectionState.clientWriteKey = Util.prf(sessionState.keySize, connectionState.clientWriteKey, "client write key", Util.concat(connectionState.clientRandom, connectionState.serverRandom));
            connectionState.serverWriteKey = Util.prf(sessionState.keySize, connectionState.serverWriteKey, "server write key", Util.concat(connectionState.clientRandom, connectionState.serverRandom));
            byte[] byArray6 = Util.prf(sessionState.IVSize * 2, new byte[0], "IV block", Util.concat(connectionState.clientRandom, connectionState.serverRandom));
            System.arraycopy(byArray6, 0, sessionState.clientWriteIV, 0, sessionState.IVSize);
            System.arraycopy(byArray6, sessionState.IVSize, sessionState.serverWriteIV, 0, sessionState.IVSize);
        }
    }

    private void askedCert() throws IOException {
        byte[] byArray;
        ClientHandshake clientHandshake;
        SSLPlaintext sSLPlaintext = null;
        V2ServerHello v2ServerHello = new V2ServerHello(this, this.OEAB, this.acceptCertificate, this.J);
        if (!v2ServerHello.isHit()) {
            clientHandshake = new V2ClientMasterKey(this.OEAB, this.acceptCertificate, this.J);
            byArray = clientHandshake.toByteArray();
            this.clientWriteIV.write(22, byArray);
            this.J.messages.write(byArray);
        }
        this.bulkCipherAlgorithm(this.OEAB, this.acceptCertificate, this.J);
        this.clientWriteIV.setStates(this.acceptCertificate, this.OEAB);
        clientHandshake = new V2ClientFinished(this.OEAB, this.acceptCertificate, this.J);
        byArray = clientHandshake.toByteArray();
        this.clientWriteIV.write(22, byArray);
        this.clientWriteIV.setHandshake(false);
        this.clientWriteKey.setStates(this.acceptCertificate, this.OEAB);
        sSLPlaintext = this.clientWriteKey.readNext();
        if (sSLPlaintext == null) {
            throw new IOException("Server is not responding (protocol error ?). Missing V2ServerVerify.");
        }
        if (sSLPlaintext.contentType == 21) {
            Alert alert = new Alert(sSLPlaintext);
            this.close();
            throw new IOException("Fatal alert received from the server: " + alert.getDescriptionString());
        }
        if (sSLPlaintext.data[0] == 5) {
            int n = 0;
            n = 0;
            while (n < this.acceptCertificate.clientRandom.length) {
                if (sSLPlaintext.data[n + 1] != this.acceptCertificate.clientRandom[n]) break;
                ++n;
            }
            if (n < this.acceptCertificate.clientRandom.length) {
                this.close(40);
                throw new IOException("Bad server encryption");
            }
        } else {
            this.close(10);
            throw new IOException("Unexpected message received from the server: Expecting Server Verifiy - received " + (sSLPlaintext.data[0] & 0xFF));
        }
        sSLPlaintext = this.clientWriteKey.readNext();
        if (sSLPlaintext == null) {
            throw new IOException("Server is not responding (protocol error ?). Missing V2ServerHandshake.");
        }
        if (sSLPlaintext.contentType == 21) {
            Alert alert = new Alert(sSLPlaintext);
            this.close();
            throw new IOException("Fatal alert received from the server: " + alert.getDescriptionString());
        }
        if (sSLPlaintext.contentType != 22 || sSLPlaintext.data[0] != 6) {
            this.close(10);
            throw new IOException("Unexpected message received from the server: Expecting Server Finished - received " + (sSLPlaintext.data[0] & 0xFF));
        }
        this.OEAB.sessionID = new byte[sSLPlaintext.data.length - 1];
        System.arraycopy(sSLPlaintext.data, 1, this.OEAB.sessionID, 0, sSLPlaintext.data.length - 1);
        this.OEAB.isResumable = this.OEAB.sessionID.length > 0;
        this.clientWriteKey.setHandshake(false);
        this.certCallback(this.OEAB, this.acceptCertificate, this.J);
    }

    private void bulkCipherAlgorithm(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("Algorithm not found : " + (messageDigest == null ? "MD5" : "SHA") + " digest");
        }
        int n = 2;
        if (sessionState.bulkCipherAlgorithm == 3) {
            n = 1;
        } else if (sessionState.bulkCipherAlgorithm == 4) {
            n = 3;
        }
        byte[] byArray = new byte[]{48};
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        messageDigest.reset();
        messageDigest.update(sessionState.masterSecret);
        messageDigest.update(byArray);
        messageDigest.update(connectionState.clientRandom);
        messageDigest.update(connectionState.serverRandom);
        byArray2 = messageDigest.digest();
        if (n > 1) {
            byArray[0] = 49;
            messageDigest.reset();
            messageDigest.update(sessionState.masterSecret);
            messageDigest.update(byArray);
            messageDigest.update(connectionState.clientRandom);
            messageDigest.update(connectionState.serverRandom);
            byArray3 = messageDigest.digest();
            if (n > 2) {
                byArray[0] = 50;
                messageDigest.reset();
                messageDigest.update(sessionState.masterSecret);
                messageDigest.update(byArray);
                messageDigest.update(connectionState.clientRandom);
                messageDigest.update(connectionState.serverRandom);
                byArray4 = messageDigest.digest();
            }
        }
        if (sessionState.bulkCipherAlgorithm == 3) {
            connectionState.serverWriteKey = new byte[sessionState.keySize];
            connectionState.clientWriteKey = new byte[sessionState.keySize];
            System.arraycopy(byArray2, 0, connectionState.serverWriteKey, 0, sessionState.keySize);
            System.arraycopy(byArray2, sessionState.keySize, connectionState.clientWriteKey, 0, sessionState.keySize);
        } else if (sessionState.bulkCipherAlgorithm == 4) {
            connectionState.serverWriteKey = new byte[sessionState.keySize];
            connectionState.clientWriteKey = new byte[sessionState.keySize];
            System.arraycopy(byArray2, 0, connectionState.serverWriteKey, 0, 16);
            System.arraycopy(byArray3, 0, connectionState.serverWriteKey, 16, 8);
            System.arraycopy(byArray3, 8, connectionState.clientWriteKey, 0, 8);
            System.arraycopy(byArray4, 0, connectionState.clientWriteKey, 8, 16);
        } else {
            connectionState.serverWriteKey = byArray2;
            connectionState.clientWriteKey = byArray3;
        }
    }

    private void certCallback(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) throws IOException {
        if (handshakeState.certEvent == null) {
            if (sessionState.isResumable) {
                IVSize.put(this.getInetAddress(), sessionState);
            }
            return;
        }
        if (certEvent == 3 && !handshakeState.certEvent.isVerified()) {
            throw new IOException(handshakeState.certEvent.getErrors()[0].getMessage());
        }
        if (certEvent == 3) {
            if (sessionState.isResumable) {
                IVSize.put(this.getInetAddress(), sessionState);
            }
            return;
        }
        if (certEvent == 2 && handshakeState.certEvent.isVerified()) {
            if (sessionState.isResumable) {
                IVSize.put(this.getInetAddress(), sessionState);
            }
            return;
        }
        if (!this.processEvent(handshakeState.certEvent)) {
            this.close(42);
            return;
        }
        if (sessionState.isResumable) {
            IVSize.put(this.getInetAddress(), sessionState);
        }
    }

    public InetAddress getInetAddress() {
        if (this.arraycopy) {
            return this.append.getInetAddress();
        }
        return super.getInetAddress();
    }

    public String getTargetHostName() {
        if (this.askedCert != null) {
            return this.askedCert;
        }
        return this.getInetAddress().getHostName();
    }

    public InputStream getInputStream() throws IOException {
        if (this.clientSeqNum == null) {
            this.IVSize();
        }
        return this.clientWriteKey;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.clientSeqNum == null) {
            this.IVSize();
        }
        return this.clientWriteIV;
    }

    public void close() throws IOException {
        try {
            this.close(0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    void close(int n) throws IOException {
        if (this.clientWriteIV != null) {
            Alert alert = new Alert(2, n);
            try {
                this.clientWriteIV.write(21, alert.toByteArray());
                this.clientWriteIV.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.clientWriteIV.close();
        }
        if (this.clientWriteKey != null) {
            this.clientWriteKey.close();
        }
        if (this.clientRandom != null) {
            this.clientRandom.close();
        }
        if (this.clientSeqNum != null) {
            this.clientSeqNum.close();
        }
        if (this.arraycopy) {
            this.append.close();
        } else {
            super.close();
        }
    }

    public static void setCipherSuiteList(int[] nArray) throws IllegalArgumentException {
        int n = 0;
        while (n < nArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < certificateReceived.length) {
                if (nArray[n] == certificateReceived[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new IllegalArgumentException("Cipher " + nArray[n] + " is not supported");
            }
            ++n;
        }
        class$ = (int[])nArray.clone();
    }

    public static int[] getCipherSuiteList() {
        return (int[])class$.clone();
    }

    public static int[] getSupportedCipherSuiteList() {
        return (int[])certificateReceived.clone();
    }

    public static void setCipherSuiteListV2(int[] nArray) throws IllegalArgumentException {
        int n = 0;
        while (n < nArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < cipherSuite.length) {
                if (nArray[n] == cipherSuite[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new IllegalArgumentException("Cipher " + nArray[n] + " is not supported");
            }
            ++n;
        }
        clientCertificateChain = (int[])nArray.clone();
    }

    public static int[] getCipherSuiteListV2() {
        return (int[])clientCertificateChain.clone();
    }

    public static int[] getSupportedCipherSuiteListV2() {
        return (int[])cipherSuite.clone();
    }

    public static void setCompressionMethodList(int[] nArray) {
    }

    public static int[] getCompressionMethodList() {
        return (int[])clientCertificate.clone();
    }

    public static void setProtocols(int n) {
        bulkCipherAlgorithm = n;
        if ((bulkCipherAlgorithm & 4) != 0) {
            highestProto = 4;
        } else if ((bulkCipherAlgorithm & 2) != 0) {
            highestProto = 2;
        } else if ((bulkCipherAlgorithm & 1) != 0) {
            highestProto = 1;
        } else {
            bulkCipherAlgorithm = 7;
            highestProto = 4;
        }
    }

    public static int getProtocols() {
        return bulkCipherAlgorithm;
    }

    public static void setUseSecureRandom(boolean bl) {
        useSecureRandom = bl;
    }

    public static void setDataStorage(DataStorage dataStorage) {
        storage = dataStorage;
    }

    public static boolean getUseSecureRandom() {
        return useSecureRandom;
    }

    private static ServerCertificateList certEvent() {
        ServerCertificateList serverCertificateList;
        block7: {
            serverCertificateList = null;
            InputStream inputStream = (class$ice$ssl$ServerCertificateList == null ? (class$ice$ssl$ServerCertificateList = SSLSocket.class$("ice.ssl.ServerCertificateList")) : class$ice$ssl$ServerCertificateList).getResourceAsStream("cacerts.crt");
            if (inputStream != null) {
                try {
                    try {
                        serverCertificateList = ServerCertificateList.restoreListFromPEM(inputStream);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block7;
                    Debug.ex((Throwable)iOException);
                }
            }
        }
        if (serverCertificateList == null) {
            if (Debug.trace) {
                Debug.trace((String)"WARNING: failed to load the default CA list, All sites will be considered as untrusted.");
            }
            serverCertificateList = new ServerCertificateList();
        }
        return serverCertificateList;
    }

    public static synchronized ServerCertificateList getTrustedCACertList() {
        return (ServerCertificateList)trustedCA.clone();
    }

    public static synchronized void setTrustedCACertList(ServerCertificateList serverCertificateList) {
        trustedCA = serverCertificateList == null ? new ServerCertificateList() : (ServerCertificateList)serverCertificateList.clone();
    }

    public static synchronized ServerCertificateList getTrustedSiteCertList() {
        return (ServerCertificateList)trustedSites.clone();
    }

    public static synchronized void setTrustedSiteCertList(ServerCertificateList serverCertificateList) {
        trustedSites = serverCertificateList == null ? new ServerCertificateList() : (ServerCertificateList)serverCertificateList.clone();
    }

    public static void setCertificateCallback(CertificateCallback certificateCallback) {
        certCallback = certificateCallback;
    }

    protected static CertificateCallback getCertificateCallback() {
        return certCallback;
    }

    public static void removeCertificateCallback(CertificateCallback certificateCallback) {
        if (certificateCallback == certCallback) {
            certCallback = null;
        }
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        this.clone = certificateManager;
    }

    public CertificateManager getCertificateManager() {
        if (this.clone != null) {
            return this.clone;
        }
        return CertificateManager.getCertificateManager();
    }

    public static void setBlockingCertificateListener(CertificateListener certificateListener) {
        if (close != null) {
            throw new IllegalArgumentException("You must remove the current listener before setting a new one");
        }
        close = certificateListener;
    }

    public static void removeBlockingCertificateListener(CertificateListener certificateListener) {
        if (close == certificateListener) {
            close = null;
        }
    }

    public static CertificateListener getBlockingCertificateListener() {
        return close;
    }

    public static void setCertEvents(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Illegal certEvents ID : " + n);
        }
        certEvent = n;
    }

    public static int getCertEvents() {
        return certEvent;
    }

    boolean processEvent(CertificateEvent certificateEvent) throws IOException {
        CertificateManager certificateManager = this.getCertificateManager();
        if (certificateManager != null) {
            if (certificateManager.acceptCertificate(this.J.serverCerts, this)) {
                return true;
            }
            if (certCallback != null) {
                return certCallback.acceptCertificate(this.J.serverCerts, this);
            }
            return false;
        }
        if (close == null) {
            this.close(42);
            throw new IOException(this.J.certEvent.getErrors()[0].getMessage());
        }
        return close.certificateReceived(certificateEvent);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (Debug.trace) {
            Debug.traceAsIs((String)"ICEssl v3_0_4");
        } else if (Defs.sysPropertyBoolean((String)"ice.browser.verbose", (boolean)true)) {
            System.out.println("ICEssl v3_0_4");
            System.out.println("(c) ICEsoft Technologies, Inc.");
        }
        useSecureRandom = false;
        IVSize = new Hashtable();
        bulkCipherAlgorithm = 3;
        highestProto = (bulkCipherAlgorithm & 4) != 0 ? 4 : ((bulkCipherAlgorithm & 2) != 0 ? 2 : 1);
        certEvent = 2;
        certificateReceived = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 10};
        cipherSuite = new int[]{65664, 131200, 196736, 262272, 393280, 458944};
        class$ = new int[]{5, 4, 10, 9, 3, 6};
        clientCertificate = new int[]{0};
        clientCertificateChain = new int[]{65664, 196736, 458944, 393280, 262272, 131200};
        trustedCA = SSLSocket.certEvent();
        trustedSites = new ServerCertificateList();
        clientWriteMACSecret = null;
        certCallback = null;
        close = null;
    }
}

