/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import cryptix.provider.Cryptix;
import ice.cert.CertificateException;
import ice.cert.CertificateExpiredException;
import ice.cert.CertificateNotYetValidException;
import ice.cert.X500Name;
import ice.cert.X509Certificate;
import ice.cert.X509CertificateFactory;
import ice.crypto.ICEsoft;
import ice.crypto.RSAPrivateKey;
import ice.crypto.RSAPublicKey;
import ice.ssl.CertificateErrorInfo;
import ice.ssl.CertificateEvent;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.RandomAdapter;
import ice.ssl.SSLSocket;
import ice.ssl.ServerCertificateList;
import ice.ssl.SessionState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public final class Util {
    static byte[] pad1 = new byte[48];
    static byte[] pad2 = new byte[48];
    private static MessageDigest[] I = new MessageDigest[3];
    private static RandomAdapter J = new RandomAdapter();
    private static RandomAdapter MACAlgorithm = new RandomAdapter();
    private static boolean OEAB = false;

    public static void init() {
        if (OEAB) {
            return;
        }
        OEAB = true;
        int n = 0;
        while (n < 48) {
            Util.pad1[n] = 54;
            Util.pad2[n] = 92;
            ++n;
        }
        Security.addProvider(new Cryptix());
        Security.addProvider(new ICEsoft());
        try {
            Util.I[1] = MessageDigest.getInstance("MD5");
            Util.I[2] = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("Digest algorithm not found");
        }
        byte[] byArray = new byte[16];
        new Random().nextBytes(byArray);
        MACAlgorithm.setSeed(byArray);
    }

    static int minorVersion(int n) {
        if (n == 1 || n == 2) {
            return 0;
        }
        return 1;
    }

    static int majorVersion(int n) {
        if (n == 1) {
            return 2;
        }
        return 3;
    }

    static SecureRandom getSecureRandom() {
        if (SSLSocket.useSecureRandom) {
            return J.getSecureRandom();
        }
        return MACAlgorithm.getSecureRandom();
    }

    static void secureRandom(byte[] byArray) {
        if (SSLSocket.useSecureRandom) {
            J.nextBytes(byArray);
        } else {
            MACAlgorithm.nextBytes(byArray);
        }
    }

    static void secureRandom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        if (SSLSocket.useSecureRandom) {
            J.nextBytes(byArray2);
        } else {
            MACAlgorithm.nextBytes(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    static byte[] toByteArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < (4 < n2 ? 4 : n2)) {
            byArray[n2 - n3 - 1] = (byte)(n >>> 8 * n3);
            ++n3;
        }
        return byArray;
    }

    static byte[] toByteArray(long l, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < (8 < n ? 8 : n)) {
            byArray[n - n2 - 1] = (byte)(l >>> 8 * n2);
            ++n2;
        }
        return byArray;
    }

    static void toByteArray(long l, byte[] byArray, int n, int n2) {
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException("Array too small (" + byArray.length + " < " + n + n2 + ")");
        }
        int n3 = 0;
        while (n3 < (8 < n2 ? 8 : n2)) {
            byArray[n + n2 - n3 - 1] = (byte)(l >>> 8 * n3);
            ++n3;
        }
    }

    static int byteArrayToInt(byte[] byArray) {
        if (byArray.length == 0) {
            return 0;
        }
        int n = byArray[0] & 0xFF;
        int n2 = 1;
        while (n2 < (byArray.length < 4 ? byArray.length : 4)) {
            n = (n << 8) + (byArray[n2] & 0xFF);
            ++n2;
        }
        return n;
    }

    static int byteArrayToInt(byte[] byArray, int n, int n2) {
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException("Array too small (" + byArray.length + " < " + (n + n2) + ")");
        }
        int n3 = byArray[n] & 0xFF;
        int n4 = 1;
        while (n4 < (n2 < 4 ? n2 : 4)) {
            n3 = (n3 << 8) + (byArray[n + n4] & 0xFF);
            ++n4;
        }
        return n3;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static int[] concat(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static String getPrintForm(int[] nArray) {
        return Util.getPrintForm(nArray, 0, nArray != null ? nArray.length : 0);
    }

    public static String getPrintForm(int[] nArray, int n, int n2) {
        if (nArray == null || n2 == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(nArray[n3 + n]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String getPrintForm(byte[] byArray) {
        return Util.getPrintForm(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public static String getPrintForm(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * 3 - 1);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0xFF & byArray[n3 + n];
            if (n3 != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Util.I(n4 >>> 4));
            stringBuffer.append(Util.I(n4 & 0xF));
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static char I(int n) {
        return n < 10 ? (char)(48 + n) : (char)(55 + n);
    }

    public static void treatCert(byte[] byArray, SSLSocket sSLSocket, SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        Object object;
        Object object2;
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        X509Certificate x509Certificate = null;
        CertificateException certificateException = null;
        try {
            x509Certificate = x509CertificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        catch (CertificateException certificateException2) {
            certificateException = certificateException2;
        }
        if (certificateException != null) {
            CertificateErrorInfo[] certificateErrorInfoArray = new CertificateErrorInfo[]{new CertificateErrorInfo(0, "The certificate is corrupted: " + certificateException.getMessage(), null, null)};
            handshakeState.certEvent = new CertificateEvent(sSLSocket, x509Certificate, certificateErrorInfoArray);
            return;
        }
        Vector<CertificateErrorInfo> vector = new Vector<CertificateErrorInfo>();
        sessionState.serverCertificate = x509Certificate;
        sessionState.serverPublicKey = x509Certificate.getPublicKey();
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            vector.addElement(new CertificateErrorInfo(4, "This certificate has expired", x509Certificate.getNotAfter(), new Date()));
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            vector.addElement(new CertificateErrorInfo(5, "This certificate has expired", x509Certificate.getNotBefore(), new Date()));
        }
        String string = sSLSocket.getTargetHostName();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = ((X500Name)x509Certificate.getSubjectDN()).getElement("CN");
        string2 = string2.toLowerCase();
        string = string.toLowerCase();
        if (string2.startsWith("*.")) {
            object2 = string2.substring(2);
            if (!string.endsWith((String)object2)) {
                vector.addElement(new CertificateErrorInfo(3, "The certificate is not issued for the site providing it.", string2, string));
            }
        } else {
            object2 = new InetAddress[]{};
            try {
                object2 = InetAddress.getAllByName(string2);
                string2 = InetAddress.getByName(string2).getHostName().toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            int n = 0;
            while (n < ((Object)object2).length) {
                if (((InetAddress)object2[n]).equals(inetAddress)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (string2.equals(string)) {
                bl = true;
            }
            if (!bl) {
                vector.addElement(new CertificateErrorInfo(3, "The certificate is not issued for the site providing it.", string2, string));
            }
        }
        object2 = SSLSocket.getTrustedCACertList();
        Enumeration enumeration = ((ServerCertificateList)object2).getList();
        CertificateErrorInfo certificateErrorInfo = null;
        X509Certificate x509Certificate2 = null;
        while (x509Certificate2 == null && enumeration.hasMoreElements()) {
            x509Certificate2 = (X509Certificate)enumeration.nextElement();
            if (x509Certificate2.getSubjectDN().equals(x509Certificate.getIssuerDN())) continue;
            x509Certificate2 = null;
        }
        if (x509Certificate2 == null) {
            object = null;
            ServerCertificateList serverCertificateList = SSLSocket.getTrustedSiteCertList();
            Enumeration enumeration2 = serverCertificateList.getList();
            while (object == null && enumeration2.hasMoreElements()) {
                object = (X509Certificate)enumeration2.nextElement();
                if (((X509Certificate)object).getSubjectDN().equals(x509Certificate.getSubjectDN())) continue;
                object = null;
            }
            if (object == null) {
                vector.addElement(new CertificateErrorInfo(1, "The issuer can not be found in the trusted CA list.", x509Certificate.getIssuerDN(), null));
            }
        } else {
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (Exception exception) {
                certificateErrorInfo = new CertificateErrorInfo(2, "The certificate's signature is invalid.", null, null);
            }
        }
        CertificateErrorInfo[] certificateErrorInfoArray = new CertificateErrorInfo[vector.size()];
        object = vector.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            certificateErrorInfoArray[n++] = (CertificateErrorInfo)object.nextElement();
        }
        handshakeState.certEvent = new CertificateEvent(sSLSocket, x509Certificate, certificateErrorInfoArray);
    }

    public static byte[] hmac(int n, byte[] byArray, byte[] byArray2) {
        MessageDigest[] messageDigestArray = I;
        synchronized (messageDigestArray) {
            if (byArray.length > 64) {
                I[n].reset();
                I[n].update(byArray);
                byArray = I[n].digest();
            }
            byte[] byArray3 = new byte[64];
            byte[] byArray4 = new byte[64];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            int n2 = 0;
            while (n2 < 64) {
                byArray3[n2] = (byte)(0xFF & byArray3[n2] ^ 0x36);
                byArray4[n2] = (byte)(0xFF & byArray4[n2] ^ 0x5C);
                ++n2;
            }
            I[n].reset();
            I[n].update(byArray3);
            I[n].update(byArray2);
            byte[] byArray5 = I[n].digest();
            I[n].reset();
            I[n].update(byArray4);
            I[n].update(byArray5);
            byte[] byArray6 = I[n].digest();
            return byArray6;
        }
    }

    public static byte[] pHash(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3 = n == 1 ? 16 : 20;
        int n4 = n2 / n3 + 1;
        byte[] byArray3 = byArray2;
        byte[] byArray4 = new byte[n2];
        int n5 = 0;
        while (n5 < n4) {
            byArray3 = Util.hmac(n, byArray, byArray3);
            byte[] byArray5 = Util.concat(byArray3, byArray2);
            byte[] byArray6 = Util.hmac(n, byArray, byArray5);
            System.arraycopy(byArray6, 0, byArray4, n5 * n3, n5 < n4 - 1 ? n3 : n2 % n3);
            ++n5;
        }
        return byArray4;
    }

    public static byte[] prf(int n, byte[] byArray, String string, byte[] byArray2) {
        int n2 = byArray.length / 2 + (byArray.length % 2 > 0 ? 1 : 0);
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray, byArray.length - n2, byArray4, 0, n2);
        byte[] byArray5 = Util.concat(string.getBytes(), byArray2);
        byte[] byArray6 = Util.pHash(1, n, byArray3, byArray5);
        byte[] byArray7 = Util.pHash(2, n, byArray4, byArray5);
        byte[] byArray8 = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            byArray8[n3] = (byte)(0xFF & byArray6[n3] ^ 0xFF & byArray7[n3]);
            ++n3;
        }
        return byArray8;
    }

    static byte[] encryptRSAPKCS1(byte[] byArray, Key key) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n;
        if (key instanceof RSAPublicKey) {
            n = 2;
            bigInteger2 = ((RSAPublicKey)key).getModulus();
            bigInteger = ((RSAPublicKey)key).getPublicExponent();
        } else if (key instanceof RSAPrivateKey) {
            n = 1;
            bigInteger2 = ((RSAPrivateKey)key).getModulus();
            bigInteger = ((RSAPrivateKey)key).getPrivateExponent();
        } else {
            throw new IllegalArgumentException("Expecting RSA key but received " + key.getAlgorithm() + " key (" + key + ").");
        }
        int n2 = (bigInteger2.bitLength() - 1) / 8 + 1;
        if (byArray.length > n2 - 11) {
            throw new IllegalArgumentException("array length too big (is " + byArray.length + " but should be < " + (n2 - 11) + ")");
        }
        byte[] byArray2 = new byte[n2];
        byArray2[0] = 0;
        byArray2[1] = (byte)n;
        int n3 = n2 - 1 - byArray.length;
        if (n == 1) {
            int n4 = 2;
            while (n4 < n3) {
                byArray2[n4] = -1;
                ++n4;
            }
        } else if (n == 2) {
            byte[] byArray3 = new byte[1];
            int n5 = 2;
            while (n5 < n3) {
                Util.secureRandom(byArray3);
                while (byArray3[0] == 0) {
                    Util.secureRandom(byArray3);
                }
                byArray2[n5] = byArray3[0];
                ++n5;
            }
        }
        byArray2[n3] = 0;
        System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        byte[] byArray4 = new BigInteger(byArray2).modPow(bigInteger, bigInteger2).toByteArray();
        byte[] byArray5 = new byte[n2];
        if (byArray4.length > n2) {
            System.arraycopy(byArray4, byArray4.length - n2, byArray5, 0, n2);
        } else {
            System.arraycopy(byArray4, 0, byArray5, n2 - byArray4.length, byArray4.length);
        }
        return byArray5;
    }

    static byte[] v3generateHash(boolean bl, SessionState sessionState, ConnectionState connectionState, int n, byte[] byArray) {
        if (sessionState.MACAlgorithm == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        MessageDigest[] messageDigestArray = I;
        synchronized (messageDigestArray) {
            if (sessionState.nowProto == 2) {
                int n2 = 0;
                if (sessionState.MACAlgorithm == 1) {
                    n2 = 48;
                } else if (sessionState.MACAlgorithm == 2) {
                    n2 = 40;
                }
                I[sessionState.MACAlgorithm].reset();
                I[sessionState.MACAlgorithm].update(bl ? connectionState.serverWriteMACSecret : connectionState.clientWriteMACSecret);
                I[sessionState.MACAlgorithm].update(pad1, 0, n2);
                I[sessionState.MACAlgorithm].update(Util.toByteArray(bl ? connectionState.serverSeqNum : connectionState.clientSeqNum, 8));
                I[sessionState.MACAlgorithm].update((byte)n);
                I[sessionState.MACAlgorithm].update(Util.toByteArray(byArray.length, 2));
                I[sessionState.MACAlgorithm].update(byArray);
                byte[] byArray3 = I[sessionState.MACAlgorithm].digest();
                I[sessionState.MACAlgorithm].reset();
                I[sessionState.MACAlgorithm].update(bl ? connectionState.serverWriteMACSecret : connectionState.clientWriteMACSecret);
                I[sessionState.MACAlgorithm].update(pad2, 0, n2);
                I[sessionState.MACAlgorithm].update(byArray3);
                byArray2 = I[sessionState.MACAlgorithm].digest();
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    byteArrayOutputStream.write(Util.toByteArray(bl ? connectionState.serverSeqNum : connectionState.clientSeqNum, 8));
                    byteArrayOutputStream.write((byte)n);
                    byteArrayOutputStream.write((byte)Util.majorVersion(sessionState.nowProto));
                    byteArrayOutputStream.write((byte)Util.minorVersion(sessionState.nowProto));
                    byteArrayOutputStream.write(Util.toByteArray(byArray.length, 2));
                    byteArrayOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byArray2 = Util.hmac(sessionState.MACAlgorithm, bl ? connectionState.serverWriteMACSecret : connectionState.clientWriteMACSecret, byteArrayOutputStream.toByteArray());
            }
        }
        return byArray2;
    }

    static byte[] v2generateHash(boolean bl, SessionState sessionState, ConnectionState connectionState, byte[] byArray) {
        if (sessionState.MACAlgorithm == 0) {
            return new byte[0];
        }
        MessageDigest[] messageDigestArray = I;
        synchronized (messageDigestArray) {
            I[sessionState.MACAlgorithm].reset();
            I[sessionState.MACAlgorithm].update(bl ? connectionState.serverWriteKey : connectionState.clientWriteKey);
            I[sessionState.MACAlgorithm].update(byArray);
            I[sessionState.MACAlgorithm].update(Util.toByteArray(bl ? connectionState.serverSeqNum : connectionState.clientSeqNum, 4));
            byte[] byArray2 = I[sessionState.MACAlgorithm].digest();
            return byArray2;
        }
    }
}

