/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.NewThreadAction;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ThreadPool
implements Executor {
    private static final long idleTimeout = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.thread.idleThreadTimeout", 300000L));
    private static final Logger logger = Logger.getLogger("com.sun.jini.thread.ThreadPool");
    private final ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int idleThreads = 0;
    private final LinkedList queue = new LinkedList();

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String string) {
        Task task = new Task(runnable, string);
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
                return;
            }
        }
        object = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), string, true));
        ((Thread)object).start();
    }

    private class Worker
    implements Runnable {
        private Task first;

        Worker(Task task) {
            this.first = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Task task = this.first;
            this.first = null;
            while (true) {
                try {
                    task.runnable.run();
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "uncaught exception", throwable);
                }
                Object object = ThreadPool.this.lock;
                synchronized (object) {
                    if (ThreadPool.this.queue.isEmpty()) {
                        block11: {
                            Object var5_5;
                            Thread.currentThread().setName("(JSK) Idle");
                            ThreadPool.this.idleThreads++;
                            try {
                                try {
                                    ThreadPool.this.lock.wait(idleTimeout);
                                }
                                catch (InterruptedException interruptedException) {
                                    var5_5 = null;
                                    ThreadPool.this.idleThreads--;
                                    break block11;
                                }
                                var5_5 = null;
                            }
                            catch (Throwable throwable) {
                                var5_5 = null;
                                ThreadPool.this.idleThreads--;
                                throw throwable;
                            }
                            ThreadPool.this.idleThreads--;
                        }
                        if (ThreadPool.this.queue.isEmpty()) {
                            return;
                        }
                    }
                    task = (Task)ThreadPool.this.queue.removeFirst();
                    Thread.currentThread().setName("(JSK) " + task.name);
                }
            }
        }
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String string) {
            this.runnable = runnable;
            this.name = string;
        }
    }
}

