/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class Config {
    static final Logger logger = Logger.getLogger("net.jini.config");

    private Config() {
        throw new AssertionError((Object)"com.sun.jini.config.Config cannot be instantiated");
    }

    public static Object getNonNullEntry(Configuration configuration, String string, String string2, Class clazz) throws ConfigurationException {
        return Config.getNonNullEntry(configuration, string, string2, clazz, Configuration.NO_DEFAULT, Configuration.NO_DATA);
    }

    public static Object getNonNullEntry(Configuration configuration, String string, String string2, Class clazz, Object object) throws ConfigurationException {
        return Config.getNonNullEntry(configuration, string, string2, clazz, object, Configuration.NO_DATA);
    }

    public static Object getNonNullEntry(Configuration configuration, String string, String string2, Class clazz, Object object, Object object2) throws ConfigurationException {
        if (object == null) {
            throw new NullPointerException("defaultValue cannot be null");
        }
        Object object3 = configuration.getEntry(string, string2, clazz, object, object2);
        if (object3 == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: cannot be null", new Object[]{configuration, string, string2});
            }
            throw new ConfigurationException("entry for component " + string + ", name " + string2 + " cannot be null");
        }
        return object3;
    }

    private static boolean inRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    private static boolean inRange(long l, long l2, long l3) {
        return l2 <= l && l <= l3;
    }

    private static boolean inRange(float f, float f2, float f3) {
        return f2 <= f && f <= f3;
    }

    public static long getLongEntry(Configuration configuration, String string, String string2, long l, long l2, long l3) throws ConfigurationException {
        if (l2 > l3) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        if (!Config.inRange(l, l2, l3)) {
            throw new IllegalArgumentException("defaultValue (" + l + ") must be between " + l2 + " and " + l3);
        }
        long l4 = (Long)configuration.getEntry(string, string2, Long.TYPE, new Long(l));
        if (!Config.inRange(l4, l2, l3)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: entry is out of range, value: {3}, valid range: {4}:{5}", new Object[]{configuration, string, string2, new Long(l4), new Long(l2), new Long(l3)});
            }
            throw new ConfigurationException("entry for component " + string + ", name " + string2 + " must be between " + l2 + " and " + l3 + ", has a value of " + l4);
        }
        return l4;
    }

    public static int getIntEntry(Configuration configuration, String string, String string2, int n, int n2, int n3) throws ConfigurationException {
        if (n2 > n3) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        if (!Config.inRange(n, n2, n3)) {
            throw new IllegalArgumentException("defaultValue (" + n + ") must be between " + n2 + " and " + n3);
        }
        int n4 = (Integer)configuration.getEntry(string, string2, Integer.TYPE, new Integer(n));
        if (!Config.inRange(n4, n2, n3)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: entry is out of range, value: {3}, valid range: {4}:{5}", new Object[]{configuration, string, string2, new Integer(n4), new Integer(n2), new Integer(n3)});
            }
            throw new ConfigurationException("entry for component " + string + ", name " + string2 + " must be between " + n2 + " and " + n3 + ", has a value of " + n4);
        }
        return n4;
    }

    public static float getFloatEntry(Configuration configuration, String string, String string2, float f, float f2, float f3) throws ConfigurationException {
        if (f2 > f3) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        if (!Config.inRange(f, f2, f3)) {
            throw new IllegalArgumentException("defaultValue (" + f + ") must be between " + f2 + " and " + f3);
        }
        float f4 = ((Float)configuration.getEntry(string, string2, Float.TYPE, new Float(f))).floatValue();
        if (!Config.inRange(f4, f2, f3)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: entry is out of range, value: {3}, valid range: {4}:{5}", new Object[]{configuration, string, string2, new Float(f4), new Float(f2), new Float(f3)});
            }
            throw new ConfigurationException("entry for component " + string + ", name " + string2 + " must be between " + f2 + " and " + f3 + ", has a value of " + f4);
        }
        return f4;
    }
}

