/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.Plaintext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.Constants;
import net.jini.io.MarshalledInstance;
import net.jini.io.UnsupportedConstraintException;

class DiscoveryV1
extends Discovery {
    private static final int SERVICE_ID_LEN = 16;
    private static final DiscoveryV1 instance = new DiscoveryV1();
    private static final Logger logger = Logger.getLogger(DiscoveryV1.class.getName());

    DiscoveryV1() {
    }

    static DiscoveryV1 getInstance() {
        return instance;
    }

    public EncodeIterator encodeMulticastRequest(final MulticastRequest multicastRequest, final int n, final InvocationConstraints invocationConstraints) {
        if (n < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        return new EncodeIterator(){
            private boolean used;

            public DatagramPacket[] next() throws IOException {
                this.used = true;
                return DiscoveryV1.encode(multicastRequest, n, invocationConstraints);
            }

            public boolean hasNext() {
                return !this.used;
            }
        };
    }

    private static DatagramPacket[] encode(MulticastRequest multicastRequest, int n, InvocationConstraints invocationConstraints) throws IOException {
        Object object;
        DiscoveryV1.checkConstraints(invocationConstraints);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String[] stringArray = multicastRequest.getGroups();
        for (int i = 0; i < stringArray.length; ++i) {
            object = Plaintext.toUtf(stringArray[i]);
            if (((byte[])object).length + 16 > n) {
                throw new DiscoveryProtocolException("group too long: " + stringArray[i]);
            }
            linkedList.add(object);
        }
        ArrayList<DatagramPacket> arrayList = new ArrayList<DatagramPacket>();
        do {
            int n2;
            object = ByteBuffer.allocate(n);
            object.putInt(1);
            object.putInt(multicastRequest.getPort());
            ServiceID[] serviceIDArray = multicastRequest.getServiceIDs();
            int n3 = Math.min(serviceIDArray.length, (object.remaining() - (linkedList.isEmpty() ? 0 : ((byte[])linkedList.getFirst()).length) - 4 - 4) / 16);
            object.putInt(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                object.putLong(serviceIDArray[n2].getMostSignificantBits());
                object.putLong(serviceIDArray[n2].getLeastSignificantBits());
            }
            n2 = object.position();
            int n4 = 0;
            object.putInt(n4);
            while (!linkedList.isEmpty() && ((byte[])linkedList.getFirst()).length <= object.remaining()) {
                object.put((byte[])linkedList.removeFirst());
                ++n4;
            }
            if (n4 > 0) {
                object.putInt(n2, n4);
            }
            arrayList.add(new DatagramPacket(object.array(), object.position(), Constants.getRequestAddress(), 4160));
        } while (!linkedList.isEmpty());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "encoded {0}", new Object[]{multicastRequest});
        }
        return arrayList.toArray(new DatagramPacket[arrayList.size()]);
    }

    public MulticastRequest decodeMulticastRequest(DatagramPacket datagramPacket, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker) throws IOException {
        DiscoveryV1.checkConstraints(invocationConstraints);
        if (clientSubjectChecker != null) {
            clientSubjectChecker.checkClientSubject(null);
        }
        try {
            int n;
            ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            int n2 = byteBuffer.getInt();
            if (n2 != 1) {
                throw new DiscoveryProtocolException("wrong protocol version: " + n2);
            }
            String string = datagramPacket.getAddress().getHostAddress();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            if (n4 < 0 || n4 > byteBuffer.remaining() / 16) {
                throw new DiscoveryProtocolException("invalid service ID count: " + n4);
            }
            ServiceID[] serviceIDArray = new ServiceID[n4];
            for (n = 0; n < serviceIDArray.length; ++n) {
                long l = byteBuffer.getLong();
                long l2 = byteBuffer.getLong();
                serviceIDArray[n] = new ServiceID(l, l2);
            }
            n = byteBuffer.getInt();
            if (n < 0 || n > byteBuffer.remaining() / 2) {
                throw new DiscoveryProtocolException("invalid group count: " + n);
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Plaintext.getUtf(byteBuffer);
            }
            MulticastRequest multicastRequest = new MulticastRequest(string, n3, stringArray, serviceIDArray);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "decoded {0}", new Object[]{multicastRequest});
            }
            return multicastRequest;
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public EncodeIterator encodeMulticastAnnouncement(final MulticastAnnouncement multicastAnnouncement, final int n, final InvocationConstraints invocationConstraints) {
        if (n < 512) {
            throw new IllegalArgumentException("maxPacketSize too small");
        }
        return new EncodeIterator(){
            private boolean used;

            public DatagramPacket[] next() throws IOException {
                this.used = true;
                return DiscoveryV1.encode(multicastAnnouncement, n, invocationConstraints);
            }

            public boolean hasNext() {
                return !this.used;
            }
        };
    }

    private static DatagramPacket[] encode(MulticastAnnouncement multicastAnnouncement, int n, InvocationConstraints invocationConstraints) throws IOException {
        Object object;
        DiscoveryV1.checkConstraints(invocationConstraints);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        byte[] byArray = Plaintext.toUtf(multicastAnnouncement.getHost());
        String[] stringArray = multicastAnnouncement.getGroups();
        for (int i = 0; i < stringArray.length; ++i) {
            object = Plaintext.toUtf(stringArray[i]);
            if (((byte[])object).length + byArray.length + 28 > n) {
                throw new DiscoveryProtocolException("group too long: " + stringArray[i]);
            }
            linkedList.add(object);
        }
        ArrayList<DatagramPacket> arrayList = new ArrayList<DatagramPacket>();
        do {
            object = ByteBuffer.allocate(n);
            object.putInt(1);
            object.put(byArray);
            object.putInt(multicastAnnouncement.getPort());
            ServiceID serviceID = multicastAnnouncement.getServiceID();
            object.putLong(serviceID.getMostSignificantBits());
            object.putLong(serviceID.getLeastSignificantBits());
            int n2 = object.position();
            int n3 = 0;
            object.putInt(n3);
            while (!linkedList.isEmpty() && ((byte[])linkedList.getFirst()).length <= object.remaining()) {
                object.put((byte[])linkedList.removeFirst());
                ++n3;
            }
            if (n3 > 0) {
                object.putInt(n2, n3);
            }
            arrayList.add(new DatagramPacket(object.array(), object.position(), Constants.getAnnouncementAddress(), 4160));
        } while (!linkedList.isEmpty());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "encoded {0}", new Object[]{multicastAnnouncement});
        }
        return arrayList.toArray(new DatagramPacket[arrayList.size()]);
    }

    public MulticastAnnouncement decodeMulticastAnnouncement(DatagramPacket datagramPacket, InvocationConstraints invocationConstraints) throws IOException {
        DiscoveryV1.checkConstraints(invocationConstraints);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            int n = byteBuffer.getInt();
            if (n != 1) {
                throw new DiscoveryProtocolException("wrong protocol version: " + n);
            }
            String string = Plaintext.getUtf(byteBuffer);
            int n2 = byteBuffer.getInt();
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            ServiceID serviceID = new ServiceID(l, l2);
            int n3 = byteBuffer.getInt();
            if (n3 < 0 || n3 > byteBuffer.remaining() / 2) {
                throw new DiscoveryProtocolException("invalid group count: " + n3);
            }
            String[] stringArray = new String[n3];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Plaintext.getUtf(byteBuffer);
            }
            MulticastAnnouncement multicastAnnouncement = new MulticastAnnouncement(-1L, string, n2, stringArray, serviceID);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "decoded {0}", new Object[]{multicastAnnouncement});
            }
            return multicastAnnouncement;
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints invocationConstraints, ClassLoader classLoader, ClassLoader classLoader2, Collection collection) throws IOException, ClassNotFoundException {
        DiscoveryV1.checkConstraints(invocationConstraints);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 4));
            dataOutputStream.writeInt(1);
            dataOutputStream.flush();
            String string = socket.getInetAddress().getHostAddress();
            int n = socket.getPort();
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            MarshalledInstance marshalledInstance = new MarshalledInstance((MarshalledObject)objectInputStream.readObject());
            ServiceRegistrar serviceRegistrar = (ServiceRegistrar)marshalledInstance.get(classLoader, false, null, collection);
            int n2 = objectInputStream.readInt();
            if (n2 < 0) {
                throw new DiscoveryProtocolException("invalid group count: " + n2);
            }
            String[] stringArray = new String[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = objectInputStream.readUTF();
            }
            UnicastResponse unicastResponse = new UnicastResponse(string, n, stringArray, serviceRegistrar);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "received {0}", new Object[]{unicastResponse});
            }
            return unicastResponse;
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public void handleUnicastDiscovery(UnicastResponse unicastResponse, Socket socket, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker, Collection collection) throws IOException {
        DiscoveryV1.checkConstraints(invocationConstraints);
        if (clientSubjectChecker != null) {
            clientSubjectChecker.checkClientSubject(null);
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        objectOutputStream.writeObject(new MarshalledInstance(unicastResponse.getRegistrar(), collection).convertToMarshalledObject());
        String[] stringArray = unicastResponse.getGroups();
        objectOutputStream.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            objectOutputStream.writeUTF(stringArray[i]);
        }
        objectOutputStream.flush();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "sent {0}", new Object[]{unicastResponse});
        }
    }

    public String toString() {
        return "DiscoveryV1";
    }

    private static void checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        if (invocationConstraints != null) {
            invocationConstraints = invocationConstraints.makeAbsolute();
        }
        Plaintext.checkConstraints(invocationConstraints);
    }
}

