/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.io.MarshalledInstance;
import net.jini.io.UnsupportedConstraintException;

public class Plaintext {
    private static final int MAX_USHORT = 65535;
    private static final int SHORT_LEN = 2;
    private static final int SERVICE_ID_LEN = 16;
    private static final Charset utf = Charset.forName("UTF-8");
    private static final Set supportedConstraints = new HashSet();

    private Plaintext() {
    }

    public static short intToUshort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("invalid value: " + n);
        }
        return (short)n;
    }

    public static int ushortToInt(short s) {
        return s & 0xFFFF;
    }

    public static byte[] toUtf(String string) throws UTFDataFormatException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            return byteArrayOutputStream.toByteArray();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw uTFDataFormatException;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void putUtf(ByteBuffer byteBuffer, String string) throws UTFDataFormatException {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.putShort((short)0);
        int n = byteBuffer2.position();
        CoderResult coderResult = utf.newEncoder().encode(CharBuffer.wrap(string), byteBuffer2, true);
        if (!coderResult.isUnderflow()) {
            if (coderResult.isOverflow()) {
                throw new BufferOverflowException();
            }
            throw new UTFDataFormatException(coderResult.toString());
        }
        byteBuffer.putShort(Plaintext.intToUshort(byteBuffer2.position() - n));
        byteBuffer.position(byteBuffer2.position());
    }

    public static String getUtf(ByteBuffer byteBuffer) throws UTFDataFormatException {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        int n = Plaintext.ushortToInt(byteBuffer2.getShort());
        if (n > byteBuffer2.remaining()) {
            throw new BufferUnderflowException();
        }
        byteBuffer2.limit(byteBuffer2.position() + n);
        try {
            String string = utf.newDecoder().decode(byteBuffer2).toString();
            byteBuffer.position(byteBuffer2.position());
            return string;
        }
        catch (CharacterCodingException characterCodingException) {
            throw (UTFDataFormatException)new UTFDataFormatException().initCause(characterCodingException);
        }
    }

    public static void checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        if (invocationConstraints == null) {
            return;
        }
        Iterator iterator = invocationConstraints.requirements().iterator();
        while (iterator.hasNext()) {
            InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
            if (Plaintext.supported(invocationConstraint)) continue;
            throw new UnsupportedConstraintException("unsupported constraint: " + invocationConstraint);
        }
    }

    public static void encodeMulticastRequest(MulticastRequest multicastRequest, DatagramBufferFactory datagramBufferFactory) throws IOException {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(Arrays.asList(multicastRequest.getGroups()));
            do {
                int n;
                ByteBuffer byteBuffer = datagramBufferFactory.newBuffer();
                Plaintext.putUtf(byteBuffer, multicastRequest.getHost());
                byteBuffer.putShort(Plaintext.intToUshort(multicastRequest.getPort()));
                int n2 = 0;
                int n3 = byteBuffer.position();
                byteBuffer.putShort((short)0);
                if (!linkedList.isEmpty()) {
                    Plaintext.putUtf(byteBuffer, (String)linkedList.removeFirst());
                    ++n2;
                }
                ServiceID[] serviceIDArray = multicastRequest.getServiceIDs();
                int n4 = Math.min(serviceIDArray.length, 65535);
                int n5 = 2 + n4 * 16;
                if (byteBuffer.remaining() > n5 && !linkedList.isEmpty()) {
                    n = byteBuffer.limit();
                    byteBuffer.limit(n - n5);
                    try {
                        do {
                            Plaintext.putUtf(byteBuffer, (String)linkedList.getFirst());
                            linkedList.removeFirst();
                        } while (!linkedList.isEmpty() && ++n2 < 65535);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        // empty catch block
                    }
                    byteBuffer.limit(n);
                }
                byteBuffer.putShort(n3, Plaintext.intToUshort(n2));
                n = Math.min(n4, (byteBuffer.remaining() - 2) / 16);
                byteBuffer.putShort(Plaintext.intToUshort(n));
                for (int i = 0; i < n; ++i) {
                    ServiceID serviceID = serviceIDArray[i];
                    byteBuffer.putLong(serviceID.getMostSignificantBits());
                    byteBuffer.putLong(serviceID.getLeastSignificantBits());
                }
            } while (!linkedList.isEmpty());
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public static MulticastRequest decodeMulticastRequest(ByteBuffer byteBuffer) throws IOException {
        try {
            String string = Plaintext.getUtf(byteBuffer);
            int n = Plaintext.ushortToInt(byteBuffer.getShort());
            String[] stringArray = new String[Plaintext.ushortToInt(byteBuffer.getShort())];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Plaintext.getUtf(byteBuffer);
            }
            ServiceID[] serviceIDArray = new ServiceID[Plaintext.ushortToInt(byteBuffer.getShort())];
            for (int i = 0; i < serviceIDArray.length; ++i) {
                long l = byteBuffer.getLong();
                long l2 = byteBuffer.getLong();
                serviceIDArray[i] = new ServiceID(l, l2);
            }
            return new MulticastRequest(string, n, stringArray, serviceIDArray);
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public static void encodeMulticastAnnouncement(MulticastAnnouncement multicastAnnouncement, DatagramBufferFactory datagramBufferFactory) throws IOException {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(Arrays.asList(multicastAnnouncement.getGroups()));
            do {
                int n;
                int n2;
                int n3;
                ByteBuffer byteBuffer;
                block6: {
                    byteBuffer = datagramBufferFactory.newBuffer();
                    n3 = byteBuffer.limit();
                    byteBuffer.limit(n3 - 16);
                    byteBuffer.putLong(multicastAnnouncement.getSequenceNumber());
                    Plaintext.putUtf(byteBuffer, multicastAnnouncement.getHost());
                    byteBuffer.putShort(Plaintext.intToUshort(multicastAnnouncement.getPort()));
                    n2 = byteBuffer.position();
                    byteBuffer.putShort((short)0);
                    try {
                        for (n = 0; !linkedList.isEmpty() && n < 65535; ++n) {
                            Plaintext.putUtf(byteBuffer, (String)linkedList.getFirst());
                            linkedList.removeFirst();
                        }
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        if (n != 0) break block6;
                        throw bufferOverflowException;
                    }
                }
                byteBuffer.putShort(n2, Plaintext.intToUshort(n));
                ServiceID serviceID = multicastAnnouncement.getServiceID();
                byteBuffer.limit(n3);
                byteBuffer.putLong(serviceID.getMostSignificantBits());
                byteBuffer.putLong(serviceID.getLeastSignificantBits());
            } while (!linkedList.isEmpty());
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public static MulticastAnnouncement decodeMulticastAnnouncement(ByteBuffer byteBuffer) throws IOException {
        try {
            long l = byteBuffer.getLong();
            String string = Plaintext.getUtf(byteBuffer);
            int n = Plaintext.ushortToInt(byteBuffer.getShort());
            String[] stringArray = new String[Plaintext.ushortToInt(byteBuffer.getShort())];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Plaintext.getUtf(byteBuffer);
            }
            long l2 = byteBuffer.getLong();
            long l3 = byteBuffer.getLong();
            return new MulticastAnnouncement(l, string, n, stringArray, new ServiceID(l2, l3));
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public static void writeUnicastResponse(OutputStream outputStream, UnicastResponse unicastResponse, Collection collection) throws IOException {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeUTF(unicastResponse.getHost());
            dataOutputStream.writeShort(Plaintext.intToUshort(unicastResponse.getPort()));
            String[] stringArray = unicastResponse.getGroups();
            dataOutputStream.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
            }
            new ObjectOutputStream(outputStream).writeObject(new MarshalledInstance(unicastResponse.getRegistrar(), collection));
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    public static UnicastResponse readUnicastResponse(InputStream inputStream, ClassLoader classLoader, boolean bl, ClassLoader classLoader2, Collection collection) throws IOException, ClassNotFoundException {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readUnsignedShort();
            String[] stringArray = new String[dataInputStream.readInt()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = dataInputStream.readUTF();
            }
            MarshalledInstance marshalledInstance = (MarshalledInstance)new ObjectInputStream(inputStream).readObject();
            ServiceRegistrar serviceRegistrar = (ServiceRegistrar)marshalledInstance.get(classLoader, bl, classLoader2, collection);
            return new UnicastResponse(string, n, stringArray, serviceRegistrar);
        }
        catch (RuntimeException runtimeException) {
            throw new DiscoveryProtocolException(null, runtimeException);
        }
    }

    private static boolean supported(InvocationConstraint invocationConstraint) {
        if (invocationConstraint instanceof ConstraintAlternatives) {
            ConstraintAlternatives constraintAlternatives = (ConstraintAlternatives)invocationConstraint;
            Iterator iterator = constraintAlternatives.elements().iterator();
            while (iterator.hasNext()) {
                if (!Plaintext.supported((InvocationConstraint)iterator.next())) continue;
                return true;
            }
            return false;
        }
        return supportedConstraints.contains(invocationConstraint) || supportedConstraints.contains(invocationConstraint.getClass());
    }

    static {
        supportedConstraints.add(Integrity.NO);
        supportedConstraints.add(Confidentiality.NO);
        supportedConstraints.add(ClientAuthentication.NO);
        supportedConstraints.add(ServerAuthentication.NO);
        supportedConstraints.add(Delegation.NO);
        supportedConstraints.add(ClientMaxPrincipal.class);
        supportedConstraints.add(ClientMaxPrincipalType.class);
        supportedConstraints.add(ClientMinPrincipal.class);
        supportedConstraints.add(ClientMinPrincipalType.class);
        supportedConstraints.add(ServerMinPrincipal.class);
        supportedConstraints.add(DelegationAbsoluteTime.class);
        supportedConstraints.add(DelegationRelativeTime.class);
    }
}

