/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jini.io.ObjectStreamContext;
import net.jini.loader.ClassLoading;

public class MarshalInputStream
extends ObjectInputStream
implements ObjectStreamContext {
    private static final Map specialClasses = new HashMap();
    private final Collection context;
    private final ClassLoader defaultLoader;
    private final boolean verifyCodebaseIntegrity;
    private final ClassLoader verifierLoader;
    private boolean usingCodebaseAnnotations = false;

    public MarshalInputStream(InputStream inputStream, ClassLoader classLoader, boolean bl, ClassLoader classLoader2, Collection collection) throws IOException {
        super(inputStream);
        if (collection == null) {
            throw new NullPointerException();
        }
        this.defaultLoader = classLoader;
        this.verifyCodebaseIntegrity = bl;
        this.verifierLoader = classLoader2;
        this.context = collection;
    }

    public void useCodebaseAnnotations() {
        this.usingCodebaseAnnotations = true;
    }

    public Collection getObjectStreamContext() {
        return this.context;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (objectStreamClass == null) {
            throw new NullPointerException();
        }
        String string = this.readAnnotation();
        String string2 = this.usingCodebaseAnnotations ? string : null;
        String string3 = objectStreamClass.getName();
        try {
            return ClassLoading.loadClass(string2, string3, this.defaultLoader, this.verifyCodebaseIntegrity, this.verifierLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = (Class)specialClasses.get(string3);
            if (clazz != null) {
                return clazz;
            }
            throw classNotFoundException;
        }
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            throw new NullPointerException();
        }
        String string = this.readAnnotation();
        String string2 = this.usingCodebaseAnnotations ? string : null;
        return ClassLoading.loadProxyClass(string2, stringArray, this.defaultLoader, this.verifyCodebaseIntegrity, this.verifierLoader);
    }

    protected String readAnnotation() throws IOException, ClassNotFoundException {
        try {
            return (String)this.readObject();
        }
        catch (ClassCastException classCastException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("annotation not String or null");
            invalidObjectException.initCause(classCastException);
            throw invalidObjectException;
        }
    }

    static {
        specialClasses.put("boolean", Boolean.TYPE);
        specialClasses.put("byte", Byte.TYPE);
        specialClasses.put("char", Character.TYPE);
        specialClasses.put("short", Short.TYPE);
        specialClasses.put("int", Integer.TYPE);
        specialClasses.put("long", Long.TYPE);
        specialClasses.put("float", Float.TYPE);
        specialClasses.put("double", Double.TYPE);
        specialClasses.put("void", Void.TYPE);
    }
}

