/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.logging.Levels;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.jeri.ssl.AuthManager;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.security.AuthenticationPermission;

class ServerAuthManager
extends AuthManager {
    private static final Logger logger;
    private final SSLSessionContext sslSessionContext;
    private final X500PrivateCredential[] readOnlyPrivateCredentials;
    private final Map credentialCache = new HashMap(2);
    private Reference sessionCache = new SoftReference<Object>(null);
    private long credentialsValidUntil = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    ServerAuthManager(Subject subject, Set set, SSLSessionContext sSLSessionContext) throws NoSuchAlgorithmException {
        super(subject, set, null);
        this.sslSessionContext = sSLSessionContext;
        this.readOnlyPrivateCredentials = !this.subjectIsReadOnly || subject == null ? null : (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(subject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate getServerCertificate(SSLSession sSLSession) {
        Map map = this.credentialCache;
        synchronized (map) {
            X500PrivateCredential x500PrivateCredential;
            Object v;
            if (this.sslSessionContext.getSession(sSLSession.getId()) != null && (v = this.credentialCache.get(ServerAuthManager.getKeyAlgorithm(sSLSession.getCipherSuite()))) instanceof X500PrivateCredential && !(x500PrivateCredential = (X500PrivateCredential)v).isDestroyed()) {
                return x500PrivateCredential.getCertificate();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkCredentials(SSLSession sSLSession, Subject subject) throws GeneralSecurityException {
        Map map = this.credentialCache;
        synchronized (map) {
            if (this.sslSessionContext.getSession(sSLSession.getId()) == null) {
                throw new SecurityException("Session not valid");
            }
            Object v = this.credentialCache.get(ServerAuthManager.getKeyAlgorithm(sSLSession.getCipherSuite()));
            if (v == null) {
                throw new SecurityException("No credential cached for key type");
            }
            if (v instanceof String) {
                throw new SecurityException((String)v);
            }
            X500PrivateCredential x500PrivateCredential = (X500PrivateCredential)v;
            if (x500PrivateCredential.isDestroyed()) {
                throw new SecurityException("Private credentials are destroyed");
            }
            if (this.subjectIsReadOnly && sSLSession.equals(this.sessionCache.get()) && System.currentTimeMillis() < this.credentialsValidUntil) {
                return;
            }
            this.credentialsValidUntil = this.checkCredentials(x500PrivateCredential, subject, "accept");
            this.sessionCache = new SoftReference<SSLSession>(sSLSession);
        }
    }

    private long checkCredentials(X500PrivateCredential x500PrivateCredential, Subject subject, String string) {
        Object object;
        Subject subject2 = this.getSubject();
        if (subject2 == null) {
            throw new SecurityException("Missing subject");
        }
        X509Certificate x509Certificate = x500PrivateCredential.getCertificate();
        if (SubjectCredentials.getPrincipal(subject2, x509Certificate) == null) {
            throw new SecurityException("Missing principal");
        }
        CertPath certPath = SubjectCredentials.getCertificateChain(subject2, x509Certificate);
        if (certPath == null) {
            throw new SecurityException("Missing public credentials");
        }
        long l = ServerAuthManager.certificatesValidUntil(certPath);
        if (subject != null) {
            if (!$assertionsDisabled && !subject.isReadOnly()) {
                throw new AssertionError();
            }
            object = (CertPath)subject.getPublicCredentials().iterator().next();
            l = Math.min(l, ServerAuthManager.certificatesValidUntil((CertPath)object));
        }
        if (System.currentTimeMillis() > l) {
            throw new SecurityException("Certificates no longer valid");
        }
        object = this.getPeerPrincipalName(subject);
        X500PrivateCredential x500PrivateCredential2 = this.getPrivateCredential(x509Certificate, (String)object, string);
        if (x500PrivateCredential2 == null) {
            throw new SecurityException("Missing private credentials");
        }
        if (!this.equalPrivateCredentials(x500PrivateCredential, x500PrivateCredential2)) {
            throw new SecurityException("Wrong private credential");
        }
        return l;
    }

    private String getPeerPrincipalName(Subject subject) {
        if (subject == null) {
            return null;
        }
        if (!$assertionsDisabled && !subject.isReadOnly()) {
            throw new AssertionError();
        }
        Principal principal = subject.getPrincipals().iterator().next();
        return principal.getName();
    }

    Logger getLogger() {
        return logger;
    }

    X500PrivateCredential getPrivateCredential(X509Certificate x509Certificate) {
        return this.getPrivateCredential(x509Certificate, null, "listen");
    }

    private X500PrivateCredential getPrivateCredential(X509Certificate x509Certificate, String string, String string2) {
        Subject subject = this.getSubject();
        if (subject == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.getAuthPermission(x509Certificate, string, string2));
        }
        if (this.subjectIsReadOnly) {
            int n = this.readOnlyPrivateCredentials.length;
            while (--n >= 0) {
                X500PrivateCredential x500PrivateCredential = this.readOnlyPrivateCredentials[n];
                if (!x509Certificate.equals(x500PrivateCredential.getCertificate())) continue;
                return x500PrivateCredential;
            }
            return null;
        }
        return (X500PrivateCredential)AccessController.doPrivileged(new SubjectCredentials.GetPrivateCredentialAction(subject, x509Certificate));
    }

    private AuthenticationPermission getAuthPermission(X509Certificate x509Certificate, String string, String string2) {
        Set<X500Principal> set = Collections.singleton(x509Certificate.getSubjectX500Principal());
        Set<X500Principal> set2 = string == null ? null : Collections.singleton(new X500Principal(string));
        return new AuthenticationPermission(set, set2, string2);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return null;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        Object[] objectArray = this.getAliases(string, principalArray);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "get server aliases for key type {0}\nand issuers {1}\nreturns {2}", new Object[]{string, ServerAuthManager.toString(principalArray), ServerAuthManager.toString(objectArray)});
        }
        return objectArray;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        X500PrivateCredential x500PrivateCredential = null;
        Map map = this.credentialCache;
        synchronized (map) {
            Object v = this.credentialCache.get(string);
            if (v instanceof X500PrivateCredential) {
                x500PrivateCredential = (X500PrivateCredential)v;
                try {
                    this.checkCredentials(x500PrivateCredential, null, "listen");
                }
                catch (SecurityException securityException) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        ServerAuthManager.logThrow(logger, Levels.HANDLED, ServerAuthManager.class, "chooseServerAlias", "choose server alias for key type {0}\nand issuers {1}\ncaught exception", new Object[]{string, ServerAuthManager.toString(principalArray)}, securityException);
                    }
                    x500PrivateCredential = null;
                    this.credentialCache.remove(string);
                    Enumeration<byte[]> enumeration = this.sslSessionContext.getIds();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        SSLSession sSLSession = this.sslSessionContext.getSession(enumeration.nextElement());
                        if (sSLSession == null || !string.equals(ServerAuthManager.getKeyAlgorithm(string2 = sSLSession.getCipherSuite()))) continue;
                        sSLSession.invalidate();
                    }
                }
            }
            if (x500PrivateCredential == null) {
                Exception exception = null;
                try {
                    x500PrivateCredential = this.chooseCredential(string, principalArray);
                    if (x500PrivateCredential != null) {
                        this.credentialCache.put(string, x500PrivateCredential);
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    exception = generalSecurityException;
                }
                catch (SecurityException securityException) {
                    exception = securityException;
                }
                if (exception != null) {
                    this.credentialCache.put(string, exception.getMessage());
                    return null;
                }
            }
        }
        Map map2 = map = x500PrivateCredential == null ? null : SubjectCredentials.getCertificateName(x500PrivateCredential.getCertificate());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "choose server alias for key type {0}\nissuers {1}\nreturns {2}", new Object[]{string, ServerAuthManager.toString(principalArray), map});
        }
        return map;
    }

    static {
        $assertionsDisabled = !ServerAuthManager.class.desiredAssertionStatus();
        logger = serverLogger;
    }
}

