/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import [Ljava.security.Permission;;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Permission;
import java.util.Collections;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;

public class BasicProxyPreparer
implements ProxyPreparer,
Serializable {
    private static final long serialVersionUID = 4439691869768577046L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("verify", Boolean.TYPE), new ObjectStreamField("methodConstraintsSpecified", Boolean.TYPE), new ObjectStreamField("methodConstraints", MethodConstraints.class), new ObjectStreamField("permissions", Permission;.class, true)};
    protected final boolean verify;
    protected final boolean methodConstraintsSpecified;
    protected final MethodConstraints methodConstraints;
    protected final Permission[] permissions;

    public BasicProxyPreparer() {
        this.verify = false;
        this.methodConstraintsSpecified = false;
        this.methodConstraints = null;
        this.permissions = new Permission[0];
    }

    public BasicProxyPreparer(boolean bl, Permission[] permissionArray) {
        this.verify = bl;
        this.methodConstraintsSpecified = false;
        this.methodConstraints = null;
        this.permissions = BasicProxyPreparer.checkPermissions(permissionArray);
    }

    private static Permission[] checkPermissions(Permission[] permissionArray) {
        if (permissionArray == null) {
            return new Permission[0];
        }
        permissionArray = (Permission[])permissionArray.clone();
        int n = permissionArray.length;
        while (--n >= 0) {
            if (permissionArray[n] != null) continue;
            throw new NullPointerException("Permission cannot be null");
        }
        return permissionArray;
    }

    public BasicProxyPreparer(boolean bl, MethodConstraints methodConstraints, Permission[] permissionArray) {
        this.verify = bl;
        this.methodConstraintsSpecified = true;
        this.methodConstraints = methodConstraints;
        this.permissions = BasicProxyPreparer.checkPermissions(permissionArray);
    }

    protected MethodConstraints getMethodConstraints(Object object) {
        if (this.methodConstraintsSpecified) {
            return this.methodConstraints;
        }
        if (object instanceof RemoteMethodControl) {
            return ((RemoteMethodControl)object).getConstraints();
        }
        return null;
    }

    protected Permission[] getPermissions(Object object) {
        return this.permissions;
    }

    public Object prepareProxy(Object object) throws RemoteException {
        if (object == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        this.verify(object);
        this.grant(object);
        return this.setConstraints(object);
    }

    protected void verify(Object object) throws RemoteException {
        if (object == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        if (this.verify) {
            MethodConstraints methodConstraints = this.getMethodConstraints(object);
            Security.verifyObjectTrust(object, null, methodConstraints == null ? Collections.EMPTY_SET : Collections.singleton(methodConstraints));
        }
    }

    protected void grant(Object object) {
        if (object == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        Permission[] permissionArray = this.getPermissions(object);
        if (permissionArray.length > 0) {
            try {
                Security.grant(object.getClass(), permissionArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                SecurityException securityException = new SecurityException("Dynamic permission grants are not supported");
                securityException.initCause(unsupportedOperationException);
                throw securityException;
            }
        }
    }

    protected Object setConstraints(Object object) {
        if (object == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        if (!this.methodConstraintsSpecified) {
            return object;
        }
        if (!(object instanceof RemoteMethodControl)) {
            throw new SecurityException("Proxy must implement RemoteMethodControl");
        }
        return ((RemoteMethodControl)object).setConstraints(this.getMethodConstraints(object));
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string).append('[');
        if (this.verify) {
            stringBuffer.append("verify");
        }
        if (this.methodConstraintsSpecified) {
            if (this.verify) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.methodConstraints);
        }
        if (this.permissions.length > 0) {
            if (this.verify || this.methodConstraintsSpecified) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('{');
            for (int i = 0; i < this.permissions.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.permissions[i]);
            }
            stringBuffer.append('}');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        BasicProxyPreparer basicProxyPreparer = (BasicProxyPreparer)object;
        if (this.verify != basicProxyPreparer.verify) {
            return false;
        }
        if (this.methodConstraintsSpecified != basicProxyPreparer.methodConstraintsSpecified) {
            return false;
        }
        if (this.methodConstraintsSpecified && (this.methodConstraints == null ? basicProxyPreparer.methodConstraints != null : !this.methodConstraints.equals(basicProxyPreparer.methodConstraints))) {
            return false;
        }
        if (this.permissions.length != basicProxyPreparer.permissions.length) {
            return false;
        }
        Permission[] permissionArray = (Permission[])basicProxyPreparer.permissions.clone();
        int n = this.permissions.length;
        block0: while (--n >= 0) {
            Permission permission = this.permissions[n];
            for (int i = n; i >= 0; --i) {
                if (!permission.equals(permissionArray[i])) continue;
                permissionArray[i] = permissionArray[n];
                continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().getName().hashCode();
        if (this.verify) {
            ++n;
        }
        if (this.methodConstraintsSpecified) {
            n += 65536;
            if (this.methodConstraints != null) {
                n += this.methodConstraints.hashCode();
            }
        }
        int n2 = this.permissions.length;
        while (--n2 >= 0) {
            n += this.permissions[n2].hashCode();
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.methodConstraintsSpecified && this.methodConstraints != null) {
            throw new InvalidObjectException("Method constraints not specified but not null");
        }
        if (this.permissions == null) {
            throw new InvalidObjectException("Permissions cannot be null");
        }
        int n = this.permissions.length;
        while (--n >= 0) {
            if (this.permissions[n] != null) continue;
            throw new InvalidObjectException("Permission cannot be null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Permissions must be specified");
    }
}

