/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jidesoft.swing.AutoCompletion;
import com.jidesoft.swing.ListSearchable;
import com.jidesoft.swing.Searchable;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;

public final class AutoCompletionList {
    private final MJList fList;
    private final MJTextField fTextField;
    private final MJPanel fPanel;
    private final AutoCompletion fCompletion;
    private final EventListenerList fActionListeners;
    private String fRevertSelection;

    public AutoCompletionList(List<?> list, String string) {
        Validate.notNull(list, (String)"'items' cannot be null");
        Validate.notNull((Object)string, (String)"'componentNamePefix' cannot be null");
        this.fActionListeners = new EventListenerList();
        this.fTextField = new MJTextField();
        this.fTextField.setName(string + "AutoCompletionTextField");
        this.fList = new MJList(list.toArray()){

            public void fireSelectionValueChanged(int n, int n2, boolean bl) {
                super.fireSelectionValueChanged(n, n2, bl);
            }
        };
        this.fList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AutoCompletionList.this.fTextField.requestFocus();
            }
        });
        this.fList.setFocusable(false);
        this.fList.setName(string + "AutoCompletionList");
        this.fList.setVisibleRowCount(7);
        this.fCompletion = new AutoCompletion((JTextComponent)this.fTextField, (Searchable)new ListSearchable((JList)this.fList));
        this.fTextField.getDocument().addDocumentListener(this.createDocumentListener());
        this.fTextField.setPreferredSize(new Dimension(this.fList.getPreferredSize().width, this.fTextField.getPreferredSize().height));
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AutoCompletionList.this.fRevertSelection != null) {
                    AutoCompletionList.this.fTextField.setText(AutoCompletionList.this.fRevertSelection);
                }
            }
        });
        this.fPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fPanel.add((Component)this.fTextField, (Object)"North");
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fList);
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setViewportBorder(BorderFactory.createLineBorder(this.fList.getBackground(), 4));
        this.fPanel.add((Component)mJScrollPane, (Object)"Center");
    }

    public void setVisibleRowCount(int n) {
        this.fList.setVisibleRowCount(n);
    }

    public void setStrict(boolean bl) {
        this.fCompletion.setStrict(bl);
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public void setSelectedValue(String string) {
        this.fTextField.setText(string);
    }

    public String getSelectedValue() {
        return this.fTextField.getText();
    }

    public void addActionListener(ActionListener actionListener) {
        this.fActionListeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fActionListeners.remove(ActionListener.class, actionListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fTextField.addFocusListener(focusListener);
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AutoCompletionList.this.notifyActionListeners();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AutoCompletionList.this.notifyActionListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AutoCompletionList.this.notifyActionListeners();
            }
        };
    }

    private void notifyActionListeners() {
        ActionListener[] actionListenerArray;
        ActionEvent actionEvent = new ActionEvent(this.fTextField, 900, this.fTextField.getText());
        for (ActionListener actionListener : actionListenerArray = (ActionListener[])this.fActionListeners.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void setRevertOnFocusLost(String string) {
        this.fRevertSelection = string;
    }

    static {
        MJUtilities.initJIDE();
    }
}

