/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FormPanel
extends MJPanel {
    public static final int STRETCH_NONE = 0;
    public static final int STRETCH_HORIZONTAL = 1;
    public static final int STRETCH_VERTICAL = 2;
    public static final int STRETCH_BOTH = 3;
    public static final int DEFAULT_VERTICAL_SPACE = 5;
    public static final int DEFAULT_HORIZONTAL_SPACE = 5;
    private int fVerticalSpace;
    private int fHorizontalSpace;
    private boolean fIsRightAligned;
    private int fRowCounter;
    private int fColCounter;
    private GridBagConstraints fLabelGBC;
    private GridBagConstraints fCtrlGBC;
    private MJLabel fRightSpacer;
    private MJLabel fBottomSpacer;
    private boolean fNeedsRightSpacer;
    private boolean fNeedsBottomSpacer;
    private GridBagConstraints fRightSpacerGBC;
    private GridBagConstraints fBottomSpacerGBC;

    public FormPanel() {
        super((LayoutManager)new GridBagLayout());
        this.setupGBCs();
        this.fRowCounter = 0;
        this.fColCounter = 0;
        this.fRightSpacer = new MJLabel("");
        this.fBottomSpacer = new MJLabel("");
        this.fNeedsRightSpacer = true;
        this.fNeedsBottomSpacer = true;
        this.setVerticalSpace(5);
        this.setHorizontalSpace(5);
        this.setRightAligned(true);
    }

    private void setupGBCs() {
        this.fLabelGBC = new GridBagConstraints();
        this.fLabelGBC.anchor = 18;
        this.fLabelGBC.fill = 0;
        this.fLabelGBC.weightx = 0.0;
        this.fLabelGBC.gridwidth = 1;
        this.fCtrlGBC = new GridBagConstraints();
        this.fCtrlGBC.anchor = 18;
        this.fCtrlGBC.gridwidth = 1;
        this.fCtrlGBC.gridx = 1;
        this.fRightSpacerGBC = new GridBagConstraints();
        this.fRightSpacerGBC.fill = 2;
        this.fRightSpacerGBC.weightx = 1.0;
        this.fBottomSpacerGBC = new GridBagConstraints();
        this.fBottomSpacerGBC.fill = 3;
        this.fBottomSpacerGBC.weighty = 1.0;
    }

    public void addRow(String string, JComponent jComponent) {
        this.addRow((JLabel)new MJLabel(string), jComponent);
    }

    public void addRow(JLabel jLabel, JComponent jComponent) {
        this.addRow(jLabel, jComponent, 1);
    }

    public void addRow(String string, JComponent jComponent, int n) {
        this.addRow((JLabel)new MJLabel(string), jComponent, n);
    }

    public void addRow(final JLabel jLabel, final JComponent jComponent, final int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormPanel.this.addRowInternal(jLabel, jComponent, n);
                }
            });
        } else {
            this.addRowInternal(jLabel, jComponent, n);
        }
    }

    private void addRowInternal(JLabel jLabel, JComponent jComponent, int n) {
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
        this.remove((Component)this.fRightSpacer);
        this.remove((Component)this.fBottomSpacer);
        switch (n) {
            case 1: {
                this.fCtrlGBC.fill = 2;
                this.fCtrlGBC.weightx = 1.0;
                this.fCtrlGBC.weighty = 0.0;
                this.fNeedsRightSpacer = false;
                break;
            }
            case 2: {
                this.fCtrlGBC.fill = 3;
                this.fCtrlGBC.weightx = 0.0;
                this.fCtrlGBC.weighty = 1.0;
                this.fNeedsBottomSpacer = false;
                break;
            }
            case 3: {
                this.fCtrlGBC.fill = 1;
                this.fCtrlGBC.weightx = 1.0;
                this.fCtrlGBC.weighty = 1.0;
                this.fNeedsRightSpacer = false;
                this.fNeedsBottomSpacer = false;
                break;
            }
            default: {
                this.fCtrlGBC.fill = 0;
                this.fCtrlGBC.weightx = 0.0;
                this.fCtrlGBC.weighty = 0.0;
            }
        }
        this.fLabelGBC.gridx = this.fColCounter * 2;
        this.fLabelGBC.gridy = this.fRowCounter;
        this.fCtrlGBC.gridx = this.fLabelGBC.gridx + 1;
        this.fCtrlGBC.gridy = this.fRowCounter;
        if (this.fCtrlGBC.gridy == 0) {
            Insets insets = this.fCtrlGBC.insets;
            this.fCtrlGBC.insets = new Insets(insets.top - this.fVerticalSpace, insets.left, insets.bottom, insets.right);
            this.add(jComponent, this.fCtrlGBC);
            this.fCtrlGBC.insets = insets;
            Insets insets2 = this.fLabelGBC.insets;
            this.fLabelGBC.insets = new Insets(insets2.top - this.fVerticalSpace, insets2.left, insets2.bottom, insets2.right);
            this.add(jLabel, this.fLabelGBC);
            this.fLabelGBC.insets = insets2;
        } else {
            this.add(jComponent, this.fCtrlGBC);
            this.add(jLabel, this.fLabelGBC);
        }
        if (this.fNeedsRightSpacer) {
            this.fRightSpacerGBC.gridx = this.fCtrlGBC.gridx + 1;
            this.fRightSpacerGBC.gridy = 0;
            this.add((Component)this.fRightSpacer, this.fRightSpacerGBC);
        }
        if (this.fNeedsBottomSpacer) {
            this.fBottomSpacerGBC.gridx = this.fLabelGBC.gridx;
            this.fBottomSpacerGBC.gridy = this.fRowCounter + 1;
            this.add((Component)this.fBottomSpacer, this.fBottomSpacerGBC);
        }
        ++this.fRowCounter;
    }

    public int getVerticalSpace() {
        return this.fVerticalSpace;
    }

    public void setVerticalSpace(int n) {
        this.fVerticalSpace = n;
        this.fCtrlGBC.insets = new Insets(this.fVerticalSpace, 0, 0, 0);
        this.resetLabelInsets();
    }

    public int getHorizontalSpace() {
        return this.fHorizontalSpace;
    }

    public void setHorizontalSpace(int n) {
        this.fHorizontalSpace = n;
        this.resetLabelInsets();
    }

    private void resetLabelInsets() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getID();
        int n = string.equals("Windows") ? 2 : (string.equals("Aqua") ? 3 : 2);
        this.fLabelGBC.insets = new Insets(n + this.fVerticalSpace, 0, 0, this.fHorizontalSpace);
    }

    public boolean isRightAligned() {
        return this.fIsRightAligned;
    }

    public void setRightAligned(boolean bl) {
        this.fIsRightAligned = bl;
        this.fLabelGBC.anchor = bl ? 12 : 18;
        this.invalidate();
    }
}

