/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.JEditorPaneHyperlinkHandler;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.text.TextUtils;
import com.mathworks.util.HTMLUtils;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.commons.lang.Validate;

public class HyperlinkTextLabel
implements ComponentBuilder {
    private final JEditorPane fTextPane = this.makeEditorPane();
    private final JScrollPane fTextScrollPane = this.makeScrollPane(this.fTextPane);
    private HyperlinkListener fHyperlinkListener;
    private HyperlinkHandler fHyperlinkHandler;
    private HyperlinkStatusBarHandler fStatusBarHandler;
    private Color fHyperlinkColor;
    private Element fLastHyperlinkElementEntered;
    private JEditorPaneHyperlinkHandler fJEditorPaneHyperlinkHandler;

    protected JEditorPane makeEditorPane() {
        return new MJEditorPane();
    }

    protected JScrollPane makeScrollPane(JComponent jComponent) {
        return new MJScrollPane(jComponent){

            public void addNotify() {
                super.addNotify();
                HyperlinkTextLabel.this.fJEditorPaneHyperlinkHandler.addListeners();
            }
        };
    }

    public HyperlinkTextLabel() {
        this("");
    }

    public HyperlinkTextLabel(String string) {
        this(string, null);
    }

    public HyperlinkTextLabel(String string, HyperlinkHandler hyperlinkHandler) {
        this(string, hyperlinkHandler, false);
    }

    public HyperlinkTextLabel(String string, HyperlinkHandler hyperlinkHandler, boolean bl) {
        this(string, hyperlinkHandler, bl, "", "");
    }

    public HyperlinkTextLabel(String string, HyperlinkHandler hyperlinkHandler, boolean bl, String string2, String string3) {
        this.initComponent();
        if (!bl) {
            this.disableContextMenu();
        }
        this.initListeners();
        this.setText(string);
        this.setFontColor(UIManager.getColor("Label.foreground"));
        this.setHyperlinkHandler(hyperlinkHandler);
        this.fTextPane.setName(string2);
        this.setAccessibleName(string3);
        this.fTextPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getID() == 1400) {
                    HyperlinkTextLabel.this.setHyperlinkColorToContrasting();
                }
            }
        });
    }

    public void setAccessibleName(String string) {
        this.fTextPane.getAccessibleContext().setAccessibleName(string);
    }

    private void initListeners() {
        this.fHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                HyperlinkTextLabel.this.processHyperlink(hyperlinkEvent);
            }
        };
        this.fTextPane.addHyperlinkListener(this.fHyperlinkListener);
        this.fTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                HyperlinkTextLabel.this.removeHyperlinkHighlight();
                HyperlinkTextLabel.this.setStatusBarText(null);
            }
        });
        this.fTextPane.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2;
                HTMLDocument hTMLDocument;
                Element element;
                String string = null;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n = HyperlinkTextLabel.this.fTextPane.viewToModel(point);
                if (n >= 0 && (element = (hTMLDocument = (HTMLDocument)HyperlinkTextLabel.this.fTextPane.getDocument()).getCharacterElement(n)) != null && (attributeSet2 = (AttributeSet)(attributeSet = element.getAttributes()).getAttribute(HTML.Tag.A)) != null) {
                    HyperlinkTextLabel.this.highlightHyperlink(element);
                    string = (String)attributeSet2.getAttribute(HTML.getAttributeKey("href"));
                }
                HyperlinkTextLabel.this.setStatusBarText(string);
            }
        });
        this.fJEditorPaneHyperlinkHandler = new JEditorPaneHyperlinkHandler(this.fTextPane);
    }

    private void setStatusBarText(String string) {
        if (this.fStatusBarHandler != null) {
            this.fStatusBarHandler.hoveredOverLink(string);
        }
    }

    public void processHyperlink(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (this.fHyperlinkHandler != null && this.fTextPane.isEnabled()) {
                this.fHyperlinkHandler.processHyperlink(hyperlinkEvent.getDescription());
                this.removeHyperlinkHighlight();
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.removeHyperlinkHighlight();
        }
    }

    private void removeHyperlinkHighlight() {
        if (this.fLastHyperlinkElementEntered != null) {
            this.changeColor(this.fLastHyperlinkElementEntered, this.getHyperlinkColor());
            this.fLastHyperlinkElementEntered = null;
        }
    }

    private void highlightHyperlink(Element element) {
        if (!element.equals(this.fLastHyperlinkElementEntered)) {
            this.removeHyperlinkHighlight();
            this.fLastHyperlinkElementEntered = element;
            this.changeColor(element, ColorUtils.HYPERLINK_HOVER_COLOR);
        }
    }

    private void changeColor(Element element, Color color) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.fTextPane.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        StyleSheet styleSheet = hTMLDocument.getStyleSheet();
        Style style = styleSheet.addStyle("HighlightedHyperlink", null);
        style.addAttribute(StyleConstants.Foreground, color);
        hTMLDocument.setCharacterAttributes(n, n2 - n, style, false);
    }

    public void cleanup() {
        this.fTextPane.removeHyperlinkListener(this.fHyperlinkListener);
    }

    private void initComponent() {
        this.fTextPane.setContentType(new HTMLEditorKit().getContentType());
        this.fTextPane.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        this.setFont(font);
        this.fTextPane.setOpaque(false);
        this.fTextPane.setMargin(new Insets(1, 1, 1, 1));
        this.fTextScrollPane.setOpaque(false);
        this.fTextScrollPane.getViewport().setOpaque(false);
        this.fTextScrollPane.setBorder(null);
        this.fTextScrollPane.putClientProperty("mwjavaguitest.instance", this);
    }

    public void setFont(Font font) {
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.fTextPane.getDocument()).getStyleSheet().addRule(string);
    }

    public void addRule(String string, String string2, String string3) {
        String string4 = string + " { " + string2 + " : " + string3 + "; }";
        ((HTMLDocument)this.fTextPane.getDocument()).getStyleSheet().addRule(string4);
    }

    @Override
    public JComponent getComponent() {
        return this.fTextScrollPane;
    }

    public void setText(String string) {
        this.fTextPane.setText(string);
        this.scrollToTop();
    }

    @Deprecated
    public void setHyperlinkHandler(HyperlinkHandler hyperlinkHandler) {
        this.fHyperlinkHandler = hyperlinkHandler;
    }

    public String getText() {
        return this.fTextPane.getText();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.fTextPane.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.fTextPane.removeMouseListener(mouseListener);
    }

    public void setRowCount(int n) {
        FontMetrics fontMetrics = this.fTextPane.getFontMetrics(this.fTextPane.getFont());
        int n2 = fontMetrics.getHeight() * n;
        this.constrainSize(this.fTextPane.getWidth(), n2 += this.fTextPane.getBorder().getBorderInsets((Component)this.fTextPane).top * 2);
    }

    public void scrollToTop() {
        this.fTextPane.setCaretPosition(0);
    }

    public void setBackgroundColor(Color color) {
        this.fTextPane.setOpaque(true);
        this.fTextPane.setBackground(color);
        this.setHyperlinkColorToContrasting();
    }

    @Deprecated
    public void setOpaque(boolean bl) {
        this.fTextPane.setOpaque(bl);
        this.setHyperlinkColorToContrasting();
    }

    public void setMargin(Insets insets) {
        this.fTextPane.setMargin(insets);
    }

    public Insets getMargin() {
        return this.fTextPane.getMargin();
    }

    public void setEnabled(boolean bl) {
        this.fTextPane.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.fTextPane.isEnabled();
    }

    public void setFontColor(Color color) {
        this.addRule("body", "color", HTMLUtils.convertColorToHex((Color)color));
    }

    public void setHyperlinkColor(Color color) {
        this.fHyperlinkColor = color;
    }

    public Color getHyperlinkColor() {
        return this.fHyperlinkColor != null ? this.fHyperlinkColor : ColorUtils.getContrastingHyperlinkColor((Color)ComponentUtils.getActualBackgroundColor((Component)this.fTextPane));
    }

    public void resetHyperlinkColorToDefault() {
        this.fHyperlinkColor = null;
        this.setHyperlinkColorToContrasting();
    }

    private void setHyperlinkColorToContrasting() {
        Color color = this.getHyperlinkColor();
        this.addRule("a", "color", HTMLUtils.convertColorToHex((Color)color));
    }

    private void disableContextMenu() {
        this.fTextPane.setInheritsPopupMenu(false);
        this.fTextPane.setComponentPopupMenu(null);
        ((MJEditorPane)this.fTextPane).addContextMenu(null);
    }

    public void constrainSize(int n, int n2) {
        this.fTextPane.setSize(n, this.fTextPane.getPreferredSize().height);
        Insets insets = this.fTextScrollPane.getInsets();
        int n3 = this.fTextScrollPane.getViewport().getPreferredSize().height + insets.top + insets.bottom;
        int n4 = Math.min(n2, n3);
        this.fTextScrollPane.setPreferredSize(new Dimension(n, n4));
    }

    public void setStatusBarHandler(HyperlinkStatusBarHandler hyperlinkStatusBarHandler) {
        this.fStatusBarHandler = hyperlinkStatusBarHandler;
    }

    public JTextComponent getHTMLPane() {
        return this.fTextPane;
    }

    public JScrollPane getScrollPane() {
        return this.fTextScrollPane;
    }

    public List<Rectangle> getHotSpots() {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        if (!this.fTextPane.isVisible()) {
            throw new IllegalStateException("HyperlinkTextLabel must be visible to query the hot spots");
        }
        HTMLDocument hTMLDocument = (HTMLDocument)this.fTextPane.getDocument();
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        while (iterator.isValid()) {
            arrayList.add(this.getRectangleForATagIteration(iterator));
            iterator.next();
        }
        return arrayList;
    }

    private Rectangle getRectangleForATagIteration(HTMLDocument.Iterator iterator) {
        Rectangle rectangle = null;
        int n = iterator.getStartOffset();
        int n2 = iterator.getEndOffset();
        try {
            Rectangle rectangle2 = this.fTextPane.modelToView(n);
            Rectangle rectangle3 = this.fTextPane.modelToView(n2);
            if (rectangle2.y != rectangle3.y) {
                int[] nArray = TextUtils.getLineStartAndEnd((JTextComponent)this.fTextPane, (int)n);
                rectangle3 = this.fTextPane.modelToView(nArray[1]);
            }
            rectangle = rectangle2.union(rectangle3);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return rectangle;
    }

    public Rectangle getHotSpotForLink(String string) {
        Validate.notNull((Object)string);
        if (!this.fTextPane.isVisible()) {
            throw new IllegalStateException("HyperlinkTextLabel must be visible to query the hot spots");
        }
        HTMLDocument hTMLDocument = (HTMLDocument)this.fTextPane.getDocument();
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        while (iterator.isValid()) {
            String string2 = (String)iterator.getAttributes().getAttribute(HTML.getAttributeKey("id"));
            if (string2 != null && string2.equals(string)) {
                return this.getRectangleForATagIteration(iterator);
            }
            iterator.next();
        }
        return null;
    }

    public String getHrefForId(String string) {
        Validate.notNull((Object)string);
        HTMLDocument hTMLDocument = (HTMLDocument)this.fTextPane.getDocument();
        HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
        while (iterator.isValid()) {
            String string2 = (String)iterator.getAttributes().getAttribute(HTML.getAttributeKey("id"));
            if (string2 != null && string2.equals(string)) {
                return (String)iterator.getAttributes().getAttribute(HTML.getAttributeKey("href"));
            }
            iterator.next();
        }
        return null;
    }

    public String getLinkTextForId(String string) {
        System.out.println(this.fTextPane.getText());
        String string2 = "(?<=id=\\\"" + string + "\\\"[^>]{0,1000}?>)(.*)(?=</a>)";
        int[] nArray = StringUtils.findPattern((String)string2, (int)0, (CharSequence)this.fTextPane.getText());
        String string3 = null;
        if (nArray[0] != -1 && nArray[1] != -1) {
            string3 = this.fTextPane.getText().substring(nArray[0], nArray[1]);
        }
        return string3;
    }

    public static interface HyperlinkStatusBarHandler {
        public void hoveredOverLink(String var1);
    }

    public static interface HyperlinkHandler {
        public void processHyperlink(String var1);
    }
}

