/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.SyntaxHighlightingUtils;
import com.mathworks.widgets.TextPrintPanel;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.MethodStyle;
import com.mathworks.widgets.text.cplusplus.CAndCPlusPlusSyntaxHighlighting;
import com.mathworks.widgets.text.cplusplus.CCKit;
import com.mathworks.widgets.text.java.JavaKit;
import com.mathworks.widgets.text.java.JavaSyntaxHighlighting;
import com.mathworks.widgets.text.matlab.MatlabFunctionIndentingScheme;
import com.mathworks.widgets.text.mcode.MFoldType;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import com.mathworks.widgets.text.xml.XMLKit;
import com.mathworks.widgets.text.xml.XMLSyntaxHighlighting;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.text.EditorKit;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsAdapter;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;

public class STPPrefsManager {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");
    private static STPPrefsManager sInstance;
    private static final String PREF_FOLD_ENABLE = "Editorcode-folding-enable";
    private Map<String, List<Class>> fMimeTypeKitClassMap = new HashMap<String, List<Class>>();
    private static final PrintColoringEvaluator PRINT_COLORING_EVALUATOR;

    /*
     * WARNING - void declaration
     */
    private STPPrefsManager() {
        Object object;
        try {
            void var5_9;
            Method[] objectArray;
            object = EditorPrefsAccessor.class;
            Method[] methodArray = objectArray = ((Class)object).getMethods();
            int n = methodArray.length;
            boolean method = false;
            while (var5_9 < n) {
                Method method2 = methodArray[var5_9];
                Class<?>[] classArray = method2.getParameterTypes();
                if (classArray.length == 0 && method2.toString().indexOf("com.mathworks.widgets.text") > 0) {
                    method2.invoke(null, null);
                }
                ++var5_9;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new STPPrefsListener();
        EditorPreferences.listenToSyntaxHighlightingPreferences((PrefListener)object);
        Prefs.addListener((PrefListener)object, (String)"EditorShowLineNumbers");
        Prefs.addListener((PrefListener)object, (String)"EditorSpacesPerTab");
        Prefs.addListener((PrefListener)object, (String)"EditorSpacesPerIndent");
        Prefs.addListener((PrefListener)object, (String)"EditorMFunctionIndentType");
        Prefs.addListener((PrefListener)object, (String)"EditorTabToSpaces");
        Prefs.addListener((PrefListener)object, (String)"EditorEmacsTab");
        KeyboardPrefs.registerForDelimMatchingPrefs((PrefListener)object);
        EditorPreferences.listenToIndentingPreferences((PrefListener)object);
        JavaSyntaxHighlighting.listenToJavaMethodTypePreference((PrefListener)object);
        Prefs.addListener((PrefListener)object, (String)"EditorRightTextLineLimit");
        Prefs.addListener((PrefListener)object, (String)"EditorRightTextLineVisible");
        Prefs.addListener((PrefListener)object, (String)"EditorRightTextLimitLineWidth");
        Prefs.addListener((PrefListener)object, (String)"EditorRightTextLimitLineColor");
        Prefs.addListener((PrefListener)object, (String)"EditorPrintOptions");
        Prefs.addListener((PrefListener)object, (String)"EditorTextFont");
        Prefs.addListener((PrefListener)object, (String)"Editorhighlight-lines");
        Prefs.addListener((PrefListener)object, (String)"Editorhighlight-caret-row-boolean");
        Prefs.addListener((PrefListener)object, (String)"Editorhighlight-caret-row-boolean-color");
        Prefs.addListener((PrefListener)object, (String)"Editormlint-display");
        Prefs.addListener((PrefListener)object, (String)"Editormlint-underlining");
        Prefs.addListener((PrefListener)object, (String)PREF_FOLD_ENABLE);
        for (MFoldType mFoldType : MFoldType.values()) {
            Prefs.addListener((PrefListener)object, (String)mFoldType.getFoldEnabledPrefKey());
            Prefs.addListener((PrefListener)object, (String)mFoldType.getFoldedUponOpenPrefKey());
        }
        FontPrefs.addFontListener((String)BUNDLE.getString("editor.name"), (FontListener)object);
        ColorPrefs.addColorListener((String)"Colors_M_", (PrefListener)object);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)object);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)object);
        Prefs.addListener((PrefListener)object, (String)"Editor.VariableHighlighting.Color");
        Prefs.addListener((PrefListener)object, (String)"Editor.VariableHighlighting.Automatic");
        Prefs.addListener((PrefListener)object, (String)"Editor.NonlocalVariableHighlighting.TextColor");
        Prefs.addListener((PrefListener)object, (String)"Editor.NonlocalVariableHighlighting");
    }

    public static synchronized STPPrefsManager getInstance() {
        if (sInstance == null) {
            sInstance = new STPPrefsManager();
        }
        return sInstance;
    }

    public void registerCodeFoldExtKitClass(String string, Class clazz) {
        if (string != null && clazz != null) {
            List<Class> list = this.fMimeTypeKitClassMap.get(string);
            if (list == null) {
                list = new ArrayList<Class>();
                this.fMimeTypeKitClassMap.put(string, list);
            }
            if (!list.contains(clazz)) {
                list.add(clazz);
            }
        }
    }

    public void setSyntaxHighlightingEnabled(EditorLanguage editorLanguage, Class<? extends EditorKit> clazz, boolean bl) {
        Validate.notNull((Object)editorLanguage, (String)"'language' cannot be null");
        Validate.notNull(clazz, (String)"'editorKitClass' cannot be null");
        EditorSyntaxHighlighting editorSyntaxHighlighting = SyntaxHighlightingUtils.findSyntaxHighlighting(editorLanguage);
        Validate.notNull((Object)editorSyntaxHighlighting, (String)("Language " + editorLanguage + " doesn't have associated syntax highlighting information"));
        for (SyntaxHighlightingColor syntaxHighlightingColor : editorSyntaxHighlighting.getColors()) {
            this.setSyntaxColor(syntaxHighlightingColor, syntaxHighlightingColor.getCurrentColor(), clazz, bl, editorSyntaxHighlighting.getTokenContext());
        }
    }

    void setSyntaxColor(SyntaxHighlightingColor syntaxHighlightingColor, Color color, Class clazz, boolean bl, TokenContext tokenContext) {
        assert (syntaxHighlightingColor != null) : "'color' cannot be null";
        assert (color != null) : "'newColor' cannot be null";
        assert (clazz != null) : "'kitClass' cannot be null";
        assert (tokenContext != null) : "'context' cannot be null";
        Coloring coloring = null;
        TokenContextPath[] tokenContextPathArray = tokenContext.getAllContextPaths();
        if (!bl) {
            coloring = new Coloring(null, null, null);
        }
        boolean bl2 = false;
        for (TokenContextPath tokenContextPath : tokenContextPathArray) {
            for (String string : syntaxHighlightingColor.getAllTokenNames()) {
                String string2 = tokenContextPath.getFullTokenName(string);
                Coloring coloring2 = (Coloring)SettingsUtil.getColoring((Class)clazz, (String)string2, (boolean)bl2, (boolean)true);
                if (coloring2 == null) continue;
                if (bl) {
                    coloring = Coloring.changeForeColor((Coloring)coloring2, (Color)color);
                }
                SettingsAdapter.setColoring((Object)this, (Class)clazz, (String)string2, (Object)coloring, (Object)PRINT_COLORING_EVALUATOR);
            }
        }
    }

    private void setMethodColoring(String string, Coloring coloring, Class<?> clazz, TokenContext tokenContext) {
        TokenContextPath[] tokenContextPathArray;
        for (TokenContextPath tokenContextPath : tokenContextPathArray = tokenContext.getAllContextPaths()) {
            String string2 = tokenContextPath.getFullTokenName(string);
            Coloring coloring2 = (Coloring)SettingsUtil.getColoring(clazz, (String)string2, (boolean)false, (boolean)true);
            if (coloring2 == null) continue;
            SettingsAdapter.setColoring((Object)this, clazz, (String)string2, (Object)coloring, (Object)PRINT_COLORING_EVALUATOR);
        }
    }

    protected void setJavaMethodType(MethodStyle methodStyle, Class<?> clazz) {
        if (methodStyle == null) {
            throw new IllegalArgumentException("'style' cannot be null");
        }
        this.setMethodColoring(JavaLayerTokenContext.METHOD.getName(), methodStyle.getColoring(), clazz, (TokenContext)JavaLayerTokenContext.context);
    }

    public Coloring getJavaMethodStyle(Class<?> clazz) {
        return STPPrefsManager.getMethodColoring(JavaLayerTokenContext.METHOD.getName(), clazz, (TokenContext)JavaLayerTokenContext.context);
    }

    private static Coloring getMethodColoring(String string, Class<?> clazz, TokenContext tokenContext) {
        TokenContextPath[] tokenContextPathArray;
        for (TokenContextPath tokenContextPath : tokenContextPathArray = tokenContext.getAllContextPaths()) {
            String string2 = tokenContextPath.getFullTokenName(string);
            Coloring coloring = (Coloring)SettingsUtil.getColoring(clazz, (String)string2, (boolean)false, (boolean)true);
            if (coloring == null) continue;
            return coloring;
        }
        return null;
    }

    protected void handleDefaultTextColorChange(boolean bl) {
        Coloring coloring;
        Coloring coloring2;
        String string = "default";
        Coloring coloring3 = SettingsUtil.getColoring(MWKit.class, (String)string, (boolean)false);
        Coloring coloring4 = SettingsUtil.getColoring(MWKit.class, (String)string, (boolean)true);
        if (bl) {
            coloring2 = Coloring.changeBackColor((Coloring)coloring3, (Color)ColorPrefs.getBackgroundColor());
            coloring = Coloring.changeBackColor((Coloring)coloring4, (Color)ColorPrefs.getBackgroundColor());
        } else {
            coloring2 = Coloring.changeForeColor((Coloring)coloring3, (Color)EditorPrefsAccessor.getTextColor());
            coloring = Coloring.changeForeColor((Coloring)coloring4, (Color)ColorPrefs.getTextColor());
        }
        coloring = STPPrefsManager.computePrintingColoring(coloring, coloring.getFont());
        if (!bl) {
            SettingsAdapter.setValue((Object)this, MWKit.class, (String)"caret-color-overwrite-mode", (Object)coloring2.getForeColor());
            SettingsAdapter.setValue((Object)this, MWKit.class, (String)"caret-color-insert-mode", (Object)coloring2.getForeColor());
        }
        this.setDefaultTextPrefColoring(coloring2, coloring);
    }

    private void setDefaultTextPrefColoring(Coloring coloring, Coloring coloring2) {
        this.setPrefColoring("default", coloring, coloring2, MWKit.class);
    }

    private void setPrefColoring(String string, Coloring coloring, Coloring coloring2, Class clazz) {
        SettingsAdapter.setColoring((Object)this, (Class)clazz, (String)string, (Object)coloring, (Object)coloring2);
    }

    private void setPrefValue(String string, Object object) {
        this.setPrefValue(string, object, MWKit.class);
    }

    private void setPrefValue(String string, Object object, Class clazz) {
        SettingsAdapter.setValue((Object)this, (Class)clazz, (String)string, (Object)object);
    }

    public void updatePrintOptions(int n, String string, Font font) {
        if (string.equals("EditorPrintOptions")) {
            PrintColoringEvaluator.printOptionsChanged(n);
        }
        Coloring coloring = STPPrefsManager.computePrintingColoring(SettingsUtil.getColoring(MWKit.class, (String)"default", (boolean)true), font);
        Coloring coloring2 = SettingsUtil.getColoring(MWKit.class, (String)"default", (boolean)false);
        this.setDefaultTextPrefColoring(coloring2, coloring);
    }

    public static Coloring computePrintingColoring(Coloring coloring, Font font) {
        Coloring coloring2 = Coloring.changeFont((Coloring)coloring, (Font)font);
        if (Color.white.equals(coloring2.getForeColor())) {
            coloring2 = Coloring.changeForeColor((Coloring)coloring2, (Color)Color.black);
        }
        return coloring2;
    }

    private void updateSyntaxHighlightColors(EditorSyntaxHighlighting editorSyntaxHighlighting) {
        Validate.notNull((Object)editorSyntaxHighlighting, (String)"'highlighting' cannot be null");
        boolean bl = EditorPreferences.isSyntaxHighlightingEnabled(editorSyntaxHighlighting);
        for (SyntaxHighlightingColor syntaxHighlightingColor : editorSyntaxHighlighting.getColors()) {
            this.setSyntaxColor(syntaxHighlightingColor, syntaxHighlightingColor.getCurrentColor(), editorSyntaxHighlighting.getBaseKitClass(), bl, editorSyntaxHighlighting.getTokenContext());
        }
    }

    private void updateDelimMatchingOptions() {
        this.setPrefValue("mw-highlight-match-brace", EditorPrefsAccessor.isDelimMatchingWhileTyping());
        this.setPrefValue("mw-highlight-match-brace-on-arrow", EditorPrefsAccessor.isDelimMatchingWhileMousing());
        this.setPrefValue("mw-bracematch-key", EditorPrefsAccessor.getDelimMatchTypeWhileTyping());
        this.setPrefValue("mw-bracematch-arrow", EditorPrefsAccessor.getDelimMatchTypeWhileMousing());
        this.setPrefValue("mw-bracemismatch-key", EditorPrefsAccessor.getDelimMismatchTypeWhileTyping());
        this.setPrefValue("mw-bracemismatch-arrow", EditorPrefsAccessor.getDelimMismatchTypeWhileMousing());
    }

    public static Settings.Evaluator getPrintColoringEvaluator() {
        return PRINT_COLORING_EVALUATOR;
    }

    static {
        STPPrefsManager.getInstance();
        PRINT_COLORING_EVALUATOR = new PrintColoringEvaluator();
    }

    private static class PrintColoringEvaluator
    implements Settings.Evaluator {
        private static int sPrintOptions = EditorPrefsAccessor.getPrintOptions();

        private PrintColoringEvaluator() {
        }

        private static void printOptionsChanged(int n) {
            if (TextPrintPanel.isStylized(n) != TextPrintPanel.isStylized(sPrintOptions)) {
                sPrintOptions = n;
            } else if (TextPrintPanel.isColored(n) != TextPrintPanel.isColored(sPrintOptions)) {
                sPrintOptions = n;
            }
        }

        private static Coloring getPrintColoring(Class clazz, String string, Coloring coloring) {
            Coloring coloring2 = coloring;
            if (coloring2 != null) {
                Coloring coloring3 = SettingsUtil.getColoring((Class)clazz, (String)"default", (boolean)true);
                Font font = coloring3.getFont();
                Color color = coloring3.getForeColor();
                if (coloring2.getFont() != null) {
                    int n = coloring2.getFontMode();
                    if ((n & 1) != 0) {
                        font = new Font(coloring2.getFont().getName(), font.getStyle(), font.getSize());
                    }
                    if ((n & 2) != 0) {
                        font = font.deriveFont(coloring2.getFont().getStyle());
                    }
                    if ((n & 4) != 0) {
                        font = font.deriveFont(coloring2.getFont().getSize2D());
                    }
                }
                coloring2 = Coloring.changeFont((Coloring)coloring2, (Font)font);
                if (!TextPrintPanel.isColored(sPrintOptions)) {
                    coloring2 = Coloring.changeFont((Coloring)coloring2, (Font)font.deriveFont(0));
                    coloring2 = Coloring.changeBackColor((Coloring)coloring2, (Color)Color.white);
                    coloring2 = Coloring.changeForeColor((Coloring)coloring2, (Color)Color.black);
                    if (TextPrintPanel.isStylized(sPrintOptions)) {
                        if (PrintColoringEvaluator.isCommentColor(clazz, string)) {
                            coloring2 = Coloring.changeFont((Coloring)coloring2, (Font)font.deriveFont(2));
                        } else if (PrintColoringEvaluator.isKeywordColor(clazz, string)) {
                            coloring2 = Coloring.changeFont((Coloring)coloring2, (Font)font.deriveFont(1));
                        }
                    }
                } else if (coloring2.getForeColor() == null && Color.white.equals(color) || coloring2.getForeColor() != null && Color.white.equals(coloring2.getForeColor())) {
                    coloring2 = Coloring.changeForeColor((Coloring)coloring2, (Color)Color.black);
                }
            }
            return coloring2;
        }

        private static boolean isCommentColor(Class clazz, String string) {
            if (MKit.class.isAssignableFrom(clazz) && string.endsWith(ColorPrefs.MatlabColor.COMMENT.getKey())) {
                return true;
            }
            if (JavaKit.class.isAssignableFrom(clazz) && string.endsWith(JavaSyntaxHighlighting.COMMENT.getTokenName())) {
                return true;
            }
            if (CCKit.class.isAssignableFrom(clazz) && string.endsWith(CAndCPlusPlusSyntaxHighlighting.COMMENT.getTokenName())) {
                return true;
            }
            return XMLKit.class.isAssignableFrom(clazz) && string.endsWith(XMLSyntaxHighlighting.BLOCK_COMMENT.getTokenName());
        }

        private static boolean isKeywordColor(Class clazz, String string) {
            if (MKit.class.isAssignableFrom(clazz) && string.endsWith(ColorPrefs.MatlabColor.KEYWORD.getKey())) {
                return true;
            }
            if (JavaKit.class.isAssignableFrom(clazz) && string.endsWith(JavaSyntaxHighlighting.KEYWORD.getTokenName())) {
                return true;
            }
            if (CCKit.class.isAssignableFrom(clazz) && string.endsWith(CAndCPlusPlusSyntaxHighlighting.KEYWORD.getTokenName())) {
                return true;
            }
            return XMLKit.class.isAssignableFrom(clazz) && string.endsWith(XMLSyntaxHighlighting.TAG.getTokenName());
        }

        public Object getValue(Class clazz, String string) {
            if (string.endsWith("-print-coloring")) {
                String string2 = string.substring(0, string.length() - "-print-coloring".length());
                Coloring coloring = SettingsUtil.getColoring((Class)clazz, (String)string2, (boolean)false);
                return PrintColoringEvaluator.getPrintColoring(clazz, string2, coloring);
            }
            return null;
        }
    }

    private class STPPrefsListener
    implements PrefListener,
    FontListener {
        STPPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            Object object;
            String string = prefEvent.getPrefKey();
            for (EditorSyntaxHighlighting editorSyntaxHighlighting : SyntaxHighlightingUtils.getAllSyntaxHighlightings()) {
                if (!EditorPreferences.isSyntaxHighlightingPreference(editorSyntaxHighlighting.getLanguage(), string)) continue;
                STPPrefsManager.this.updateSyntaxHighlightColors(editorSyntaxHighlighting);
                return;
            }
            for (EditorSyntaxHighlighting editorSyntaxHighlighting : SyntaxHighlightingUtils.getAllSyntaxHighlightings()) {
                for (Object object2 : editorSyntaxHighlighting.getColors()) {
                    if (!string.equals(object2.getPreferenceKey())) continue;
                    STPPrefsManager.this.updateSyntaxHighlightColors(editorSyntaxHighlighting);
                }
            }
            for (EditorSyntaxHighlighting editorSyntaxHighlighting : SyntaxHighlightingUtils.getAllSyntaxHighlightings()) {
                Object object2;
                EditorLanguage editorLanguage = editorSyntaxHighlighting.getLanguage();
                if (!EditorLanguageUtils.isSmartIndentingSupported(editorLanguage) || !EditorPreferences.isIndentingPreference(editorLanguage, string)) continue;
                object2 = EditorPreferences.getIndentingStyle(editorLanguage);
                STPPrefsManager.this.setPrefValue("indenting-type", ((IndentingStyle)((Object)object2)).getInternalName(), editorSyntaxHighlighting.getBaseKitClass());
            }
            if (string.equals("EditorPrintOptions") || string.equals("EditorTextFont")) {
                STPPrefsManager.this.updatePrintOptions(EditorPrefsAccessor.getPrintOptions(), string, EditorPrefsAccessor.getPrintingBodyFont());
            } else if (JavaSyntaxHighlighting.isJavaMethodTypePreference(string)) {
                STPPrefsManager.this.setJavaMethodType(JavaSyntaxHighlighting.getJavaMethodStyle(), JavaKit.class);
            } else if (string.equals("ColorsBackground")) {
                STPPrefsManager.this.handleDefaultTextColorChange(true);
            } else if (string.equals("ColorsText")) {
                STPPrefsManager.this.handleDefaultTextColorChange(false);
            } else if (string.equals("EditorShowLineNumbers")) {
                boolean bl = EditorPrefsAccessor.getShowLineNumbers();
                STPPrefsManager.this.setPrefValue("line-number-visible", bl);
                AnnotationTypes.getTypes().setShowGlyphGutter(Boolean.valueOf(bl));
            } else if (string.equals("EditorSpacesPerTab")) {
                int n = EditorPrefsAccessor.getSpacesPerTab();
                STPPrefsManager.this.setPrefValue("tab-size", n);
                STPPrefsManager.this.setPrefValue("spaces-per-tab", n);
            } else if (string.equals("EditorSpacesPerIndent")) {
                int n = EditorPrefsAccessor.getSpacesPerIndent();
                STPPrefsManager.this.setPrefValue("indent-shift-width", n);
            } else if (string.equals("EditorMFunctionIndentType")) {
                object = EditorPrefsAccessor.getMatlabIndentingScheme();
                STPPrefsManager.this.setPrefValue("function-indenting-type", ((MatlabFunctionIndentingScheme)((Object)object)).getInternalName(), MKit.class);
            } else if (string.equals("EditorTabToSpaces")) {
                boolean bl = EditorPrefsAccessor.isTabChangedToSpaces();
                STPPrefsManager.this.setPrefValue("expand-tabs", bl);
            } else if (string.equals("EditorEmacsTab")) {
                boolean bl = EditorPrefsAccessor.isEmacsStyleTab();
                STPPrefsManager.this.setPrefValue("emacs-smart-tab", bl);
            } else if (KeyboardPrefs.didDelimMatchingPrefChange((PrefEvent)prefEvent)) {
                STPPrefsManager.this.updateDelimMatchingOptions();
            } else if (string.equals("EditorRightTextLineLimit")) {
                STPPrefsManager.this.setPrefValue("text-limit-width", EditorPrefsAccessor.getTextLimit());
            } else if (string.equals("EditorRightTextLimitLineWidth")) {
                STPPrefsManager.this.setPrefValue("text-limit-line-width", EditorPrefsAccessor.getTextLimitLineWidth());
            } else if (string.equals("EditorRightTextLimitLineColor")) {
                STPPrefsManager.this.setPrefValue("text-limit-line-color", EditorPrefsAccessor.getTextLimitLineColor());
            } else if (string.equals("EditorRightTextLineVisible")) {
                STPPrefsManager.this.setPrefValue("text-limit-line-visible", EditorPrefsAccessor.isTextLimitOn());
            } else if (string.equals("Editorhighlight-lines")) {
                object = new Coloring(null, null, EditorPrefsAccessor.getHighlightingColor());
                STPPrefsManager.this.setPrefColoring("highlight-lines", (Coloring)object, (Coloring)object, MWKit.class);
            } else if (string.equals("Editorhighlight-caret-row-boolean-color")) {
                object = new Coloring(null, null, EditorPrefsAccessor.getHighlightCaretRowColor());
                STPPrefsManager.this.setPrefColoring("highlight-caret-row", (Coloring)object, (Coloring)object, MWKit.class);
            } else if (string.equals("Editorhighlight-caret-row-boolean")) {
                STPPrefsManager.this.setPrefValue("highlight-caret-row", EditorPrefsAccessor.isHighlightCaretRow());
            } else if (string.equals("Editormlint-display")) {
                STPPrefsManager.this.setPrefValue("mlint-display", EditorPrefsAccessor.isMLintEnabled(), MKit.class);
            } else if (string.equals("Editormlint-underlining")) {
                STPPrefsManager.this.setPrefValue("mlint-underlining", EditorPrefsAccessor.getMLintUnderlining(), MKit.class);
            } else if (string.equals(STPPrefsManager.PREF_FOLD_ENABLE)) {
                this.handleCodeFoldsEnablePrefChange();
            } else if (MFoldType.isFoldEnabledPrefKey(string)) {
                object = MFoldType.getFoldForPrefKey(string);
                STPPrefsManager.this.setPrefValue(((MFoldType)((Object)object)).getFoldEnabledPrefKey(), ((MFoldType)((Object)object)).isFoldEnabled(), MKit.class);
            } else if (MFoldType.isFoldedUponOpenPrefKey(string)) {
                object = MFoldType.getFoldForPrefKey(string);
                STPPrefsManager.this.setPrefValue(((MFoldType)((Object)object)).getFoldedUponOpenPrefKey(), ((MFoldType)((Object)object)).isFoldedUponOpen(), MKit.class);
            } else if (string.equals("Editor.VariableHighlighting.Color")) {
                STPPrefsManager.this.setPrefValue(string, VariableHighlightPrefs.getPreferredHighlightColor(), MKit.class);
            } else if (string.equals("Editor.VariableHighlighting.Automatic")) {
                STPPrefsManager.this.setPrefValue(string, VariableHighlightPrefs.isAutoHighlighting(), MKit.class);
            } else if (string.equals("Editor.NonlocalVariableHighlighting.TextColor")) {
                STPPrefsManager.this.setPrefValue(string, VariableHighlightPrefs.getPreferredNonlocalVariableTextColor(), MKit.class);
            } else if (string.equals("Editor.NonlocalVariableHighlighting")) {
                STPPrefsManager.this.setPrefValue(string, VariableHighlightPrefs.isNonlocalVariableHighlightingEnabled(), MKit.class);
            }
        }

        private void handleCodeFoldsEnablePrefChange() {
            List list;
            STPPrefsManager.this.setPrefValue("code-folding-enable", EditorPrefsAccessor.isCodeFoldingEnabled(), MKit.class);
            if (STPPrefsManager.this.fMimeTypeKitClassMap != null && STPPrefsManager.this.fMimeTypeKitClassMap.containsKey(MLanguage.INSTANCE.getMimeType()) && (list = (List)STPPrefsManager.this.fMimeTypeKitClassMap.get(MLanguage.INSTANCE.getMimeType())) != null && !list.isEmpty()) {
                for (Class clazz : list) {
                    STPPrefsManager.this.setPrefValue("code-folding-enable", EditorPrefsAccessor.isCodeFoldingEnabled(), clazz);
                }
                STPPrefsManager.this.setPrefValue("code-folding-enable", EditorPrefsAccessor.isCodeFoldingEnabled(), ((Object)((Object)new MLanguage().createDefaultKit())).getClass());
            }
        }

        public void fontChanged(Font font) {
            Coloring coloring = SettingsUtil.getColoring(MWKit.class, (String)"default", (boolean)false);
            Coloring coloring2 = Coloring.changeFont((Coloring)coloring, (Font)font);
            Coloring coloring3 = STPPrefsManager.computePrintingColoring(SettingsUtil.getColoring(MWKit.class, (String)"default", (boolean)true), EditorPrefsAccessor.getPrintingBodyFont());
            STPPrefsManager.this.setDefaultTextPrefColoring(coloring2, coloring3);
        }
    }
}

