/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;

public class Tokenizer {
    private static final TokenInfo[] EMPTY_TOKENINFO = new TokenInfo[0];
    private final List<SyntaxHighlightingColor> fColors;
    private final Syntax fSyntax;

    protected Tokenizer(List<SyntaxHighlightingColor> list, Syntax syntax) {
        Validate.notNull(list, (String)"'colors' cannot be null");
        Validate.notNull((Object)syntax, (String)"'syntax' cannot be null");
        this.fColors = list;
        this.fSyntax = syntax;
    }

    public synchronized TokenInfo[] tokenize(String string) {
        return this.tokenize(string.toCharArray());
    }

    public synchronized TokenInfo[] tokenize(char[] cArray) {
        this.fSyntax.load(null, cArray, 0, cArray.length, true, -1);
        return this.tokenize().toArray(EMPTY_TOKENINFO);
    }

    public synchronized TokenInfo[] tokenize(char[] cArray, TokenInfo tokenInfo) {
        this.fSyntax.load(tokenInfo.fStateInfo, cArray, 0, cArray.length, true, -1);
        return this.tokenize().toArray(EMPTY_TOKENINFO);
    }

    private List<TokenInfo> tokenize() {
        ArrayList<TokenInfo> arrayList = new ArrayList<TokenInfo>();
        boolean bl = true;
        while (bl) {
            TokenID tokenID = this.fSyntax.nextToken();
            if (tokenID == null) {
                bl = false;
                int n = arrayList.size();
                if (n <= 0) continue;
                TokenInfo tokenInfo = (TokenInfo)arrayList.get(n - 1);
                tokenInfo.fStateInfo = this.fSyntax.createStateInfo();
                this.fSyntax.storeState(tokenInfo.fStateInfo);
                continue;
            }
            TokenInfo tokenInfo = new TokenInfo(this.fSyntax.getTokenOffset(), this.fSyntax.getTokenLength(), tokenID, this.fColors);
            arrayList.add(tokenInfo);
        }
        return arrayList;
    }

    public String toString() {
        return "[Tokenizer fSyntax=" + this.fSyntax + ", fColors=" + this.fColors + "]";
    }

    public static final class TokenInfo {
        private final int fOffset;
        private final int fLength;
        private final SyntaxHighlightingColor fColor;
        private final TokenID fTokenID;
        private Syntax.StateInfo fStateInfo = null;

        private TokenInfo(int n, int n2, TokenID tokenID, Collection<SyntaxHighlightingColor> collection) {
            this.fOffset = n;
            this.fLength = n2;
            this.fTokenID = tokenID;
            this.fColor = TokenInfo.findColor(tokenID, collection);
        }

        public final String getColorPreferenceName() {
            return this.fColor == null ? null : this.fColor.getPreferenceKey();
        }

        public final int getOffset() {
            return this.fOffset;
        }

        public final int getLength() {
            return this.fLength;
        }

        public final Color getColor() {
            return this.fColor == null ? null : this.fColor.getCurrentColor();
        }

        public final TokenID getTokenID() {
            return this.fTokenID;
        }

        public String toString() {
            return this.fOffset + " " + this.fLength + " " + this.fColor;
        }

        private static SyntaxHighlightingColor findColor(TokenID tokenID, Collection<SyntaxHighlightingColor> collection) {
            assert (tokenID != null) : "'tokenID' is not expected to be null";
            assert (collection != null) : "'colors' is not expected to be null";
            SyntaxHighlightingColor syntaxHighlightingColor = null;
            Map<String, SyntaxHighlightingColor> map = TokenInfo.createColorMap(collection);
            if (tokenID.getCategory() != null) {
                syntaxHighlightingColor = map.get(tokenID.getCategory().getName());
            }
            if (syntaxHighlightingColor == null) {
                syntaxHighlightingColor = map.get(tokenID.getName());
            }
            return syntaxHighlightingColor;
        }

        private static synchronized Map<String, SyntaxHighlightingColor> createColorMap(Collection<SyntaxHighlightingColor> collection) {
            HashMap<String, SyntaxHighlightingColor> hashMap = new HashMap<String, SyntaxHighlightingColor>();
            for (SyntaxHighlightingColor syntaxHighlightingColor : collection) {
                hashMap.put(syntaxHighlightingColor.getTokenName(), syntaxHighlightingColor);
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }
}

