/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentBar;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class DTDocumentBarMenu
extends MJMenu
implements MenuListener {
    private Desktop fDesktop;
    private DTDocumentContainer fDocumentContainer;

    DTDocumentBarMenu(Desktop desktop, DTDocumentContainer dTDocumentContainer) {
        super(desktop.getString("menu.DocumentBar"));
        this.fDesktop = desktop;
        this.fDocumentContainer = dTDocumentContainer;
        if (DTUtilities.usingMacScreenMenus()) {
            this.populate();
        } else {
            this.addMenuListener(this);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (this.fDocumentContainer == null) {
            return;
        }
        this.populate();
    }

    private void populate() {
        EventListener eventListener;
        Action action = this.fDocumentContainer.getDocumentBar().getAlphabetizeAction();
        if (action != null) {
            this.add((JMenuItem)new MJCheckBoxMenuItem(action));
        }
        if (!DTUtilities.usingMacScreenMenus() && (eventListener = this.fDocumentContainer.getDocumentBar().getAdjustWidthAction()) != null) {
            if (!this.fDocumentContainer.getDocumentBar().isVisible() || this.fDocumentContainer.getBarPosition() == -1) {
                eventListener.setEnabled(false);
            }
            this.add((Action)eventListener);
        }
        this.add((JMenuItem)((Object)new BarPositionMenu()));
        if (!DTUtilities.usingMacScreenMenus() && (eventListener = new ButtonMoveMenu()).isEnabled()) {
            this.add((JMenuItem)((Object)eventListener));
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTDocumentBarMenu.this.dispose();
                DTDocumentBarMenu.this.removeAll();
                if (!Arrays.asList(DTDocumentBarMenu.this.getMenuListeners()).contains(DTDocumentBarMenu.this)) {
                    DTDocumentBarMenu.this.addMenuListener(DTDocumentBarMenu.this);
                }
            }
        });
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.menuDeselected(menuEvent);
    }

    class ButtonMoveMenu
    extends MJMenu
    implements MenuListener {
        ButtonMoveMenu() {
            assert (DTDocumentBarMenu.this.fDocumentContainer != null);
            DTDocumentBar dTDocumentBar = DTDocumentBarMenu.this.fDocumentContainer.getDocumentBar();
            DTClient dTClient = dTDocumentBar.getSelectedDocument();
            if (!dTDocumentBar.isVisible() || DTDocumentBarMenu.this.fDocumentContainer.getBarPosition() == -1 || dTClient == null || !dTDocumentBar.buttonMovePermitted(dTClient)) {
                this.setText(DTDocumentBarMenu.this.fDesktop.getString("menu.MoveOnBar"));
                this.setEnabled(false);
            } else {
                Object[] objectArray = new Object[]{dTClient.getShortTitle()};
                this.setText(MessageFormat.format(DTDocumentBarMenu.this.fDesktop.getString("menu.MoveThisOnBar"), objectArray));
            }
            this.addMenuListener(this);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (this.getMenuComponentCount() == 0) {
                Action[] actionArray;
                for (Action action : actionArray = DTDocumentBarMenu.this.fDocumentContainer.getDocumentBar().getDocumentMoveActions()) {
                    this.add(action);
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    }

    class BarPositionMenu
    extends MJMenu
    implements MenuListener {
        BarPositionMenu() {
            super(DTDocumentBarMenu.this.fDesktop.getString("menu.BarPosition"));
            this.addMenuListener(this);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (this.getMenuComponentCount() == 0) {
                ButtonGroup buttonGroup = new ButtonGroup();
                MJRadioButtonMenuItem mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getBarToNorthAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getBarToSouthAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getBarToEastAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getBarToWestAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
                this.addSeparator();
                mJRadioButtonMenuItem = new MJRadioButtonMenuItem(DTDocumentBarMenu.this.fDocumentContainer.getBarHideAction());
                buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
                this.add((JMenuItem)mJRadioButtonMenuItem);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    }
}

