/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.ControlKeyOverride;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJDimensionPicker;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTiledPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTCloseDialog;
import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentBar;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDragger;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTExternalTarget;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFloatingPane;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMaximizedPane;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTNotifyingList;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTSelectionManager;
import com.mathworks.widgets.desk.DTTabbedPane;
import com.mathworks.widgets.desk.DTTileDialog;
import com.mathworks.widgets.desk.DTTiledLocation;
import com.mathworks.widgets.desk.DTTiledPane;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.TargetedAction;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTDocumentContainer
extends MJPanel
implements DTContainer,
ItemSelectable,
PropertyChangeListener,
ActionListener,
MJTiledPane.GridListener,
ControlKeyOverride {
    private Desktop fDesktop;
    private DTFrame fFrame;
    private DTGroup fGroup;
    private boolean fShowTitleWhenMaximized;
    private List<DTClient> fDocuments = new ArrayList<DTClient>();
    private Panel fHeavyPanel;
    private DTFloatingPane fFloatingPane;
    private DTTiledPane fTiledPane;
    private DTMaximizedPane fMaximizedPane;
    private int fArrangement = -1;
    private ItemListener fSelectionListener;
    private List<ArrangementListener> fArrangementListeners;
    private MouseListener fBackgroundListener;
    private DTDocumentBar fDocumentBar;
    private int fDocumentBarPosition = -1;
    private JToolBar fTopRightToolBar;
    private JToolBar fTopLeftToolBar;
    private JComponent fBlankPanel;
    private DTClient fLastSelectedDocument;
    private boolean fIsSelected;
    private boolean fRestoringDocuments;
    private boolean fWasEmpty;
    private boolean fWasShowing;
    private Component fFocusOwnerBeforePicker;
    private int fHeavyDocumentCount;
    private TileAction fTileAction;
    private MJAbstractAction fTileSelectAction;
    private MJAbstractAction fSplitEastWestAction;
    private MJAbstractAction fSplitNorthSouthAction;
    private MJAbstractAction fFloatAction;
    private MJAbstractAction fMaximizeAction;
    private ActionListener fMaximizeListener;
    private MJAbstractAction[] fArrangementActions = new MJAbstractAction[5];
    private MJAbstractAction fCloseAllAction;
    private MJAbstractAction fCascadeAction;
    private MJAbstractAction fMinimizeAllAction;
    private MJAbstractAction fBarToNorthAction;
    private MJAbstractAction fBarToSouthAction;
    private MJAbstractAction fBarToEastAction;
    private MJAbstractAction fBarToWestAction;
    private MJAbstractAction fBarHideAction;
    private MJAbstractAction[] fBarActions = new MJAbstractAction[5];
    private DropTargetListener fDropTargetListener;
    private KeyListener fEmptyKeyListener;
    public static final int HIDE_DOCUMENT_BAR = -1;
    private static final int DEFAULT_BAR_POSITION = -2;
    public static final int NEVER_HEAVY = 0;
    public static final int ALWAYS_HEAVY = 1;
    public static final int CONDITIONALLY_HEAVY = 2;
    public static final int WHEN_HEAVY = 2;
    public static final int MAXIMIZED = 1;
    public static final int TILED = 2;
    public static final int FLOATING = 3;
    private static final int MINIMUM_CONTAINER_SIZE = 100;
    static final String DOCUMENT_AREA_TAG = "DocumentArea";
    private static final String SHOWING_ATTRIBUTE = "Showing";
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";
    private static final String EMPTY_ATTRIBUTE = "Empty";
    private static final String ARRANGEMENT_ATTRIBUTE = "Arrangement";
    private static final String MAXIMIZED_VALUE = "maximized";
    private static final String TILED_VALUE = "tiled";
    private static final String FLOATING_VALUE = "floating";
    private static final String BAR_ATTRIBUTE = "Bar";
    private static final String LEFT_VALUE = "left";
    private static final String RIGHT_VALUE = "right";
    private static final String TOP_VALUE = "top";
    private static final String BOTTOM_VALUE = "bottom";
    private static final String HIDE_VALUE = "hide";
    private static final String MAX_BAR_WIDTH_ATTRIBUTE = "MaxBarWidth";

    DTDocumentContainer(Desktop desktop, DTFrame dTFrame, DTGroup dTGroup) {
        this(desktop, dTFrame, dTGroup, null);
    }

    DTDocumentContainer(Desktop desktop, DTFrame dTFrame, DTGroup dTGroup, Object object) {
        this.setName("DesktopDocumentContainer");
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fGroup = dTGroup;
        if (this.fGroup != null) {
            this.fGroup.addPropertyListener(this);
        }
        this.fShowTitleWhenMaximized = dTGroup == null;
        State state = (State)object;
        if (state != null) {
            this.fWasEmpty = state.fWasEmpty;
            this.fWasShowing = state.fWasShowing;
        }
        this.setLayout(null);
        this.fBackgroundListener = new BackgroundMouseListener();
        this.fTileAction = new TileAction();
        this.fArrangementActions[0] = this.fTileAction;
        this.fArrangementActions[1] = this.fSplitEastWestAction = new SplitEastWestAction();
        this.fArrangementActions[2] = this.fSplitNorthSouthAction = new SplitNorthSouthAction();
        this.fArrangementActions[3] = this.fFloatAction = new FloatAction();
        this.fArrangementActions[4] = this.fMaximizeAction = new MaximizeAction();
        int n = this.getDefaultBarPosition();
        if (state != null && state.fDocumentBarPosition != -2) {
            n = state.fDocumentBarPosition;
        }
        int n2 = state != null && state.fMaxDocumentBarWidth > 0 ? state.fMaxDocumentBarWidth : Toolkit.getDefaultToolkit().getScreenSize().width >> 3;
        this.fDocumentBar = new DTDocumentBar(this, DTDocumentContainer.orientationForPosition(n), n2, dTGroup == null);
        this.fDocumentBar.setBorder(new DocumentBarBorder());
        if (this.fGroup != null && this.fGroup.getNewAction() != null) {
            this.fDocumentBar.setNewAction(this.fGroup.getNewAction());
        }
        this.add((Component)((Object)this.fDocumentBar));
        this.fBarActions[0] = this.fBarToNorthAction = new MoveBarAction(1);
        this.fBarActions[1] = this.fBarToSouthAction = new MoveBarAction(5);
        this.fBarActions[2] = this.fBarToEastAction = new MoveBarAction(3);
        this.fBarActions[3] = this.fBarToWestAction = new MoveBarAction(7);
        this.fBarActions[4] = this.fBarHideAction = new MoveBarAction(-1);
        int n3 = 1;
        if (state != null && (n3 = state.fArrangement) == 2) {
            try {
                this.fTiledPane = new DTTiledPane(this, state.fTiledState);
                this.fTiledPane.addGridListener(this);
                this.fTiledPane.addMouseListener(this.fBackgroundListener);
            }
            catch (Exception exception) {
                this.fTiledPane = null;
                n3 = 1;
            }
        }
        this.setArrangement(n3, null);
        this.setBarPosition(n);
        this.setKeyBindings();
    }

    void cleanup() {
        if (this.fGroup != null) {
            this.fGroup.removePropertyListener(this);
        }
    }

    protected void setKeyBindings() {
        this.setInputMap(1, DTKeyBindings.getInstance().getInputMap());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("select-next-tab", (Action)((Object)new NextDocumentAction()));
        actionMap.put("select-previous-tab", (Action)((Object)new PreviousDocumentAction()));
    }

    Action getNextDocumentAction() {
        return this.getActionByName("select-next-tab");
    }

    Action getPrevDocumentAction() {
        return this.getActionByName("select-previous-tab");
    }

    private Action getActionByName(String string) {
        return this.getActionMap().get(string);
    }

    public boolean wantKey(KeyStroke keyStroke, Component component) {
        DTClientFrame dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, component));
        return dTClientFrame == null || !dTClientFrame.getClient().wantsControlKeys();
    }

    private void setHeavy(boolean bl) {
        if (bl != this.isHeavy()) {
            DTContainer dTContainer = null;
            switch (this.fArrangement) {
                case 1: {
                    dTContainer = this.fMaximizedPane;
                    break;
                }
                case 3: {
                    dTContainer = this.fFloatingPane;
                    break;
                }
                case 2: {
                    dTContainer = this.fTiledPane;
                }
            }
            if (bl) {
                this.fHeavyPanel = new Panel();
                this.fHeavyPanel.setFocusable(false);
                this.fHeavyPanel.setLayout(new BorderLayout());
                this.remove((Component)((Object)dTContainer));
                this.fHeavyPanel.add((Component)((Object)dTContainer), "Center");
                this.add(this.fHeavyPanel);
            } else {
                this.remove(this.fHeavyPanel);
                this.add((Component)((Object)dTContainer));
                this.fHeavyPanel = null;
            }
        }
    }

    boolean isHeavy() {
        return this.fHeavyPanel != null;
    }

    DTFrame getFrame() {
        return this.fFrame;
    }

    void setFrame(DTFrame dTFrame) {
        this.fFrame = dTFrame;
    }

    DTGroup getGroup() {
        return this.fGroup;
    }

    Desktop getDesktop() {
        return this.fDesktop;
    }

    DTDocumentBar getDocumentBar() {
        return this.fDocumentBar;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        this.fDocuments.add(dTClient);
        dTClient.addPropertyListener(this);
        dTClient.addPreSelectionListener(this);
        dTClient.getInternalFrame().setBorderVisible(false);
        DTGroup dTGroup = dTClient.getGroup();
        DTNotifyingList<DTClient> dTNotifyingList = dTGroup.getDockedDocuments();
        if (dTNotifyingList.isEmpty()) {
            this.fDocumentBar.addGroup(dTGroup);
        }
        dTNotifyingList.add(dTClient);
        if (dTClient.treatAsHeavyweight()) {
            ++this.fHeavyDocumentCount;
            if (this.fHeavyDocumentCount == 1) {
                this.setHeavy(true);
            }
        }
        switch (this.fArrangement) {
            case 1: {
                this.fMaximizedPane.add(dTClient, dTLocation);
                if (this.isRestoringDocuments() || this.fMaximizedPane.getMaximizedDocument() != dTClient) break;
                this.fLastSelectedDocument = dTClient;
                break;
            }
            case 2: {
                dTClient.getInternalFrame().setTitleBarVisible(true);
                if (this.fRestoringDocuments) {
                    if (!(dTLocation instanceof DTTiledLocation)) {
                        dTLocation = DTLocation.create(-1);
                    }
                    dTLocation.setFrame(this.fFrame);
                    dTLocation.setContainer(this);
                    dTClient.setLocation(dTLocation);
                    break;
                }
                this.fTiledPane.add(dTClient, dTLocation);
                break;
            }
            case 3: {
                dTClient.getInternalFrame().setTitleBarVisible(true);
                this.fFloatingPane.add(dTClient, dTLocation);
                if (this.isRestoringDocuments() || this.fFloatingPane.getTopMost() != dTClient) break;
                this.fLastSelectedDocument = dTClient;
            }
        }
        if (dTClient.isSelected()) {
            this.fLastSelectedDocument = dTClient;
            this.setSelected(true, false);
        }
        this.fDocumentBar.setVisible(this.documentBarShouldBeVisible());
        if (this.fDocuments.size() == 1) {
            if (this.fCloseAllAction != null) {
                this.fCloseAllAction.setEnabled(true);
            }
            if (this.fCascadeAction != null) {
                this.fCascadeAction.setEnabled(true);
            }
            if (this.fMinimizeAllAction != null) {
                this.fMinimizeAllAction.setEnabled(true);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        Object object;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = dTClient.isSelected();
        this.fDocuments.remove(dTClient);
        if (this.fLastSelectedDocument == dTClient) {
            this.fLastSelectedDocument = null;
        }
        switch (this.fArrangement) {
            case 1: {
                this.fMaximizedPane.remove(dTClient);
                break;
            }
            case 2: {
                this.fTiledPane.remove(dTClient);
                int n = this.fTiledPane.getSelectedTile();
                if (n == -1 || this.fTiledPane.getComponentInTile(n) != null || (object = this.getMostRecentlySelected()) == null || this.fGroup != null && this.fGroup.getToolBars().length != 0) break;
                ((DTOccupant)object).setSelected(true);
                break;
            }
            case 3: {
                this.fFloatingPane.remove(dTClient);
            }
        }
        DTGroup dTGroup = dTClient.getGroup();
        if (dTGroup != null) {
            object = dTGroup.getDockedDocuments();
            object.remove(dTClient);
            if (object.isEmpty()) {
                this.fDocumentBar.removeGroup(dTGroup);
            }
        }
        this.fDocumentBar.setVisible(this.documentBarShouldBeVisible());
        if (dTClient.treatAsHeavyweight()) {
            --this.fHeavyDocumentCount;
        }
        if (bl && this.isEmpty() && !this.isHeavy()) {
            if (dTGroup == null || !dTGroup.isClosing()) {
                this.requestFocus();
            }
        } else if (this.fHeavyDocumentCount == 0) {
            this.getDesktop().getSelectionManager().lock();
            this.setHeavy(false);
            if (bl && this.isEmpty() && (dTGroup == null || !dTGroup.isClosing())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DTDocumentContainer.this.fFrame != null) {
                            DTDocumentContainer.this.requestFocusInWindow();
                        }
                        DTDocumentContainer.this.getDesktop().getSelectionManager().unlock();
                    }
                });
            } else {
                this.getDesktop().getSelectionManager().unlock();
            }
        }
        dTClient.removePropertyListener(this);
        dTClient.removePreSelectionListener(this);
        dTClient.getLocation().setContainer(null);
        dTClient.setLocation(null);
        if (this.fDocuments.isEmpty()) {
            if (this.fCloseAllAction != null) {
                this.fCloseAllAction.setEnabled(false);
            }
            if (this.fCascadeAction != null) {
                this.fCascadeAction.setEnabled(false);
            }
            if (this.fMinimizeAllAction != null) {
                this.fMinimizeAllAction.setEnabled(false);
            }
        }
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        if (this.isEmpty()) {
            return null;
        }
        if (dTSelectable != null && !(dTSelectable instanceof DTClient)) {
            return null;
        }
        DTClient dTClient = (DTClient)dTSelectable;
        if (!bl) {
            return this.getNextOnBar(dTClient);
        }
        if (dTClient == null) {
            switch (this.fArrangement) {
                case 1: {
                    return this.fMaximizedPane.getNext(null, bl);
                }
                case 3: {
                    return this.fFloatingPane.getNext(null, bl);
                }
                case 2: {
                    return this.fTiledPane.getNext(null, bl);
                }
            }
        }
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        if (this.isEmpty()) {
            return null;
        }
        if (dTSelectable != null && !(dTSelectable instanceof DTClient)) {
            return null;
        }
        DTClient dTClient = (DTClient)dTSelectable;
        if (!bl) {
            return this.getPreviousOnBar(dTClient);
        }
        if (dTClient == null) {
            switch (this.fArrangement) {
                case 1: {
                    return this.fMaximizedPane.getPrevious(null, bl);
                }
                case 3: {
                    return this.fFloatingPane.getPrevious(null, bl);
                }
                case 2: {
                    return this.fTiledPane.getPrevious(null, bl);
                }
            }
        }
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        if (dTOccupant == null) {
            return;
        }
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = scope == DTContainer.Scope.GROUP && this.fLastSelectedDocument != null && this.fLastSelectedDocument.isSelected() && this.fLastSelectedDocument.getGroup() == dTClient.getGroup();
        switch (this.fArrangement) {
            case 1: {
                this.fMaximizedPane.toFront(dTClient, scope);
                this.fLastSelectedDocument = dTClient;
                dTClient.setSelectionOrder(this.getDesktop().getSelectionManager().getNextSelectionOrder());
                break;
            }
            case 3: {
                this.fFloatingPane.toFront(dTClient, scope);
                break;
            }
            case 2: {
                this.fTiledPane.toFront(dTClient, scope);
            }
        }
        if (bl) {
            dTClient.setSelected(true);
        }
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        switch (this.fArrangement) {
            case 1: {
                return this.fMaximizedPane.canMoveWithKeys(dTOccupant);
            }
            case 3: {
                return this.fFloatingPane.canMoveWithKeys(dTOccupant);
            }
            case 2: {
                return this.fTiledPane.canMoveWithKeys(dTOccupant);
            }
        }
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        switch (this.fArrangement) {
            case 1: {
                this.fMaximizedPane.startKeyMove(dTOccupant);
                break;
            }
            case 3: {
                this.fFloatingPane.startKeyMove(dTOccupant);
                break;
            }
            case 2: {
                this.fTiledPane.startKeyMove(dTOccupant);
            }
        }
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        switch (this.fArrangement) {
            case 1: {
                return this.fMaximizedPane.canResizeWithKeys(dTOccupant);
            }
            case 3: {
                return this.fFloatingPane.canResizeWithKeys(dTOccupant);
            }
            case 2: {
                return this.fTiledPane.canResizeWithKeys(dTOccupant);
            }
        }
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        switch (this.fArrangement) {
            case 1: {
                this.fMaximizedPane.startKeyResize(dTOccupant);
                break;
            }
            case 3: {
                this.fFloatingPane.startKeyResize(dTOccupant);
                break;
            }
            case 2: {
                this.fTiledPane.startKeyResize(dTOccupant);
            }
        }
    }

    private DTClient getNextOnBar(DTClient dTClient) {
        Iterator<DTClient> iterator = this.fDocumentBar.getClientIterator();
        if (dTClient == null || !this.fDocuments.contains(dTClient)) {
            return iterator.next();
        }
        while (iterator.hasNext() && dTClient != iterator.next()) {
        }
        return iterator.hasNext() ? iterator.next() : null;
    }

    private DTClient getPreviousOnBar(DTClient dTClient) {
        DTClient dTClient2;
        DTClient dTClient3 = null;
        Iterator<DTClient> iterator = this.fDocumentBar.getClientIterator();
        while (iterator.hasNext() && dTClient != (dTClient2 = iterator.next())) {
            dTClient3 = dTClient2;
        }
        return dTClient3;
    }

    boolean isEmpty() {
        return this.fDocuments.isEmpty();
    }

    boolean isShowingInDesktop() {
        return this.isVisible() && SwingUtilities.windowForComponent((Component)((Object)this)) != null;
    }

    boolean wasEmpty() {
        return this.fWasEmpty;
    }

    boolean wasShowing() {
        return this.fWasShowing;
    }

    void saveShowingAndEmpty() {
        this.fWasShowing = this.isShowingInDesktop();
        this.fWasEmpty = this.isEmpty();
    }

    int getDocumentCount() {
        return this.fDocuments.size();
    }

    int getGroupCount() {
        return this.fDocumentBar.getGroupCount();
    }

    List<DTClient> getDocuments() {
        return Collections.unmodifiableList(this.fDocuments);
    }

    DTClient getMaximizedDocument() {
        return this.fMaximizedPane == null ? null : this.fMaximizedPane.getMaximizedDocument();
    }

    boolean showTitleWhenMaximized() {
        return this.fShowTitleWhenMaximized;
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.add(this.fSelectionListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.remove(this.fSelectionListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this};
        return objectArray;
    }

    final int getArrangement() {
        return this.fArrangement;
    }

    final Dimension getTiledDimension() {
        return this.fArrangement == 2 ? this.fTiledPane.getGridSize() : null;
    }

    public void setArrangement(int n, Dimension dimension) {
        this.setArrangement(n, dimension, true, true);
    }

    private void setArrangement(int n, Dimension dimension, boolean bl) {
        this.setArrangement(n, dimension, bl, true);
    }

    private void setArrangement(int n, Dimension dimension, boolean bl, boolean bl2) {
        this.setArrangement(n, dimension, bl, bl2, null);
    }

    void setArrangement(int n, Dimension dimension, boolean bl, boolean bl2, List list) {
        DTClient dTClient;
        if (n != this.fArrangement) {
            Object object = this.isHeavy() ? this.fHeavyPanel : this;
            switch (this.fArrangement) {
                case 1: {
                    this.fMaximizedPane.removeAll();
                    ((Container)object).remove((Component)((Object)this.fMaximizedPane));
                    break;
                }
                case 2: {
                    this.fTiledPane.removeAll();
                    ((Container)object).remove((Component)((Object)this.fTiledPane));
                    break;
                }
                case 3: {
                    this.fFloatingPane.removeAll();
                    ((Container)object).remove((Component)((Object)this.fFloatingPane));
                }
            }
            int n2 = this.fArrangement;
            this.fArrangement = n;
            switch (n) {
                case 1: {
                    if (this.fMaximizedPane == null) {
                        this.fMaximizedPane = new DTMaximizedPane(this);
                        this.fMaximizedPane.addMouseListener(this.fBackgroundListener);
                        if (this.fDropTargetListener != null) {
                            try {
                                this.fMaximizedPane.addDropTargetListener(this.fDropTargetListener);
                            }
                            catch (TooManyListenersException tooManyListenersException) {
                                tooManyListenersException.printStackTrace();
                            }
                        }
                        if (this.fEmptyKeyListener != null) {
                            this.fMaximizedPane.addKeyListener(this.fEmptyKeyListener);
                        }
                    }
                    this.fMaximizedPane.beginRestore();
                    int n3 = this.fDocuments.size();
                    for (int i = 0; i < n3; ++i) {
                        this.fMaximizedPane.add(this.fDocuments.get(i), null);
                    }
                    this.fMaximizedPane.endRestore();
                    ((Container)object).add((Component)((Object)this.fMaximizedPane), "Center");
                    dTClient = list != null && list.size() > 0 ? (DTClient)list.get(0) : this.getMostRecentlySelected();
                    if (dTClient == null) break;
                    this.fMaximizedPane.toFront(dTClient, DTContainer.Scope.FRAME);
                    break;
                }
                case 2: {
                    if (this.fTiledPane == null) {
                        this.fTiledPane = new DTTiledPane(this, dimension);
                        this.fTiledPane.addGridListener(this);
                        this.fTiledPane.addMouseListener(this.fBackgroundListener);
                        if (this.fDropTargetListener != null) {
                            try {
                                this.fTiledPane.addDropTargetListener(this.fDropTargetListener);
                            }
                            catch (TooManyListenersException tooManyListenersException) {
                                tooManyListenersException.printStackTrace();
                            }
                        }
                        if (this.fEmptyKeyListener != null) {
                            this.fTiledPane.addKeyListener(this.fEmptyKeyListener);
                        }
                    } else if (dimension != null) {
                        this.fTiledPane.setSelectedTile(-1);
                        this.fTiledPane.setGridSize(dimension);
                    }
                    int n4 = this.fDocuments.size();
                    for (int i = 0; i < n4; ++i) {
                        dTClient = this.fDocuments.get(i);
                        DTLocation dTLocation = DTLocation.create(-1);
                        dTLocation.setFrame(this.fFrame);
                        dTLocation.setContainer(this);
                        dTClient.setLocation(dTLocation);
                    }
                    this.fillTiles(list);
                    ((Container)object).add((Component)((Object)this.fTiledPane), "Center");
                    break;
                }
                case 3: {
                    if (this.fFloatingPane == null) {
                        this.fFloatingPane = new DTFloatingPane(this);
                        if (this.fDropTargetListener != null) {
                            try {
                                this.fFloatingPane.addDropTargetListener(this.fDropTargetListener);
                            }
                            catch (TooManyListenersException tooManyListenersException) {
                                tooManyListenersException.printStackTrace();
                            }
                        }
                        if (this.fEmptyKeyListener != null) {
                            this.fFloatingPane.addKeyListener(this.fEmptyKeyListener);
                        }
                    }
                    ((Container)object).add((Component)((Object)this.fFloatingPane), "Center");
                    if (this.isShowing()) {
                        ((Container)object).doLayout();
                    }
                    if (!bl || this.fDocuments.size() <= 0) break;
                    ArrayList<DTClient> arrayList = new ArrayList<DTClient>(this.fDocuments);
                    Collections.sort(arrayList, new DTSelectionManager.OrderComparator());
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        dTClient = (DTClient)arrayList.get(i);
                        this.fFloatingPane.add(dTClient, dTClient.getLastFloatingInLocation());
                    }
                    break;
                }
            }
            this.fDocumentBar.setVisible(this.documentBarShouldBeVisible());
            this.fireArrangementChange(n2, this.fArrangement);
            this.revalidate();
            this.repaint();
            if (this.isHeavy()) {
                this.fHeavyPanel.invalidate();
                this.fHeavyPanel.validate();
                this.fHeavyPanel.repaint();
            }
        } else if (this.fArrangement == 2 && dimension != null) {
            if (this.fTiledPane.getTileCount() == dimension.width * dimension.height && !bl2 && list == null) {
                this.fTiledPane.setGridSize(dimension);
            } else {
                this.fTiledPane.removeAll();
                this.fTiledPane.setGridSize(dimension);
                int n5 = this.fDocuments.size();
                for (int i = 0; i < n5; ++i) {
                    dTClient = this.fDocuments.get(i);
                    ((DTTiledLocation)dTClient.getLocation()).setTile(-1);
                }
                this.fillTiles(list);
                if (this.isShowing() && this.isHeavy()) {
                    this.fTiledPane.doLayout();
                }
            }
        } else if (this.fArrangement == 1 && list != null && list.size() > 0) {
            this.fMaximizedPane.toFront((DTClient)list.get(0), DTContainer.Scope.FRAME);
        }
        if (this.fLastSelectedDocument != null) {
            if (this.fArrangement == 1 && this.fLastSelectedDocument != this.fMaximizedPane.getMaximizedDocument() || this.fArrangement == 2 && (this.fLastSelectedDocument.getLocation() == null || this.fLastSelectedDocument.getLocation().getTile() == -1)) {
                this.fLastSelectedDocument.getSelectAction().setSelected(false);
                dTClient = this.fArrangement == 1 ? this.fMaximizedPane.getMaximizedDocument() : this.fTiledPane.getClientInTile(0);
                if (dTClient != null) {
                    dTClient.setSelected(true);
                } else {
                    this.fLastSelectedDocument.setSelected(false);
                    this.fLastSelectedDocument = null;
                    this.requestFocusInWindow();
                }
            } else if (this.fLastSelectedDocument.isSelected()) {
                this.fLastSelectedDocument.requestFocus();
            } else if (this.fIsSelected) {
                this.fLastSelectedDocument.setSelected(true);
            }
        } else if (this.fIsSelected) {
            this.requestFocusInWindow();
        }
        this.updateArrangementActions();
    }

    public void setColumnWidths(float[] fArray) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify column widths when not TILED");
        }
        this.fTiledPane.setColumnWidths(fArray);
    }

    public void setRowHeights(float[] fArray) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify row heights when not TILED");
        }
        this.fTiledPane.setRowHeights(fArray);
    }

    public void setColumnSpan(int n, int n2, int n3) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify column span when not TILED");
        }
        this.fTiledPane.setColumnSpan(n, n2, n3);
    }

    public void setRowSpan(int n, int n2, int n3) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify column span when not TILED");
        }
        this.fTiledPane.setRowSpan(n, n2, n3);
    }

    private void fillTiles(List list) {
        if (list == null) {
            this.fillTiles();
        } else {
            for (int i = 0; i < list.size() && i < this.fTiledPane.getTileCount(); ++i) {
                this.fTiledPane.add((DTClient)list.get(i), DTLocation.create(i));
            }
        }
    }

    private void fillTiles() {
        block6: {
            DTClient dTClient;
            block7: {
                block5: {
                    if (this.fDocuments.size() > this.fTiledPane.getTileCount() && this.fLastSelectedDocument != null) break block5;
                    Iterator<DTClient> iterator = this.fDocumentBar.getClientIterator();
                    for (int i = 0; iterator.hasNext() && i < this.fTiledPane.getTileCount(); ++i) {
                        DTClient dTClient2 = iterator.next();
                        this.fTiledPane.add(dTClient2, DTLocation.create(i));
                    }
                    break block6;
                }
                if (this.fTiledPane.getTileCount() != 2 || this.fLastSelectedDocument == null) break block7;
                this.fTiledPane.add(this.fLastSelectedDocument, DTLocation.create(0));
                int n = -1;
                DTClient dTClient3 = null;
                int n2 = this.fDocuments.size();
                for (int i = 0; i < n2; ++i) {
                    DTClient dTClient4 = this.fDocuments.get(i);
                    if (dTClient4 == this.fLastSelectedDocument || dTClient4.getSelectionOrder() <= n) continue;
                    dTClient3 = dTClient4;
                    n = dTClient4.getSelectionOrder();
                }
                if (dTClient3 == null) break block6;
                this.fTiledPane.add(dTClient3, DTLocation.create(1));
                break block6;
            }
            int n = 0;
            Iterator<DTClient> iterator = this.fDocumentBar.getClientIterator();
            while (iterator.hasNext() && n < this.fTiledPane.getTileCount()) {
                dTClient = iterator.next();
                if (n <= 0 && dTClient != this.fLastSelectedDocument) continue;
                this.fTiledPane.add(dTClient, DTLocation.create(n++));
            }
            if (n < this.fTiledPane.getTileCount()) {
                iterator = this.fDocumentBar.getClientIterator();
                while (iterator.hasNext() && n < this.fTiledPane.getTileCount()) {
                    dTClient = iterator.next();
                    this.fTiledPane.add(dTClient, DTLocation.create(n));
                    ++n;
                }
            }
        }
    }

    public void setSelected(boolean bl) {
        this.setSelected(bl, true);
    }

    void setSelected(boolean bl, boolean bl2) {
        this.setSelected(bl, bl2, true);
    }

    void setSelected(boolean bl, boolean bl2, boolean bl3) {
        if (bl != this.fIsSelected) {
            this.fIsSelected = bl;
            if (bl) {
                int n;
                if (this.fArrangement == 2 && (n = this.fTiledPane.getSelectedTile()) != -1 && this.fTiledPane.getComponentInTile(n) == null) {
                    if (bl2) {
                        this.fTiledPane.requestFocus();
                    }
                    bl3 = false;
                }
                if (this.fLastSelectedDocument == null || !this.fLastSelectedDocument.isSelected()) {
                    DTClient dTClient;
                    DTClient dTClient2 = dTClient = bl3 ? this.getMostRecentlySelected() : null;
                    if (dTClient != null && dTClient.getLocation() != null && !dTClient.getLocation().isMinimized()) {
                        dTClient.setSelected(true, bl2);
                    } else {
                        DTClient dTClient3 = this.getDesktop().getSelectionManager().getSelectedClient();
                        if (dTClient3 != null && dTClient3.getGroup() != this.fGroup) {
                            this.getDesktop().getSelectionManager().clearSelection();
                            if (bl2) {
                                new FocusRequestor().run();
                            }
                        }
                    }
                }
            } else if (bl3 && this.fLastSelectedDocument != null) {
                this.fLastSelectedDocument.setSelected(false);
            }
            if (this.fSelectionListener != null) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this, bl ? 1 : 2);
                this.fSelectionListener.itemStateChanged(itemEvent);
            }
        }
    }

    public void requestFocus() {
        if (this.fLastSelectedDocument != null && this.fLastSelectedDocument.isSelected()) {
            this.fLastSelectedDocument.requestFocus();
        } else {
            switch (this.fArrangement) {
                case 1: {
                    this.fMaximizedPane.requestFocus();
                    break;
                }
                case 2: {
                    this.fTiledPane.requestFocus();
                    break;
                }
                case 3: {
                    this.fFloatingPane.requestFocus();
                }
            }
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = false;
        if (this.fLastSelectedDocument != null && this.fLastSelectedDocument.isSelected()) {
            bl = this.fLastSelectedDocument.requestFocusInWindow();
        } else {
            switch (this.fArrangement) {
                case 1: {
                    bl = this.fMaximizedPane.requestFocusInWindow();
                    break;
                }
                case 2: {
                    bl = this.fTiledPane.requestFocusInWindow();
                    break;
                }
                case 3: {
                    bl = this.fFloatingPane.requestFocusInWindow();
                }
            }
        }
        return bl;
    }

    void beginRestore() {
        this.fRestoringDocuments = true;
    }

    boolean isRestoringDocuments() {
        return this.fRestoringDocuments;
    }

    void endRestore() {
        if (!this.fRestoringDocuments) {
            return;
        }
        this.fRestoringDocuments = false;
        DTClient dTClient = this.getMostRecentlySelected();
        if (this.fArrangement == 1) {
            if (dTClient != null) {
                this.toFront(dTClient, DTContainer.Scope.FRAME);
            }
        } else if (this.fArrangement == 2) {
            int n = this.fTiledPane.getTileCount();
            for (int i = 0; i < n; ++i) {
                dTClient = this.fTiledPane.getMostRecentOccupant(i, null);
                if (dTClient == null) continue;
                this.fTiledPane.toFront(dTClient, DTContainer.Scope.FRAME);
            }
        }
    }

    synchronized void addArrangementListener(ArrangementListener arrangementListener) {
        if (this.fArrangementListeners == null) {
            this.fArrangementListeners = new ArrayList<ArrangementListener>();
        }
        if (!this.fArrangementListeners.contains(arrangementListener)) {
            this.fArrangementListeners.add(arrangementListener);
        }
    }

    synchronized void removeArrangementListener(ArrangementListener arrangementListener) {
        if (this.fArrangementListeners != null) {
            this.fArrangementListeners.remove(arrangementListener);
        }
    }

    private synchronized void fireArrangementChange(int n, int n2) {
        if (this.fArrangementListeners == null) {
            return;
        }
        int n3 = this.fArrangementListeners.size();
        for (int i = 0; i < n3; ++i) {
            ArrangementListener arrangementListener = this.fArrangementListeners.get(i);
            arrangementListener.arrangementChanged(this, n, n2);
        }
    }

    public void gridSizeChanged(MJTiledPane mJTiledPane, Dimension dimension, Dimension dimension2) {
        if (dimension2.width == 1 && dimension2.height == 1) {
            this.setArrangement(1, null);
        } else {
            this.updateArrangementActions();
            this.fireArrangementChange(this.fArrangement, this.fArrangement);
        }
    }

    public void tilesMerged(MJTiledPane mJTiledPane, int n, int n2) {
        this.fireArrangementChange(this.fArrangement, this.fArrangement);
    }

    public void tileSplit(MJTiledPane mJTiledPane, int n, int n2) {
        this.fireArrangementChange(this.fArrangement, this.fArrangement);
    }

    public void updateArrangementActions() {
        MJAbstractAction mJAbstractAction = null;
        switch (this.fArrangement) {
            case 1: {
                mJAbstractAction = this.fMaximizeAction;
                break;
            }
            case 2: {
                Dimension object = this.fTiledPane.getGridSize();
                if (object.width == 2 && object.height == 1) {
                    mJAbstractAction = this.fSplitEastWestAction;
                    break;
                }
                if (object.width == 1 && object.height == 2) {
                    mJAbstractAction = this.fSplitNorthSouthAction;
                    break;
                }
                mJAbstractAction = this.fTileAction;
                break;
            }
            case 3: {
                mJAbstractAction = this.fFloatAction;
            }
        }
        for (MJAbstractAction mJAbstractAction2 : this.fArrangementActions) {
            if (mJAbstractAction2 == null) continue;
            mJAbstractAction2.setSelected(mJAbstractAction == mJAbstractAction2);
        }
    }

    JMenu createTileMenu() {
        MJMenu mJMenu = new MJMenu((Action)((Object)this.fTileAction));
        mJMenu.addMenuListener((MenuListener)new TileMenuListener());
        mJMenu.setName("TileDocuments");
        return mJMenu;
    }

    final TileAction getTileAction() {
        return this.fTileAction;
    }

    final MJAbstractAction getSplitEastWestAction() {
        return this.fSplitEastWestAction;
    }

    final MJAbstractAction getSplitNorthSouthAction() {
        return this.fSplitNorthSouthAction;
    }

    final MJAbstractAction getFloatAction() {
        return this.fFloatAction;
    }

    final MJAbstractAction getMaximizeAction() {
        return this.fMaximizeAction;
    }

    final ActionListener getMaximizeListener() {
        if (this.fMaximizeListener == null) {
            this.fMaximizeListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DTDocumentContainer.this.getMaximizeAction().actionPerformed(actionEvent);
                }
            };
        }
        return this.fMaximizeListener;
    }

    final Action getTileSelectAction() {
        if (this.fTileSelectAction == null) {
            this.fTileSelectAction = new TileSelectAction();
        }
        return this.fTileSelectAction;
    }

    final Action getCloseAllAction() {
        if (this.fCloseAllAction == null) {
            this.fCloseAllAction = new CloseAllAction();
        }
        return this.fCloseAllAction;
    }

    final Action getCloseAllExceptAction(DTClient dTClient) {
        return new CloseAllExceptAction(dTClient);
    }

    final Action getCloseSelectAction(DTClient dTClient) {
        return new CloseSelectAction(dTClient);
    }

    final Action getCloseSelectAction() {
        return new CloseSelectAction(null);
    }

    final Action getCascadeAction() {
        if (this.fCascadeAction == null) {
            this.fCascadeAction = new CascadeAction();
        }
        return this.fCascadeAction;
    }

    final Action getMinimizeAllAction() {
        if (this.fMinimizeAllAction == null) {
            this.fMinimizeAllAction = new MinimizeAllAction();
        }
        return this.fMinimizeAllAction;
    }

    DTCloseTransaction getCloseAllTransaction() {
        Object object;
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>(this.fDocuments.size());
        Iterator<DTClient> iterator = this.fDocumentBar.getClientIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((DTOccupant)object).permitUserClose()) continue;
            arrayList.add((DTWindowCloser)object);
        }
        object = new DTCloseTransaction(arrayList);
        ((DTCloseTransaction)object).setDoneListener(new RepaintWhenDoneListener());
        return object;
    }

    DTCloseTransaction getCloseAllExceptTransaction(DTClient dTClient) {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>(this.fDocuments.size());
        Object object = this.fDocumentBar.getClientIterator();
        while (object.hasNext()) {
            DTClient dTClient2 = object.next();
            if (dTClient2 == dTClient || !dTClient2.permitUserClose()) continue;
            arrayList.add(dTClient2);
        }
        object = new DTCloseTransaction(arrayList);
        ((DTCloseTransaction)object).setDoneListener(new RepaintWhenDoneListener());
        return object;
    }

    void undockAll() {
        if (this.fGroup != null) {
            this.fGroup.getUndockAction().actionPerformed(null);
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        DTGroup[] dTGroupArray = new DTGroup[this.fDocumentBar.getGroupCount()];
        Iterator<DTGroup> iterator = this.fDocumentBar.getGroupIterator();
        for (int i = 0; i < dTGroupArray.length && iterator.hasNext(); ++i) {
            dTGroupArray[i] = iterator.next();
        }
        if (dTGroupArray.length > 1) {
            this.getDesktop().setUndockingGroups(true);
        }
        for (DTGroup dTGroup : dTGroupArray) {
            dTGroup.getUndockAction().actionPerformed(null);
        }
        this.getDesktop().setUndockingGroups(false);
    }

    void cascadeDocuments() {
        boolean bl = false;
        if (this.fArrangement != 3) {
            this.setArrangement(3, null, false);
            bl = true;
        }
        this.fFloatingPane.resetCascade();
        DTClient dTClient = null;
        Iterator<DTClient> iterator = this.fDocumentBar.getClientIterator();
        while (iterator.hasNext()) {
            DTClient dTClient2 = iterator.next();
            if (bl) {
                this.fFloatingPane.add(dTClient2, null);
            } else {
                this.fFloatingPane.setLocation(dTClient2, null);
            }
            if (!dTClient2.isSelected()) continue;
            dTClient = dTClient2;
        }
        if (dTClient != null) {
            this.fFloatingPane.toFront(dTClient, DTContainer.Scope.GROUP);
        }
        this.fFloatingPane.revalidate();
        this.fFloatingPane.repaint();
    }

    void minimizeDocuments() {
        if (this.fArrangement == 3) {
            this.fFloatingPane.minimizeAll();
        } else {
            this.setArrangement(3, null, false);
            int n = this.fDocuments.size();
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = this.fDocuments.get(i);
                DTFloatingLocation dTFloatingLocation = dTClient.getLastFloatingInLocation();
                if (dTFloatingLocation == null) {
                    dTFloatingLocation = (DTFloatingLocation)DTLocation.createMinimized(false);
                } else {
                    dTFloatingLocation.setMinimized(true);
                }
                this.fFloatingPane.add(dTClient, dTFloatingLocation);
            }
        }
    }

    void setBarPosition(int n) {
        if (n != this.fDocumentBarPosition) {
            if (n != -1 && n != 1 && n != 5 && n != 3 && n != 7) {
                throw new IllegalArgumentException("Invalid bar position " + n);
            }
            this.fDocumentBarPosition = n;
            MJAbstractAction mJAbstractAction = null;
            if (n == -1) {
                mJAbstractAction = this.fBarHideAction;
                this.fDocumentBar.setVisible(false);
            } else {
                int n2 = DTDocumentContainer.orientationForPosition(n);
                this.fDocumentBar.setOrientation(n2);
                switch (n) {
                    case 1: {
                        mJAbstractAction = this.fBarToNorthAction;
                        break;
                    }
                    case 5: {
                        mJAbstractAction = this.fBarToSouthAction;
                        break;
                    }
                    case 3: {
                        mJAbstractAction = this.fBarToEastAction;
                        break;
                    }
                    case 7: {
                        mJAbstractAction = this.fBarToWestAction;
                    }
                }
                this.fDocumentBar.setVisible(this.documentBarShouldBeVisible());
            }
            mJAbstractAction.setSelected(true);
            for (MJAbstractAction mJAbstractAction2 : this.fBarActions) {
                if (mJAbstractAction2 == mJAbstractAction) continue;
                mJAbstractAction2.setSelected(false);
            }
            this.revalidate();
            this.repaint();
        }
    }

    void setTopLeftToolBar(JToolBar jToolBar) {
        if (this.fTopLeftToolBar != null) {
            this.remove(this.fTopLeftToolBar);
        }
        this.fTopLeftToolBar = jToolBar;
        if (jToolBar != null) {
            this.addToolBar(jToolBar);
        }
        this.updateBlankPanel();
        this.revalidate();
        this.repaint();
    }

    void setTopRightToolBar(JToolBar jToolBar) {
        if (this.fTopRightToolBar != null) {
            this.remove(this.fTopRightToolBar);
        }
        this.fTopRightToolBar = jToolBar;
        if (jToolBar != null) {
            this.addToolBar(jToolBar);
        }
        this.updateBlankPanel();
        this.revalidate();
        this.repaint();
    }

    private void addToolBar(JToolBar jToolBar) {
        jToolBar.setBorder(new TopToolBarBorder());
        jToolBar.setFloatable(false);
        this.add(jToolBar);
    }

    private void updateBlankPanel() {
        if (this.fTopLeftToolBar != null || this.fTopRightToolBar != null) {
            if (this.fBlankPanel == null) {
                this.fBlankPanel = new MJPanel();
                this.fBlankPanel.setBorder(new TopToolBarBorder());
                this.add(this.fBlankPanel);
            }
        } else if (this.fBlankPanel != null) {
            this.remove(this.fBlankPanel);
            this.fBlankPanel = null;
        }
    }

    int getBarPosition() {
        return this.fDocumentBarPosition;
    }

    private int getDefaultBarPosition() {
        return DTDocumentContainer.getDefaultBarPosition(this.fDesktop.useToolstrip());
    }

    static int getDefaultBarPosition(boolean bl) {
        return bl ? 1 : 5;
    }

    public void doLayout() {
        Cloneable cloneable;
        Insets insets = this.getInsets();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        Dimension dimension = this.fDocumentBar.getPreferredSize();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.fTopLeftToolBar != null) {
            cloneable = this.fTopLeftToolBar.getPreferredSize();
            if (this.fDocumentBarPosition == 1) {
                cloneable.height = dimension.height;
            }
            this.fTopLeftToolBar.setBounds(insets.left, insets.top, cloneable.width, cloneable.height);
            n3 = cloneable.width;
            n5 = cloneable.height;
        }
        if (this.fTopRightToolBar != null) {
            cloneable = this.fTopRightToolBar.getPreferredSize();
            if (this.fDocumentBarPosition == 1) {
                cloneable.height = dimension.height;
            }
            this.fTopRightToolBar.setBounds(n - insets.right - cloneable.width, insets.top, cloneable.width, cloneable.height);
            n4 = cloneable.width;
            n5 = Math.max(cloneable.height, n5);
        }
        if (this.fBlankPanel != null) {
            if (this.fDocumentBarPosition != 1) {
                this.fBlankPanel.setBounds(insets.left + n3, insets.top, rectangle.width - n3 - n4, n5);
                rectangle.y += n5;
                rectangle.height -= n5;
            } else {
                this.fBlankPanel.setBounds(0, 0, 0, 0);
            }
        }
        cloneable = new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
        if (!this.fDocumentBar.isVisible()) {
            ((Rectangle)cloneable).x = n;
            ((Rectangle)cloneable).y = n2;
        } else {
            switch (this.fDocumentBarPosition) {
                case 1: {
                    ((Rectangle)cloneable).width = rectangle.width - n3 - n4;
                    rectangle.y += dimension.height;
                    rectangle.height -= dimension.height;
                    ((Rectangle)cloneable).x += n3;
                    break;
                }
                case 5: {
                    ((Rectangle)cloneable).width = rectangle.width;
                    ((Rectangle)cloneable).y = n2 - insets.bottom - dimension.height;
                    rectangle.height -= dimension.height;
                    break;
                }
                case 3: {
                    ((Rectangle)cloneable).height = rectangle.height;
                    ((Rectangle)cloneable).x = n - insets.right - dimension.width;
                    rectangle.width -= dimension.width;
                    break;
                }
                case 7: {
                    ((Rectangle)cloneable).height = rectangle.height;
                    rectangle.x += dimension.width;
                    rectangle.width -= dimension.width;
                }
            }
        }
        Object object = this.fHeavyPanel;
        if (!this.isHeavy()) {
            switch (this.fArrangement) {
                case 1: {
                    object = this.fMaximizedPane;
                    break;
                }
                case 3: {
                    object = this.fFloatingPane;
                    break;
                }
                case 2: {
                    object = this.fTiledPane;
                }
            }
        }
        ((Component)object).setBounds(rectangle);
        this.fDocumentBar.setBounds((Rectangle)cloneable);
    }

    boolean documentBarShouldBeVisible() {
        return this.fDocumentBarPosition != -1 && !this.fDocumentBar.isEmpty() && (this.fGroup == null || this.fGroup.showSingleEntryDocumentBar() || this.fArrangement == 3 || this.fDocuments.size() > 1 || this.fGroup.getNewAction() != null);
    }

    Rectangle getBarBounds() {
        if (this.fDocumentBarPosition == -1) {
            return new Rectangle();
        }
        return this.fDocumentBar.getBounds();
    }

    Insets getBarInsets() {
        Insets insets = this.getInsets();
        if (this.fDocumentBar.isVisible()) {
            switch (this.fDocumentBarPosition) {
                case 1: {
                    insets.top += this.fDocumentBar.getHeight();
                    break;
                }
                case 5: {
                    insets.bottom += this.fDocumentBar.getHeight();
                    break;
                }
                case 3: {
                    insets.right += this.fDocumentBar.getWidth();
                    break;
                }
                case 7: {
                    insets.left += this.fDocumentBar.getWidth();
                }
            }
        }
        return insets;
    }

    private static int orientationForPosition(int n) {
        return n == 1 || n == 5 ? 0 : 1;
    }

    final Action getBarToNorthAction() {
        return this.fBarToNorthAction;
    }

    final Action getBarToSouthAction() {
        return this.fBarToSouthAction;
    }

    final Action getBarToEastAction() {
        return this.fBarToEastAction;
    }

    final Action getBarToWestAction() {
        return this.fBarToWestAction;
    }

    final Action getBarHideAction() {
        return this.fBarHideAction;
    }

    String labelForPosition(int n) {
        switch (n) {
            case 1: {
                return this.getDesktop().getString("menuitem.North");
            }
            case 5: {
                return this.getDesktop().getString("menuitem.South");
            }
            case 3: {
                return this.getDesktop().getString("menuitem.East");
            }
            case 7: {
                return this.getDesktop().getString("menuitem.West");
            }
            case -1: {
                return this.getDesktop().getString("menuitem.Hide");
            }
        }
        return null;
    }

    private boolean needTopSeparator() {
        return this.fTopLeftToolBar == null && this.fTopRightToolBar == null || this.fGroup.getLocation() != null && this.fGroup.getLocation().isDocked();
    }

    void startBarDrag(Component component) {
        new BarDragger(component);
    }

    void addDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener == null) {
            this.fDropTargetListener = dropTargetListener;
            if (this.fMaximizedPane != null) {
                try {
                    this.fMaximizedPane.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
            if (this.fTiledPane != null) {
                try {
                    this.fTiledPane.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
            if (this.fFloatingPane != null) {
                try {
                    this.fFloatingPane.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
            if (this.fDocumentBar != null) {
                try {
                    this.fDocumentBar.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
        }
    }

    void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener != null) {
            if (this.fMaximizedPane != null) {
                this.fMaximizedPane.removeDropTargetListener(dropTargetListener);
            }
            if (this.fTiledPane != null) {
                this.fTiledPane.removeDropTargetListener(dropTargetListener);
            }
            if (this.fFloatingPane != null) {
                this.fFloatingPane.removeDropTargetListener(dropTargetListener);
            }
            if (this.fDocumentBar != null) {
                this.fDocumentBar.removeDropTargetListener(dropTargetListener);
            }
            this.fDropTargetListener = null;
        }
    }

    void addEmptyKeyListener(KeyListener keyListener) {
        this.fEmptyKeyListener = keyListener;
        if (this.fMaximizedPane != null) {
            this.fMaximizedPane.addKeyListener(this.fEmptyKeyListener);
        }
        if (this.fTiledPane != null) {
            this.fTiledPane.addKeyListener(this.fEmptyKeyListener);
        }
        if (this.fFloatingPane != null) {
            this.fFloatingPane.addKeyListener(this.fEmptyKeyListener);
        }
    }

    void removeEmptyKeyListener(KeyListener keyListener) {
        if (this.fMaximizedPane != null) {
            this.fMaximizedPane.removeKeyListener(keyListener);
        }
        if (this.fTiledPane != null) {
            this.fTiledPane.removeKeyListener(keyListener);
        }
        if (this.fFloatingPane != null) {
            this.fFloatingPane.removeKeyListener(keyListener);
        }
        if (keyListener == this.fEmptyKeyListener) {
            this.fEmptyKeyListener = null;
        }
    }

    public DropTarget getDropTarget() {
        switch (this.fArrangement) {
            case 1: {
                return this.fMaximizedPane.getDropTarget();
            }
            case 3: {
                return this.fFloatingPane.getDropTarget();
            }
            case 2: {
                return this.fTiledPane.getDropTarget();
            }
        }
        return null;
    }

    void startClientDrag(DTClient dTClient, Component component) {
        new DocumentDragger(dTClient, component);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof DTClient) {
            DTClient dTClient = (DTClient)propertyChangeEvent.getSource();
            boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
            if (this.fDocuments.contains(dTClient) && bl2) {
                if (this.fArrangement == 1 && this.fMaximizedPane.getMaximizedDocument() != dTClient) {
                    this.toFront(dTClient, DTContainer.Scope.FRAME);
                }
                this.fLastSelectedDocument = dTClient;
                this.setSelected(true, false);
                this.fDocumentBar.clientSelected(dTClient);
            }
        } else if (DTGroupProperty.SHOW_SINGLE_ENTRY_DOCUMENT_BAR.toString().equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() == this.fGroup && (bl = this.documentBarShouldBeVisible()) != this.fDocumentBar.isVisible()) {
            this.fDocumentBar.setVisible(bl);
            this.revalidate();
            this.repaint();
        }
    }

    DTClient getTopDocument() {
        switch (this.fArrangement) {
            case 1: {
                return this.fMaximizedPane.getMaximizedDocument();
            }
            case 3: {
                return this.fFloatingPane.getTopMost();
            }
            case 2: {
                return this.fTiledPane.getClientInSelectedTile();
            }
        }
        return null;
    }

    DTClient getMostRecentlySelected() {
        if (this.fLastSelectedDocument != null) {
            return this.fLastSelectedDocument;
        }
        DTClient dTClient = null;
        int n = -1;
        int n2 = this.fDocuments.size();
        for (int i = 0; i < n2; ++i) {
            DTClient dTClient2 = this.fDocuments.get(i);
            if (dTClient2.getSelectionOrder() <= n) continue;
            dTClient = dTClient2;
            n = dTClient2.getSelectionOrder();
        }
        return dTClient;
    }

    Iterator<DTGroup> getGroupIterator() {
        return this.fDocumentBar.getGroupIterator();
    }

    private MJDimensionPicker createDimensionPicker() {
        MJDimensionPicker mJDimensionPicker = new MJDimensionPicker();
        mJDimensionPicker.setOccupancy(this.fDocuments.size());
        mJDimensionPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJDimensionPicker mJDimensionPicker = (MJDimensionPicker)actionEvent.getSource();
                Dimension dimension = mJDimensionPicker.getSelectedSize();
                if (dimension.width == 1 && dimension.height == 1) {
                    DTDocumentContainer.this.setArrangement(1, null);
                } else {
                    DTDocumentContainer.this.setArrangement(2, dimension);
                }
                if (DTDocumentContainer.this.fFocusOwnerBeforePicker != null) {
                    DTDocumentContainer.this.fFocusOwnerBeforePicker.requestFocus();
                    DTDocumentContainer.this.fFocusOwnerBeforePicker = null;
                }
            }
        });
        return mJDimensionPicker;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fArrangement == 2) {
            DTClient dTClient = (DTClient)actionEvent.getSource();
            this.fTiledPane.toFront(dTClient, DTContainer.Scope.FRAME);
        }
    }

    Object getState() {
        return new State(this);
    }

    static Element stateToXML(Object object, Document document) {
        return ((State)object).toXML(document);
    }

    static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new State(simpleElement);
    }

    private static class State {
        boolean fWasShowing;
        boolean fWasEmpty;
        int fArrangement;
        int fDocumentBarPosition;
        int fMaxDocumentBarWidth;
        Object fTiledState;

        State(DTDocumentContainer dTDocumentContainer) {
            this.fArrangement = dTDocumentContainer.fArrangement;
            this.fWasEmpty = dTDocumentContainer.fWasEmpty;
            this.fWasShowing = dTDocumentContainer.fWasShowing;
            this.fDocumentBarPosition = dTDocumentContainer.fDocumentBarPosition;
            if (this.fDocumentBarPosition == dTDocumentContainer.getDefaultBarPosition()) {
                this.fDocumentBarPosition = -2;
            }
            this.fMaxDocumentBarWidth = dTDocumentContainer.fDocumentBar.getMaxWidth();
            if (this.fArrangement == 2) {
                this.fTiledState = dTDocumentContainer.fTiledPane.getState();
            }
        }

        State(SimpleElement simpleElement) throws DataFormatException {
            assert (DTDocumentContainer.DOCUMENT_AREA_TAG.equals(simpleElement.getTagName()));
            String string = simpleElement.getAttribute(DTDocumentContainer.SHOWING_ATTRIBUTE);
            this.fWasShowing = DTDocumentContainer.YES_VALUE.equalsIgnoreCase(string);
            string = simpleElement.getAttribute(DTDocumentContainer.EMPTY_ATTRIBUTE);
            this.fWasEmpty = DTDocumentContainer.YES_VALUE.equalsIgnoreCase(string);
            string = simpleElement.getAttribute(DTDocumentContainer.ARRANGEMENT_ATTRIBUTE);
            if (DTDocumentContainer.MAXIMIZED_VALUE.equalsIgnoreCase(string)) {
                this.fArrangement = 1;
            } else if (DTDocumentContainer.TILED_VALUE.equalsIgnoreCase(string)) {
                this.fArrangement = 2;
            } else if (DTDocumentContainer.FLOATING_VALUE.equalsIgnoreCase(string)) {
                this.fArrangement = 3;
            } else if (string == null || string.length() == 0) {
                this.fArrangement = 1;
            } else {
                throw new DataFormatException("Unrecognized Arrangement: " + string);
            }
            string = simpleElement.getAttribute(DTDocumentContainer.BAR_ATTRIBUTE);
            if (DTDocumentContainer.TOP_VALUE.equalsIgnoreCase(string)) {
                this.fDocumentBarPosition = 1;
            } else if (DTDocumentContainer.BOTTOM_VALUE.equalsIgnoreCase(string)) {
                this.fDocumentBarPosition = 5;
            } else if (DTDocumentContainer.LEFT_VALUE.equalsIgnoreCase(string)) {
                this.fDocumentBarPosition = 7;
            } else if (DTDocumentContainer.RIGHT_VALUE.equalsIgnoreCase(string)) {
                this.fDocumentBarPosition = 3;
            } else if (DTDocumentContainer.HIDE_VALUE.equalsIgnoreCase(string)) {
                this.fDocumentBarPosition = -1;
            } else if (string == null || string.length() == 0) {
                this.fDocumentBarPosition = -2;
            } else {
                throw new DataFormatException("Unrecognized Bar: " + string);
            }
            string = simpleElement.getAttribute(DTDocumentContainer.MAX_BAR_WIDTH_ATTRIBUTE);
            if (string != null && string.length() > 0) {
                try {
                    this.fMaxDocumentBarWidth = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid MaxBarWidth: " + string);
                }
            }
            if (this.fArrangement == 2) {
                SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName("Tiles");
                if (simpleNodeList.getLength() < 1) {
                    throw new DataFormatException("Missing Tiles");
                }
                SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(0);
                this.fTiledState = DTTiledPane.stateFromXML((SimpleElement)simpleElement2);
            }
        }

        public Element toXML(Document document) {
            Element element = document.createElement(DTDocumentContainer.DOCUMENT_AREA_TAG);
            element.setAttribute(DTDocumentContainer.SHOWING_ATTRIBUTE, this.fWasShowing ? DTDocumentContainer.YES_VALUE : DTDocumentContainer.NO_VALUE);
            element.setAttribute(DTDocumentContainer.EMPTY_ATTRIBUTE, this.fWasEmpty ? DTDocumentContainer.YES_VALUE : DTDocumentContainer.NO_VALUE);
            String string = null;
            switch (this.fArrangement) {
                case 1: {
                    string = DTDocumentContainer.MAXIMIZED_VALUE;
                    break;
                }
                case 2: {
                    string = DTDocumentContainer.TILED_VALUE;
                    break;
                }
                case 3: {
                    string = DTDocumentContainer.FLOATING_VALUE;
                }
            }
            element.setAttribute(DTDocumentContainer.ARRANGEMENT_ATTRIBUTE, string);
            string = null;
            switch (this.fDocumentBarPosition) {
                case 1: {
                    string = DTDocumentContainer.TOP_VALUE;
                    break;
                }
                case 5: {
                    string = DTDocumentContainer.BOTTOM_VALUE;
                    break;
                }
                case 3: {
                    string = DTDocumentContainer.RIGHT_VALUE;
                    break;
                }
                case 7: {
                    string = DTDocumentContainer.LEFT_VALUE;
                    break;
                }
                case -1: {
                    string = DTDocumentContainer.HIDE_VALUE;
                }
            }
            if (string != null) {
                element.setAttribute(DTDocumentContainer.BAR_ATTRIBUTE, string);
            }
            element.setAttribute(DTDocumentContainer.MAX_BAR_WIDTH_ATTRIBUTE, Integer.toString(this.fMaxDocumentBarWidth));
            if (this.fTiledState != null) {
                element.appendChild(DTTiledPane.stateToXML((Object)this.fTiledState, (Document)document));
            }
            return element;
        }
    }

    class PreviousDocumentAction
    extends MJAbstractAction {
        PreviousDocumentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ItemListener itemListener;
            DTSelectable dTSelectable = null;
            DTClient dTClient = null;
            Iterator<DTClient> iterator = DTDocumentContainer.this.fDocumentBar.getClientIterator();
            while (iterator.hasNext()) {
                itemListener = iterator.next();
                dTClient = itemListener;
                if (((DTClient)itemListener).isSelected()) break;
                dTSelectable = itemListener;
            }
            if (dTSelectable == null) {
                while (iterator.hasNext()) {
                    dTClient = iterator.next();
                }
                itemListener = (DTTabbedPane)((Object)SwingUtilities.getAncestorOfClass(DTTabbedPane.class, (Component)((Object)DTDocumentContainer.this)));
                if (itemListener != null) {
                    ((DTTabbedPane)itemListener).selectPreviousTab();
                    DTDocumentContainer.this.toFront(dTClient, DTContainer.Scope.FRAME);
                } else {
                    dTSelectable = dTClient;
                }
            }
            if (dTSelectable != null) {
                dTSelectable.setSelected(true);
            }
        }
    }

    class NextDocumentAction
    extends MJAbstractAction {
        NextDocumentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTSelectable dTSelectable;
            DTClient dTClient = null;
            Iterator<DTClient> iterator = DTDocumentContainer.this.fDocumentBar.getClientIterator();
            while (iterator.hasNext()) {
                dTSelectable = iterator.next();
                if (dTClient == null) {
                    dTClient = dTSelectable;
                }
                if (!((DTClient)dTSelectable).isSelected()) continue;
                break;
            }
            dTSelectable = null;
            if (iterator.hasNext()) {
                dTSelectable = iterator.next();
            } else {
                DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)SwingUtilities.getAncestorOfClass(DTTabbedPane.class, (Component)((Object)DTDocumentContainer.this)));
                if (dTTabbedPane != null) {
                    dTTabbedPane.selectNextTab();
                    DTDocumentContainer.this.toFront(dTClient, DTContainer.Scope.FRAME);
                } else {
                    dTSelectable = dTClient;
                }
            }
            if (dTSelectable != null) {
                dTSelectable.setSelected(true);
            }
        }
    }

    class MinimizeAllAction
    extends MJAbstractAction {
        public MinimizeAllAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.MinimizeAll"));
            if (DTDocumentContainer.this.fGroup != null && DTDocumentContainer.this.fGroup.getTitle() != null) {
                String string = DTDocumentContainer.this.fGroup.getTitle();
                Object[] objectArray = new Object[]{string};
                String string2 = string.charAt(string.length() - 1) == 's' ? "action.MinimizeThese" : "action.MinimizeTheseDocuments";
                this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString(string2), objectArray));
            }
            this.setComponentName("MinimizeAll");
            DTMenuMergeTag.MINIMIZE.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.minimizeDocuments();
        }
    }

    class CascadeAction
    extends MJAbstractAction {
        public CascadeAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Cascade"));
            if (DTDocumentContainer.this.fGroup != null && DTDocumentContainer.this.fGroup.getTitle() != null) {
                String string = DTDocumentContainer.this.fGroup.getTitle();
                Object[] objectArray = new Object[]{string};
                String string2 = string.charAt(string.length() - 1) == 's' ? "action.CascadeThese" : "action.CascadeTheseDocuments";
                this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString(string2), objectArray));
            }
            this.setComponentName("Cascade");
            DTMenuMergeTag.CASCADE.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.cascadeDocuments();
        }
    }

    class CloseSelectAction
    extends MJAbstractAction
    implements TargetedAction {
        final DTClient iDefaultDocument;

        public CloseSelectAction(DTClient dTClient) {
            super(DTDocumentContainer.this.getDesktop().getString("action.CloseSelect"));
            this.setComponentName("CloseSelect");
            DTMenuMergeTag.CLOSE_SELECT.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
            this.iDefaultDocument = dTClient;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<DTClient> list = this.getCloseableDocuments();
            DTClient dTClient = null;
            if (this.iDefaultDocument != null) {
                dTClient = this.iDefaultDocument;
            } else {
                for (DTClient dTClient2 : list) {
                    if (dTClient != null || !dTClient2.isSelected()) continue;
                    dTClient = dTClient2;
                }
            }
            List<DTClient> list2 = dTClient == null ? Collections.EMPTY_LIST : Collections.singletonList(dTClient);
            DTCloseDialog.show(DTDocumentContainer.this.getDesktop(), (Component)((Object)DTDocumentContainer.this), list, list2);
        }

        List<DTClient> getCloseableDocuments() {
            ArrayList<DTClient> arrayList = new ArrayList<DTClient>(DTDocumentContainer.this.fDocuments.size());
            Iterator<DTClient> iterator = DTDocumentContainer.this.fDocumentBar.getClientIterator();
            while (iterator.hasNext()) {
                DTClient dTClient = iterator.next();
                if (!dTClient.permitUserClose()) continue;
                arrayList.add(dTClient);
            }
            return arrayList;
        }

        @Override
        public boolean hasAnyTargets() {
            return this.getCloseableDocuments().size() > 0;
        }
    }

    class CloseAllExceptAction
    extends MJAbstractAction
    implements TargetedAction {
        private DTClient iDocumentToKeep;

        public CloseAllExceptAction(DTClient dTClient) {
            this.iDocumentToKeep = dTClient;
            Object[] objectArray = new Object[]{dTClient.getShortTitle()};
            this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString("action.CloseAllExcept"), objectArray));
            this.setComponentName("CloseAllExcept");
            DTMenuMergeTag.CLOSE_ALL_EXCEPT.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.getCloseAllExceptTransaction(this.iDocumentToKeep).start();
        }

        @Override
        public boolean hasAnyTargets() {
            return DTDocumentContainer.this.getCloseAllExceptTransaction((DTClient)this.iDocumentToKeep).fClosers.size() > 0;
        }
    }

    class CloseAllAction
    extends MJAbstractAction
    implements TargetedAction {
        public CloseAllAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.CloseDocuments"));
            if (DTDocumentContainer.this.fGroup != null && DTDocumentContainer.this.fGroup.getTitle() != null) {
                String string = DTDocumentContainer.this.fGroup.getTitle();
                Object[] objectArray = new Object[]{string};
                String string2 = string.charAt(string.length() - 1) == 's' ? "action.CloseThese" : "action.CloseTheseDocuments";
                this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString(string2), objectArray));
            }
            this.setComponentName("CloseDocuments");
            DTMenuMergeTag.CLOSE_ALL.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.getCloseAllTransaction().start();
        }

        @Override
        public boolean hasAnyTargets() {
            return DTDocumentContainer.this.getCloseAllTransaction().fClosers.size() > 0;
        }
    }

    class MaximizeAction
    extends MJAbstractAction {
        public MaximizeAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Maximize"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/mdimax.gif")));
            this.setComponentName("Maximize");
            DTMenuMergeTag.MAXIMIZE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(1, null);
        }
    }

    class FloatAction
    extends MJAbstractAction {
        public FloatAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Float"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/float.gif")));
            this.setComponentName("Float");
            DTMenuMergeTag.FLOAT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(3, null);
        }
    }

    class SplitNorthSouthAction
    extends MJAbstractAction {
        public SplitNorthSouthAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.SplitNorthSouth"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/splitnorthsouth.gif")));
            this.setComponentName("SplitTopBottom");
            DTMenuMergeTag.TOP_BOTTOM_SPLIT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(2, new Dimension(1, 2), true, false);
        }
    }

    class SplitEastWestAction
    extends MJAbstractAction {
        public SplitEastWestAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.SplitEastWest"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/spliteastwest.gif")));
            this.setComponentName("SplitLeftRight");
            DTMenuMergeTag.LEFT_RIGHT_SPLIT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(2, new Dimension(2, 1), true, false);
        }
    }

    class TileSelectAction
    extends MJAbstractAction {
        public TileSelectAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.TileSelect"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/tile.gif")));
            this.setComponentName("TileSelect");
            DTMenuMergeTag.TILE_SELECT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<DTClient> arrayList = new ArrayList<DTClient>(DTDocumentContainer.this.fDocuments.size());
            Object object = DTDocumentContainer.this.fDocumentBar.getClientIterator();
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
            object = new ArrayList();
            switch (DTDocumentContainer.this.fArrangement) {
                case 1: {
                    if (DTDocumentContainer.this.fMaximizedPane.getMaximizedDocument() == null) break;
                    object.add(DTDocumentContainer.this.fMaximizedPane.getMaximizedDocument());
                    break;
                }
                case 3: {
                    if (DTDocumentContainer.this.fFloatingPane.getTopMost() == null) break;
                    object.add(DTDocumentContainer.this.fFloatingPane.getTopMost());
                    break;
                }
                case 2: {
                    for (int i = 0; i < DTDocumentContainer.this.fTiledPane.getTileCount(); ++i) {
                        DTClient dTClient = DTDocumentContainer.this.fTiledPane.getClientInTile(i);
                        if (dTClient == null) continue;
                        object.add(dTClient);
                    }
                    break;
                }
            }
            DTTileDialog.show(DTDocumentContainer.this, arrayList, (List)object);
        }
    }

    class TileAction
    extends MJAbstractAction {
        boolean iIsPickerShowing;

        public TileAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Tile"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/tile.gif")));
            this.setComponentName("TileDocuments");
            DTMenuMergeTag.TILE.setTag((Action)((Object)this));
            this.putValue("PopupListener", new PopupListener(){

                public void onPopupEvent(final JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                    MJDimensionPicker mJDimensionPicker = DTDocumentContainer.this.createDimensionPicker();
                    mJDimensionPicker.setAutoGrowEnabled(false);
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            OverlayManagers.get((Component)jComponent).removePopups();
                        }
                    };
                    mJDimensionPicker.addActionListener(actionListener);
                    mJDimensionPicker.addCancelationListener(actionListener);
                    popupCallback.show((JComponent)mJDimensionPicker);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JComboBox && !this.iIsPickerShowing) {
                this.showPicker((Component)actionEvent.getSource());
            }
        }

        void buttonPressed(Component component) {
            this.showPicker(component);
        }

        void showPicker(Component component) {
            this.iIsPickerShowing = true;
            Window window = SwingUtilities.windowForComponent(component);
            DTDocumentContainer.this.fFocusOwnerBeforePicker = window.getFocusOwner();
            MJDimensionPicker mJDimensionPicker = DTDocumentContainer.this.createDimensionPicker();
            mJDimensionPicker.setAutoGrowEnabled(true);
            mJDimensionPicker.show(component, 0, component.getHeight());
            mJDimensionPicker.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    DTDocumentContainer.this.updateArrangementActions();
                    TileAction.this.iIsPickerShowing = false;
                    if (DTDocumentContainer.this.fFocusOwnerBeforePicker != null) {
                        DTDocumentContainer.this.fFocusOwnerBeforePicker.requestFocus();
                        DTDocumentContainer.this.fFocusOwnerBeforePicker = null;
                    }
                }
            });
        }
    }

    class BackgroundMouseListener
    extends MouseAdapter {
        BackgroundMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTDocumentContainer.this.setSelected(true, DTDocumentContainer.this.fArrangement != 3);
        }
    }

    class TileMenuListener
    implements MenuListener {
        MJDimensionPicker fPicker;
        Dimension fSize;

        TileMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.fPicker == null) {
                this.fPicker = DTDocumentContainer.this.createDimensionPicker();
                this.fPicker.setAutoGrowEnabled(true);
                this.fSize = this.fPicker.getPreferredSize();
                Insets insets = jMenu.getPopupMenu().getInsets();
                this.fSize.width += insets.left + insets.right;
                this.fSize.height += insets.top + insets.bottom;
                jMenu.add((Component)this.fPicker);
                this.fPicker.setInvokingMenu(jMenu);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.fPicker != null) {
                this.fPicker.setInvokingMenu(null);
                jMenu.remove((Component)this.fPicker);
                jMenu.getPopupMenu().setSize(this.fSize);
                this.fPicker = null;
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }
    }

    class DocumentDragger
    extends DTDragger {
        DTClient fDocument;

        DocumentDragger(DTClient dTClient, Component component) {
            super(dTClient, component);
            this.fDocument = dTClient;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            Container container = DTDocumentContainer.this.getParent();
            point = SwingUtilities.convertPoint(component, point, container);
            DTDropTarget dTDropTarget = this.fTarget;
            this.fTarget = null;
            if (DTDocumentContainer.this.getBounds().contains(point)) {
                switch (DTDocumentContainer.this.fArrangement) {
                    case 1: {
                        this.fTarget = DTDocumentContainer.this.fMaximizedPane;
                        break;
                    }
                    case 2: {
                        this.fTarget = DTDocumentContainer.this.fTiledPane;
                        break;
                    }
                    case 3: {
                        this.fTarget = DTDocumentContainer.this.fFloatingPane;
                    }
                }
            } else if (this.fDocument.permitUserUndock() && (point.x < 0 || point.y < 0 || point.x > container.getWidth() || point.y > container.getHeight())) {
                if (this.fExternalTarget == null) {
                    this.fExternalTarget = new DTExternalTarget(DTDocumentContainer.this.getDesktop(), this.fDocument);
                }
                this.fTarget = this.fExternalTarget;
            }
            if (this.fTarget == null) {
                component.setCursor(DragSource.DefaultMoveNoDrop);
                if (dTDropTarget != null && this.fDropLocation != null) {
                    DTDragUtilities.getDropOutlinePainter().hide(false);
                    DTDragUtilities.showHint(this.fFrame, DTDocumentContainer.this.getDesktop().getString("status.MoveDocumentElsewhere"));
                    this.fDropLocation = null;
                }
            } else {
                component.setCursor(this.fSaveCursor);
                if (this.fTarget instanceof Component) {
                    point = SwingUtilities.convertPoint(container, point, (Component)((Object)this.fTarget));
                } else {
                    SwingUtilities.convertPointToScreen(point, container);
                }
                DTLocation dTLocation = this.fPreviousLocation;
                this.fPreviousLocation = this.fDropLocation;
                this.fDropLocation = dTLocation;
                this.fDropLocation = this.fTarget.getDropLocation(this.fDocument, point.x, point.y, this.fDropLocation);
                if (!(this.fPreviousLocation == this.fDropLocation || this.fDropLocation != null && this.fDropLocation.equals(this.fPreviousLocation))) {
                    if (dTDropTarget != null) {
                        DTDragUtilities.getDropOutlinePainter().hide(false);
                    }
                    this.fTarget.drawDropOutline(this.fDropLocation);
                    String string = this.fTarget.getDropHint(this.fDocument, this.fDropLocation);
                    DTDragUtilities.showHint(this.fFrame, string);
                }
            }
        }
    }

    class BarDragger
    extends MouseInputAdapter {
        int iLastBarPosition;

        BarDragger(Component component) {
            this.iLastBarPosition = DTDocumentContainer.this.fDocumentBarPosition;
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n = this.getBarPosition(point = SwingUtilities.convertPoint(component, point, (Component)((Object)DTDocumentContainer.this)));
            if (n != DTDocumentContainer.this.fDocumentBarPosition) {
                DTDocumentContainer.this.setBarPosition(n);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupSuccesor((MouseEvent)mouseEvent)) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            DTDocumentContainer.this.fDocumentBar.barDragEnded();
            DTDocumentContainer.this.fDocumentBar.revalidate();
            DTDocumentContainer.this.fDocumentBar.repaint();
        }

        int getBarPosition(Point point) {
            boolean bl;
            int n;
            int n2;
            int n3 = DTDocumentContainer.this.getHeight();
            int n4 = n3 * point.x;
            boolean bl2 = n4 > (n2 = (n = DTDocumentContainer.this.getWidth()) * point.y);
            boolean bl3 = bl = n4 < n3 * n - n2;
            if (bl2) {
                return bl ? 1 : 3;
            }
            return bl ? 7 : 5;
        }
    }

    class TopToolBarBorder
    extends DTBorderFactory.TopSeparatorBorder {
        TopToolBarBorder() {
        }

        @Override
        protected boolean needSeparator(Component component) {
            return DTDocumentContainer.this.needTopSeparator();
        }
    }

    class DocumentBarBorder
    extends AbstractBorder {
        DocumentBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 0;
            insets.bottom = 0;
            insets.right = 0;
            insets.left = 0;
            boolean bl = DTDocumentContainer.this.fFrame != DTDocumentContainer.this.fDesktop.getMainFrame();
            switch (DTDocumentContainer.this.fDocumentBarPosition) {
                case 1: {
                    if (!DTDocumentContainer.this.needTopSeparator()) break;
                    insets.top = 2;
                    break;
                }
                case 5: {
                    if (!bl) break;
                    insets.bottom = 2;
                    break;
                }
                case 3: {
                    insets.top = 1;
                    insets.left = 5;
                    if (!bl) break;
                    insets.bottom = 1;
                    break;
                }
                case 7: {
                    insets.top = 1;
                    insets.right = 5;
                    if (!bl) break;
                    insets.bottom = 1;
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            boolean bl = DTDocumentContainer.this.fFrame != DTDocumentContainer.this.fDesktop.getMainFrame();
            switch (DTDocumentContainer.this.fDocumentBarPosition) {
                case 1: {
                    if (!DTDocumentContainer.this.needTopSeparator()) break;
                    graphics.setColor(UIManager.getColor("controlShadow"));
                    graphics.drawLine(n, n2, n + n3 - 1, n2);
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n, n2 + 1, n + n3 - 1, n2 + 1);
                    break;
                }
                case 5: {
                    if (DTDocumentContainer.this.fFrame == DTDocumentContainer.this.fDesktop.getMainFrame()) break;
                    graphics.setColor(UIManager.getColor("controlShadow"));
                    graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    break;
                }
                case 3: {
                    graphics.setColor(UIManager.getColor("controlShadow"));
                    graphics.drawLine(n + 4, n2, n + n3 - 1, n2);
                    graphics.drawLine(n + 4, n2, n + 4, n2 + n4 - 1);
                    if (!bl) break;
                    graphics.drawLine(n + 4, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    break;
                }
                case 7: {
                    graphics.setColor(UIManager.getColor("controlShadow"));
                    graphics.drawLine(n, n2, n + n3 - 5, n2);
                    graphics.drawLine(n + n3 - 5, n2, n + n3 - 5, n2 + n4 - 1);
                    if (!bl) break;
                    graphics.drawLine(n, n2 + n4 - 1, n + n3 - 5, n2 + n4 - 1);
                }
            }
            graphics.setColor(color);
        }
    }

    private class MoveBarAction
    extends MJAbstractAction {
        int fPosition;

        public MoveBarAction(int n) {
            super(DTDocumentContainer.this.labelForPosition(n));
            this.fPosition = n;
            this.setSelected(n == DTDocumentContainer.this.getBarPosition());
            this.setComponentName(DTDocumentContainer.BAR_ATTRIBUTE + this.getName());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setBarPosition(this.fPosition);
            this.setSelected(this.fPosition == DTDocumentContainer.this.fDocumentBarPosition);
        }
    }

    private class RepaintWhenDoneListener
    implements DTCloseTransaction.DoneListener {
        private RepaintWhenDoneListener() {
        }

        @Override
        public void closeTransactionDone(boolean bl) {
            if (bl) {
                DTDocumentContainer.this.repaint();
            }
        }
    }

    private class FocusRequestor
    implements Runnable {
        private int iAttemptsRemaining = 3;

        private FocusRequestor() {
        }

        @Override
        public void run() {
            if (!DTDocumentContainer.this.requestFocusInWindow() && --this.iAttemptsRemaining > 0) {
                EventQueue.invokeLater(this);
            }
        }
    }

    static interface ArrangementListener {
        public void arrangementChanged(DTDocumentContainer var1, int var2, int var3);
    }
}

