/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuContributor;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTNestingContainer;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.desk.DTToolBarContainer;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

abstract class DTInternalFrame
extends MJPanel
implements DTContainer,
DTSelectable,
ItemSelectable,
PropertyChangeListener,
DTMenuContributor {
    protected JComponent fRootPane;
    protected DTTitleBar fTitleBar;
    protected JComponent fContentPane;
    protected DTToolBarContainer fToolBarContainer;
    protected JComponent fControlPalette;
    protected boolean fTitleBarCloseAllowed = true;
    protected boolean fTitleBarMinimizeAllowed = true;
    protected boolean fTitleBarMaximizeAllowed = true;
    protected boolean fTitleBarDragAllowed = true;
    private Border fBorder;
    private boolean fIsSelected;
    private boolean fIsTitleBarVisible;
    private boolean fIsBorderVisible;
    private ItemListener fSelectionListener;
    private TitleDragDetector fTitleDragDetector;

    public DTInternalFrame() {
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.fRootPane = new RootPane();
        this.fRootPane.setLayout(null);
        this.fContentPane = new JPanel();
        this.fContentPane.setLayout(new BorderLayout());
        this.fRootPane.add(this.fContentPane);
        this.add(this.fRootPane, "Center");
        this.fToolBarContainer = new DTToolBarContainer();
        this.fContentPane.add((Component)((Object)this.fToolBarContainer), "North");
        this.fContentPane.addMouseListener(new MouseAdapter(){});
        this.fContentPane.setFocusTraversalPolicy(new CustomTraversalPolicy());
        this.fContentPane.setFocusCycleRoot(true);
    }

    public abstract DTOccupant getOccupant();

    abstract DTClient getTopClient();

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.add(this.fSelectionListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.remove(this.fSelectionListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = null;
        if (this.fIsSelected) {
            objectArray = new Object[]{this};
        }
        return objectArray;
    }

    DTTitleBar getTitleBar() {
        if (this.fTitleBar == null) {
            this.fTitleBar = this.createTitleBar();
            this.configureTitleBar(this.fTitleBar);
            this.add(this.fTitleBar, "North");
        }
        return this.fTitleBar;
    }

    protected DTTitleBar createTitleBar() {
        if (this.getOccupant() == null) {
            return null;
        }
        Action action = this.getTitleBarUndockAction();
        Action action2 = this.getTitleBarCloseAction();
        Action action3 = this.getTitleBarMinimizeAction();
        Action action4 = this.getTitleBarMaximizeAction();
        return new DTTitleBar(action, action3, action4, action2, true, false, this.getOccupant().getDesktop().useToolstrip(), this.getOccupant().getName());
    }

    protected void configureTitleBar(DTTitleBar dTTitleBar) {
        dTTitleBar.setIsDocked(true);
        dTTitleBar.addMouseListener(new TitleMouseListener());
        if (this.fTitleBarDragAllowed) {
            if (this.fTitleDragDetector == null) {
                this.fTitleDragDetector = new TitleDragDetector();
            }
            dTTitleBar.addMouseListener((MouseListener)((Object)this.fTitleDragDetector));
            dTTitleBar.addMouseMotionListener((MouseMotionListener)((Object)this.fTitleDragDetector));
        }
        dTTitleBar.setActive(this.fIsSelected);
        dTTitleBar.setVisible(this.fIsTitleBarVisible);
        dTTitleBar.setShowActionMenu(this.getOccupant().getDesktop().condenseTitleActions() && this.getOccupant().isSingleton());
    }

    protected Action getTitleBarCloseAction() {
        return this.fTitleBarCloseAllowed && this.getOccupant() != null && this.getOccupant().permitUserClose() ? this.getOccupant().getCloseAction() : null;
    }

    protected Action getTitleBarUndockAction() {
        return this.getOccupant() != null && this.getOccupant().permitUserUndock() ? this.getOccupant().getUndockAction() : null;
    }

    protected Action getTitleBarMinimizeAction() {
        return this.fTitleBarMinimizeAllowed && this.getOccupant() != null && this.getOccupant().permitUserMinimize() ? this.getOccupant().getMinimizeAction() : null;
    }

    protected Action getTitleBarMaximizeAction() {
        return this.fTitleBarMaximizeAllowed && this.getOccupant() != null && this.getOccupant().permitUserMaximize() ? this.getOccupant().getMaximizeAction() : null;
    }

    void setTitleBarCloseAllowed(boolean bl) {
        this.fTitleBarCloseAllowed = bl;
        if (this.fTitleBar != null) {
            this.fTitleBar.setCloseListener(this.getTitleBarCloseAction());
        }
    }

    void setTitleBarMinimizeAllowed(boolean bl) {
        this.fTitleBarMinimizeAllowed = bl;
        if (this.fTitleBar != null) {
            this.fTitleBar.setMinimizeListener(this.getTitleBarMinimizeAction());
        }
    }

    void setTitleBarMaximizeAllowed(boolean bl) {
        this.fTitleBarMaximizeAllowed = bl;
        if (this.fTitleBar != null) {
            this.fTitleBar.setMaximizeListener(this.getTitleBarMaximizeAction(), this.getOccupant() != null && this.getOccupant().getLocation() != null && this.getOccupant().getLocation().isMaximized());
        }
    }

    void promoteTitleBarRestore(boolean bl) {
        if (this.fTitleBar != null) {
            this.fTitleBar.setPromoteRestore(bl);
        }
    }

    void setTitleBarDragAllowed(boolean bl) {
        if (this.fTitleBar == null || bl == this.fTitleBarDragAllowed) {
            return;
        }
        if (bl) {
            if (this.fTitleDragDetector == null) {
                this.fTitleDragDetector = new TitleDragDetector();
            }
            this.fTitleBar.addMouseListener((MouseListener)((Object)this.fTitleDragDetector));
            this.fTitleBar.addMouseMotionListener((MouseMotionListener)((Object)this.fTitleDragDetector));
            this.fTitleDragDetector.setEnabled(true);
        } else if (this.fTitleDragDetector != null) {
            this.fTitleBar.removeMouseListener((MouseListener)((Object)this.fTitleDragDetector));
            this.fTitleBar.removeMouseMotionListener((MouseMotionListener)((Object)this.fTitleDragDetector));
            this.fTitleDragDetector.setEnabled(false);
        }
        this.fTitleBarDragAllowed = bl;
    }

    DTTitleBar borrowTitleBar() {
        DTTitleBar dTTitleBar = this.getTitleBar();
        this.remove(dTTitleBar);
        return dTTitleBar;
    }

    void returnTitleBar(DTTitleBar dTTitleBar) {
        assert (dTTitleBar == null || dTTitleBar == this.fTitleBar);
        this.add(this.fTitleBar, "North");
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl != this.fIsSelected) {
            this.fIsSelected = bl;
            if (this.fTitleBar != null) {
                this.fTitleBar.setActive(bl);
            }
            if (this.getBorder() instanceof DTBorderFactory.SelectionDependent) {
                this.repaint();
            }
            if (this.fSelectionListener != null) {
                int n = bl ? 1 : 2;
                ItemEvent itemEvent = new ItemEvent(this, 701, this, n);
                this.fSelectionListener.itemStateChanged(itemEvent);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.fIsSelected;
    }

    @Override
    public boolean isConsideringSelection() {
        DTOccupant dTOccupant = this.getOccupant();
        return dTOccupant != null && dTOccupant.isConsideringSelection();
    }

    @Override
    public void setConsideringSelection(boolean bl) {
        DTOccupant dTOccupant = this.getOccupant();
        if (dTOccupant != null) {
            dTOccupant.setConsideringSelection(bl);
        }
    }

    void setDockListener(ActionListener actionListener) {
        this.getTitleBar().setDockListener(actionListener, false);
    }

    void setUndockListener(ActionListener actionListener) {
        this.getTitleBar().setDockListener(actionListener, true);
    }

    void setMinimizeListener(ActionListener actionListener) {
        this.getTitleBar().setMinimizeListener(actionListener);
    }

    void setMaximizeListener(ActionListener actionListener) {
        this.getTitleBar().setMaximizeListener(actionListener, false);
    }

    void setRestoreListener(ActionListener actionListener) {
        this.getTitleBar().setMaximizeListener(actionListener, true);
    }

    void setCloseListener(ActionListener actionListener) {
        this.getTitleBar().setCloseListener(actionListener);
    }

    void setTitleBarVisible(boolean bl) {
        if (this.fIsTitleBarVisible != bl) {
            this.fIsTitleBarVisible = bl;
            if (bl || this.fTitleBar != null) {
                this.getTitleBar().setVisible(bl);
            }
        }
    }

    boolean isTitleBarVisible() {
        return this.fIsTitleBarVisible;
    }

    void setBorderVisible(boolean bl) {
        if (this.fIsBorderVisible != bl) {
            this.fIsBorderVisible = bl;
            if (bl) {
                this.setBorder(this.fBorder);
            } else {
                this.setBorder(null);
            }
        }
    }

    boolean isBorderVisible() {
        return this.fIsBorderVisible;
    }

    void setBorderType(boolean bl) {
        Border border;
        Boolean bl2 = this.getOccupant().getDesktop().useToolstrip();
        Border border2 = border = bl ? DTBorderFactory.createFrameBorder(bl2) : DTBorderFactory.createDockedFrameBorder(bl2);
        if (border != this.fBorder) {
            this.fBorder = border;
            if (this.fIsBorderVisible) {
                this.setBorder(this.fBorder);
            }
        }
    }

    boolean hasToolBar() {
        return this.fToolBarContainer.getComponentCount() > 0;
    }

    boolean isAnyToolBarVisible() {
        return this.fToolBarContainer.isAnyToolBarVisible();
    }

    protected void addToolBar(JToolBar jToolBar, String string, String string2) {
        if (jToolBar != null) {
            this.fToolBarContainer.addToolBar(jToolBar, string, string2);
        }
    }

    protected void removeToolBars() {
        this.fToolBarContainer.removeAllToolBars();
        this.fToolBarContainer.setToolBarAlternative(null);
    }

    DTToolBarContainer getToolBarContainer() {
        return this.fToolBarContainer;
    }

    void addControlPalette(JComponent jComponent) {
        this.fControlPalette = jComponent;
        this.fRootPane.add((Component)jComponent, JLayeredPane.PALETTE_LAYER);
    }

    void removeControlPalette() {
        if (this.fControlPalette != null) {
            this.fRootPane.remove(this.fControlPalette);
            this.fControlPalette = null;
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(DTTitleBar.SIZING_MINIMUM);
        if (this.fTitleBar != null) {
            dimension.height = this.fTitleBar.getMinimumSize().height + this.getInsets().top;
        }
        return dimension;
    }

    Dimension getMinimumVisibleSize() {
        Dimension dimension = this.getTitleBar().getMinimumSize();
        dimension.width = 100;
        dimension.height = (int)((double)dimension.height + this.getToolBarContainer().getPreferredSize().getHeight());
        dimension.height += 25;
        return dimension;
    }

    Insets getDecorationInsets() {
        Border border = this.getBorder();
        Insets insets = this.isBorderVisible() && border != null ? border.getBorderInsets((Component)((Object)this)) : new Insets(0, 0, 0, 0);
        DTTitleBar dTTitleBar = this.getTitleBar();
        if (this.isTitleBarVisible() && dTTitleBar != null) {
            insets.top += dTTitleBar.getPreferredSize().height;
        }
        return insets;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() != this.getOccupant()) {
            return;
        }
        if (this.fTitleBar == null) {
            return;
        }
        if ("Occupant Considering Selection".equals(propertyChangeEvent.getPropertyName())) {
            this.fTitleBar.setConsideringActivation((Boolean)propertyChangeEvent.getNewValue());
            this.revalidate();
            this.repaint();
        } else if (DTProperty.PERMIT_USER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.fTitleBar.setCloseListener(this.getTitleBarCloseAction());
        } else if (DTProperty.PERMIT_USER_UNDOCK.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.fTitleBar.setDockListener(this.getTitleBarUndockAction(), true);
        } else if (DTProperty.PERMIT_USER_MINIMIZE.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.fTitleBar.setMinimizeListener(this.getTitleBarMinimizeAction());
        } else if (DTProperty.PERMIT_USER_MAXIMIZE.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.fTitleBar.setMaximizeListener(this.getTitleBarMaximizeAction(), this.getOccupant().getLocation() != null && this.getOccupant().getLocation().isMaximized());
        }
    }

    @Override
    public void contributeToMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        if (this.getOccupant().getDesktop().condenseTitleActions() && Prefs.getBooleanPref((String)"GeneralEnableAccessibilityFeatures", (boolean)false)) {
            MJAbstractAction object4;
            MJAbstractAction mJAbstractAction = this.getOccupant().getMoveAction();
            if (mJAbstractAction.isEnabled()) {
                jPopupMenu.add((Action)mJAbstractAction);
            }
            if ((object4 = this.getOccupant().getResizeAction()).isEnabled()) {
                jPopupMenu.add((Action)object4);
            }
        }
        if (this.getOccupant().isSingleton()) {
            int n = 0;
            JMenu jMenu = this.getOccupant().getContextMenu();
            if (jMenu != null) {
                JMenu jMenu2 = DTMenu.clone(jMenu);
                jMenu2.addSeparator();
                for (Component component : jMenu2.getMenuComponents()) {
                    jPopupMenu.add(component, n);
                    ++n;
                }
            }
            if (this.getOccupant().getDesktop().useToolstrip() && this.getOccupant() instanceof DTClient) {
                Action action;
                Action action2;
                List<Action> list = ((DTClient)this.getOccupant()).getContextActions();
                Action action3 = DTInternalFrame.findActionByTag(list, DTMenuMergeTag.SELECT_ALL);
                if (action3 != null) {
                    jPopupMenu.add((Component)new MJMenuItem(action3), n++);
                }
                if ((action2 = DTInternalFrame.findActionByTag(list, DTMenuMergeTag.FIND)) != null) {
                    jPopupMenu.add((Component)new MJMenuItem(action2), n++);
                }
                if (action3 != null || action2 != null) {
                    jPopupMenu.insert(new JPopupMenu.Separator(), n++);
                }
                if ((action = DTInternalFrame.findActionByTag(list, DTMenuMergeTag.PRINT)) != null) {
                    Action action4;
                    jPopupMenu.add((Component)new MJMenuItem(action), n++);
                    Action action5 = DTInternalFrame.findActionByTag(list, DTMenuMergeTag.PRINT_SELECTION);
                    if (action5 != null) {
                        jPopupMenu.add((Component)new MJMenuItem(action5), n++);
                    }
                    if ((action4 = DTInternalFrame.findActionByTag(list, DTMenuMergeTag.PAGE_SETUP)) != null) {
                        jPopupMenu.add((Component)new MJMenuItem(action4), n++);
                    }
                    jPopupMenu.insert(new JPopupMenu.Separator(), n);
                }
            }
        }
        if (this.fToolBarContainer.offerToggles() && this.fToolBarContainer.getToolBarCount() > 0) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            for (Action action : this.fToolBarContainer.getContextToggleActions()) {
                jPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem(action));
            }
        }
    }

    private static Action findActionByTag(List<Action> list, DTMenuMergeTag dTMenuMergeTag) {
        for (Action action : list) {
            if (DTMenuMergeTag.getTag(action) != dTMenuMergeTag && !dTMenuMergeTag.toString().equals(ContextTargetingManager.getToolName((Action)action))) continue;
            return action;
        }
        return null;
    }

    private static boolean hasDescendantOfClass(Container container, Class<?> clazz, int n) {
        return DTInternalFrame.getDescendantOfClass(container, clazz, n) != null;
    }

    private static Component getDescendantOfClass(Container container, Class<?> clazz, int n) {
        for (Component component : container.getComponents()) {
            Component component2;
            if (clazz.isInstance(component) && component.isVisible()) {
                return component;
            }
            if (n < 0 || !(component instanceof Container) || (component2 = DTInternalFrame.getDescendantOfClass((Container)component, clazz, n - 1)) == null) continue;
            return component2;
        }
        return null;
    }

    private class TitleDragDetector
    extends DTDragDetector {
        private boolean fFloatingDrag;
        private boolean fIsEnabled = true;

        private TitleDragDetector() {
        }

        @Override
        protected Object getLoad(MouseEvent mouseEvent) {
            return DTInternalFrame.this.getOccupant();
        }

        @Override
        protected void startDrag(MouseEvent mouseEvent) {
            DTOccupant dTOccupant;
            if (this.fLoad instanceof DTClient && (dTOccupant = (DTClient)this.fLoad).getLocation() instanceof DTFloatingLocation && !dTOccupant.getLocation().isMaximized()) {
                this.fFloatingDrag = true;
                return;
            }
            dTOccupant = (DTOccupant)this.fLoad;
            DTLocation dTLocation = dTOccupant.getLocation();
            DTContainer dTContainer = dTLocation.getContainer();
            if (dTContainer instanceof DTNestingContainer) {
                ((DTNestingContainer)dTContainer).startDrag(this.fLoad, (Component)mouseEvent.getSource());
            } else if (dTContainer instanceof DTDocumentContainer) {
                ((DTDocumentContainer)dTContainer).startClientDrag((DTClient)this.fLoad, (Component)mouseEvent.getSource());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.fIsEnabled) {
                super.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            this.fFloatingDrag = false;
        }

        @Override
        protected String getHint(MouseEvent mouseEvent) {
            if (this.fFloatingDrag) {
                return null;
            }
            return super.getHint(mouseEvent);
        }

        void setEnabled(boolean bl) {
            if (this.fIsEnabled != bl) {
                this.fIsEnabled = bl;
                if (!this.fIsEnabled) {
                    this.clearHint();
                }
            }
        }
    }

    class RootPane
    extends MJLayeredPane {
        RootPane() {
        }

        public Dimension getPreferredSize() {
            return DTInternalFrame.this.fContentPane.getPreferredSize();
        }

        public void doLayout() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            DTInternalFrame.this.fContentPane.setBounds(0, 0, n, n2);
            if (DTInternalFrame.this.fControlPalette != null) {
                Component component;
                Dimension dimension = DTInternalFrame.this.fControlPalette.getPreferredSize();
                int n3 = n - dimension.width - 2;
                int n4 = 3;
                if (DTInternalFrame.hasDescendantOfClass(DTInternalFrame.this.fContentPane, JToolBar.class, 2)) {
                    n4 += 22;
                } else if (DTInternalFrame.hasDescendantOfClass(DTInternalFrame.this.fContentPane, DTTitleButton.class, 3)) {
                    n4 += 24;
                }
                if (DTInternalFrame.hasDescendantOfClass(DTInternalFrame.this.fContentPane, JTable.class, 4)) {
                    n4 += 24;
                }
                if ((component = DTInternalFrame.getDescendantOfClass(DTInternalFrame.this.fContentPane, JScrollPane.class, 2)) != null && ((JScrollPane)component).getVerticalScrollBar().isVisible()) {
                    n3 -= 18;
                }
                DTInternalFrame.this.fControlPalette.setBounds(n3, n4, dimension.width, dimension.height);
            }
        }
    }

    private class TitleMouseListener
    extends MouseAdapter {
        boolean fFocusIsPending;

        private TitleMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!(mouseEvent.isPopupTrigger() || MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent) || DTInternalFrame.this.getOccupant().isSelected() || DTInternalFrame.this.fTitleBar.isOnIcon(mouseEvent.getX(), mouseEvent.getY()))) {
                DTInternalFrame.this.getOccupant().setSelected(true, false);
                this.fFocusIsPending = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.fFocusIsPending) {
                DTInternalFrame.this.getOccupant().requestFocusLater();
                this.fFocusIsPending = true;
            }
        }
    }

    private class CustomTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private CustomTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            DTToolBarContainer dTToolBarContainer;
            Component component2 = super.getComponentAfter(container, component);
            if (container == DTInternalFrame.this.fContentPane && (dTToolBarContainer = (DTToolBarContainer)((Object)SwingUtilities.getAncestorOfClass(DTToolBarContainer.class, component))) == DTInternalFrame.this.fToolBarContainer && component2 == this.getFirstComponent(container) && DTInternalFrame.this.getTopClient() != null) {
                component2 = DTInternalFrame.this.getTopClient().getComponent();
            }
            return component2;
        }
    }
}

