/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.KeyControlledDragger;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

class DTKeyControlledResizer
extends KeyControlledDragger {
    protected Container fContainer;

    DTKeyControlledResizer() {
    }

    public void activate(DTOccupant dTOccupant, Container container) {
        this.fContainer = container;
        super.activate((Component)((Object)dTOccupant.getInternalFrame()));
        if (this.isActive()) {
            DTDragUtilities.setIsDraggingWithKeys(true);
            DTLocation dTLocation = dTOccupant.getLastLocation();
            if (dTLocation != null) {
                DTDragUtilities.showHint(dTLocation.getFrame(), DTDragUtilities.getToResizeThis(dTOccupant));
            }
        }
    }

    public void deactivate(boolean bl) {
        DTDragUtilities.setIsDraggingWithKeys(false);
        DTOccupant dTOccupant = ((DTInternalFrame)((Object)this.fInvoker)).getOccupant();
        DTLocation dTLocation = dTOccupant.getLastLocation();
        if (dTLocation != null) {
            DTDragUtilities.showHint(dTLocation.getFrame(), null);
        }
        super.deactivate(bl);
        this.fContainer = null;
    }

    protected Cursor getDragCursor() {
        return null;
    }

    protected Point getDragStartPoint() {
        Rectangle rectangle;
        Rectangle rectangle2 = new Rectangle(0, 0, this.fInvoker.getWidth(), this.fInvoker.getHeight());
        if (this.fContainer == null) {
            rectangle = WindowUtils.getVirtualScreenBounds();
            Point point = rectangle2.getLocation();
            SwingUtilities.convertPointToScreen(point, this.fInvoker);
            rectangle2.setLocation(point);
        } else {
            rectangle = new Rectangle(0, 0, this.fContainer.getWidth(), this.fContainer.getHeight());
            rectangle2 = SwingUtilities.convertRectangle(this.fInvoker, rectangle2, this.fContainer);
        }
        int n = rectangle2.x;
        int n2 = n + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = n3 + rectangle2.height;
        Point point = null;
        if (rectangle.contains(n2, n4)) {
            point = new Point(n2 - 2, n4 - 2);
        } else if (rectangle.contains(n, n3)) {
            point = new Point(n + 2, n3 + 2);
        } else if (rectangle.contains(n2, n3)) {
            point = new Point(n2 - 2, n3 + 2);
        } else if (rectangle.contains(n, n4)) {
            point = new Point(n + 2, n4 - 2);
        } else if (n2 >= rectangle.x + 2 && n2 <= rectangle.x + rectangle.width) {
            point = new Point(n2 - 2, (rectangle.y + rectangle.height) / 2);
        } else if (n >= rectangle.x && n <= rectangle.x + rectangle.width - 2) {
            point = new Point(n + 2, (rectangle.y + rectangle.height) / 2);
        } else if (n4 >= rectangle.y + 2 && n4 <= rectangle.y + rectangle.height) {
            point = new Point((rectangle.x + rectangle.width) / 2, n4 - 2);
        } else if (n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height - 2) {
            point = new Point((rectangle.x + rectangle.width) / 2, n3 + 2);
        }
        if (point != null && this.fContainer != null) {
            SwingUtilities.convertPointToScreen(point, this.fContainer);
        }
        return point;
    }
}

