/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.UIManager;

class DTMaximizedPane
extends MJPanel
implements DTContainer,
DTDropTarget {
    private DTDocumentContainer fDocumentContainer;
    private DTClient fMaximizedDocument;
    private boolean fRestoringDocuments;
    private DropTarget fDropTarget;

    DTMaximizedPane(DTDocumentContainer dTDocumentContainer) {
        this.setLayout(null);
        this.fDocumentContainer = dTDocumentContainer;
        this.setBackground(UIManager.getColor("control").darker());
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        boolean bl;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl2 = bl = this.fMaximizedDocument == null || dTClient.isSelected() || !this.fMaximizedDocument.isSelected();
        if (this.fMaximizedDocument != null && bl) {
            this.hide(this.fMaximizedDocument);
        }
        dTClient.getInternalFrame().setTitleBarVisible(this.fDocumentContainer.showTitleWhenMaximized());
        this.add((Component)((Object)dTClient.getInternalFrame()));
        DTLocation dTLocation2 = dTClient.getLastFloatingInLocation();
        if (dTLocation2 == null) {
            dTLocation2 = DTLocation.createInternal(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        dTLocation2.setFrame(this.fDocumentContainer.getFrame());
        dTLocation2.setContainer(this.fDocumentContainer);
        dTClient.setLocation(dTLocation2);
        dTClient.locationChanged();
        if (this.fRestoringDocuments || !bl) {
            this.hide(dTClient);
        } else {
            this.show(dTClient);
        }
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        DTFloatingLocation dTFloatingLocation;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = dTClient.isSelected();
        this.remove((Component)((Object)dTClient.getInternalFrame()));
        dTClient.getInternalFrame().setTitleBarVisible(true);
        if (dTClient == this.fMaximizedDocument) {
            this.fMaximizedDocument = this.fDocumentContainer.getMostRecentlySelected();
            if (this.fMaximizedDocument != null) {
                this.show(this.fMaximizedDocument);
                if (bl && dTClient.isClosing()) {
                    this.fMaximizedDocument.setSelected(true);
                }
            } else {
                if (bl && dTClient.isClosing()) {
                    this.requestFocus();
                }
                this.revalidate();
                this.repaint();
            }
        } else {
            dTClient.getInternalFrame().setVisible(true);
            if (dTClient.treatAsHeavyweight()) {
                this.setCanvasVisible((Component)((Object)dTClient.getInternalFrame()), true);
            }
        }
        if ((dTFloatingLocation = (DTFloatingLocation)dTClient.getLocation()).isMaximized()) {
            dTFloatingLocation.setMaximized(false);
            dTFloatingLocation.setFrameBounds(dTFloatingLocation.getRestoreBounds());
        }
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        return !bl || dTSelectable == this.fMaximizedDocument ? null : this.fMaximizedDocument;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        return !bl || dTSelectable == this.fMaximizedDocument ? null : this.fMaximizedDocument;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        if (dTClient == this.fMaximizedDocument) {
            return;
        }
        if (this.fMaximizedDocument != null) {
            if (scope == DTContainer.Scope.GROUP && this.fMaximizedDocument.getGroup() != dTClient.getGroup()) {
                return;
            }
            this.fMaximizedDocument.setSelected(false);
            this.hide(this.fMaximizedDocument);
        }
        this.show(dTClient);
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
    }

    DTClient getMaximizedDocument() {
        return this.fMaximizedDocument;
    }

    public void removeAll() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            component.setVisible(true);
            DTClientFrame dTClientFrame = (DTClientFrame)((Object)component);
            DTClient dTClient = dTClientFrame.getClient();
            if (dTClient.treatAsHeavyweight()) {
                this.setCanvasVisible((Component)((Object)dTClient.getInternalFrame()), true);
            }
            dTClientFrame.setTitleBarVisible(true);
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)dTClient.getLocation();
            if (!dTFloatingLocation.isMaximized()) continue;
            dTFloatingLocation.setMaximized(false);
            dTFloatingLocation.setFrameBounds(dTFloatingLocation.getRestoreBounds());
        }
        this.fMaximizedDocument = null;
        super.removeAll();
    }

    void beginRestore() {
        this.fRestoringDocuments = true;
    }

    void endRestore() {
        this.fRestoringDocuments = false;
    }

    private void show(DTClient dTClient) {
        dTClient.getInternalFrame().setVisible(true);
        if (dTClient.treatAsHeavyweight()) {
            this.setCanvasVisible((Component)((Object)dTClient.getInternalFrame()), true);
        }
        DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)dTClient.getLocation();
        dTFloatingLocation.setMaximized(true);
        dTFloatingLocation.setFrameBounds(0, 0, this.getWidth(), this.getHeight());
        dTClient.getSelectAction().setSelected(true);
        this.fMaximizedDocument = dTClient;
    }

    private void hide(DTClient dTClient) {
        dTClient.getInternalFrame().setVisible(false);
        if (dTClient.treatAsHeavyweight()) {
            this.setCanvasVisible((Component)((Object)dTClient.getInternalFrame()), false);
        }
        dTClient.getSelectAction().setSelected(false);
        if (dTClient == this.fMaximizedDocument) {
            this.fMaximizedDocument = null;
        }
    }

    private boolean setCanvasVisible(Component component, boolean bl) {
        if (component instanceof Canvas) {
            component.setVisible(bl);
            return true;
        }
        if (component instanceof Container) {
            int n = ((Container)component).getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!this.setCanvasVisible(((Container)component).getComponent(i), bl)) continue;
                return true;
            }
        }
        return false;
    }

    public void doLayout() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            DTClientFrame dTClientFrame = (DTClientFrame)((Object)this.getComponent(i));
            DTClient dTClient = dTClientFrame.getClient();
            DTLocation dTLocation = dTClient.getLocation();
            if (!dTLocation.isMaximized()) continue;
            dTClientFrame.setBounds(0, 0, this.getWidth(), this.getHeight());
            dTLocation.setFrameBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        DTFloatingLocation dTFloatingLocation = null;
        if (this.contains(n, n2)) {
            dTFloatingLocation = dTLocation instanceof DTFloatingLocation && !dTLocation.isExternal() ? (DTFloatingLocation)dTLocation : new DTFloatingLocation(false);
            dTFloatingLocation.setMaximized(true);
        }
        return dTFloatingLocation;
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        return dTLocation == null ? DTDragUtilities.getToLeaveHint(object) : DTDragUtilities.getToOutlineHint(object);
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        if (dTLocation == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        DTDragUtilities.getDropOutlinePainter().show(this.getParent(), rectangle.x, rectangle.y, rectangle.width, rectangle.height, DTDropOutlinePainter.OutlineType.RECTANGLE);
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        if (dTLocation != null) {
            ((DTClient)object).setSelected(true);
        }
    }

    void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new DropTarget();
            this.fDropTarget.setComponent((Component)((Object)this));
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
    }

    void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
        }
    }
}

