/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJScrollStrip;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.border.FocusBorderFactory;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.widgets.desk.ComponentIcon;
import com.mathworks.widgets.desk.DTComponentBar;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.widgets.desk.DTToolbarLayoutController;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.QuickAccessToolBarCustomizationPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DTToolBarCustomizationPanel
extends MJPanel {
    public static final String QUICK_ACCESS_PANEL_KEY = "QUICK_ACCESS_PANEL";
    private static final QuickAccessToolBarCustomizationPanel sQuickAccessPanel = new QuickAccessToolBarCustomizationPanel();
    private static DTToolbarLayoutController sQuickAccessLayoutController;
    private JScrollPane fScrolledTable;
    private DTToolBarRegistry fRegistry;
    private Desktop fDesktop;
    private String fSelectedToolBarKey;
    private HashMap<String, DTToolBarConfiguration> fModifiedConfigMap = new HashMap();
    private ToolBarEntry[] fEntries;
    private JComboBox fToolBarCombo;
    private ToolBarProxy fToolBarProxy;
    private MJScrollStrip fProxyScroller;
    private MJTable fItemTable;
    private int fDefaultTableRowHeight;
    private DTToolbarLayoutController fLayoutController;
    private static final String TOOL_SET_KEY = "ToolSetKey";
    private static final int CHECK_COLUMN_WIDTH = 32;
    private static final int ICON_COLUMN_WIDTH = 24;
    private static final int TOTAL_COLUMN_WIDTH = 156;
    private static final int CHECK_COLUMN = 0;
    private static final int ICON_COLUMN = 1;
    private static final int LABEL_COLUMN = 2;
    private static final int COLUMN_COUNT = 3;
    private static final Class[] COLUMN_CLASS;

    public DTToolBarCustomizationPanel(DTToolBarRegistry dTToolBarRegistry, Desktop desktop) {
        Object object;
        this.fRegistry = dTToolBarRegistry;
        this.fDesktop = desktop;
        List<String> list = this.fRegistry.getKeys();
        int n = list.size();
        n = this.initQuickAccessPanel(n);
        this.fEntries = new ToolBarEntry[n];
        Iterator<String> iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            this.fEntries[n2] = new ToolBarEntry((String)object, this.fRegistry.getLabel((String)object));
            ++n2;
        }
        if (this.fDesktop.useToolstrip()) {
            this.fEntries[n2] = new ToolBarEntry(QUICK_ACCESS_PANEL_KEY, this.getResourceString("comboboxitem.QuickAccess"));
        }
        this.fToolBarCombo = new MJComboBox((Object[])this.fEntries);
        this.fToolBarCombo.setName("ToolBarComboBox");
        this.fToolBarCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTToolBarCustomizationPanel.this.selectToolBar(((ToolBarEntry)((DTToolBarCustomizationPanel)DTToolBarCustomizationPanel.this).fToolBarCombo.getSelectedItem()).iKey);
            }
        });
        this.fToolBarProxy = new ToolBarProxy();
        this.fLayoutController = new DTToolbarLayoutController(this.fToolBarProxy, this.fToolBarProxy, true, "Toolbars");
        this.fToolBarProxy.setName("ToolBarProxy");
        this.fToolBarProxy.addLayoutListener(new DTComponentBar.LayoutListener(){

            @Override
            public void componentMoved(DTComponentBar dTComponentBar, Component component, int n, int n2) {
                DTToolBarCustomizationPanel.this.updateRestoreDefaultAction();
                DTToolBarCustomizationPanel.this.fLayoutController.updateSelectionDependentActions();
            }
        });
        this.fToolBarProxy.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DTToolBarCustomizationPanel.this.updateRestoreDefaultAction();
                    }
                });
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                DTToolBarCustomizationPanel.this.updateRestoreDefaultAction();
            }
        });
        this.fProxyScroller = new MJScrollStrip(0, (Component)((Object)this.fToolBarProxy)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        };
        this.fProxyScroller.setName("ProxyScrollStrip");
        this.fProxyScroller.setScrollOnMouseOver(true);
        this.fProxyScroller.setBorder(FocusBorderFactory.create());
        this.fItemTable = new MJTable(new ItemTableModel()){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(156, 10 * this.getRowHeight());
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                boolean bl = this.hasFocus() && n2 == 0 && this.isCellSelected(n, n2);
                return tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), this.getModel().getValueAt(n, n2), false, bl, n, n2);
            }
        };
        this.fDefaultTableRowHeight = this.fItemTable.getRowHeight();
        this.fItemTable.getAccessibleContext().setAccessibleName(this.getResourceString("description.ToolbarControlTable"));
        this.fItemTable.setAccessibleTextProvider(this.createAccessibilityTextProvider());
        this.fItemTable.setName("ToolBarItemTable");
        this.fItemTable.setTableHeader(null);
        this.fItemTable.setShowGrid(false);
        this.fItemTable.setColumnSelectionAllowed(false);
        this.fItemTable.setRowSelectionAllowed(true);
        this.fItemTable.setSelectionMode(0);
        object = this.fItemTable.getInputMap(0);
        if (object != null) {
            ((InputMap)object).put(KeyStroke.getKeyStroke(9, 0), "TransferFocus");
            this.fItemTable.getActionMap().put("TransferFocus", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Container container = DTToolBarCustomizationPanel.this.getFocusCycleRootAncestor();
                    Component component = container.getFocusTraversalPolicy().getComponentAfter(container, (Component)DTToolBarCustomizationPanel.this.fItemTable);
                    component.requestFocusInWindow();
                }
            });
            ((InputMap)object).put(KeyStroke.getKeyStroke(37, 0), "DoNothing");
            ((InputMap)object).put(KeyStroke.getKeyStroke(39, 0), "DoNothing");
            ((InputMap)object).put(KeyStroke.getKeyStroke(37, 2), "DoNothing");
            ((InputMap)object).put(KeyStroke.getKeyStroke(39, 2), "DoNothing");
            ((InputMap)object).put(KeyStroke.getKeyStroke(37, 1), "DoNothing");
            ((InputMap)object).put(KeyStroke.getKeyStroke(39, 1), "DoNothing");
            this.fItemTable.getActionMap().put("DoNothing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            ((InputMap)object).put(KeyStroke.getKeyStroke(32, 0), "ToggleAction");
            this.fItemTable.getActionMap().put("ToggleAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DTToolBarCustomizationPanel.this.fItemTable.getSelectedRow();
                    if (n != -1) {
                        TableModel tableModel;
                        Boolean bl = (Boolean)(tableModel = DTToolBarCustomizationPanel.this.fItemTable.getModel()).getValueAt(n, 0);
                        tableModel.setValueAt(bl == false, n, 0);
                    }
                }
            });
        }
        this.fItemTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                int n2 = DTToolBarCustomizationPanel.this.fItemTable.columnAtPoint(mouseEvent.getPoint());
                if (n2 > 0 && (n = DTToolBarCustomizationPanel.this.fItemTable.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                    TableModel tableModel;
                    Boolean bl = (Boolean)(tableModel = DTToolBarCustomizationPanel.this.fItemTable.getModel()).getValueAt(n, 0);
                    tableModel.setValueAt(bl == false, n, 0);
                }
            }
        });
        this.fItemTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DTToolBarCustomizationPanel.this.fItemTable.getSelectionModel().getLeadSelectionIndex() == -1) {
                    DTToolBarCustomizationPanel.this.fItemTable.changeSelection(0, 0, false, false);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.fScrolledTable = new MJScrollPane((Component)this.fItemTable);
        this.fScrolledTable.setName("TableScrollPane");
        this.fScrolledTable.getViewport().setBackground(this.fItemTable.getBackground());
        String string = (this.fToolBarCombo != null ? "p, 4dlu, " : "") + "p, 3dlu, p, 6dlu, fill:p:grow";
        this.setLayout((LayoutManager)new FormLayout("p, 3dlu, d:grow", string));
        CellConstraints cellConstraints = new CellConstraints();
        int n3 = 1;
        if (this.fToolBarCombo != null) {
            MJLabel mJLabel = new MJLabel(this.getResourceString("label.Toolbar") + ":");
            mJLabel.setLabelFor(this.fToolBarCombo);
            this.add((Component)mJLabel, cellConstraints.xy(1, n3));
            this.add(this.fToolBarCombo, cellConstraints.xy(3, n3));
            n3 += 2;
        }
        this.add((Component)new MJLabel(this.getResourceString("label.Layout") + ":"), cellConstraints.xy(1, n3));
        this.add((Component)this.fProxyScroller, cellConstraints.xy(3, n3));
        this.configureQuickAccessPanelToolbarProxy(cellConstraints, n3);
        this.add(this.fLayoutController.getLayoutControls(), cellConstraints.xy(3, n3 += 2));
        this.configureQuickAccessPanelLayoutController(cellConstraints, n3);
        this.add((Component)new MJLabel(this.getResourceString("label.Controls") + ":"), cellConstraints.xy(1, n3 += 2, CellConstraints.LEFT, CellConstraints.TOP));
        this.add(this.fScrolledTable, cellConstraints.xy(3, n3));
        this.configureQuickAccessPanel(cellConstraints, n3);
        this.selectToolBar(QUICK_ACCESS_PANEL_KEY);
    }

    private int initQuickAccessPanel(int n) {
        int n2 = n;
        if (this.fDesktop.useToolstrip()) {
            if (!sQuickAccessPanel.isInitialized()) {
                sQuickAccessPanel.init(this.fDesktop.getQuickAccessConfiguration(), this.fDesktop.getDefaultQuickAccessConfiguration(), this.fDesktop.getToolstripRegistry(), TSRobot.getQuickAccessToolBar((Toolstrip)TSRobot.getToolstripFor((Component)((Object)this.fDesktop.getMainFrame()))));
                sQuickAccessLayoutController = sQuickAccessPanel.getLayoutController();
            }
            n2 = n + 1;
        }
        return n2;
    }

    public static QuickAccessToolBarCustomizationPanel getQuickAccessCustomizationPanel() {
        if (sQuickAccessPanel != null) {
            return sQuickAccessPanel;
        }
        return null;
    }

    private void configureQuickAccessPanelToolbarProxy(CellConstraints cellConstraints, int n) {
        if (!this.fDesktop.useToolstrip()) {
            return;
        }
        this.add((Component)sQuickAccessPanel.getToolbarProxy(), cellConstraints.xy(3, n));
        sQuickAccessPanel.getToolbarProxy().setVisible(false);
    }

    private void configureQuickAccessPanelLayoutController(CellConstraints cellConstraints, int n) {
        if (!this.fDesktop.useToolstrip()) {
            return;
        }
        this.add(sQuickAccessLayoutController.getLayoutControls(), cellConstraints.xy(3, n));
        sQuickAccessLayoutController.getLayoutControls().setVisible(false);
    }

    private void configureQuickAccessPanel(CellConstraints cellConstraints, int n) {
        if (!this.fDesktop.useToolstrip()) {
            return;
        }
        this.add((Component)((Object)sQuickAccessPanel), cellConstraints.xy(3, n));
        sQuickAccessPanel.setVisible(false);
    }

    private AccessibleTextProvider createAccessibilityTextProvider() {
        return new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                String string = (String)DTToolBarCustomizationPanel.this.fItemTable.getValueAt(n, 2);
                boolean bl = (Boolean)DTToolBarCustomizationPanel.this.fItemTable.getValueAt(n, 0);
                return MessageFormat.format(DTToolBarCustomizationPanel.this.getResourceString(bl ? "text.checked" : "text.notChecked"), string);
            }
        };
    }

    private String getResourceString(String string) {
        return Desktop.getString(this.fDesktop, string);
    }

    private int getQuickAccessPanelEntryIndex() {
        int n = -1;
        for (int i = 0; i < this.fEntries.length; ++i) {
            ToolBarEntry toolBarEntry = this.fEntries[i];
            if (!toolBarEntry.iKey.equals(QUICK_ACCESS_PANEL_KEY)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void selectToolBar(String string) {
        if (string != null && !string.equals(this.fSelectedToolBarKey) || string == null) {
            Object object;
            DTToolBarInfo dTToolBarInfo;
            if (this.fDesktop.useToolstrip() && (string == null || string.equals(QUICK_ACCESS_PANEL_KEY))) {
                this.fScrolledTable.setVisible(false);
                sQuickAccessPanel.setVisible(true);
                this.fProxyScroller.setVisible(false);
                sQuickAccessPanel.getToolbarProxy().setVisible(true);
                this.fLayoutController.getLayoutControls().setVisible(false);
                sQuickAccessLayoutController.getLayoutControls().setVisible(true);
                sQuickAccessPanel.updateRestoreDefaultAction();
                this.fSelectedToolBarKey = string;
                this.fToolBarCombo.setSelectedIndex(this.getQuickAccessPanelEntryIndex());
                return;
            }
            if (this.fDesktop.useToolstrip()) {
                sQuickAccessPanel.setVisible(false);
                this.fScrolledTable.setVisible(true);
                sQuickAccessPanel.getToolbarProxy().setVisible(false);
                this.fProxyScroller.setVisible(true);
                sQuickAccessLayoutController.getLayoutControls().setVisible(false);
                this.fLayoutController.getLayoutControls().setVisible(true);
            }
            this.saveModifications();
            DTToolBarInfo dTToolBarInfo2 = dTToolBarInfo = string == null ? null : this.fRegistry.getToolBarInfo(string);
            if (dTToolBarInfo == null) {
                object = this.fRegistry.getKeys();
                if (object.isEmpty()) {
                    this.fLayoutController.fAddSeparatorAction.setEnabled(false);
                    this.fLayoutController.fRestoreDefaultAction.setEnabled(false);
                    return;
                }
                this.fLayoutController.fAddSeparatorAction.setEnabled(true);
                string = this.fRegistry.getKeys().get(0);
                dTToolBarInfo = this.fRegistry.getToolBarInfo(string);
            }
            this.fSelectedToolBarKey = string;
            object = this.fModifiedConfigMap.get(string);
            if (object == null) {
                object = this.fRegistry.getToolBarConfiguration(string);
            }
            if (object == null) {
                object = dTToolBarInfo.getDefaultConfig();
            }
            this.fItemTable.setModel((TableModel)new ItemTableModel(dTToolBarInfo.getToolSet(), (DTToolBarConfiguration)object));
            int n = this.fDefaultTableRowHeight;
            int n2 = 24;
            DTToolSet dTToolSet = dTToolBarInfo.getToolSet();
            for (String string2 : dTToolSet.getKeys()) {
                Icon icon = dTToolSet.getIcon(string2);
                if (icon.getIconHeight() + 1 > n) {
                    n = icon.getIconHeight() + 1;
                }
                if (icon.getIconWidth() + 5 <= n2) continue;
                n2 = icon.getIconWidth() + 5;
            }
            Object object2 = this.fItemTable.getColumnModel().getColumn(0);
            ((TableColumn)object2).setPreferredWidth(32);
            ((TableColumn)object2).setMaxWidth(32);
            object2 = this.fItemTable.getColumnModel().getColumn(1);
            ((TableColumn)object2).setPreferredWidth(n2);
            ((TableColumn)object2).setMaxWidth(n2);
            this.fItemTable.setRowHeight(n);
            this.fToolBarProxy.setConfiguration(dTToolBarInfo.getToolSet(), (DTToolBarConfiguration)object);
            if (this.fToolBarCombo != null && !string.equals(((ToolBarEntry)this.fToolBarCombo.getSelectedItem()).iKey)) {
                int n3 = this.fRegistry.getKeys().indexOf(string);
                this.fToolBarCombo.setSelectedIndex(n3);
            }
            this.fLayoutController.fRestoreDefaultAction.setEnabled(!((DTToolBarConfiguration)object).equals(dTToolBarInfo.getDefaultConfig()));
        }
    }

    public boolean hasModifications() {
        if (this.fSelectedToolBarKey != null && this.fSelectedToolBarKey.equals(QUICK_ACCESS_PANEL_KEY)) {
            return sQuickAccessPanel.hasModifications();
        }
        this.saveModifications();
        return !this.fModifiedConfigMap.isEmpty();
    }

    public void applyModifications() {
        if (this.fSelectedToolBarKey != null && this.fSelectedToolBarKey.equals(QUICK_ACCESS_PANEL_KEY)) {
            sQuickAccessPanel.applyModifications();
        } else {
            for (Map.Entry<String, DTToolBarConfiguration> entry : this.fModifiedConfigMap.entrySet()) {
                DTToolBarRegistry.Registrant registrant = this.fRegistry.getRegistrant(entry.getKey());
                registrant.updateToolBars(entry.getKey(), entry.getValue());
            }
            this.fModifiedConfigMap.clear();
        }
    }

    public void discardModifications() {
        sQuickAccessPanel.discardModifications();
        this.fModifiedConfigMap.clear();
        sQuickAccessPanel.discardModifications();
    }

    void updateRestoreDefaultAction() {
        this.fLayoutController.fRestoreDefaultAction.setEnabled(!this.fToolBarProxy.getConfiguration().equals(this.fRegistry.getToolBarInfo(this.fSelectedToolBarKey).getDefaultConfig()));
    }

    private void saveModifications() {
        if (this.fSelectedToolBarKey != null && !this.fSelectedToolBarKey.equals(QUICK_ACCESS_PANEL_KEY)) {
            DTToolBarConfiguration dTToolBarConfiguration = this.fRegistry.getToolBarConfiguration(this.fSelectedToolBarKey);
            DTToolBarConfiguration dTToolBarConfiguration2 = this.fToolBarProxy.getConfiguration();
            if (!dTToolBarConfiguration2.equals(dTToolBarConfiguration)) {
                this.fModifiedConfigMap.put(this.fSelectedToolBarKey, dTToolBarConfiguration2);
            }
        }
    }

    static {
        COLUMN_CLASS = new Class[]{Boolean.class, Icon.class, String.class};
    }

    private class ItemTableModel
    extends AbstractTableModel {
        DTToolSet iToolSet;
        boolean[] iIsItemShowing;

        ItemTableModel() {
        }

        ItemTableModel(DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration) {
            this.iToolSet = dTToolSet;
            List<String> list = dTToolSet.getKeys();
            this.iIsItemShowing = new boolean[list.size()];
            this.setItemsShowing(dTToolBarConfiguration);
        }

        void setConfiguration(DTToolBarConfiguration dTToolBarConfiguration) {
            Arrays.fill(this.iIsItemShowing, false);
            this.setItemsShowing(dTToolBarConfiguration);
            this.fireTableDataChanged();
        }

        private void setItemsShowing(DTToolBarConfiguration dTToolBarConfiguration) {
            List<String> list = this.iToolSet.getKeys();
            List<String> list2 = dTToolBarConfiguration.getVisibleItemKeys();
            for (String string : list2) {
                int n;
                if ("Tool Bar Separator Key".equals(string) || (n = list.indexOf(string)) == -1) continue;
                this.iIsItemShowing[n] = true;
            }
        }

        void setItemShowing(String string, boolean bl) {
            int n = this.iToolSet.getKeys().indexOf(string);
            if (n != -1) {
                this.iIsItemShowing[n] = bl;
            }
            this.fireTableRowsUpdated(n, n);
        }

        @Override
        public int getRowCount() {
            return this.iIsItemShowing == null ? 0 : this.iIsItemShowing.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASS[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.iIsItemShowing[n];
                }
                case 1: {
                    String string = this.iToolSet.getKeys().get(n);
                    return this.iToolSet.getIcon(string);
                }
                case 2: {
                    String string = this.iToolSet.getKeys().get(n);
                    return MJUtilities.exciseMnemonic((String)this.iToolSet.getLabel(string));
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                String string = this.iToolSet.getKeys().get(n);
                if (((Boolean)object).booleanValue()) {
                    String string2 = null;
                    for (int i = n - 1; i >= 0 && string2 == null; --i) {
                        if (!this.iIsItemShowing[i]) continue;
                        string2 = this.iToolSet.getKeys().get(i);
                    }
                    DTToolBarCustomizationPanel.this.fToolBarProxy.insertItem(string, string2);
                } else {
                    DTToolBarCustomizationPanel.this.fToolBarProxy.removeItem(string);
                }
                this.iIsItemShowing[n] = (Boolean)object;
                this.fireTableRowsUpdated(n, n);
            }
        }
    }

    private static class AccessibleToolBarProxyRole
    extends AccessibleRole {
        public static final AccessibleToolBarProxyRole LAYOUT = new AccessibleToolBarProxyRole("layout");

        protected AccessibleToolBarProxyRole(String string) {
            super(string);
        }
    }

    private class ToolBarProxy
    extends DTComponentBar
    implements Accessible,
    DTComponentBar.ItemAccess {
        DTToolSet iToolSet;
        JComponent iSelectedItem;
        Integer iPreferredHeight;

        ToolBarProxy() {
            super(0);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DTToolBarCustomizationPanel.this.fProxyScroller.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    DTToolBarCustomizationPanel.this.fProxyScroller.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ToolBarProxy.this.requestFocusInWindow();
                }
            });
            this.setName("ToolBarProxy_Toolbars");
        }

        @Override
        public void restoreDefault() {
            if (DTToolBarCustomizationPanel.this.fSelectedToolBarKey == null) {
                return;
            }
            DTToolBarInfo dTToolBarInfo = DTToolBarCustomizationPanel.this.fRegistry.getToolBarInfo(DTToolBarCustomizationPanel.this.fSelectedToolBarKey);
            DTToolBarCustomizationPanel.this.fToolBarProxy.setConfiguration(dTToolBarInfo.getToolSet(), dTToolBarInfo.getDefaultConfig());
            ((ItemTableModel)DTToolBarCustomizationPanel.this.fItemTable.getModel()).setConfiguration(dTToolBarInfo.getDefaultConfig());
            ((DTToolBarCustomizationPanel)DTToolBarCustomizationPanel.this).fLayoutController.fRestoreDefaultAction.setEnabled(false);
        }

        void setConfiguration(DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration) {
            boolean bl = this.getComponentCount() == 0;
            this.iToolSet = dTToolSet;
            this.iSelectedItem = null;
            this.removeAll();
            List<String> list = dTToolBarConfiguration.getVisibleItemKeys();
            for (String string : list) {
                this.add(this.createProxyComponent(string));
            }
            this.iPreferredHeight = (int)super.getPreferredSize().getHeight();
            for (String string : dTToolBarConfiguration.getHiddenItemKeys()) {
                int n = (int)this.createProxyComponent(string).getPreferredSize().getHeight();
                this.iPreferredHeight = Math.max(this.iPreferredHeight, n);
            }
            if (bl) {
                DTToolBarCustomizationPanel.this.revalidate();
                DTToolBarCustomizationPanel.this.repaint();
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return this.iPreferredHeight == null ? dimension : new Dimension((int)dimension.getWidth(), this.iPreferredHeight);
        }

        DTToolBarConfiguration getConfiguration() {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>(this.iToolSet.getKeys());
            boolean bl = true;
            Iterator<Component> iterator = this.iterator();
            while (iterator.hasNext()) {
                String string;
                Component component = iterator.next();
                if (!(component instanceof JComponent) || (string = (String)((JComponent)component).getClientProperty(DTToolBarCustomizationPanel.TOOL_SET_KEY)) == null) continue;
                if ("Tool Bar Separator Key".equals(string)) {
                    if (bl || !iterator.hasNext()) continue;
                    arrayList.add(string);
                    bl = true;
                    continue;
                }
                bl = false;
                arrayList.add(string);
                arrayList2.remove(string);
            }
            int n = arrayList.size();
            if (n > 0 && "Tool Bar Separator Key".equals(arrayList.get(n - 1))) {
                arrayList.remove(n - 1);
            }
            return new DTToolBarConfiguration(arrayList, arrayList2);
        }

        void insertItem(String string, String string2) {
            boolean bl = this.getComponentCount() == 0;
            int n = 0;
            if (string2 != null) {
                n = this.indexFromKey(string2) + 1;
            }
            JComponent jComponent = this.createProxyComponent(string);
            this.addToLayout(jComponent, n);
            this.setSelectedItem(jComponent);
            if (bl) {
                DTToolBarCustomizationPanel.this.revalidate();
                DTToolBarCustomizationPanel.this.repaint();
            }
            this.revalidate();
            this.repaint();
        }

        void removeItem(String string) {
            int n = this.indexFromKey(string);
            if (n != -1) {
                Component component = this.getComponentAtLayoutIndex(n);
                if (this.iSelectedItem == component) {
                    this.setSelectedItem(null);
                }
                this.remove(component);
                this.revalidate();
                this.repaint();
            }
        }

        private JComponent createProxyComponent(String string) {
            DTComponentBar.ItemProxy itemProxy;
            if ("Tool Bar Separator Key".equals(string)) {
                itemProxy = new DTComponentBar.ItemProxy(ComponentIcon.SEPARATOR.getIcon(), this);
                ((Component)((Object)itemProxy)).setName("Separator");
                ((JComponent)((Object)itemProxy)).setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            } else {
                DTToolSet.ItemType itemType = this.iToolSet.getType(string);
                if (this.iToolSet.includeLabelOnBar(string)) {
                    itemProxy = (DTComponentBar)this.new DTComponentBar.ItemProxy(this.iToolSet.getLabel(string) + ":", this.iToolSet.getIcon(string), (DTComponentBar.ItemAccess)this);
                } else if (itemType == DTToolSet.ItemType.CHECK_BOX || itemType == DTToolSet.ItemType.RADIO_BUTTON) {
                    itemProxy = (DTComponentBar)this.new DTComponentBar.ItemProxy(this.iToolSet.getIcon(string), this.iToolSet.getLabel(string), (DTComponentBar.ItemAccess)this);
                } else {
                    itemProxy = new DTComponentBar.ItemProxy(this.iToolSet.getIcon(string), this);
                    ((Component)((Object)itemProxy)).getAccessibleContext().setAccessibleName(this.iToolSet.getLabel(string));
                }
                ((Component)((Object)itemProxy)).setName(string + "Item");
                ((JComponent)((Object)itemProxy)).setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
            ((JComponent)((Object)itemProxy)).putClientProperty(DTToolBarCustomizationPanel.TOOL_SET_KEY, string);
            return itemProxy;
        }

        private int indexFromKey(String string) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JComponent) || !string.equals(((JComponent)component).getClientProperty(DTToolBarCustomizationPanel.TOOL_SET_KEY))) continue;
                return this.layoutIndexOf(component);
            }
            return -1;
        }

        @Override
        public void setSelectedItem(JComponent jComponent) {
            if (this.iSelectedItem == jComponent) {
                return;
            }
            JComponent jComponent2 = this.iSelectedItem;
            this.iSelectedItem = jComponent;
            if (jComponent2 != null) {
                jComponent2.repaint();
            }
            DTToolBarCustomizationPanel.this.fLayoutController.updateSelectionDependentActions();
            this.ensureSelectionVisible();
            this.firePropertyChange("AccessibleSelection", null, null);
            this.firePropertyChange("AccessibleActiveDescendant", jComponent2, this.iSelectedItem);
            this.firePropertyChange("AccessibleVisibleData", jComponent2, this.iSelectedItem);
        }

        @Override
        public JComponent getSelectedItem() {
            return this.iSelectedItem;
        }

        private void ensureSelectionVisible() {
            if (this.iSelectedItem != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ToolBarProxy.this.iSelectedItem != null) {
                            DTToolBarCustomizationPanel.this.fProxyScroller.ensureVisible((Component)ToolBarProxy.this.iSelectedItem);
                        }
                    }
                });
            }
        }

        @Override
        public void selectFirst() {
            if (this.getComponentCount() > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(0));
                this.repaint();
            }
        }

        @Override
        public void selectPrevious() {
            if (this.iSelectedItem != null) {
                int n = this.layoutIndexOf(this.iSelectedItem);
                if (n > 0) {
                    this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n - 1));
                    this.repaint();
                }
            } else if (this.getComponentCount() > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(this.getComponentCount() - 1));
                this.repaint();
            }
        }

        @Override
        public void selectNext() {
            int n = this.getComponentCount();
            if (this.iSelectedItem != null) {
                int n2 = this.layoutIndexOf(this.iSelectedItem);
                if (n2 < n - 1) {
                    this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n2 + 1));
                    this.repaint();
                }
            } else if (n > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(0));
                this.repaint();
            }
        }

        @Override
        public void selectLast() {
            int n = this.getComponentCount();
            if (n > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n - 1));
                this.repaint();
            }
        }

        @Override
        public void moveSelectedItemToBegin() {
            if (this.iSelectedItem == null) {
                return;
            }
            int n = this.layoutIndexOf(this.iSelectedItem);
            if (n > 0) {
                this.moveComponent(n, 0);
                this.ensureSelectionVisible();
            }
        }

        @Override
        public void moveSelectedItemToLeft() {
            if (this.iSelectedItem == null) {
                return;
            }
            int n = this.layoutIndexOf(this.iSelectedItem);
            if (n > 0) {
                this.moveComponent(n, n - 1);
                this.ensureSelectionVisible();
            }
        }

        @Override
        public void moveSelectedItemToRight() {
            if (this.iSelectedItem == null) {
                return;
            }
            int n = this.layoutIndexOf(this.iSelectedItem);
            if (n < this.getComponentCount() - 1) {
                this.moveComponent(n, n + 1);
                this.ensureSelectionVisible();
            }
        }

        @Override
        public void moveSelectedItemToEnd() {
            int n;
            if (this.iSelectedItem == null) {
                return;
            }
            int n2 = this.layoutIndexOf(this.iSelectedItem);
            if (n2 < (n = this.getComponentCount()) - 1) {
                this.moveComponent(n2, n - 1);
                this.ensureSelectionVisible();
            }
        }

        @Override
        public void addSeparator() {
            JComponent jComponent = this.createProxyComponent("Tool Bar Separator Key");
            if (this.iSelectedItem == null) {
                this.add(jComponent);
            } else {
                int n = this.layoutIndexOf(this.iSelectedItem) + 1;
                this.addToLayout(jComponent, n);
            }
            this.setSelectedItem(jComponent);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void removeSelectedItem() {
            if (this.iSelectedItem != null) {
                int n;
                int n2 = this.layoutIndexOf(this.iSelectedItem);
                this.remove(this.iSelectedItem);
                String string = (String)this.iSelectedItem.getClientProperty(DTToolBarCustomizationPanel.TOOL_SET_KEY);
                if (!"Tool Bar Separator Key".equals(string)) {
                    ItemTableModel itemTableModel = (ItemTableModel)DTToolBarCustomizationPanel.this.fItemTable.getModel();
                    itemTableModel.setItemShowing(string, false);
                }
                if (n2 >= (n = this.getComponentCount())) {
                    n2 = n - 1;
                }
                this.iSelectedItem = n2 < 0 ? null : (JComponent)this.getComponentAtLayoutIndex(n2);
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public boolean toggleLabelVisibility() {
            return false;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleToolBarProxy();
            }
            return this.accessibleContext;
        }

        private class AccessibleToolBarProxy
        extends JComponent.AccessibleJComponent
        implements AccessibleSelection {
            AccessibleToolBarProxy() {
                super((JComponent)((Object)ToolBarProxy.this));
                this.setAccessibleName(DTToolBarCustomizationPanel.this.getResourceString("name.ToolbarLayout"));
                this.setAccessibleDescription(DTToolBarCustomizationPanel.this.getResourceString("description.ToolbarLayout"));
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleToolBarProxyRole.LAYOUT;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this;
            }

            @Override
            public int getAccessibleChildrenCount() {
                return ToolBarProxy.this.getComponentCount();
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                return (Accessible)((Object)ToolBarProxy.this.getComponentAtLayoutIndex(n));
            }

            @Override
            public int getAccessibleSelectionCount() {
                return ToolBarProxy.this.iSelectedItem == null ? 0 : 1;
            }

            @Override
            public Accessible getAccessibleSelection(int n) {
                return (Accessible)((Object)ToolBarProxy.this.iSelectedItem);
            }

            @Override
            public boolean isAccessibleChildSelected(int n) {
                return ToolBarProxy.this.iSelectedItem != null && n == ToolBarProxy.this.layoutIndexOf(ToolBarProxy.this.iSelectedItem);
            }

            @Override
            public void addAccessibleSelection(int n) {
                ToolBarProxy.this.setSelectedItem((JComponent)ToolBarProxy.this.getComponentAtLayoutIndex(n));
            }

            @Override
            public void removeAccessibleSelection(int n) {
                if (this.isAccessibleChildSelected(n)) {
                    this.clearAccessibleSelection();
                }
            }

            @Override
            public void clearAccessibleSelection() {
                ToolBarProxy.this.setSelectedItem(null);
            }

            @Override
            public void selectAllAccessibleSelection() {
            }
        }
    }

    private class ToolBarEntry {
        final String iKey;
        final String iLabel;

        ToolBarEntry(String string, String string2) {
            this.iKey = string;
            this.iLabel = string2;
        }

        public boolean equals(Object object) {
            return object instanceof ToolBarEntry && this.iKey.equals(((ToolBarEntry)object).iKey);
        }

        public int hashCode() {
            return this.iKey.hashCode();
        }

        public String toString() {
            return this.iLabel;
        }
    }
}

