/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.google.common.base.Preconditions;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.factory.XMLUtils;
import com.mathworks.util.ClassLoaderBridge;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

public class RecentFiles {
    public static final int PER_TOOL_LIMIT = 12;
    private final Map<String, Tool> fToolMap = new HashMap<String, Tool>();
    private final List<String> fToolNames = new ArrayList<String>();
    private static final String RECENT_FILES_TAG = "recent_files";
    private static final String OPENER_ATTRIBUTE = "opener";
    private static final String ICON_SUPPLIER_ATTRIBUTE = "icon_supplier";
    private static final String PREF_KEY_ATTRIBUTE = "pref_key";
    private static final String LIMIT_ATTRIBUTE = "limit";

    public void addTool(String string, String string2, Opener opener, IconSupplier iconSupplier, String string3, int n) {
        this.addTool(new Tool(string, string2, opener, iconSupplier, string3, n));
    }

    public void addTool(Tool tool) {
        this.fToolNames.add(tool.iName);
        this.fToolMap.put(tool.iName, tool);
        RecentFiles.recall(tool.iPrefKey, tool.iPathNameList, tool.iLimit);
    }

    public void setLimit(String string, int n) {
        Preconditions.checkNotNull((Object)string, (Object)"toolName must not be null");
        Tool tool = this.fToolMap.get(string);
        Preconditions.checkState((tool != null ? 1 : 0) != 0, (String)"Can't set limit for %s before calling addTool", (Object[])new Object[]{string});
        if (n < tool.iLimit) {
            Deque deque = tool.iPathNameList;
            while (deque.size() > n) {
                deque.removeLast();
            }
            RecentFiles.save(tool.iPrefKey, tool.iPathNameList);
        }
        tool.iLimit = n;
    }

    public void addFile(String string, String string2) {
        assert (EventQueue.isDispatchThread());
        Preconditions.checkNotNull((Object)string, (Object)"toolName must not be null");
        Preconditions.checkArgument((string2 != null && string2.length() > 0 ? 1 : 0) != 0, (Object)"pathName cannot be null or empty");
        Tool tool = this.fToolMap.get(string);
        Preconditions.checkState((tool != null ? 1 : 0) != 0, (String)"Can't add file for %s before calling addTool", (Object[])new Object[]{string});
        Object object = tool.iPathNameList.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            boolean bl = PlatformInfo.isUnix() ? string3.equals(string2) : string3.equalsIgnoreCase(string2);
            if (!bl) continue;
            object.remove();
        }
        object = tool.iPathNameList;
        object.addFirst(string2);
        if (object.size() > tool.iLimit) {
            object.removeLast();
        }
        RecentFiles.save(tool.iPrefKey, (Deque<String>)object);
    }

    public List<String> getToolNames() {
        return Collections.unmodifiableList(this.fToolNames);
    }

    public String getToolLabel(String string) {
        Tool tool = this.fToolMap.get(string);
        return tool == null ? null : tool.iLabel;
    }

    public List<Action> getReopenActions(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"toolName must not be null");
        Tool tool = this.fToolMap.get(string);
        Preconditions.checkState((tool != null ? 1 : 0) != 0, (String)"Can't set limit for %s before calling addTool", (Object[])new Object[]{string});
        ArrayList<Action> arrayList = new ArrayList<Action>(tool.iPathNameList.size());
        for (String string2 : tool.iPathNameList) {
            arrayList.add((Action)((Object)new ReopenAction(string2, tool.iIconSupplier, tool.iOpener)));
        }
        return arrayList;
    }

    public static List<Tool> getTools(SimpleElement simpleElement) throws DataFormatException {
        ArrayList<Tool> arrayList = new ArrayList<Tool>();
        ResourceBundle resourceBundle = XMLUtils.readResourceBundleAttribute((SimpleElement)simpleElement);
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(RECENT_FILES_TAG);
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            String string = XMLUtils.readIdAttribute((SimpleElement)simpleElement2, (String)RECENT_FILES_TAG);
            if (string == null) {
                throw new DataFormatException("recent_files missing id attribute");
            }
            String string2 = resourceBundle == null ? string : XMLUtils.getString((ResourceBundle)resourceBundle, (String[])new String[]{"RecentFiles", string, "Label"});
            Opener opener = (Opener)RecentFiles.createFromClassName(simpleElement2.getAttribute(OPENER_ATTRIBUTE), string, Opener.class);
            IconSupplier iconSupplier = (IconSupplier)RecentFiles.createFromClassName(simpleElement2.getAttribute(ICON_SUPPLIER_ATTRIBUTE), string, IconSupplier.class);
            String string3 = simpleElement2.getAttribute(PREF_KEY_ATTRIBUTE);
            if (string3 == null) {
                throw new DataFormatException("recent_files for " + string + " missing " + PREF_KEY_ATTRIBUTE + " attribute");
            }
            int n2 = XMLUtils.readIntegerAttribute((SimpleElement)simpleElement2, (String)LIMIT_ATTRIBUTE, (int)12);
            if (string2 == null || opener == null || iconSupplier != null) {
                // empty if block
            }
            arrayList.add(new Tool(string, string2, opener, iconSupplier, string3, n2));
        }
        return arrayList;
    }

    private static Object createFromClassName(String string, String string2, Class clazz) {
        Object var3_3 = null;
        try {
            var3_3 = ClassLoaderBridge.findClass((String)string).newInstance();
            if (!clazz.isInstance(var3_3)) {
                Log.log((String)(string + " for " + string2 + " is not a " + clazz + " instance\n"));
                var3_3 = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.log((String)("Unable to find class " + string + " for " + string2 + "\n"));
        }
        catch (InstantiationException instantiationException) {
            Log.log((String)("Unable to instantiate " + string + " for " + string2 + "\n"));
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.log((String)("Unable to access " + string + " for " + string2 + "\n"));
        }
        return var3_3;
    }

    private static void recall(String string, Deque<String> deque, int n) {
        String string2;
        for (int i = 0; i < n && (string2 = Prefs.getStringPref((String)(string + (i + 1)), (String)"")) != null && string2.length() > 0; ++i) {
            deque.add(string2);
        }
    }

    private static void save(String string, Deque<String> deque) {
        String string2;
        int n = 0;
        Iterator<String> iterator = deque.iterator();
        while (iterator.hasNext()) {
            Prefs.setStringPref((String)(string + (n + 1)), (String)iterator.next());
            ++n;
        }
        for (int i = n; i < 12 && Prefs.exists((String)(string2 = string + (n + 1))); ++i) {
            Prefs.remove((String)string2);
        }
    }

    private static class ReopenAction
    extends MJAbstractAction {
        private final String iPathName;
        private final Opener iOpener;

        private ReopenAction(String string, IconSupplier iconSupplier, Opener opener) {
            this.iPathName = string;
            this.iOpener = opener;
            if (iconSupplier != null) {
                this.putValue("SmallIcon", iconSupplier.getFileIcon(this.iPathName));
            }
            this.putValue("Name", FilenameUtils.getName((String)string));
            this.putValue("ShortDescription", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iOpener.open(this.iPathName);
        }
    }

    public static class Tool {
        private final String iName;
        private final String iLabel;
        private final Opener iOpener;
        private final IconSupplier iIconSupplier;
        private final String iPrefKey;
        private int iLimit;
        private final Deque<String> iPathNameList = new LinkedList<String>();

        Tool(String string, String string2, Opener opener, IconSupplier iconSupplier, String string3, int n) {
            this.iName = string;
            this.iLabel = string2;
            this.iOpener = opener;
            this.iIconSupplier = iconSupplier;
            this.iPrefKey = string3;
            this.iLimit = n;
        }
    }

    public static interface IconSupplier {
        public Icon getFileIcon(String var1);
    }

    public static interface Opener {
        public void open(String var1);
    }
}

