/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.util.Holder;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.grouptable.ColorStyle;
import java.util.Map;
import java.util.TreeMap;

public final class DisplayEffects {
    private final String fToolTipText;
    private final Map<String, String> fColumnSpecificToolTipText;
    private final ReturnRunnable<ClosableToolTipData> fToolTipGenerator;
    private final Map<String, ReturnRunnable<ClosableToolTipData>> fColumnSpecificToolTipGenerator;
    private final ColorStyle fColorStyle;
    private final Map<String, ColorStyle> fColumnSpecificColorStyle;

    public DisplayEffects(String string, ColorStyle colorStyle) {
        this(null, string, colorStyle);
    }

    public DisplayEffects(String string, String string2, ColorStyle colorStyle) {
        this(string, string2, null, colorStyle);
    }

    public DisplayEffects(ClosableToolTipData closableToolTipData, ColorStyle colorStyle) {
        this(null, closableToolTipData, colorStyle);
    }

    public DisplayEffects(String string, final ClosableToolTipData closableToolTipData, ColorStyle colorStyle) {
        this(string, new ReturnRunnable<ClosableToolTipData>(){

            public ClosableToolTipData run() {
                return closableToolTipData;
            }
        }, colorStyle);
    }

    public DisplayEffects(ReturnRunnable<ClosableToolTipData> returnRunnable, ColorStyle colorStyle) {
        this(null, returnRunnable, colorStyle);
    }

    public DisplayEffects(String string, ReturnRunnable<ClosableToolTipData> returnRunnable, ColorStyle colorStyle) {
        this(string, null, returnRunnable, colorStyle);
    }

    private DisplayEffects(String string, String string2, ReturnRunnable<ClosableToolTipData> returnRunnable, ColorStyle colorStyle) {
        assert (string2 == null || returnRunnable == null);
        if (string == null) {
            this.fToolTipText = string2;
            this.fToolTipGenerator = returnRunnable;
            this.fColorStyle = colorStyle;
            this.fColumnSpecificToolTipText = null;
            this.fColumnSpecificToolTipGenerator = null;
            this.fColumnSpecificColorStyle = null;
        } else {
            this.fToolTipText = null;
            this.fToolTipGenerator = null;
            this.fColorStyle = null;
            this.fColumnSpecificToolTipText = DisplayEffects.createIfNecessary(string, string2);
            this.fColumnSpecificToolTipGenerator = DisplayEffects.createIfNecessary(string, returnRunnable);
            this.fColumnSpecificColorStyle = DisplayEffects.createIfNecessary(string, colorStyle);
        }
    }

    public DisplayEffects(DisplayEffects ... displayEffectsArray) {
        ColorStyle colorStyle = null;
        CombinedToolTipGenerator combinedToolTipGenerator = new CombinedToolTipGenerator();
        Holder holder = new Holder();
        Holder holder2 = new Holder();
        Holder holder3 = new Holder();
        for (DisplayEffects displayEffects : displayEffectsArray) {
            if (displayEffects.fToolTipText != null) {
                combinedToolTipGenerator.add(displayEffects.fToolTipText);
            } else if (displayEffects.fToolTipGenerator != null) {
                combinedToolTipGenerator.add(displayEffects.fToolTipGenerator);
            }
            if (displayEffects.getColorStyle() != null) {
                colorStyle = displayEffects.getColorStyle();
            }
            DisplayEffects.addAll(holder, displayEffects.fColumnSpecificColorStyle);
            DisplayEffects.addAll(holder2, displayEffects.fColumnSpecificToolTipText);
            DisplayEffects.addAll(holder3, displayEffects.fColumnSpecificToolTipGenerator);
        }
        this.fToolTipText = null;
        this.fColorStyle = colorStyle;
        this.fToolTipGenerator = combinedToolTipGenerator;
        this.fColumnSpecificToolTipText = (Map)holder2.get();
        this.fColumnSpecificToolTipGenerator = (Map)holder3.get();
        this.fColumnSpecificColorStyle = (Map)holder.get();
    }

    public ClosableToolTipData getColumnSpecificToolTipData(String string) {
        if (this.fColumnSpecificToolTipGenerator != null && this.fColumnSpecificToolTipGenerator.containsKey(string)) {
            return (ClosableToolTipData)this.fColumnSpecificToolTipGenerator.get(string).run();
        }
        if (this.fColumnSpecificToolTipText != null && this.fColumnSpecificToolTipText.containsKey(string)) {
            return new ClosableToolTipData(this.fColumnSpecificToolTipText.get(string));
        }
        return null;
    }

    public ClosableToolTipData getToolTipData() {
        if (this.fToolTipGenerator == null && this.fToolTipText == null) {
            return null;
        }
        return this.fToolTipGenerator != null ? (ClosableToolTipData)this.fToolTipGenerator.run() : new ClosableToolTipData(this.fToolTipText);
    }

    public ColorStyle getColumnSpecificColorStyle(String string) {
        if (this.fColumnSpecificColorStyle != null && this.fColumnSpecificColorStyle.containsKey(string)) {
            return this.fColumnSpecificColorStyle.get(string);
        }
        return null;
    }

    public ColorStyle getColorStyle() {
        return this.fColorStyle == null ? ColorStyle.NORMAL : this.fColorStyle;
    }

    private static <K, V> void addAll(Holder<Map<K, V>> holder, Map<K, V> map) {
        if (map != null) {
            if (holder.get() == null) {
                holder.set(new TreeMap());
            }
            ((Map)holder.get()).putAll(map);
        }
    }

    private static <K, V> Map<K, V> createIfNecessary(K k, V v) {
        if (v == null) {
            return null;
        }
        TreeMap<K, V> treeMap = new TreeMap<K, V>();
        treeMap.put(k, v);
        return treeMap;
    }

    private static class CombinedToolTipGenerator
    implements ReturnRunnable<ClosableToolTipData> {
        private ReturnRunnable<ClosableToolTipData>[] fGenerators;

        private CombinedToolTipGenerator() {
        }

        void add(final String string) {
            this.add(new ReturnRunnable<ClosableToolTipData>(){

                public ClosableToolTipData run() {
                    return new ClosableToolTipData(string);
                }
            });
        }

        void add(ReturnRunnable<ClosableToolTipData> returnRunnable) {
            if (this.fGenerators == null) {
                this.fGenerators = new ReturnRunnable[1];
                this.fGenerators[0] = returnRunnable;
            } else {
                ReturnRunnable[] returnRunnableArray = new ReturnRunnable[this.fGenerators.length + 1];
                System.arraycopy(this.fGenerators, 0, returnRunnableArray, 0, this.fGenerators.length);
                returnRunnableArray[returnRunnableArray.length - 1] = returnRunnable;
                this.fGenerators = returnRunnableArray;
            }
        }

        public ClosableToolTipData run() {
            if (this.fGenerators != null) {
                for (int i = this.fGenerators.length - 1; i >= 0; --i) {
                    ClosableToolTipData closableToolTipData = (ClosableToolTipData)this.fGenerators[i].run();
                    if (closableToolTipData == null || closableToolTipData.isPreferenceSetToClose()) continue;
                    return closableToolTipData;
                }
            }
            return null;
        }
    }
}

