/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.widgets.grouptable.GroupingTableColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GroupingTableLayout<T> {
    private final List<GroupingTableColumn<T>> fVisibleColumnsInOrder = new Vector<GroupingTableColumn<T>>();
    private final Map<GroupingTableColumn<T>, Integer> fSizes = new HashMap<GroupingTableColumn<T>, Integer>();

    public void addColumn(GroupingTableColumn<T> groupingTableColumn, int n) {
        this.fVisibleColumnsInOrder.add(groupingTableColumn);
        this.fSizes.put(groupingTableColumn, n);
    }

    public int indexOf(GroupingTableColumn<T> groupingTableColumn) {
        return this.fVisibleColumnsInOrder.indexOf(groupingTableColumn);
    }

    public List<GroupingTableColumn<T>> getVisibleColumnsInOrder() {
        return new Vector<GroupingTableColumn<T>>(this.fVisibleColumnsInOrder);
    }

    public int getSize(GroupingTableColumn<T> groupingTableColumn) {
        if (!this.fVisibleColumnsInOrder.contains(groupingTableColumn)) {
            return -1;
        }
        return this.fSizes.get(groupingTableColumn);
    }

    public double getSizePercent(GroupingTableColumn<T> groupingTableColumn) {
        return (double)this.getSize(groupingTableColumn) / (double)this.getTotalSize();
    }

    public int getTotalSize() {
        int n = 0;
        for (Integer n2 : this.fSizes.values()) {
            n += n2.intValue();
        }
        return n;
    }

    public GroupingTableColumn<T> getPriorColumn(GroupingTableColumn<T> groupingTableColumn) {
        int n = this.fVisibleColumnsInOrder.indexOf(groupingTableColumn);
        if (n <= 0) {
            return null;
        }
        return this.fVisibleColumnsInOrder.get(n - 1);
    }

    public GroupingTableColumn<T> getNextColumn(GroupingTableColumn<T> groupingTableColumn) {
        int n = this.fVisibleColumnsInOrder.indexOf(groupingTableColumn);
        if (n < 0 || n >= this.fVisibleColumnsInOrder.size() - 1) {
            return null;
        }
        return this.fVisibleColumnsInOrder.get(n + 1);
    }
}

