/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.DefaultExpandableRow;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.grouptable.CombinedExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTablePopulator;
import com.mathworks.widgets.grouptable.GroupingTableResources;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import com.mathworks.widgets.grouptable.RowListTransactionTarget;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public final class GroupingTableRow<T>
extends DefaultExpandableRow {
    private final Group<T> fGroup;
    private final boolean fIsPlaceholder;
    private final ExpansionChangeListener<T> fExpansionChangeListener;
    private final GroupingTableConfiguration<T> fConfiguration;
    private final GroupingTablePopulator<T> fPopulator;
    private final Map<VerticalAttribute<T>, String> fVerticalAttributeValues;
    private final Object fContextLock;
    private CombinedExpansionContext<T> fExpansionContext;
    private boolean fChildrenPopulated;
    private boolean fExpandableStateInitialized;
    private boolean fDisposed;
    private T fItem;

    GroupingTableRow(GroupingTableConfiguration<T> groupingTableConfiguration, GroupingTablePopulator<T> groupingTablePopulator, Group<T> group) {
        this.fGroup = group;
        this.fItem = null;
        this.fExpansionChangeListener = null;
        this.fPopulator = groupingTablePopulator;
        this.fIsPlaceholder = false;
        this.fConfiguration = groupingTableConfiguration;
        this.fVerticalAttributeValues = new HashMap<VerticalAttribute<T>, String>();
        this.fContextLock = new Object();
    }

    GroupingTableRow(GroupingTableConfiguration<T> groupingTableConfiguration, GroupingTablePopulator<T> groupingTablePopulator, T t) {
        this(groupingTableConfiguration, groupingTablePopulator, t, false);
    }

    private GroupingTableRow(GroupingTableConfiguration<T> groupingTableConfiguration, GroupingTablePopulator<T> groupingTablePopulator, T t, final boolean bl) {
        this.fConfiguration = groupingTableConfiguration;
        this.fGroup = null;
        this.fPopulator = groupingTablePopulator;
        this.fItem = t;
        this.fIsPlaceholder = bl;
        this.fVerticalAttributeValues = new HashMap<VerticalAttribute<T>, String>(2);
        this.fContextLock = new Object();
        this.fExpansionChangeListener = new ExpansionChangeListener<T>(){

            @Override
            public void childrenChanged(GroupingTableTransaction<T> groupingTableTransaction) {
                if (!GroupingTableRow.this.isExpanded()) {
                    return;
                }
                groupingTableTransaction.apply(GroupingTableRow.this.createTransactionTarget(bl));
            }

            @Override
            public void hasChildrenChanged() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!GroupingTableRow.this.isExpanded()) {
                            GroupingTableRow.this.fExpandableStateInitialized = false;
                            GroupingTableRow.this.fPopulator.notifyVisible(GroupingTableRow.this);
                        }
                    }
                });
            }
        };
    }

    public int getLoadedVerticalAttributeCount() {
        return this.getLoadedVerticalAttributes().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnyVerticalAttributeMissing() {
        if (this.fItem == null) {
            return false;
        }
        Map<VerticalAttribute<T>, String> map = this.fVerticalAttributeValues;
        synchronized (map) {
            for (VerticalAttribute<T> verticalAttribute : this.fConfiguration.getVisibleVerticalAttributes()) {
                if (!this.isExpanded() && !verticalAttribute.shouldShowWhenCollapsed(this.fItem) || this.fVerticalAttributeValues.containsKey(verticalAttribute)) continue;
                return true;
            }
            return false;
        }
    }

    void loadAllNonLoadedVerticalAttributes() {
        if (this.fItem != null) {
            for (VerticalAttribute<T> verticalAttribute : this.fConfiguration.getVisibleVerticalAttributes()) {
                this.getOrLoadVerticalAttribute(verticalAttribute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<VerticalAttribute<T>, String> getLoadedVerticalAttributes() {
        LinkedHashMap<VerticalAttribute<T>, String> linkedHashMap = new LinkedHashMap<VerticalAttribute<T>, String>();
        Map<VerticalAttribute<T>, String> map = this.fVerticalAttributeValues;
        synchronized (map) {
            if (this.fItem != null) {
                for (VerticalAttribute<T> verticalAttribute : this.fConfiguration.getVisibleVerticalAttributes()) {
                    String string;
                    if (!this.isExpanded() && !verticalAttribute.shouldShowWhenCollapsed(this.fItem) || !this.fVerticalAttributeValues.containsKey(verticalAttribute) || (string = this.fVerticalAttributeValues.get(verticalAttribute)) == null || string.trim().length() <= 0) continue;
                    linkedHashMap.put(verticalAttribute, string);
                }
            }
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrLoadVerticalAttribute(VerticalAttribute<T> verticalAttribute) {
        if (this.fItem == null) {
            return null;
        }
        Map<VerticalAttribute<T>, String> map = this.fVerticalAttributeValues;
        synchronized (map) {
            if (!this.fVerticalAttributeValues.containsKey(verticalAttribute)) {
                this.fVerticalAttributeValues.put(verticalAttribute, verticalAttribute.getText(this.fItem));
            }
            return this.fVerticalAttributeValues.get(verticalAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        CombinedExpansionContext<T> combinedExpansionContext;
        Object object = this.fContextLock;
        synchronized (object) {
            combinedExpansionContext = this.fExpansionContext;
            if (combinedExpansionContext != null) {
                this.fExpansionContext = null;
                this.fExpandableStateInitialized = false;
            }
        }
        if (combinedExpansionContext != null) {
            combinedExpansionContext.close();
            this.initializeExpandableState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeExpandableState() {
        CombinedExpansionContext<T> combinedExpansionContext;
        boolean bl = this.fExpandableStateInitialized;
        this.fExpandableStateInitialized = true;
        Object object = this.fContextLock;
        synchronized (object) {
            combinedExpansionContext = this.fExpansionContext;
            if (combinedExpansionContext == null && !this.fIsPlaceholder && this.fItem != null) {
                this.fExpansionContext = new CombinedExpansionContext<T>(this.fItem, this.fConfiguration);
                this.fExpansionContext.addListener(this.fExpansionChangeListener);
                combinedExpansionContext = this.fExpansionContext;
            }
        }
        if (!(bl || this.fDisposed || this.fIsPlaceholder || combinedExpansionContext == null)) {
            if (combinedExpansionContext.hasChildren()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GroupingTableRow.this.setExpandable(true);
                    }
                });
                GroupingTableUtils.populateFirstChild(combinedExpansionContext, this.createTransactionTarget(true));
            } else {
                this.setChildren(new ArrayList(0));
            }
        }
    }

    public boolean isExpandableStateInitialized() {
        return this.fExpandableStateInitialized;
    }

    public void setChildren(List<?> list) {
        this.fExpandableStateInitialized = true;
        if (list != null && list.size() < 10) {
            ArrayList arrayList = new ArrayList(list.size());
            arrayList.addAll(list);
            list = arrayList;
        }
        super.setChildren(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpanded(boolean bl) {
        boolean bl2;
        CombinedExpansionContext<T> combinedExpansionContext;
        Object object = this.fContextLock;
        synchronized (object) {
            combinedExpansionContext = this.fExpansionContext;
            bl2 = bl && this.fExpansionContext != null && !this.fChildrenPopulated;
        }
        if (bl2) {
            object = this.fPopulator.getWorkMonitor();
            WorkMonitor.Task task = ((WorkMonitor)object).startTask(GroupingTableResources.getString("table.populating"));
            this.fChildrenPopulated = true;
            GroupingTableTransaction.Target<T> target = this.createTransactionTarget(true);
            GroupingTableTransaction<T> groupingTableTransaction = new GroupingTableTransaction<T>();
            groupingTableTransaction.add(GroupingTableTransaction.Type.CLEAR);
            groupingTableTransaction.apply(target);
            GroupingTableUtils.populate(this.fPopulator, combinedExpansionContext, this.createTransactionTarget(false), ((WorkMonitor)object).createEdtFinisher(task));
        }
        if (this.fItem != null) {
            this.fConfiguration.setExpanded(this.fItem, bl);
        }
        if (!bl && this.fItem != null) {
            this.removeChildrenAndLeavePlaceholder();
        }
        super.setExpanded(bl);
        if (bl && this.fPopulator != null) {
            this.fPopulator.notifyExpanded(this);
        }
    }

    public void removeAllChildren() {
        ArrayList arrayList = new ArrayList(this._children);
        this._children.clear();
        if (!this.isAdjusting() & this.getTreeTableModel() != null) {
            this.notifyChildrenDeleted(arrayList);
        }
        for (Object e : arrayList) {
            if (!(e instanceof GroupingTableRow)) continue;
            ((GroupingTableRow)((Object)e)).setParent(null);
        }
    }

    private void removeChildrenAndLeavePlaceholder() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List list = GroupingTableRow.this.getChildren();
                if (list != null && !list.isEmpty()) {
                    GroupingTableRow.this.fPopulator.getModel().detectOverflow(-list.size());
                    GroupingTableRow groupingTableRow = (GroupingTableRow)((Object)list.get(0));
                    for (GroupingTableRow groupingTableRow2 : list) {
                        groupingTableRow2.dispose();
                    }
                    list.clear();
                    list.add(new GroupingTableRow(GroupingTableRow.this.fConfiguration, GroupingTableRow.this.fPopulator, groupingTableRow.getItem(), true));
                    GroupingTableRow.this.setChildren(list);
                    GroupingTableRow.this.fChildrenPopulated = false;
                    GroupingTableRow.this.fPopulator.notifyChildrenRemoved(GroupingTableRow.this);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CombinedExpansionContext<T> getExpansionContext() {
        Object object = this.fContextLock;
        synchronized (object) {
            return this.fExpansionContext;
        }
    }

    boolean isPlaceholder() {
        return this.fIsPlaceholder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupingTableTransaction.UpdateResult updateItem(T t) {
        List<Group<Object>> list;
        List<Group<Object>> list2;
        assert (this.fItem != null && this.fItem.equals(t));
        T t2 = this.fItem;
        this.fItem = t;
        Object object2 = this.fVerticalAttributeValues;
        synchronized (object2) {
            for (VerticalAttribute<T> object3 : new ArrayList<VerticalAttribute<T>>(this.fVerticalAttributeValues.keySet())) {
                this.fVerticalAttributeValues.remove(object3);
                this.getOrLoadVerticalAttribute(object3);
            }
        }
        object2 = this.fConfiguration.getAscendingSortComparator();
        if (object2 != null && object2.compare(t2, t) != 0) {
            return GroupingTableTransaction.UpdateResult.AFFECTS_SORTING_OR_GROUPING;
        }
        GroupingMode<T> groupingMode = this.fConfiguration.getGroupMode();
        if (groupingMode != null && !((Object)(list2 = groupingMode.getGroups(Arrays.asList(t2)))).equals(list = groupingMode.getGroups(Arrays.asList(this.fItem)))) {
            return GroupingTableTransaction.UpdateResult.AFFECTS_SORTING_OR_GROUPING;
        }
        return GroupingTableTransaction.UpdateResult.DOES_NOT_AFFECT_SORTING_OR_GROUPING;
    }

    public Group<T> getGroup() {
        return this.fGroup;
    }

    public T getItem() {
        return this.fItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachExpansionContext() {
        Object object = this.fContextLock;
        synchronized (object) {
            if (this.fExpansionContext != null) {
                this.fExpansionContext.removeListener(this.fExpansionChangeListener);
            }
            this.fExpansionContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Iterator iterator = this.fContextLock;
        synchronized (iterator) {
            if (this.fExpansionContext != null) {
                this.fExpansionContext.removeListener(this.fExpansionChangeListener);
                this.fExpansionContext.close();
            }
        }
        if (this.getChildren() != null) {
            for (GroupingTableRow groupingTableRow : this.getChildren()) {
                groupingTableRow.dispose();
            }
        }
        this.fDisposed = true;
    }

    public Object getValueAt(int n) {
        if (this.fGroup != null) {
            return n == 0 ? this.fGroup : null;
        }
        GroupingTableColumn<T> groupingTableColumn = this.fConfiguration.getVisibleColumn(n);
        return groupingTableColumn == null ? "" : groupingTableColumn.getValue(this.fItem);
    }

    public boolean equals(Object object) {
        if (!GroupingTableRow.class.isInstance(object)) {
            return false;
        }
        GroupingTableRow groupingTableRow = (GroupingTableRow)((Object)object);
        if (groupingTableRow.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (groupingTableRow.getGroup() != null) {
            return this.getGroup().equals(groupingTableRow.getGroup());
        }
        return this.getItem().equals(groupingTableRow.getItem());
    }

    public int hashCode() {
        return this.fGroup != null ? this.fGroup.hashCode() : this.fItem.hashCode();
    }

    public String toString() {
        return "group: " + this.fGroup + " item: " + this.fItem;
    }

    GroupingTableTransaction.Target<T> createTransactionTarget() {
        return this.createTransactionTarget(false);
    }

    private GroupingTableTransaction.Target<T> createTransactionTarget(final boolean bl) {
        return new RowListTransactionTarget(new RowListTransactionTarget.Adapter<T>(){

            @Override
            public List<GroupingTableRow<T>> start() {
                List list = GroupingTableRow.this.getChildren();
                if (list == null) {
                    return new ArrayList();
                }
                return GroupingTableUtils.withoutPlaceholders(list);
            }

            @Override
            public void commitRows(List<GroupingTableRow<T>> list, Map<T, Integer> map, boolean bl2) {
                GroupingTableRow.this.setChildren(list);
                GroupingTableRow.this.setExpandable(!list.isEmpty());
                GroupingTableRow.this.fPopulator.notifyChildrenAdded(GroupingTableRow.this);
                if (GroupingTableRow.this.fItem != null && GroupingTableRow.this.fConfiguration.isExpanded(GroupingTableRow.this.fItem)) {
                    GroupingTableRow.this.setExpanded(true);
                }
            }

            @Override
            public GroupingTableRow<T> createRow(T t) {
                return new GroupingTableRow(GroupingTableRow.this.fConfiguration, GroupingTableRow.this.fPopulator, t, bl);
            }

            @Override
            public GroupingTableConfiguration<T> getConfiguration() {
                return GroupingTableRow.this.fConfiguration;
            }

            @Override
            public boolean detectOverflow(int n) {
                return GroupingTableRow.this.fPopulator.getModel().detectOverflow(n);
            }

            @Override
            public boolean inOverflowState() {
                return GroupingTableRow.this.fPopulator.getModel().inOverflowState();
            }
        });
    }
}

