/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.plaf.basic.BasicCellSpanTableUIDelegate;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableCellRenderer;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

final class GroupingTableUIDelegate
extends BasicCellSpanTableUIDelegate {
    private Set _paintedCell = new HashSet();

    GroupingTableUIDelegate(JTable jTable, CellRendererPane cellRendererPane) {
        super(jTable, cellRendererPane);
    }

    public void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        Object object;
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            object = ((JideTable)this.table).getEditorCellRect(n, n2);
            if (rectangle != null && rectangle.equals(object)) {
                return;
            }
        }
        if (rectangle == null) {
            return;
        }
        object = this.table.getCellRenderer(n, n2);
        if (object == null) {
            return;
        }
        GroupingTable groupingTable = (GroupingTable)((Object)this.table);
        GroupingTableRow groupingTableRow = groupingTable.getRowAt(n);
        GroupingTableCellRenderer groupingTableCellRenderer = (GroupingTableCellRenderer)groupingTable.getColumnModel().getColumn(n2).getCellRenderer();
        groupingTableCellRenderer.setCellRect(groupingTable, groupingTableRow, n2, rectangle);
        Component component = this.table.prepareRenderer((TableCellRenderer)object, n, n2);
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (this.table instanceof JideTable) {
            ((JideTable)this.table).releaseRendererComponent((TableCellRenderer)object, n, n2, component);
        }
        groupingTableCellRenderer.setCellRect(null, null, 0, null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        if (!(this.table instanceof CellSpanTable)) {
            super.paint(graphics, jComponent);
            return;
        }
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        TableModel tableModel = cellSpanTable.getSpanModel();
        if (!(tableModel instanceof SpanModel) || !((SpanModel)tableModel).isCellSpanOn()) {
            super.paint(graphics, jComponent);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = cellSpanTable.originalRowAtPoint(point);
        int n2 = cellSpanTable.originalRowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = cellSpanTable.getRowCount() - 1;
        }
        int n3 = cellSpanTable.originalColumnAtPoint((bl = cellSpanTable.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n4 = cellSpanTable.originalColumnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = cellSpanTable.getColumnCount() - 1;
        }
        this.paintSpanCells(graphics, n, n2, n3, n4);
        this.paintSpanGrid(graphics, n, n2, n3, n4);
    }

    private void paintSpanGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        CellSpan cellSpan;
        int n6;
        int n7;
        int n8;
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        Rectangle rectangle = cellSpanTable.originalGetCellRect(n, n3, true);
        Rectangle rectangle2 = cellSpanTable.originalGetCellRect(n2, n4, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        boolean bl2 = cellSpanTable.getComponentOrientation().isLeftToRight();
        graphics.setColor(cellSpanTable.getGridColor());
        if (cellSpanTable.getShowVerticalLines()) {
            int n9;
            TableColumnModel tableColumnModel = cellSpanTable.getColumnModel();
            if (bl2) {
                n8 = rectangle3.x;
                for (n9 = n3; n9 <= n4; ++n9) {
                    n7 = rectangle3.y;
                    n8 += tableColumnModel.getColumn(n9).getWidth();
                    for (n6 = n; n6 <= n2; ++n6) {
                        cellSpan = cellSpanTable.getCellSpanAt(n6, n9);
                        bl = false;
                        if (cellSpan == null) {
                            bl = true;
                        } else {
                            n5 = Math.min(cellSpan.getColumn() + cellSpan.getColumnSpan() - 1, tableColumnModel.getColumnCount() - 1);
                            if (n9 == n5) {
                                bl = true;
                            } else {
                                int n10;
                                for (n10 = n9 + 1; n10 <= n5 && tableColumnModel.getColumn(n10).getWidth() == 0; ++n10) {
                                }
                                if (n10 > n5) {
                                    bl = true;
                                }
                            }
                        }
                        n5 = cellSpanTable.getRowHeight(n6);
                        if (bl) {
                            graphics.drawLine(n8 - 1, n7, n8 - 1, n7 + n5 - 1);
                        }
                        n7 += n5;
                    }
                }
            } else {
                n8 = rectangle3.x + rectangle3.width;
                for (n9 = n3; n9 < n4; ++n9) {
                    n7 = rectangle3.y;
                    n8 -= tableColumnModel.getColumn(n9).getWidth();
                    for (n6 = n; n6 <= n2; ++n6) {
                        cellSpan = cellSpanTable.getCellSpanAt(n6, n9);
                        bl = cellSpan == null || n9 == cellSpan.getColumn() + cellSpan.getColumnSpan() - 1;
                        n5 = cellSpanTable.getRowHeight(n6);
                        if (bl) {
                            graphics.drawLine(n8 - 1, n7, n8 - 1, n7 + n5 - 1);
                        }
                        n7 += n5;
                    }
                }
            }
        }
        graphics.setColor(cellSpanTable.getGridColor());
        if (cellSpanTable.getShowHorizontalLines()) {
            int n11 = rectangle3.y;
            for (n8 = n; n8 <= n2; ++n8) {
                n7 = bl2 ? rectangle3.x : rectangle3.x + rectangle3.width;
                n11 += cellSpanTable.getRowHeight(n8);
                Color color = cellSpanTable.getGridColor(n8);
                if (color != null) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(cellSpanTable.getGridColor());
                }
                for (n6 = n3; n6 <= n4; ++n6) {
                    cellSpan = cellSpanTable.getCellSpanAt(n8, n6);
                    bl = cellSpan == null || n8 == cellSpan.getRow() + cellSpan.getRowSpan() - 1;
                    n5 = cellSpanTable.getColumnModel().getColumn(n6).getWidth();
                    if (bl) {
                        if (bl2) {
                            graphics.drawLine(n7, n11 - 1, n7 + n5 - 1, n11 - 1);
                        } else {
                            graphics.drawLine(n7, n11 - 1, n7 - n5 - 1, n11 - 1);
                        }
                    }
                    if (bl2) {
                        n7 += n5;
                        continue;
                    }
                    n7 -= n5;
                }
            }
        }
    }

    private void addPaintedCell(Cell cell) {
        this._paintedCell.add(cell);
    }

    private boolean isCellPainted(Cell cell) {
        return this._paintedCell.contains(cell);
    }

    private void paintSpanCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        SpanModel spanModel = (SpanModel)((CellSpanTable)this.table).getSpanModel();
        this._paintedCell.clear();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    Cell cell;
                    TableColumn tableColumn2;
                    Rectangle rectangle;
                    CellSpan cellSpan = cellSpanTable.getCellSpanAt(spanModel, i, j);
                    if (cellSpan != null) {
                        int n5;
                        int n6 = cellSpan.getRow();
                        Cell cell2 = new Cell(n6, n5 = cellSpan.getColumn());
                        if (this.isCellPainted(cell2) || n6 != i && n5 != j) continue;
                        rectangle = this.table.getCellRect(i, j, false);
                        tableColumn2 = tableColumnModel.getColumn(j);
                        if (tableColumn2 == tableColumn) continue;
                        this.paintCell(graphics, rectangle, n6, n5);
                        this.addPaintedCell(cell2);
                        continue;
                    }
                    rectangle = this.table.getCellRect(i, j, false);
                    tableColumn2 = tableColumnModel.getColumn(j);
                    if (tableColumn2 == tableColumn || this.isCellPainted(cell = new Cell(i, j))) continue;
                    this.paintCell(graphics, rectangle, i, j);
                    this.addPaintedCell(cell);
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    Cell cell;
                    TableColumn tableColumn3;
                    Rectangle rectangle;
                    CellSpan cellSpan = cellSpanTable.getCellSpanAt(spanModel, i, j);
                    if (cellSpan != null) {
                        int n7;
                        int n8 = cellSpan.getRow();
                        Cell cell3 = new Cell(n8, n7 = cellSpan.getColumn());
                        if (this.isCellPainted(cell3) || n8 != i && n7 != j) continue;
                        rectangle = this.table.getCellRect(i, j, false);
                        tableColumn3 = tableColumnModel.getColumn(j);
                        if (tableColumn3 == tableColumn) continue;
                        this.paintCell(graphics, rectangle, n8, n7);
                        this.addPaintedCell(cell3);
                        continue;
                    }
                    rectangle = this.table.getCellRect(i, j, false);
                    tableColumn3 = tableColumnModel.getColumn(j);
                    if (tableColumn3 == tableColumn || this.isCellPainted(cell = new Cell(i, j))) continue;
                    this.paintCell(graphics, rectangle, i, j);
                    this.addPaintedCell(cell);
                }
            }
        }
        if (tableColumn != null) {
            this.paintSpanDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private class Cell {
        int row;
        int column;

        public Cell(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public int hashCode() {
            int n = this.row;
            n = 29 * n + this.column;
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Cell) {
                Cell cell = (Cell)object;
                return this.row == cell.row && this.column == cell.column;
            }
            return super.equals(object);
        }
    }
}

