/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.internal.loginws.client.v2.LoginServiceClient;
import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.DefaultPersistenceStrategy;
import com.mathworks.widgets.login.LoginDialogConsumer;
import com.mathworks.widgets.login.LoginFonts;
import com.mathworks.widgets.login.LoginPersistenceStrategy;
import com.mathworks.widgets.login.LoginUtils;
import com.mathworks.widgets.login.ProxySettings;
import com.mathworks.widgets.login.UniversalLoginComponent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public final class UniversalLoginDialog {
    private LoginDialog fDialog;
    private UniversalLoginComponent fLoginComponent;

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, ProxySettings proxySettings) {
        return UniversalLoginDialog.invoke(loginDialogConsumer, string, authenticationListener, UniversalLoginComponent.LoginDisplayType.LOGIN_AND_BENEFITS, proxySettings);
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, String string2, ProxySettings proxySettings) {
        return UniversalLoginDialog.invoke(loginDialogConsumer, string, authenticationListener, UniversalLoginComponent.LoginDisplayType.LOGIN_AND_BENEFITS, false, new DefaultPersistenceStrategy(), string2, proxySettings);
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, LoginServiceClient loginServiceClient, ProxySettings proxySettings) {
        return UniversalLoginDialog.invoke(loginDialogConsumer, authenticationListener, UniversalLoginComponent.LoginDisplayType.LOGIN_AND_BENEFITS, false, new DefaultPersistenceStrategy(), loginServiceClient, proxySettings);
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, ProxySettings proxySettings) {
        return UniversalLoginDialog.invoke(loginDialogConsumer, string, authenticationListener, loginDisplayType, false, proxySettings);
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, ProxySettings proxySettings) {
        return UniversalLoginDialog.invoke(loginDialogConsumer, string, authenticationListener, loginDisplayType, bl, new DefaultPersistenceStrategy(), proxySettings);
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, ProxySettings proxySettings) {
        UniversalLoginDialog universalLoginDialog = new UniversalLoginDialog(loginDialogConsumer, string, authenticationListener, loginDisplayType, bl, loginPersistenceStrategy, proxySettings);
        universalLoginDialog.show();
        return universalLoginDialog;
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, String string2, ProxySettings proxySettings) {
        UniversalLoginDialog universalLoginDialog = new UniversalLoginDialog(loginDialogConsumer, string, authenticationListener, loginDisplayType, bl, loginPersistenceStrategy, string2, proxySettings);
        universalLoginDialog.show();
        return universalLoginDialog;
    }

    public static UniversalLoginDialog invoke(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, LoginServiceClient loginServiceClient, ProxySettings proxySettings) {
        UniversalLoginDialog universalLoginDialog = new UniversalLoginDialog(loginDialogConsumer, authenticationListener, loginDisplayType, bl, loginPersistenceStrategy, loginServiceClient, proxySettings);
        universalLoginDialog.show();
        return universalLoginDialog;
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, ProxySettings proxySettings) {
        this(loginDialogConsumer, authenticationListener, UniversalLoginComponent.LoginDisplayType.LOGIN_AND_BENEFITS, proxySettings);
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, String string, ProxySettings proxySettings) {
        this(loginDialogConsumer, null, authenticationListener, UniversalLoginComponent.LoginDisplayType.LOGIN_AND_BENEFITS, false, new DefaultPersistenceStrategy(), string, proxySettings);
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, ProxySettings proxySettings) {
        this(loginDialogConsumer, authenticationListener, loginDisplayType, false, proxySettings);
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, ProxySettings proxySettings) {
        this(loginDialogConsumer, null, authenticationListener, loginDisplayType, bl, new DefaultPersistenceStrategy(), proxySettings);
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, ProxySettings proxySettings) {
        assert (SwingUtilities.isEventDispatchThread()) : "UniversalLoginDialog must be created on the EDT.";
        assert (loginDialogConsumer != null) : "UniversalLoginDialog must be created with non-null LoginDialogConsumer.";
        assert (string != null) : "UniversalLoginDialog must be created with non-null clientString.";
        assert (loginPersistenceStrategy != null) : "UniversalLoginDialog must be created with non-null LoginPersistenceStrategy.";
        this.createDialog(loginDialogConsumer, authenticationListener, loginDisplayType, bl, loginPersistenceStrategy, string, null, null, proxySettings);
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, String string, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, String string2, ProxySettings proxySettings) {
        assert (SwingUtilities.isEventDispatchThread()) : "UniversalLoginDialog must be created on the EDT.";
        assert (loginDialogConsumer != null) : "UniversalLoginDialog must be created with non-null LoginDialogConsumer.";
        assert (string != null) : "UniversalLoginDialog must be created with non-null clientString.";
        assert (loginPersistenceStrategy != null) : "UniversalLoginDialog must be created with non-null LoginPersistenceStrategy.";
        assert (string2 != null) : "UniversalLoginDialog must be created with non-null Web-Service Login Endpoint.";
        this.createDialog(loginDialogConsumer, authenticationListener, loginDisplayType, bl, loginPersistenceStrategy, string, string2, null, proxySettings);
    }

    public UniversalLoginDialog(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, LoginServiceClient loginServiceClient, ProxySettings proxySettings) {
        assert (SwingUtilities.isEventDispatchThread()) : "UniversalLoginDialog must be created on the EDT.";
        assert (loginDialogConsumer != null) : "UniversalLoginDialog must be created with non-null LoginDialogConsumer.";
        assert (loginPersistenceStrategy != null) : "UniversalLoginDialog must be created with non-null LoginPersistenceStrategy.";
        assert (loginServiceClient != null) : "UniversalLoginDialog must be created with non-null LoginServiceClient.";
        this.createDialog(loginDialogConsumer, authenticationListener, loginDisplayType, bl, loginPersistenceStrategy, null, null, loginServiceClient, proxySettings);
    }

    private void createDialog(LoginDialogConsumer loginDialogConsumer, AuthenticationListener authenticationListener, UniversalLoginComponent.LoginDisplayType loginDisplayType, boolean bl, LoginPersistenceStrategy loginPersistenceStrategy, String string, String string2, LoginServiceClient loginServiceClient, ProxySettings proxySettings) {
        Component component = loginDialogConsumer.getInvoker();
        Window window = UniversalLoginDialog.createWindowForDialog(component);
        this.fDialog = this.createDialog(window, bl);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(ApplicationIcon.MATLAB.getIcon().getImage());
        arrayList.add(ApplicationIcon.MATLAB_32x32.getIcon().getImage());
        arrayList.add(ApplicationIcon.MATLAB_48x48.getIcon().getImage());
        this.fDialog.setIconImages(arrayList);
        if (loginDisplayType == UniversalLoginComponent.LoginDisplayType.SHORT_LOGIN) {
            this.fDialog.setTitle(LoginUtils.getString("universalLogin.title.text.inu"));
        } else {
            this.fDialog.setTitle(LoginUtils.getString("universalLogin.title.text"));
        }
        this.fDialog.setFont(LoginFonts.getDefaultFont());
        this.fDialog.setName("UniversalLoginDialog");
        this.fDialog.getAccessibleContext().setAccessibleName("UniversalLoginDialog");
        this.fLoginComponent = loginServiceClient != null ? new UniversalLoginComponent(authenticationListener, loginDisplayType, loginPersistenceStrategy, loginServiceClient) : (string2 != null ? new UniversalLoginComponent(string, authenticationListener, loginDisplayType, loginPersistenceStrategy, string2, proxySettings) : new UniversalLoginComponent(string, authenticationListener, loginDisplayType, loginPersistenceStrategy, proxySettings));
        this.fDialog.add(this.fLoginComponent.getComponent());
        this.fDialog.setResizable(false);
        this.fDialog.pack();
        this.fDialog.getRootPane().setDefaultButton(this.fLoginComponent.getDefaultButton());
        if (window != null) {
            this.fDialog.setLocationRelativeTo(window);
        } else {
            Point point = this.getLocationForDialog();
            this.fDialog.setLocation(point.x, point.y);
        }
        this.fLoginComponent.requestFocus();
    }

    private static Window createWindowForDialog(Component component) {
        Window window = null;
        if (component != null) {
            window = component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        }
        return window;
    }

    private LoginDialog createDialog(Object object, boolean bl) {
        LoginDialog loginDialog = object != null ? (object instanceof Frame ? new LoginDialog((Frame)object, bl) : new LoginDialog((Dialog)object, bl)) : new LoginDialog((Dialog)object, bl);
        return loginDialog;
    }

    private void authenticationCancelled() {
        if (this.fLoginComponent != null && this.fLoginComponent.getAuthenticationListener() != null) {
            this.fLoginComponent.getAuthenticationListener().notAuthenticated();
        }
    }

    private Point getLocationForDialog() {
        Dimension dimension = this.fDialog.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension2.width - dimension.width) / 2;
        int n2 = (dimension2.height - dimension.height) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new Point(n, n2);
    }

    public Component getComponent() {
        return this.fDialog;
    }

    public void setVisible(boolean bl) {
        if (this.fDialog != null) {
            this.fDialog.setVisible(bl);
        }
    }

    public void setSize(Dimension dimension) {
        if (this.fDialog != null) {
            this.fDialog.setSize(dimension);
        }
    }

    public void setLocation(Point point) {
        if (this.fDialog != null) {
            this.fDialog.setLocation(point);
        }
    }

    public void setLocationRelativeTo(Component component) {
        if (this.fDialog != null) {
            this.fDialog.setLocationRelativeTo(component);
        }
    }

    public void show() {
        if (this.fDialog != null) {
            this.fDialog.setVisible(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UniversalLoginDialog.this.fDialog != null) {
                    UniversalLoginDialog.this.fDialog.toFront();
                    UniversalLoginDialog.this.fLoginComponent.clearPanel();
                    UniversalLoginDialog.this.fLoginComponent.requestFocus();
                }
            }
        });
    }

    public void close() {
        if (this.fDialog != null) {
            this.fDialog.setVisible(false);
        }
    }

    public void dispose() {
        this.close();
        if (this.fDialog != null) {
            this.fDialog.dispose();
        }
    }

    void setAuthenticationListener(AuthenticationListener authenticationListener) {
        if (this.fLoginComponent != null) {
            this.fLoginComponent.setAuthenticationListener(authenticationListener);
        }
    }

    private class LoginDialog
    extends JDialog {
        private LoginDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }

        private LoginDialog(Dialog dialog, boolean bl) {
            super(dialog, bl);
        }

        @Override
        protected void processWindowEvent(WindowEvent windowEvent) {
            super.processWindowEvent(windowEvent);
            if (windowEvent.getID() == 201) {
                UniversalLoginDialog.this.authenticationCancelled();
            }
        }
    }
}

