/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJStartup;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SpreadsheetColor {
    private Color fCellSelectedBackground = null;
    private Color fCellSelectedForeground = null;
    private Color fCellUnselectedBackground = null;
    private Color fCellUnselectedForeground = null;
    private Color fLeadCellBackground = null;
    private Color fLeadCellForeground = null;
    private Color fContrastingLineColor = null;
    private Color fHeaderSelectedBackground = null;
    private Color fHeaderSelectedForeground = null;
    private Color fHeaderSelectedLine = null;
    private Color fHeaderUnselectedBackground = null;
    private Color fHeaderUnselectedForeground = null;
    private Color fHeaderUnselectedLine = null;
    private static final double LUMINANCE_CUTTOFF = 64.0;
    private static final double LUMINANCE_EQUATION_CUTTOFF = 231.6;
    private Color fSelectionBorder = null;
    private boolean fUseHighContrast = SpreadsheetColor.getLuminance(ColorPrefs.getBackgroundColor()) < 64.0;
    private JTable fTable = null;
    private static final List<PrefListener> COLOR_LISTENERS = new ArrayList<PrefListener>(7);
    private WeakReference<SpreadsheetColor> fPrefListener = null;
    private static final Color FAINT_GRAY = new Color(235, 235, 235);
    private static final Color GRID_GRAY = new Color(192, 192, 192);
    private static Vector<WeakReference<SpreadsheetColor>> sWeakReferenceVector;
    private static final Object WEAK_REFERENCE_VECTOR_LOCK;

    public SpreadsheetColor(JTable jTable) {
        this.setBaseTable(jTable);
    }

    public void setBaseTable(JTable jTable) {
        this.fTable = jTable;
        if (jTable != null) {
            this.recalculateColors();
        }
    }

    protected boolean useHighContrast() {
        return this.fUseHighContrast;
    }

    Color getContrastingSelectionBorder() {
        return this.fContrastingLineColor;
    }

    public Color getSelectionBorder() {
        if (this.fSelectionBorder == null) {
            if (PlatformInfo.isMacintosh()) {
                this.fSelectionBorder = UIManager.getColor("com.mathworks.controlHighlightColor");
                if (this.fSelectionBorder == null) {
                    this.fSelectionBorder = SystemColor.controlHighlight;
                }
            } else {
                this.fSelectionBorder = this.getContrastingSelectionBorder();
            }
        }
        return this.fSelectionBorder;
    }

    public Color getCellSelectedBackground() {
        return this.fCellSelectedBackground;
    }

    public Color getCellSelectedForeground() {
        return this.fCellSelectedForeground;
    }

    public Color getCellUnselectedBackground() {
        return this.fCellUnselectedBackground;
    }

    public Color getCellUnselectedForeground() {
        return this.fCellUnselectedForeground;
    }

    public Color getLeadCellBackground() {
        return this.fLeadCellBackground;
    }

    public Color getLeadCellForeground() {
        return this.fLeadCellForeground;
    }

    public Color getCellForeground(boolean bl, boolean bl2) {
        if (!bl && bl2) {
            throw new IllegalArgumentException("A non-selected cell cannot be the anchor cell.");
        }
        Color color = bl ? (bl2 ? this.getLeadCellForeground() : this.getCellSelectedForeground()) : this.getCellUnselectedForeground();
        return color;
    }

    public Color getCellBackground(boolean bl, boolean bl2) {
        if (!bl && bl2) {
            throw new IllegalArgumentException("A non-selected cell cannot be the anchor cell.");
        }
        Color color = bl ? (bl2 ? this.getLeadCellBackground() : this.fTable.getSelectionBackground()) : this.getCellUnselectedBackground();
        return color;
    }

    public Color getHeaderSelectedBackground() {
        return this.fHeaderSelectedBackground;
    }

    public Color getHeaderSelectedForeground() {
        return this.fHeaderSelectedForeground;
    }

    public Color getHeaderUnselectedBackground() {
        return this.fHeaderUnselectedBackground;
    }

    public Color getHeaderUnselectedForeground() {
        return this.fHeaderUnselectedForeground;
    }

    public Color getHeaderSelectedLine() {
        return this.fHeaderSelectedLine;
    }

    public Color getHeaderUnselectedLine() {
        return this.fHeaderUnselectedLine;
    }

    public Color getSecondaryCellSelectedBackground() {
        return ColorUtils.getUnfocusedSelectionBackgroundColor((Component)this.fTable);
    }

    public Color getSecondarySelectionBorder() {
        return this.getSecondaryCellSelectedBackground().darker();
    }

    public static double getLuminance(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return (double)n * 0.299 + (double)n2 * 0.587 + (double)n3 * 0.114;
    }

    private void recalculateColors() {
        double d;
        Color color;
        boolean bl = this.fUseHighContrast = SpreadsheetColor.getLuminance(ColorPrefs.getBackgroundColor()) < 64.0;
        if (PlatformInfo.isMacintosh()) {
            color = UIManager.getColor("com.mathworks.controlHighlightColor");
            if (color == null) {
                color = SystemColor.controlHighlight;
            }
        } else {
            color = ColorUtils.getSelectionBackgroundColor();
        }
        color = (d = SpreadsheetColor.getLuminance(color)) < 231.6 ? new Color((float)((0.3529 * (double)color.getRed() + 165.0) / 255.0), (float)((0.3529 * (double)color.getGreen() + 165.0) / 255.0), (float)((0.3529 * (double)color.getBlue() + 165.0) / 255.0)) : new Color(165, 165, 165);
        if (PlatformInfo.isMacintosh()) {
            this.fHeaderSelectedBackground = Color.gray;
            this.fHeaderUnselectedBackground = FAINT_GRAY;
        } else {
            this.fHeaderUnselectedBackground = SystemColor.control;
            this.fHeaderSelectedBackground = PlatformInfo.isWindowsModernAppearance() ? new Color(255, 192, 111) : color;
        }
        this.fHeaderSelectedForeground = SystemColor.controlText;
        this.fHeaderUnselectedForeground = SystemColor.controlText;
        if (PlatformInfo.isWindowsXP() && this.useHighContrast()) {
            this.fHeaderSelectedLine = Color.white;
            this.fHeaderUnselectedLine = Color.white;
        } else {
            this.fHeaderSelectedLine = this.getContrastingSelectionBorder();
            this.fHeaderUnselectedLine = GRID_GRAY;
        }
        if (SpreadsheetColor.getLuminance(ColorPrefs.getBackgroundColor()) < 64.0) {
            this.fCellSelectedBackground = Color.white;
            this.fContrastingLineColor = Color.white;
        } else {
            this.fCellSelectedBackground = color;
            this.fContrastingLineColor = Color.black;
        }
        this.fCellUnselectedForeground = this.fTable.getForeground();
        this.fCellUnselectedBackground = this.fTable.getBackground();
        this.fCellSelectedForeground = this.fTable.getForeground();
        if (PlatformInfo.isMacintosh()) {
            this.fLeadCellBackground = this.fTable.getBackground();
            this.fLeadCellForeground = this.fTable.getForeground();
        } else if (this.useHighContrast()) {
            this.fCellSelectedForeground = Color.black;
            this.fLeadCellForeground = Color.white;
            this.fLeadCellBackground = Color.black;
        } else {
            this.fLeadCellForeground = this.fTable.getForeground();
            this.fLeadCellBackground = this.fTable.getBackground();
        }
        SpreadsheetColor.notifyColorListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColorListener(PrefListener prefListener) {
        List<PrefListener> list = COLOR_LISTENERS;
        synchronized (list) {
            COLOR_LISTENERS.add(prefListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeColorListener(PrefListener prefListener) {
        List<PrefListener> list = COLOR_LISTENERS;
        synchronized (list) {
            Iterator<PrefListener> iterator = COLOR_LISTENERS.iterator();
            while (iterator.hasNext()) {
                PrefListener prefListener2 = iterator.next();
                if (!prefListener2.equals(prefListener)) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyColorListenersMethod() {
        List<PrefListener> list = COLOR_LISTENERS;
        synchronized (list) {
            for (PrefListener prefListener : COLOR_LISTENERS) {
                prefListener.prefChanged(new PrefEvent(null, null, 1));
            }
        }
    }

    public static void notifyColorListeners() {
        if (SwingUtilities.isEventDispatchThread()) {
            SpreadsheetColor.notifyColorListenersMethod();
        } else {
            SwingUtilities.invokeLater(new NotifyColorListenerThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerColorInterests() {
        Object object = WEAK_REFERENCE_VECTOR_LOCK;
        synchronized (object) {
            if (this.fPrefListener == null) {
                this.fPrefListener = new WeakReference<SpreadsheetColor>(this);
            }
            sWeakReferenceVector.add(this.fPrefListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterColorInterests() {
        Object object = WEAK_REFERENCE_VECTOR_LOCK;
        synchronized (object) {
            if (this.fPrefListener != null) {
                SpreadsheetColor.removeStaleReferences();
                sWeakReferenceVector.remove(this.fPrefListener);
                this.fPrefListener = null;
            }
        }
    }

    private static void removeStaleReferences() {
        Iterator<WeakReference<SpreadsheetColor>> iterator = sWeakReferenceVector.iterator();
        while (iterator.hasNext()) {
            WeakReference<SpreadsheetColor> weakReference = iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    static {
        MJStartup.init();
        sWeakReferenceVector = new Vector(20);
        WEAK_REFERENCE_VECTOR_LOCK = new Object();
        LocalPrefListener.init();
    }

    private static class LocalPrefListener
    implements PrefListener {
        private LocalPrefListener() {
        }

        public static void init() {
            LocalPrefListener localPrefListener = new LocalPrefListener();
            ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)localPrefListener);
            ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)localPrefListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                Vector vector;
                Iterator iterator = WEAK_REFERENCE_VECTOR_LOCK;
                synchronized (iterator) {
                    SpreadsheetColor.removeStaleReferences();
                    vector = new Vector(sWeakReferenceVector);
                }
                for (WeakReference weakReference : vector) {
                    ((SpreadsheetColor)weakReference.get()).recalculateColors();
                }
            }
        }
    }

    private static class NotifyColorListenerThread
    implements Runnable {
        private NotifyColorListenerThread() {
        }

        @Override
        public void run() {
            SpreadsheetColor.notifyColorListenersMethod();
        }
    }
}

