/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.color.ColorArrayTableModel;
import com.mathworks.widgets.spreadsheet.color.CompositeColorArrayTableModel;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import java.awt.Color;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JTable;

public final class SpreadsheetUtils {
    private static final ResourceBundle sBundle = ResourceBundle.getBundle("com.mathworks.widgets.spreadsheet.resources.RES_Spreadsheet");
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final int LENGTH_OF_ALPHABET = 26;
    public static final String SPREADSHEET_CONTEXT = "SpreadsheetTable";
    public static final String PASTE_EXCEL_ID = "paste-excel-data";
    public static final String GENERIC_INSERT_ID = "generic-insert";
    public static final String GENERIC_DELETE_ID = "generic-delete";
    static final String STOP_EDITING_ID = "stop-editing-spreadsheet";

    private SpreadsheetUtils() {
    }

    static String getResource(String string) {
        return sBundle.getString(string);
    }

    public static boolean isValidPasteSource(Object[][] objectArray) {
        boolean bl = true;
        if (objectArray == null) {
            bl = false;
        } else {
            int n = objectArray.length;
            if (n == 0) {
                bl = false;
            } else {
                Object[] objectArray2 = objectArray[0];
                if (objectArray2 == null) {
                    bl = false;
                } else {
                    int n2 = objectArray2.length;
                    if (n2 == 0) {
                        bl = false;
                    } else {
                        for (int i = 1; i < n; ++i) {
                            Object[] objectArray3 = objectArray[i];
                            bl = bl && objectArray3 != null && objectArray3.length == n2;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public static Object[][] tabbedValuesToArray(String string) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.indexOf(10, -1) == -1 && string.indexOf(13, -1) == -1) {
            ((AbstractList)arrayList).add(string);
        } else {
            n4 = string.indexOf(10, -1) > string.indexOf(13, -1) ? string.indexOf(10, -1) : string.indexOf(13, -1);
            ((AbstractList)arrayList).add(string.substring(0, n4));
            n3 = -1;
            while (n4 != -1) {
                n3 = n4;
                if ((n4 = string.indexOf(10, n4 + 1)) != -1) {
                    ((AbstractList)arrayList).add(string.substring(n3 + 1, n4));
                    continue;
                }
                n4 = string.indexOf(13, n3 + 1);
                if (n4 == -1) continue;
                ((AbstractList)arrayList).add(string.substring(n3 + 1, n4));
            }
            if (n3 != string.length() - 1) {
                ((AbstractList)arrayList).add(string.substring(n3 + 1));
            }
        }
        n4 = ((AbstractCollection)arrayList).size();
        n3 = -1;
        for (int i = 0; i < n4; ++i) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            object = (String)((AbstractList)arrayList).get(i);
            n2 = ((String)object).indexOf(9, -1);
            if (n2 == -1) {
                ((AbstractList)arrayList2).add(object);
            } else {
                ((AbstractList)arrayList2).add(((String)object).substring(0, n2));
                while (n2 != -1) {
                    n = n2;
                    if ((n2 = ((String)object).indexOf(9, n2 + 1)) == -1) {
                        ((AbstractList)arrayList2).add(((String)object).substring(n + 1));
                        continue;
                    }
                    ((AbstractList)arrayList2).add(((String)object).substring(n + 1, n2));
                }
            }
            ((AbstractList)arrayList).set(i, arrayList2);
            n3 = Math.max(((AbstractCollection)arrayList2).size(), n3);
        }
        Object[][] objectArray = new Object[n4][n3];
        for (int i = 0; i < n4; ++i) {
            object = (AbstractList)((AbstractList)arrayList).get(i);
            n2 = ((AbstractCollection)object).size();
            for (n = 0; n < n3; ++n) {
                objectArray[i][n] = n < n2 ? ((AbstractList)object).get(n) : "";
            }
            ((AbstractList)arrayList).set(i, null);
        }
        return objectArray;
    }

    public static Object[][] replicateArrayToSize(Object[][] objectArray, int n, int n2) {
        if (!SpreadsheetUtils.isValidPasteSource(objectArray)) {
            return null;
        }
        if (n == 0 || n2 == 0) {
            return null;
        }
        if (n == 1 && n2 == 1) {
            return objectArray;
        }
        int n3 = objectArray.length;
        int n4 = objectArray[0].length;
        int n5 = n == 1 ? 1 : n / n3;
        int n6 = n2 == 1 ? 1 : n2 / n4;
        int n7 = n % n3;
        int n8 = n2 % n4;
        if (n7 != 0 && n != 1 || n8 != 0 && n2 != 1) {
            return objectArray;
        }
        Object[][] objectArray2 = new Object[Math.max(n, n3)][Math.max(n2, n4)];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                for (int k = 0; k < n3; ++k) {
                    System.arraycopy(objectArray[k], 0, objectArray2[i * n3 + k], j * n4, n4);
                }
            }
        }
        return objectArray2;
    }

    public static String arrayToTabbedValues(Object[][] objectArray) {
        int n = 1;
        if (objectArray.length > 0) {
            n = objectArray.length;
            if (objectArray[0].length > 0) {
                n *= objectArray[0].length;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n *= 7);
        for (Object[] objectArray2 : objectArray) {
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray2[i];
                if (object != null) {
                    stringBuilder.append(object);
                }
                if (i >= objectArray2.length - 1) continue;
                stringBuilder.append('\t');
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String getExcelSchemeHeaderLabel(int n) {
        String string = "";
        while (n >= 0) {
            string = (char)((char)(n % 26) + 65) + string;
            n = n / 26 - 1;
        }
        return string;
    }

    public static String getPasteDataMenuResource() {
        if (PlatformInfo.isWindows() || PlatformInfo.isMacintosh()) {
            return SpreadsheetUtils.getResource("Action.paste-excel-data.Label");
        }
        return SpreadsheetUtils.getResource("menu.pasteTabular");
    }

    public static String getPasteDataToolTipResource() {
        if (PlatformInfo.isWindows() || PlatformInfo.isMacintosh()) {
            return SpreadsheetUtils.getResource("Action.paste-excel-data.Tooltip");
        }
        return SpreadsheetUtils.getResource("tip.pasteTabular");
    }

    public static boolean selectionEdgeIntAbutsCellEdge(JTable jTable, int n, int n2, int n3, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            switch (n3) {
                case 1: {
                    bl2 = n == 0 || !jTable.isRowSelected(n - 1);
                    break;
                }
                case 3: {
                    bl2 = !jTable.isRowSelected(n + 1);
                    break;
                }
                case 2: {
                    bl2 = n2 == 0 || !jTable.isColumnSelected(n2 - 1);
                    break;
                }
                case 4: {
                    bl2 = !jTable.isColumnSelected(n2 + 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid position argument.");
                }
            }
        }
        return bl2;
    }

    public static Color[] colorsOnCellEdge(ColorArrayTableModel colorArrayTableModel, int n, int n2, int n3) {
        Color[] colorArray;
        if (colorArrayTableModel.getColorsAt(0, 0).length == 0) {
            return CompositeColorArrayTableModel.NO_COLORS;
        }
        Color[] colorArray2 = new Color[colorArrayTableModel.getColorsAt(0, 0).length];
        Color[] colorArray3 = colorArrayTableModel.getColorsAt(n, n2);
        switch (n3) {
            case 1: {
                if (n == 0) {
                    colorArray = new Color[colorArrayTableModel.getColorsAt(0, 0).length];
                    break;
                }
                colorArray = colorArrayTableModel.getColorsAt(n - 1, n2);
                break;
            }
            case 3: {
                colorArray = colorArrayTableModel.getColorsAt(n + 1, n2);
                break;
            }
            case 2: {
                if (n2 == 0) {
                    colorArray = new Color[colorArrayTableModel.getColorsAt(0, 0).length];
                    break;
                }
                colorArray = colorArrayTableModel.getColorsAt(n, n2 - 1);
                break;
            }
            case 4: {
                colorArray = colorArrayTableModel.getColorsAt(n, n2 + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid position argument.");
            }
        }
        for (int i = 0; i < colorArray3.length; ++i) {
            Color color = colorArray3[i];
            if (color == null || colorArray[i] != null) continue;
            colorArray2[i] = color;
        }
        return colorArray2;
    }

    public static boolean selectionEdgeExtAbutsCellEdge(JTable jTable, int n, int n2, int n3, boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            switch (n3) {
                case 1: {
                    bl2 = n > 0 && jTable.isColumnSelected(n2) && jTable.isRowSelected(n - 1);
                    break;
                }
                case 3: {
                    bl2 = jTable.isColumnSelected(n2) && jTable.isRowSelected(n + 1);
                    break;
                }
                case 2: {
                    bl2 = n2 > 0 && jTable.isRowSelected(n) && jTable.isColumnSelected(n2 - 1);
                    break;
                }
                case 4: {
                    bl2 = jTable.isRowSelected(n) && jTable.isColumnSelected(n2 + 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid position argument.");
                }
            }
        }
        return bl2;
    }

    public static int getTextAlignment(Object object) {
        if (object instanceof Number || object instanceof ComplexScalar) {
            return 4;
        }
        return 2;
    }

    public static String getSelectionString(List<int[]> list, int n) {
        if (list.size() == 1) {
            int[] nArray = list.get(0);
            return SpreadsheetUtils.getSelectionString(nArray[0], nArray[1], n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = list.get(i);
            stringBuilder.append(SpreadsheetUtils.getSelectionString(nArray[0], nArray[1], n));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        String string = stringBuilder.toString();
        return string;
    }

    private static String getSelectionString(int n, int n2, int n3) {
        String string = n == n2 ? (n3 > 1 && n == n3 - 1 ? "end" : Integer.toString(n + 1)) : (n == 0 && n2 == n3 - 1 ? ":" : (n3 > 1 && n2 == n3 - 1 ? Integer.toString(n + 1) + ":end" : Integer.toString(n + 1) + ":" + Integer.toString(n2 + 1)));
        return string;
    }

    public static List<int[]> getSelectionIntervals(int[] nArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (nArray == null || nArray.length == 0) {
            return new ArrayList<int[]>();
        }
        if (nArray.length == 1) {
            arrayList.add(new int[]{nArray[0], nArray[0]});
            return arrayList;
        }
        if (nArray.length >= 2 && nArray.length == nArray[nArray.length - 1] - nArray[0] + 1) {
            arrayList.add(new int[]{nArray[0], nArray[nArray.length - 1]});
            return arrayList;
        }
        int[] nArray2 = new int[]{nArray[0], -1};
        for (int i = 1; i < nArray.length; ++i) {
            if (i == nArray.length - 1) {
                if (nArray[i] - nArray[i - 1] > 1) {
                    nArray2[1] = nArray[i - 1];
                    arrayList.add(nArray2);
                    arrayList.add(new int[]{nArray[i], nArray[i]});
                    continue;
                }
                nArray2[1] = nArray[i];
                arrayList.add(nArray2);
                continue;
            }
            if (nArray[i] - nArray[i - 1] <= 1) continue;
            nArray2[1] = nArray[i - 1];
            arrayList.add(nArray2);
            nArray2 = new int[]{nArray[i], -1};
        }
        return arrayList;
    }
}

