/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.data.ComplexFloatingPointScalar;

public final class ComplexScalarDouble
extends ComplexFloatingPointScalar {
    private final double fR;
    private final double fI;
    private static final ComplexScalarDouble ZERO_REAL = new ComplexScalarDouble(0.0);
    private static final ComplexScalarDouble NZERO_REAL = new ComplexScalarDouble(0.0);
    private static final ComplexScalarDouble ONE_REAL = new ComplexScalarDouble(1.0);
    private static final ComplexScalarDouble ZERO_COMPLEX = new ComplexScalarDouble(0.0, 0.0);
    private static final ComplexScalarDouble ONE_COMPLEX = new ComplexScalarDouble(1.0, 0.0);
    private static final ComplexScalarDouble I_COMPLEX = new ComplexScalarDouble(0.0, 1.0);

    public static ComplexScalarDouble valueOf(double d) {
        if (d == 0.0) {
            if (1.0 / d == Double.POSITIVE_INFINITY) {
                return ZERO_REAL;
            }
            return NZERO_REAL;
        }
        if (d == 1.0) {
            return ONE_REAL;
        }
        return new ComplexScalarDouble(d);
    }

    public static ComplexScalarDouble valueOf(double d, double d2) {
        if (d == 0.0) {
            if (d2 == 1.0) {
                return I_COMPLEX;
            }
            if (d2 == 0.0) {
                return ZERO_COMPLEX;
            }
        }
        if (d == 1.0 && d2 == 0.0) {
            return ONE_COMPLEX;
        }
        return new ComplexScalarDouble(d, d2);
    }

    private ComplexScalarDouble(double d) {
        super(true, true);
        this.fR = d;
        this.fI = 0.0;
    }

    private ComplexScalarDouble(double d, double d2) {
        super(false, true);
        this.fR = d;
        this.fI = d2;
    }

    @Override
    public long longValueReal() {
        return (long)this.fR;
    }

    @Override
    public long longValueImaginary() {
        return (long)this.fI;
    }

    @Override
    public double doubleValueReal() {
        return this.fR;
    }

    @Override
    public double doubleValueImaginary() {
        return this.fI;
    }
}

