/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.widgets.spreadsheet.data.ComplexFloatingPointScalar;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import java.math.BigInteger;
import java.util.Locale;

public final class FormatUtils {
    private static final String PLUS = " + ";
    private static final String MINUS = " - ";
    private static final String IMAGINARY = "i";

    private FormatUtils() {
    }

    public static String formatAsIntegral(Number number) {
        if (FormatUtils.isFloatingPointType(number)) {
            throw new IllegalArgumentException("formatAsIntegral() must take an integral Number (Byte, Short, Integer, or Long).");
        }
        return String.format(Locale.US, "%d", number);
    }

    public static boolean isFloatingPointType(Number number) {
        return number instanceof Double || number instanceof Float;
    }

    public static boolean isFloatingPointType(ComplexScalar complexScalar) {
        return complexScalar instanceof ComplexFloatingPointScalar;
    }

    public static String formatAsIntegral(Number number, Number number2) {
        String string;
        boolean bl;
        String string2 = number instanceof BigInteger ? number.toString() : FormatUtils.formatAsIntegral(number);
        if (number2 instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number2;
            bl = bigInteger.signum() == -1;
            string = bl ? FormatUtils.formatAsIntegral(bigInteger.negate()) : FormatUtils.formatAsIntegral(number2);
        } else {
            long l = number2.longValue();
            bl = l < 0L;
            string = bl ? FormatUtils.formatAsIntegral(-l) : FormatUtils.formatAsIntegral(number2);
        }
        return FormatUtils.combineRealAndImagStrings(string2, string, bl);
    }

    public static String format(Number number, String string) {
        boolean bl;
        boolean bl2 = number instanceof Double || number instanceof Float;
        boolean bl3 = bl = string.indexOf(100) != -1;
        if (bl && bl2) {
            return FormatUtils.format(number.longValue(), string);
        }
        return String.format(Locale.US, string, number).replaceAll("Infinity", "Inf").trim();
    }

    public static String format(Number number, String string, Number number2, String string2) {
        String string3 = FormatUtils.format(number, string);
        double d = number2.doubleValue();
        String string4 = d < 0.0 ? FormatUtils.format(-d, string2) : FormatUtils.format(number2, string2);
        return FormatUtils.combineRealAndImagStrings(string3, string4, d < 0.0);
    }

    public static String combineRealAndImagStrings(String string, String string2, boolean bl) {
        return string + (bl ? MINUS : PLUS) + string2 + IMAGINARY;
    }
}

