/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.services.Prefs;
import java.awt.Color;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class DefaultSyntaxColor
implements SyntaxHighlightingColor,
Serializable {
    private static final String LANGUAGE_PREF_KEY = "Editor.Language.{0}.Color.{1}";
    private final String fDisplayName;
    private final Color fDefaultColor;
    private final String fPreferencesKey;
    private final String fTokenName;
    private final List<String> fTokenNames;
    private final Collection<Integer> fTokenOrCategoryIDs;

    public DefaultSyntaxColor(String string, Color color, String string2, String string3) {
        this(string, color, string2, string3, null);
    }

    public DefaultSyntaxColor(String string, Color color, String string2, String string3, String string4) {
        this(string, color, Collections.singletonList(string2), string3, string4, new Integer[0]);
    }

    public DefaultSyntaxColor(String string, Color color, List<String> list, String string2, String string3) {
        this(string, color, list, string2, string3, new Integer[0]);
    }

    public DefaultSyntaxColor(String string, Color color, String string2, String string3, String string4, Integer ... integerArray) {
        this(string, color, Collections.singletonList(string2), string3, string4, integerArray);
    }

    private DefaultSyntaxColor(String string, Color color, List<String> list, String string2, String string3, Integer ... integerArray) {
        Validate.notEmpty((String)string, (String)"'displayName' cannot be null or empty");
        Validate.notNull((Object)color, (String)"'defaultColor' cannot be null");
        Validate.notEmpty(list, (String)"'tokenColorName' cannot be null or empty");
        Validate.notEmpty((String)string2, (String)"'languageName' cannot be null or empty");
        Validate.notNull((Object)integerArray, (String)"'tokenOrCategoryIDs' cannot be null or empty");
        this.fDisplayName = string;
        this.fDefaultColor = color;
        this.fTokenNames = Collections.unmodifiableList(list);
        this.fTokenName = this.fTokenNames.get(0);
        this.fPreferencesKey = string3 == null ? MessageFormat.format(LANGUAGE_PREF_KEY, string2, this.fTokenName) : string3;
        this.fTokenOrCategoryIDs = Arrays.asList(integerArray);
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public Color getCurrentColor() {
        return Prefs.getColorPref((String)this.getPreferenceKey(), (Color)this.getDefaultColor());
    }

    public String getTokenName() {
        return this.fTokenName;
    }

    public List<String> getAllTokenNames() {
        return this.fTokenNames;
    }

    public String getPreferenceKey() {
        return this.fPreferencesKey;
    }

    public Color getDefaultColor() {
        return this.fDefaultColor;
    }

    public Collection<Integer> getTokenIDs() {
        return this.fTokenOrCategoryIDs;
    }
}

