/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.cplusplus;

import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.SmartFormatter;
import com.mathworks.widgets.text.cplusplus.CCFormatSupport;
import com.mathworks.widgets.text.cplusplus.CLanguage;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cnd.editor.cplusplus.CCSyntax;

public class CCFormatter
extends ExtFormatter
implements SmartFormatter {
    private IndentingStyle fIndentingStyle;

    public CCFormatter(Class<? extends EditorKit> clazz) {
        super(clazz);
    }

    public boolean isSimple() {
        return this.fIndentingStyle == IndentingStyle.NONE;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz;
        String string;
        String string2;
        super.settingsChange(settingsChangeEvent);
        String string3 = string2 = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (string2 != null && string2.equals("indenting-type") && (string = SettingsUtil.getString((Class)(clazz = this.getKitClass()), (String)string2, null)) != null) {
            this.setFormattingType(IndentingStyle.lookup(string));
        }
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof CCSyntax;
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null && (nArray = CCFormatter.getKeywordBasedReformatBlock(baseDocument, n, string)) == null) {
            nArray = super.getReformatBlock(jTextComponent, string);
        }
        return nArray;
    }

    public static int[] getKeywordBasedReformatBlock(BaseDocument baseDocument, int n, String string) {
        int[] nArray = null;
        if ("e".equals(string)) {
            try {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (CCFormatter.checkCase(baseDocument, n2, "else")) {
                    nArray = new int[]{n2, n2 + 4};
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if (":".equals(string)) {
            try {
                int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (CCFormatter.checkCase(baseDocument, n3, "case")) {
                    nArray = new int[]{n3, n3 + 4};
                } else if (CCFormatter.checkCase(baseDocument, n3, "default")) {
                    nArray = new int[]{n3, n3 + 7};
                } else if (CCFormatter.checkCase(baseDocument, n3, "public")) {
                    nArray = new int[]{n3, n3 + 6};
                } else if (CCFormatter.checkCase(baseDocument, n3, "protected")) {
                    nArray = new int[]{n3, n3 + 9};
                } else if (CCFormatter.checkCase(baseDocument, n3, "private")) {
                    nArray = new int[]{n3, n3 + 7};
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return nArray;
    }

    private static boolean checkCase(BaseDocument baseDocument, int n, String string) throws BadLocationException {
        return n >= 0 && n + string.length() <= baseDocument.getLength() && string.equals(baseDocument.getText(n, string.length()));
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
        this.setFormattingType(EditorPreferences.getIndentingStyle(CLanguage.INSTANCE));
        this.addFormatLayer((FormatLayer)new CCLayer());
    }

    @Override
    public void setFormattingType(IndentingStyle indentingStyle) {
        this.fIndentingStyle = indentingStyle;
    }

    @Override
    public IndentingStyle getFormattingType() {
        return this.fIndentingStyle;
    }

    private static class CCLayer
    extends AbstractFormatLayer {
        CCLayer() {
            super("cc-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new CCFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            block6: {
                try {
                    CCFormatSupport cCFormatSupport = (CCFormatSupport)this.createFormatSupport(formatWriter);
                    FormatTokenPosition formatTokenPosition = cCFormatSupport.getFormatStartPosition();
                    if (cCFormatSupport.isIndentOnly()) {
                        cCFormatSupport.indentLine(formatTokenPosition);
                        break block6;
                    }
                    while (formatTokenPosition != null) {
                        cCFormatSupport.indentLine(formatTokenPosition);
                        CCLayer.formatLine(cCFormatSupport, formatTokenPosition);
                        FormatTokenPosition formatTokenPosition2 = cCFormatSupport.findLineEnd(formatTokenPosition);
                        if (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && (formatTokenPosition = cCFormatSupport.getNextPosition(formatTokenPosition2, Position.Bias.Forward)) != formatTokenPosition2 && formatTokenPosition != null && formatTokenPosition.getToken() != null) {
                            FormatTokenPosition formatTokenPosition3 = cCFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                            if (formatTokenPosition3 != null) {
                                formatTokenPosition = formatTokenPosition3;
                                continue;
                            }
                            formatTokenPosition = cCFormatSupport.findLineStart(formatTokenPosition);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        private static void formatLine(CCFormatSupport cCFormatSupport, FormatTokenPosition formatTokenPosition) {
        }
    }

    private static class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        private StripEndWhitespaceLayer() {
            super("cc-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new CCFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            CCFormatSupport cCFormatSupport = (CCFormatSupport)this.createFormatSupport(formatWriter);
            FormatTokenPosition formatTokenPosition = cCFormatSupport.getFormatStartPosition();
            if (!cCFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if ((formatTokenPosition = cCFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = cCFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

