/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.java;

import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.java.BracketCompletion;
import com.mathworks.widgets.text.java.MWJavaFormatter;
import com.mathworks.widgets.text.java.MWJavaSettingsInitializer;
import com.mathworks.widgets.text.java.MWJavaSyntaxSupport;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;

public abstract class JavaKit
extends MWKit {
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    static final long serialVersionUID = -5445829962533684922L;
    private static final Settings.Initializer[] sInitializers = new Settings.Initializer[]{new MWJavaSettingsInitializer(JavaKit.class)};

    public static List<Settings.Initializer> getInitializers() {
        return Collections.unmodifiableList(Arrays.asList(sInitializers));
    }

    public Syntax createSyntax(Document document) {
        String string = "1.4";
        if (PlatformInfo.isVersion15()) {
            string = "1.5";
        }
        return new JavaSyntax(string);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new MWJavaSyntaxSupport(baseDocument);
    }

    public Formatter createFormatter() {
        return new MWJavaFormatter(((Object)((Object)this)).getClass());
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        baseDocument.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
        baseDocument.putProperty(SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
                if (JavaTokenContext.LINE_COMMENT == tokenID) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, tokenID, tokenContextPath, n, n2));
                }
            }
        });
    }

    @Override
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new AbbrevDebugLineAction()};
        actionArray = TextAction.augmentList(actionArray, MWKit.createSlashSlashCommentActions());
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BracketCompletion.charBackspaced(baseDocument, n, caret, c);
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            int n = caret.getDot();
            if (BracketCompletion.posWithinString(baseDocument, n)) {
                try {
                    baseDocument.insertString(n, "\" + \"", null);
                    caret.setDot(n += 3);
                    return new Integer(n);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(baseDocument, n)) {
                        int n2 = BracketCompletion.getRowOrBlockEnd(baseDocument, n);
                        baseDocument.insertString(n2, "}", null);
                        baseDocument.getFormatter().indentNewLine((Document)baseDocument, n2);
                        caret.setDot(n);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (object != null && object instanceof Integer) {
                int n = caret.getDot();
                caret.setDot(n + 1);
            }
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                StringBuffer stringBuffer = new StringBuffer("System.out.println(\"");
                String string = (String)baseDocument.getProperty((Object)"title");
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                try {
                    stringBuffer.append(Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                stringBuffer.append(' ');
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                if (baseKit == null) {
                    return;
                }
                Action action = baseKit.getActionByName("insert-content");
                if (action != null) {
                    Utilities.performAction((Action)action, (ActionEvent)new ActionEvent(jTextComponent, 1001, stringBuffer.toString()), (JTextComponent)jTextComponent);
                }
            }
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends MWKit.MWDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            if (c == '\"' || c == '\'') {
                boolean bl2 = BracketCompletion.completeQuote(baseDocument, n, caret, c);
                if (bl2) {
                    caret.setDot(n + 1);
                } else {
                    super.insertString(baseDocument, n, caret, string, bl);
                }
            } else {
                super.insertString(baseDocument, n, caret, string, bl);
                BracketCompletion.charInserted(baseDocument, n, caret, c);
            }
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (c == '\"' || c == '\'') {
                if (document != null) {
                    try {
                        boolean bl2 = false;
                        int n2 = Math.min(caret.getDot(), caret.getMark());
                        int n3 = Math.max(caret.getDot(), caret.getMark());
                        if (n2 != n3) {
                            document.remove(n2, n3 - n2);
                        }
                        int n4 = caret.getDot();
                        if (document instanceof BaseDocument) {
                            bl2 = BracketCompletion.completeQuote((BaseDocument)document, n4, caret, c);
                        }
                        if (bl2) {
                            caret.setDot(n4 + 1);
                        } else if (string != null && string.length() > 0) {
                            document.insertString(n2, string, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(jTextComponent, n, caret, string, bl);
                if (document instanceof BaseDocument) {
                    BracketCompletion.charInserted((BaseDocument)document, caret.getDot() - 1, caret, c);
                }
            }
        }
    }
}

