/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.layer;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.util.Log;
import com.mathworks.util.Predicate;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.STPViewInterface;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.ToolTipSupport;

public class LayerUtils {
    private static final int MOUSEOVER_PADDING = 8;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.layer.resources.RES_Layer");

    private LayerUtils() {
    }

    public static List<? extends EditorMessage> getMessagesAtCaret(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaretPosition();
        return LayerUtils.getMessagesAtPosition(jTextComponent, Math.max(n - 1, 0), n);
    }

    public static List<? extends EditorMessage> getMessagesUnderMouse(JTextComponent jTextComponent) {
        List<Object> list = Collections.emptyList();
        ToolTipSupport toolTipSupport = ExtUtilities.getExtEditorUI((JTextComponent)jTextComponent).getToolTipSupport();
        if (toolTipSupport == null) {
            return list;
        }
        try {
            Point point = toolTipSupport.getLastMouseEvent().getPoint();
            point.translate(-4, 0);
            int n = ((STPViewInterface)((Object)jTextComponent)).getPosFromPoint(point);
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n);
            rectangle.grow(8, 8);
            if (rectangle.contains(toolTipSupport.getLastMouseEvent().getPoint())) {
                list = LayerUtils.getMessagesAtPosition(jTextComponent, n, n);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return list;
    }

    private static List<? extends EditorMessage> getMessagesAtPosition(JTextComponent jTextComponent, int n, int n2) {
        MWEditorUI mWEditorUI = (MWEditorUI)((BaseTextUI)jTextComponent.getUI()).getEditorUI();
        return mWEditorUI.getEditorMessagesAtPosition(n, n2);
    }

    public static List<EditorMessage> getMessagesFromModel(int n, int n2, MessageModel<?> messageModel) {
        return LayerUtils.getMessagesFromModel(n, n2, messageModel, (Predicate<EditorMessage>)TreeUtils.yes());
    }

    public static List<EditorMessage> getMessagesFromModel(int n, int n2, MessageModel<?> messageModel, Predicate<EditorMessage> predicate) {
        Validate.notNull(predicate, (String)"can not have a null filter");
        Validate.isTrue((n <= n2 ? 1 : 0) != 0, (String)"start position must be <= end position");
        ArrayList<EditorMessage> arrayList = new ArrayList<EditorMessage>();
        for (int i = 0; i < messageModel.getMessageCount(); ++i) {
            EditorMessage editorMessage = (EditorMessage)messageModel.getMessageAt(i);
            int n3 = editorMessage.getStartPosition();
            int n4 = editorMessage.getEndPosition();
            if (n >= n4 || n2 < n3 || !predicate.accept((Object)editorMessage)) continue;
            arrayList.add(editorMessage);
        }
        return arrayList;
    }

    public static ResourceBundle getBundle() {
        return BUNDLE;
    }
}

