/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.util.IntBuffer;
import com.mathworks.widgets.text.matlab.LexicalBuffer;
import com.mathworks.widgets.text.matlab.MatlabState;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.matlab.MatlabTokenManager;

public abstract class LexicalAccumulator {
    private static final int TOKEN_ARRAY_TOO_SHORT = -1;
    private static final int EXTRA_ERROR_BUFFER_SIZE = 50;
    private final IntBuffer fTokens;
    private final IntBuffer fTokenLengths;
    private int fTotalTokens;
    private boolean fLastLineExecutable;
    private int[] fTokenArray;
    private byte[] fInputOutputState;
    private MatlabTokenManager fTokenManager;

    protected LexicalAccumulator(MatlabTokenManager matlabTokenManager, int n, byte[] byArray) {
        if (matlabTokenManager == null) {
            throw new IllegalArgumentException("'manager' cannot be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("'initialState' cannot be null");
        }
        this.fTokenManager = matlabTokenManager;
        this.fTokens = new IntBuffer();
        this.fTokens.setGrowthMode(3);
        this.fTokenLengths = new IntBuffer();
        this.fTokenLengths.setGrowthMode(3);
        this.fInputOutputState = byArray;
        int n2 = n + 50;
        int n3 = n2 < 20000 ? n2 : 0;
        this.reallocate(n3);
    }

    final MatlabTokenInfo createTokenInfo(int n) {
        boolean bl = this.fTokenManager.isImplicitEOL(this.getLastToken());
        MatlabState matlabState = MatlabState.getMatlabStateInstance(this.fInputOutputState, this.fLastLineExecutable, bl);
        assert (this.fTokens.length() == this.getTokenLengths().length() && this.getTokenLengths().length() == this.getTotalTokens()) : "mismatch between sizes of tokens, tokenLengths and totalTokens: " + this.fTokens.length() + ", " + this.getTokenLengths().length() + ", " + this.getTotalTokens();
        return new MatlabTokenInfo(this.fTokens, this.getTokenLengths(), matlabState, n);
    }

    public final void lex(LexicalBuffer lexicalBuffer) {
        this.reallocateIfNecessary(lexicalBuffer.getLineSize());
        int[] nArray = this.lexLine(lexicalBuffer);
        if (this.notEnoughRoom(nArray)) {
            this.doubleTokenCapacity();
            nArray = this.lexLine(lexicalBuffer);
        }
        this.setLastLineExecutable(nArray[1] == 1);
        int n = this.notEnoughRoom(nArray) ? 0 : nArray[0];
        this.addTokens(n);
    }

    protected abstract int[] doLexLine(LexicalBuffer var1, int[] var2, byte[] var3);

    protected final IntBuffer getTokenLengths() {
        return this.fTokenLengths;
    }

    private void reallocateIfNecessary(int n) {
        boolean bl;
        boolean bl2 = this.getCurrentTokenLength() <= n + 50;
        boolean bl3 = bl = this.getCurrentTokenLength() > 20000;
        if (bl2 || bl) {
            this.reallocate(n + 50 + 200);
        }
    }

    private int[] lexLine(LexicalBuffer lexicalBuffer) {
        assert (lexicalBuffer.getLineToTokenize().length - lexicalBuffer.getStartIndex() >= lexicalBuffer.getLineSize());
        int[] nArray = this.doLexLine(lexicalBuffer, this.fTokenArray, this.fInputOutputState);
        if (nArray == null) {
            throw new OutOfMemoryError("Insufficient Java memory to allocate arrays in native tokenization code.");
        }
        assert (nArray.length == 2);
        return nArray;
    }

    protected void reallocate(int n) {
        this.fTokenArray = new int[n];
    }

    protected void addTokens(int n) {
        this.fTokens.append(this.fTokenArray, n);
        this.fTotalTokens += n;
        assert (this.fTotalTokens == this.fTokens.length()) : "mismatch between our expected total tokens (" + this.fTotalTokens + ") " + "and token buffer (" + this.fTokens.length() + ")";
    }

    protected boolean notEnoughRoom(int[] nArray) {
        return nArray[0] == -1;
    }

    private void doubleTokenCapacity() {
        this.reallocate(this.getCurrentTokenLength() * 2);
    }

    private void setLastLineExecutable(boolean bl) {
        this.fLastLineExecutable = bl;
    }

    private int getCurrentTokenLength() {
        return this.fTokenArray.length;
    }

    private int getTotalTokens() {
        return this.fTotalTokens;
    }

    private int getLastToken() {
        if (this.fTotalTokens == 0) {
            return -1;
        }
        return this.fTokens.getAt(this.fTokens.length() - 1);
    }
}

