/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.widgets.text.matlab.MatlabLexer;
import com.mathworks.widgets.text.matlab.MatlabState;
import com.mathworks.widgets.text.matlab.MatlabStateInfo;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.matlab.MatlabTokenManager;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;

public class MatlabSyntax
extends Syntax {
    private final MatlabLexer fLexer;
    private final MatlabTokenManager fManager;
    private final boolean fCopyLoadBuffer;
    private MatlabState fStartState;
    private MatlabState fLoadStartState;
    private char[] fLoadBuffer = null;
    private int fStartLoadOffset = -1;
    private int fScannedOffset = -1;
    private int fNextArrayIndex = 0;
    private MatlabTokenInfo fTokenInfo;
    private boolean fLoadDidntScan = false;
    private final MatlabState fInitialState;

    public MatlabSyntax(MatlabTokenManager matlabTokenManager, MatlabLexer matlabLexer, TokenContextPath tokenContextPath, MatlabState matlabState, boolean bl) {
        if (matlabTokenManager == null) {
            throw new IllegalArgumentException("'manager' cannot be null");
        }
        if (matlabLexer == null) {
            throw new IllegalArgumentException("'lexer' cannot be null");
        }
        if (tokenContextPath == null) {
            throw new IllegalArgumentException("'contextPath' cannot be null");
        }
        if (matlabState == null) {
            throw new IllegalArgumentException("'initialState' cannot be null");
        }
        this.fManager = matlabTokenManager;
        this.fLexer = matlabLexer;
        this.tokenContextPath = tokenContextPath;
        this.fCopyLoadBuffer = bl;
        this.fInitialState = matlabState;
    }

    public final void relocate(char[] cArray, int n, int n2, boolean bl, int n3) {
        assert (this.fCopyLoadBuffer) : "relocate() should never be called if copyLoadBuffer is false";
        super.relocate(cArray, n, n2, bl, n3);
        this.fLoadDidntScan = false;
        if (n2 > 0) {
            if (this.fLoadBuffer != null && this.fScannedOffset > this.fStartLoadOffset) {
                this.fTokenInfo = this.fLexer.tokenizeLines(this.fLoadStartState, this.fLoadBuffer, 0, this.fScannedOffset - this.fStartLoadOffset, cArray, n, n2);
                this.fTokenInfo.modifyOffsets(n - this.fScannedOffset + this.fStartLoadOffset);
            } else if (this.fLoadBuffer != null && this.fScannedOffset == -1) {
                this.fTokenInfo = this.fLexer.tokenizeLines(this.fLoadStartState, cArray, n, n2);
                this.fNextArrayIndex = 0;
            } else {
                this.fTokenInfo = this.fLexer.tokenizeLines(this.fStartState, cArray, n, n2);
                this.fNextArrayIndex = 0;
            }
            this.fLoadBuffer = null;
            this.fStartState = this.fTokenInfo.getNewState();
        }
    }

    public final int compareState(Syntax.StateInfo stateInfo) {
        if (stateInfo != null && ((MatlabStateInfo)stateInfo).getMatlabState().isEqual(this.fStartState)) {
            return super.compareState(stateInfo);
        }
        return 1;
    }

    public final void storeState(Syntax.StateInfo stateInfo) {
        super.storeState(stateInfo);
        ((MatlabStateInfo)stateInfo).setMatlabState(this.fStartState);
        assert (this.offset == this.stopOffset) : "Error case in store state. Offset: " + this.offset + " StopOffset: " + this.stopOffset + " Please report.";
    }

    public final Syntax.StateInfo createStateInfo() {
        return new MatlabStateInfo();
    }

    public final void loadState(Syntax.StateInfo stateInfo) {
        super.loadState(stateInfo);
        this.fStartState = ((MatlabStateInfo)stateInfo).getMatlabState();
        this.fNextArrayIndex = 0;
    }

    private void verifyLoadScanned() {
        if (this.fLoadDidntScan) {
            this.fTokenInfo = this.fLexer.tokenizeLines(this.fLoadStartState, this.fLoadBuffer, 0, this.fLoadBuffer.length);
            this.fTokenInfo.modifyOffsets(this.fStartLoadOffset);
            this.fStartState = this.fTokenInfo.getNewState();
            this.fNextArrayIndex = 0;
            this.fLoadDidntScan = false;
        }
    }

    private TokenID checkCurrentToken(int n) {
        int n2 = this.fTokenInfo.getOffset(n);
        int n3 = n2 + this.fTokenInfo.getTokenLength(n);
        if (n2 <= this.offset && n3 > this.offset) {
            int n4 = this.fTokenInfo.getToken(n);
            this.offset = n3;
            if (this.fLoadBuffer != null) {
                this.fScannedOffset = this.offset;
            }
            this.fNextArrayIndex = n + 1;
            TokenID tokenID = this.fManager.getTokenID(n4);
            if (this.fManager.isBadCharacterToken(tokenID) && this.offset < this.stopOffset && ++n < this.fTokenInfo.getNumTokens()) {
                n4 = this.fTokenInfo.getToken(n);
                TokenID tokenID2 = this.fManager.getTokenID(n4);
                while (this.fManager.isBadCharacterToken(tokenID2) && this.offset < this.stopOffset) {
                    this.offset += this.fTokenInfo.getTokenLength(n);
                    this.fNextArrayIndex = n + 1;
                    if (++n >= this.fTokenInfo.getNumTokens()) break;
                    n4 = this.fTokenInfo.getToken(n);
                    tokenID2 = this.fManager.getTokenID(n4);
                }
            }
            return tokenID;
        }
        return null;
    }

    protected final TokenID parseToken() {
        this.verifyLoadScanned();
        if (this.offset < this.stopOffset) {
            int n;
            TokenID tokenID;
            assert (this.fTokenInfo != null) : "in parse token but fTokenInfo null";
            int n2 = this.fTokenInfo.getNumTokens();
            int n3 = 0;
            for (int i = this.fNextArrayIndex >= 0 && this.fNextArrayIndex <= n2 - 1 ? this.fNextArrayIndex : Math.min(this.offset, n2 - 1); n3 == 0 && i > 0; i /= 2) {
                tokenID = this.checkCurrentToken(i);
                if (tokenID != null) {
                    return tokenID;
                }
                n = this.fTokenInfo.getOffset(i);
                int n4 = n + this.fTokenInfo.getTokenLength(i);
                if (n > this.offset || n4 > this.offset) continue;
                n3 = i + 1;
            }
            for (n = n3; n < n2; ++n) {
                tokenID = this.checkCurrentToken(n);
                if (tokenID == null) continue;
                return tokenID;
            }
            assert (false) : "Didn't find token. Offset: " + this.offset + "  StopOffset: " + this.stopOffset + "  Last token (offset, length, total num tokens): " + this.fTokenInfo.getOffset(this.fTokenInfo.getNumTokens() - 1) + "," + this.fTokenInfo.getTokenLength(this.fTokenInfo.getNumTokens() - 1) + "," + this.fTokenInfo.getNumTokens();
            ++this.offset;
            return this.fManager.getIdentifierToken();
        }
        return null;
    }

    public final void load(Syntax.StateInfo stateInfo, char[] cArray, int n, int n2, boolean bl, int n3) {
        super.load(stateInfo, cArray, n, n2, bl, n3);
        if (n2 > 0) {
            if (this.fCopyLoadBuffer) {
                this.fLoadStartState = this.fStartState;
                this.fLoadBuffer = new char[n2];
                this.fStartLoadOffset = n;
                this.fScannedOffset = -1;
                System.arraycopy(cArray, n, this.fLoadBuffer, 0, n2);
                this.fLoadDidntScan = true;
            } else {
                this.fTokenInfo = this.fLexer.tokenizeLines(this.fStartState, cArray, n, n2);
                this.fStartState = this.fTokenInfo.getNewState();
                this.fNextArrayIndex = 0;
                this.fLoadDidntScan = false;
            }
        } else {
            this.fLoadBuffer = null;
            this.fLoadDidntScan = false;
        }
    }

    public void loadInitState() {
        super.loadInitState();
        this.fStartState = this.fInitialState;
        this.fNextArrayIndex = 0;
    }
}

