/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab.comment;

import com.mathworks.widgets.text.matlab.comment.CommentWrappingUtils;
import com.mathworks.widgets.text.matlab.comment.Line;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public abstract class CommentSection {
    private final BaseDocument fDocument;
    private final String fCommentPrefix;
    private Position fStartPos;
    private Position fEndPos;
    private JTextComponent fTextComponent;
    private int fCharsBeforeCaret;
    private boolean fUncountedCharBeforeCaret;

    public int getStartPosition() {
        return this.fStartPos.getOffset();
    }

    public int getEndPosition() {
        return this.fEndPos.getOffset();
    }

    public boolean contains(int n) {
        return this.getStartPosition() <= n && n <= this.getEndPosition();
    }

    public String getCommentPrefix() {
        return this.fCommentPrefix;
    }

    protected BaseDocument getDocument() {
        return this.fDocument;
    }

    protected void setEndPosition(int n) throws BadLocationException {
        this.fEndPos = this.fDocument.createPosition(Utilities.getRowEnd((BaseDocument)this.fDocument, (int)n));
    }

    protected final void wrap() throws BadLocationException {
        this.preserveCaretPosition();
        this.doWrap();
        this.restoreCaretPosition();
    }

    protected abstract void doWrap() throws BadLocationException;

    protected abstract String getPrefixToRemove(Line var1) throws BadLocationException;

    protected List<Line> getCommentLines() throws BadLocationException {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        int n = Utilities.getLineOffset((BaseDocument)this.fDocument, (int)this.getStartPosition());
        int n2 = Utilities.getLineOffset((BaseDocument)this.fDocument, (int)this.getEndPosition());
        for (int i = n; i <= n2; ++i) {
            arrayList.add(new Line(this.fDocument, i));
        }
        return arrayList;
    }

    protected final void wrapLines(List<Line> list) throws BadLocationException {
        int n = this.getStartPosition();
        int n2 = this.getEndPosition();
        int n3 = list.get(0).getStartPosition();
        int n4 = list.get(list.size() - 1).getEndPosition();
        String string = this.joinCommentLines(list);
        int n5 = n4 - n3;
        int n6 = string.length();
        this.fDocument.replace(n3, n5, string, null);
        this.fStartPos = this.fDocument.createPosition(n);
        this.fEndPos = this.fDocument.createPosition(n2 - n5 + n6);
        Position position = this.getDocument().createPosition(n3);
        Position position2 = this.getDocument().createPosition(n3 + n6);
        for (int i = Utilities.getLineOffset((BaseDocument)this.fDocument, (int)position.getOffset()); i <= Utilities.getLineOffset((BaseDocument)this.fDocument, (int)position2.getOffset()); ++i) {
            this.wrapLineIfNecessary(i);
        }
    }

    private String joinCommentLines(List<Line> list) throws BadLocationException {
        Validate.notEmpty(list, (String)"'commentLines' cannot be empty");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Line line : list) {
            String string = StringUtils.stripEnd((String)line.getText().substring(this.getPrefixToRemove(line).length()), null);
            arrayList.add(string);
        }
        return this.getCommentPrefix() + StringUtils.join(arrayList, (char)' ');
    }

    private void wrapLineIfNecessary(int n) throws BadLocationException {
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.fDocument, (int)n);
        if (CommentWrappingUtils.isLineLongEnoughToBeWrapped(this.fDocument, n2)) {
            CommentWrappingUtils.wrapLongLine(this.fDocument, n2, this.getCommentPrefix());
        }
    }

    protected CommentSection(JTextComponent jTextComponent, String string, int n, int n2) throws BadLocationException {
        Validate.notNull((Object)jTextComponent, (String)"'text' cannot be null");
        Validate.isTrue((boolean)(jTextComponent.getDocument() instanceof BaseDocument), (String)"Must have a BaseDocument");
        Validate.notNull((Object)string, (String)"'commentPrefix' cannot be null");
        Validate.isTrue((n2 > n ? 1 : 0) != 0, (String)("startPos must be greater than endPos: " + n + ", " + n2));
        this.fTextComponent = jTextComponent;
        this.fDocument = (BaseDocument)jTextComponent.getDocument();
        this.fCommentPrefix = string;
        this.fStartPos = this.fDocument.createPosition(n);
        this.fEndPos = this.fDocument.createPosition(n2);
    }

    private void preserveCaretPosition() throws BadLocationException {
        this.fCharsBeforeCaret = -1;
        int n = this.fTextComponent.getCaretPosition();
        if (this.contains(n)) {
            this.fCharsBeforeCaret = 0;
            for (int i = this.getStartPosition(); i < n; ++i) {
                if (this.isCountableCharacter(i)) {
                    ++this.fCharsBeforeCaret;
                    this.fUncountedCharBeforeCaret = false;
                    continue;
                }
                this.fUncountedCharBeforeCaret = true;
            }
        }
    }

    private void restoreCaretPosition() throws BadLocationException {
        if (this.fCharsBeforeCaret != -1) {
            int n = 0;
            for (int i = this.getStartPosition(); i < this.getEndPosition(); ++i) {
                if (n == this.fCharsBeforeCaret) {
                    int n2 = this.fUncountedCharBeforeCaret ? 1 : 0;
                    this.fTextComponent.setCaretPosition(i + n2);
                    break;
                }
                if (!this.isCountableCharacter(i)) continue;
                ++n;
            }
        }
    }

    private boolean isCountableCharacter(int n) throws BadLocationException {
        char c = this.getDocument().getText(n, 1).charAt(0);
        return !Character.isWhitespace(c) && c != '%';
    }
}

